#include <stdlib.h>
#include <math.h>
#include "main.h"
#include "tdumb.h"
#include "noise.h"



#define NOISE_LENGTH 4096

static sample_t noise[NOISE_LENGTH];



void init_noise(void)
{
	int i;

	for (i = 0; i < NOISE_LENGTH; i++)
		noise[i] = (sample_t)RND(65534*256) - 32767*256;
}



typedef struct NOISE_SIGRENDERER NOISE_SIGRENDERER;

struct NOISE_SIGRENDERER
{
	int n_channels;
	DUMB_RESAMPLER r;
};



static void noise_pickup(DUMB_RESAMPLER *r, void *data)
{
	(void)data;
	r->pos -= r->end - r->start;
}



static sigrenderer_t *noise_start_sigrenderer(DUH *duh, sigdata_t *sigdata, int n_channels, long pos)
{
	NOISE_SIGRENDERER *noise_sr = malloc(sizeof(*noise_sr));

	(void)duh;
	(void)sigdata;

	if (!noise_sr)
		return NULL;

	noise_sr->n_channels = n_channels;

	dumb_reset_resampler(&noise_sr->r, noise, pos, 0, NOISE_LENGTH);
	noise_sr->r.pickup = &noise_pickup;

	return noise_sr;
}



static long noise_sigrenderer_get_samples(sigrenderer_t *sigrenderer, float volume, float delta, long size, sample_t **samples)
{
	NOISE_SIGRENDERER *noise_sr = sigrenderer;

	ASSERT(noise_sr->n_channels == 1);

	return dumb_resample(&noise_sr->r, samples[0], size, volume, delta / 256.0);
}



static void noise_sigrenderer_get_current_sample(sigrenderer_t *sigrenderer, float volume, sample_t *samples)
{
	NOISE_SIGRENDERER *noise_sr = sigrenderer;

	ASSERT(noise_sr->n_channels == 1);

	samples[0] += dumb_resample_get_current_sample(&noise_sr->r, volume);
}



static void noise_end_sigrenderer(sigrenderer_t *sigrenderer)
{
	free(sigrenderer);
}



DUH_SIGTYPE_DESC noise_desc = {
	0,
	NULL,
	&noise_start_sigrenderer,
	NULL,
	&noise_sigrenderer_get_samples,
	&noise_sigrenderer_get_current_sample,
	&noise_end_sigrenderer,
	NULL,
};
