#include "main.h"
#include "menu.h"
#include "menuproc.h"
#include "sfxplay.h"



void md_textout_left(BITMAP *bmp, MENU_ENTRY *me, int focused)
{
	textout(bmp, font, me->dp1, me->x, me->y, focused ? MENU_FOCUSED_COLOUR : MENU_UNFOCUSED_COLOUR);
}



void md_textout_right(BITMAP *bmp, MENU_ENTRY *me, int focused)
{
	textout_right(bmp, font, me->dp1, me->x, me->y, focused ? MENU_FOCUSED_COLOUR : MENU_UNFOCUSED_COLOUR);
}



void md_textout_centre(BITMAP *bmp, MENU_ENTRY *me, int focused)
{
	textout_centre(bmp, font, me->dp1, me->x, me->y, focused ? MENU_FOCUSED_COLOUR : MENU_UNFOCUSED_COLOUR);
}



int mk_call(MENU_SYSTEM *ms, MENU_ENTRY *me, int k)
{
	switch (k >> 8) {
		case KEY_ENTER:
		case KEY_SPACE:
			{
				MK_CALL_PROC proc = me->kp1;
				(*proc)(ms);
			}
	}

	return 0;
}



int mk_exit(MENU_SYSTEM *ms, MENU_ENTRY *me, int k)
{
	(void)ms;

	switch (k >> 8) {
		case KEY_ENTER:
		case KEY_SPACE:
			return me->k1;
	}
	return 0;
}



void md_option(BITMAP *bmp, MENU_ENTRY *me, int focused)
{
	char **opt = me->dp1;
	int *i = me->kp1;
	(void)focused;
	textout(bmp, font, opt[*i], me->x, me->y, MENU_FOCUSED_COLOUR);
}



int mk_option(MENU_SYSTEM *ms, MENU_ENTRY *me, int k)
{
	int *i = me->kp1;

	(void)ms;

	switch (k >> 8) {
		case KEY_LEFT:
			if (*i == 0) *i = me->k1;
			(*i)--;
			return 0;
		case KEY_RIGHT:
			(*i)++;
			if (*i == me->k1) *i = 0;
			return 0;
	}
	return 0;
}

