#ifndef INC_MENU_H
#define INC_MENU_H


#define MENU_FPS 100


typedef struct MENU_ENTRY MENU_ENTRY;

typedef struct MENU_SYSTEM MENU_SYSTEM;

typedef void (*ME_DRAW_PROC)(BITMAP *bmp, MENU_ENTRY *me, int focused);
typedef int (*ME_KEY_PROC)(MENU_SYSTEM *ms, MENU_ENTRY *me, int k);
/* If a ME_KEY_PROC returns nonzero, the menu closes. */
#define MK_END  1
#define MK_USER 2

/* A menu can focus if its key proc exists. */
struct MENU_ENTRY
{
	ME_DRAW_PROC draw;
	int x, y;
	void *dp1;
	ME_KEY_PROC key;
	int k1;
	void *kp1;
};


MENU_SYSTEM *init_menu_system(void);
void shut_down_menu_system(MENU_SYSTEM *ms);


typedef struct MENU_DATA MENU_DATA;

MENU_DATA *wrap_menu_data(MENU_SYSTEM *ms, MENU_ENTRY *me, int focus);
int unwrap_menu_data(MENU_DATA *md); /* Returns the focus. */

void t_draw_menu(void *data);
int t_update_menu(void *data);

/* init_menu_module() must be called once at the beginning of the program, if
 * the keydetect functions are to be used.
 */
void init_menu_module(void);
void init_menu_keydetect(void);
int update_menu_keydetect(void *data);


#endif /* INC_MENU_H */

