#ifndef INC_MAIN_H
#define INC_MAIN_H


#include <stdlib.h>
#include <allegro.h>
#include <dumb.h>

extern BITMAP *sand_texture;
extern BITMAP *quicksand_texture;
extern BITMAP *player_texture;
extern BITMAP *teletubby_texture;
extern BITMAP *bmp_mission_complete;
extern BITMAP *bmp_mission_failed;

extern PALETTE pal;
extern int palptr;

#define FONT_W 8

/* Slightly misleading name, since this is actually the line spacing... */
#define FONT_H 10

#define RND(x) (rand() * ((x) / (float)RAND_MAX))


#ifdef DEBUGMALLOC
#include <stdio.h>
/* These functions will exist separately for all source files. */
static int malloc_count_n = 0;
static int malloc_virgin = 1;

static void output_count(void)
{
	fprintf(stderr, "%s : %d\n", __FILE__, malloc_count_n);
}

static void *malloc_count(size_t size)
{
	void *ptr;

	if (malloc_virgin) {
		atexit(&output_count);
		malloc_virgin = 0;
	}

	ptr = malloc(size);
	if (ptr) malloc_count_n++;
	return ptr;
}

static void *realloc_count(void *ptr, size_t size)
{
	void *newptr;

	if (malloc_virgin) {
		atexit(&output_count);
		malloc_virgin = 0;
	}

	newptr = realloc(ptr, size);
	if (!ptr && newptr) malloc_count_n++;

	return newptr;
}

static void free_count(void *ptr)
{
	free(ptr);
	malloc_count_n--;
}

#define malloc malloc_count
#define realloc realloc_count
#define free free_count

#endif


//#define H4X0R3D_CLIP
//#define H4XOR3D_POLYGON

#ifdef H4X0R3D_CLIP
static int clip3d_f_h4x0r3d(int type, float min_z, float max_z, int vc,
	const V3D_f *vtx[], V3D_f *vout[], V3D_f *vtmp[], int out[])
{
	int i;
	for (i = 0; i < vc; i++) {
		*vout[i] = *vtx[i];
		if (vtx[i]->z < min_z) return 0;
	}
	return i;
}
#define clip3d_f clip3d_f_h4x0r3d
#endif

#ifdef H4XOR3D_POLYGON
#include <stdlib.h>
#include <math.h>
/*
static void polygon3d_f_h4x0r3d(BITMAP *bmp, int type, BITMAP *texture,
	int vc, V3D_f *vtx[])
{
	int c = rand();
	int *points = malloc(vc*2*sizeof(int));
	int i;
	if (!points) abort();
	for (i = 0; i < vc; i++) {
		points[i*2+0] = (int)floor(vtx[i]->x+0.5);
		points[i*2+1] = (int)floor(vtx[i]->y+0.5);
	}
	polygon(bmp, vc, points, c);
	free(points);
}
*/
static unsigned long long bitmap_checksum(BITMAP *bmp)
{
	unsigned long long chk = 0;
	int x, y;
	for (y = 0; y < bmp->h; y++)
		for (x = 0; x < bmp->w; x++)
			chk = chk*5 + bmp->line[y][x];
	return chk;
}
static void polygon3d_f_h4x0r3d(BITMAP *bmp, int type, BITMAP *texture,
	int vc, V3D_f *vtx[])
{
	unsigned long long chk;
	if (vc < 3) {
		printf("D'oh! %d\n", vc);
		return;
	}
	//chk = bitmap_checksum(bmp);
	polygon3d_f(bmp, type, texture, vc, vtx);
	/*if (bitmap_checksum(bmp) == chk) {
		int i;
		printf("No effect with (%.1f,%.1f,%.1f)", vtx[0]->x, vtx[0]->y, vtx[0]->z);
		for (i = 1; i < vc; i++)
			printf(", (%.1f,%.1f,%.1f)", vtx[i]->x, vtx[i]->y, vtx[i]->z);
		printf("\n");
	}*/
}
#define polygon3d_f polygon3d_f_h4x0r3d
#endif


#endif /* INC_MAIN_H */

