#include "main.h"
#include "tconfig.h"
#include "menu.h"
#include "menuproc.h"
#include "m_warn.h"
#include "timeloop.h"
#include "sfx.h"
#include "sfxplay.h"



void run_warning_menu(MENU_SYSTEM *ms)
{
	MENU_ENTRY me[] = {
		/* draw            , x         , y                           , dp1                                   , key     , k1    , kp1 */
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*13, "WARNING"                             , &mk_exit, MK_END, NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)* 9, "This game contains material that"    , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)* 7, "may offend or upset some parties."   , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)* 3, "Please do not play if you are likely", NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)* 1, "to send me hate mail afterwards,"    , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)* 1, "because I really can't be"           , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)* 3, "bothered justifying myself."         , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)* 7, "(This does not apply to children.)"  , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*11, "Press Enter or Space to continue"    , NULL    , 0     , NULL},
		{NULL              , 0         , 0                           , NULL                                  , NULL    , 0     , NULL}
	};

	MENU_DATA *md;
	sfx_play(sfx_menu_enter, 1, 0, 1.0);
	md = wrap_menu_data(ms, me, 0);
	timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
	unwrap_menu_data(md);
	sfx_play(sfx_menu_enter, 1, 0, 1.0);
}

