#include <string.h>
#include "main.h"
#include "tconfig.h"
#include "timeloop.h"
#include "menu.h"
#include "menuproc.h"
#include "m_single.h"
#include "m_error.h"
#include "game.h"
#include "sfx.h"
#include "sfxplay.h"



#define CURSOR_CHAR '_'

#define MK_CONFIRM       (MK_USER + 0)
#define MK_CANCEL        (MK_USER + 1)
#define MK_ENTER_ON_NAME (MK_USER + 2)



static unsigned char *k_name[N_KEYS] = {
	"TURN LEFT",
	"TURN RIGHT",
	"LOOK DOWN",
	"LOOK UP",
	"WALK FORWARDS",
	"STEP BACKWARDS",
	"SIDESTEP LEFT",
	"SIDESTEP RIGHT",
	"FIRE"
};



PLAYER_TRANS single_player = {"", {0, 0, 0, 0, 0, 0, 0, 0, 0}, NULL, 0};



static PLAYER_TRANS *the_ptrans;



static int keys_valid(PLAYER_TRANS *ptrans)
{
	int i;

	for (i = 0; i < N_KEYS; i++)
		if (ptrans->k[i] == 0)
			return 0;

	return 1;
}



static void mkc_set_keys(MENU_SYSTEM *ms)
{
	MENU_ENTRY me[] = {
		/* draw            , x         , y                    , dp1               , key , k1, kp1 */
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - FONT_H, "Press the key to", NULL, 0 , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1)         , NULL              , NULL, 0 , NULL},
		{NULL              , 0         , 0                    , NULL              , NULL, 0 , NULL}
	};

	int i;

	for (i = 0; i < N_KEYS; i++) {
		MENU_DATA *md;
		int k;
		sfx_play(i == 0 ? sfx_menu_enter : sfx_menu_select, 1, 0, 1.0);
		me[1].dp1 = k_name[i];
		md = wrap_menu_data(ms, me, 1);
		init_menu_keydetect();
		k = timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &update_menu_keydetect, md);
		unwrap_menu_data(md);
		if (k == KEY_ESC) {
			sfx_play(sfx_menu_error, 1, 0, 1.0);
			return;
		}
		the_ptrans->k[i] = k;
	}

	sfx_play(sfx_menu_enter, 1, 0, 1.0);
}



static void mkc_swap_keys(MENU_SYSTEM *ms)
{
	unsigned char k = the_ptrans->k[K_LOOK_UP];
	the_ptrans->k[K_LOOK_UP] = the_ptrans->k[K_LOOK_DOWN];
	the_ptrans->k[K_LOOK_DOWN] = k;

	sfx_play(sfx_menu_enter, 1, 0, 1.0);

	(void)ms;
}



static int mk_enter_name(MENU_SYSTEM *ms, MENU_ENTRY *me, int k)
{
	unsigned char *name = me->dp1;
	int *lp = me->kp1;

	(void)ms;

	switch (k >> 8) {
		case KEY_BACKSPACE:
			if (*lp) {
				sfx_play(sfx_menu_select, 1, 0, 1.0);
				name[(*lp)--] = 0;
				name[*lp] = CURSOR_CHAR;
			} else
				sfx_play(sfx_menu_error, 1, 0, 1.0);
			return 0;
		case KEY_ENTER:
			return MK_ENTER_ON_NAME;
		default:
			k &= 255;
			if (k && *lp < PLAYER_NAME_MAX) {
				sfx_play(sfx_menu_select, 1, 0, 1.0);
				name[(*lp)++] = k;
				if (*lp < PLAYER_NAME_MAX) {
					name[*lp] = CURSOR_CHAR;
					name[*lp+1] = 0;
				}
			} else
				sfx_play(sfx_menu_error, 1, 0, 1.0);
			return 0;
	}
}



void run_single_player_menu(MENU_SYSTEM *ms, PLAYER_TRANS *ptrans)
{
	int l = strlen(ptrans->name);

	MENU_ENTRY me[] = {
		/* draw            , x         , y                      , dp1                    , key           , k1        , kp1 */
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - FONT_H*4, "Enter your name"      , NULL          , 0         , NULL          },
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - FONT_H*3, ptrans->name           , &mk_enter_name, 0         , &l            },
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - FONT_H*1, "Set Keys"             , &mk_call      , 0         , &mkc_set_keys },
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1)           , "Swap Up and Down Keys", &mk_call      , 0         , &mkc_swap_keys},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + FONT_H*2, "Play Game"            , &mk_exit      , MK_CONFIRM, NULL          },
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + FONT_H*3, "Cancel"               , &mk_exit      , MK_CANCEL , NULL          },
		{NULL              , 0         , 0                      , NULL                   , NULL          , 0         , NULL          }
	};

	int i;
	MENU_DATA *md;

	the_ptrans = ptrans;

	if (ptrans != &single_player) {
		me[4].dp1 = "Confirm";
		me[5].dp1 = "Remove This Player";
	}

	start_again:

	if (ptrans->name[0] == 0)
		i = 1;
	else if (!keys_valid(ptrans))
		i = 2;
	else
		i = 4;

	resume:

	if (l < PLAYER_NAME_MAX) {
		ptrans->name[l] = CURSOR_CHAR;
		ptrans->name[l+1] = 0;
	}

	md = wrap_menu_data(ms, me, i);
	i = timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
	unwrap_menu_data(md);

	ptrans->name[l] = 0;

	switch (i) {
		case MK_CONFIRM:
			if (ptrans->name[0] == 0) {
				run_error_menu(ms, "You must enter a name.");
				i = 1;
				goto resume;
			}
			if (!keys_valid(ptrans)) {
				run_error_menu(ms, "You haven't chosen your keys yet.");
				i = 2;
				goto resume;
			}
			if (ptrans != &single_player) {
				sfx_play(sfx_menu_enter, 1, 0, 1.0);
				return;
			}
			{
				GAME *game = init_game(1, &single_player, opt_n_teletubbies[opt_n_teletubbies_id]);
				if (game) {
					sfx_play(sfx_menu_enter, 1, 0, 1.0);
					new_timeloop(BPS_TO_TIMER(GAME_FPS), 10, &draw_game, &update_game, game);
					shut_down_game(game);
				} else
					run_error_menu(ms, "Out of memory!");
			}
			i = 4;
			goto resume;
		case MK_ENTER_ON_NAME:
			if (ptrans->name[0])
				sfx_play(sfx_menu_enter, 1, 0, 1.0);
			else
				sfx_play(sfx_menu_error, 1, 0, 1.0);
			goto start_again;
	}
	/* MK_END or MK_CANCEL */
	if (ptrans != &single_player && (i == MK_CANCEL || !keys_valid(ptrans)))
		ptrans->name[0] = 0;

	sfx_play(sfx_menu_enter, 1, 0, 1.0);
}

