#include "main.h"
#include "tconfig.h"
#include "menu.h"
#include "menuproc.h"
#include "m_missn.h"
#include "timeloop.h"
#include "sfx.h"
#include "sfxplay.h"



void run_mission_menu(MENU_SYSTEM *ms)
{
	MENU_ENTRY me[] = {
		/* draw            , x         , y                          , dp1                                , key     , k1    , kp1 */
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*9, "MISSION"                          , &mk_exit, MK_END, NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*5, "You have been sent over the hills", NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*3, "and far away. Your mission is to" , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*1, "restore the peace. To do so you"  , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*1, "must annihilate all Teletubbies." , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*3, "Good luck, soldier."              , NULL    , 0     , NULL},
		{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*7, "Press Enter or Space to continue" , NULL    , 0     , NULL},
		{NULL              , 0         , 0                          , NULL                               , NULL    , 0     , NULL}
	};

	MENU_DATA *md = wrap_menu_data(ms, me, 0);
	timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
	unwrap_menu_data(md);

	sfx_play(sfx_menu_enter, 1, 0, 1.0);
}
