#include "main.h"
#include "bsp.h"
#include "sfxplay.h"



void draw_prepare_bsp_tree(MATRIX_f *camera, BSP_TREE *tree)
{
	int n;

	for (n = 0; n < tree->n_vtx; n++)
		draw_prepare_vertex(camera, &tree->vtx[n>>8][n&255]);
}



static BITMAP *drawbmp;
static MATRIX_f *drawcamera;
static float drawxc, drawyc, drawzc;
static BSP_TREE *drawtree;



static void draw_bsp_node(BSP_NODE *node)
{
	POLYGON *poly;
	float zn;
	int n;
	int n_vtx;

	if (!node)
		return;

	poly = node->poly;

	zn =
		poly->xn * (poly->p[0].vtx->x - drawxc) +
		poly->yn * (poly->p[0].vtx->y - drawyc) +
		poly->zn * (poly->p[0].vtx->z - drawzc);

	if (zn <= 0) {
		draw_bsp_node(node->neg);

		for (n = 0; n < poly->n_vtx; n++) {
			V3D_f *v3d = drawtree->v3d[n];
			v3d->x = poly->p[n].vtx->xt;
			v3d->y = poly->p[n].vtx->yt;
			v3d->z = poly->p[n].vtx->zt;
			v3d->u = poly->p[n].u;
			v3d->v = poly->p[n].v;
		}

		n_vtx = clip3d_f(
			POLYTYPE_PTEX_MASK, MIN_Z, MAX_Z, poly->n_vtx,
			(const V3D_f **)drawtree->v3d, drawtree->v3dc, drawtree->v3dt, drawtree->out
		);

		if (n_vtx) {
			for (n = 0; n < n_vtx; n++) {
				V3D_f *v3d = drawtree->v3dc[n];
				persp_project_f(v3d->x, v3d->y, v3d->z, &v3d->x, &v3d->y);
			}

			polygon3d_f(drawbmp, POLYTYPE_PTEX_MASK, poly->texture, n_vtx, drawtree->v3dc);
		}

		sfx_poll();

		draw_bsp_node(node->pos);
	} else {
		draw_bsp_node(node->pos);
		draw_bsp_node(node->neg);
	}
}



/* Before calling this function, you must:
 * 1. Make sure you have called draw_prepare_vertex on all vertices.
 * 2. Call draw_prepare_bsp_tree() on the tree.
 * 3. Call set_projection_viewport() appropriately. This may be done only
 *    once if the viewport never changes.
 * Steps 1 and 2 need not be repeated if the camera matrix remains the same.
 */
void draw_bsp_tree(BITMAP *bmp, MATRIX_f *camera, float xc, float yc, float zc, BSP_TREE *tree)
{
	drawbmp = bmp;
	drawcamera = camera;

	drawxc = xc;
	drawyc = yc;
	drawzc = zc;

	drawtree = tree;

	draw_bsp_node(tree->root);
}

