#include <stdlib.h>
#include <math.h>
#include "main.h"
#include "tdumb.h"
#include "triwave.h"



#define C3_HALFPERIOD 501



typedef struct TRIWAVE_SIGRENDERER TRIWAVE_SIGRENDERER;

struct TRIWAVE_SIGRENDERER
{
	int n_channels;
	long time;
	int subtime;
};



static sigrenderer_t *triwave_start_sigrenderer(DUH *duh, sigdata_t *sigdata, int n_channels, long pos)
{
	TRIWAVE_SIGRENDERER *triwave_sr = malloc(sizeof(*triwave_sr));

	(void)duh;
	(void)sigdata;

	if (!triwave_sr)
		return NULL;

	triwave_sr->n_channels = n_channels;

	triwave_sr->time = (pos + C3_HALFPERIOD/2) % (C3_HALFPERIOD * 2);
	triwave_sr->subtime = 0;

	return triwave_sr;
}



static long triwave_sigrenderer_get_samples(sigrenderer_t *sigrenderer, float volume, float delta, long size, sample_t **samples)
{
	TRIWAVE_SIGRENDERER *triwave_sr = sigrenderer;
	int dt = floor(delta * 65536 + 0.5);
	long s;
	int vol = floor(volume * (65534*256) / C3_HALFPERIOD + 0.5);

	ASSERT(triwave_sr->n_channels == 1);

	for (s = 0; s < size; s++) {
		int x = triwave_sr->time >= C3_HALFPERIOD ? triwave_sr->time - C3_HALFPERIOD*3/2 : C3_HALFPERIOD/2 - triwave_sr->time;
		x *= vol;
		samples[0][s] += x;
		triwave_sr->subtime += dt;
		triwave_sr->time += triwave_sr->subtime >> 16;
		triwave_sr->subtime &= 65535;
		triwave_sr->time %= C3_HALFPERIOD * 2;
	}

	return size;
}



static void triwave_sigrenderer_get_current_sample(sigrenderer_t *sigrenderer, float volume, sample_t *samples)
{
	TRIWAVE_SIGRENDERER *triwave_sr = sigrenderer;
	int vol = floor(volume * (65534*256) / C3_HALFPERIOD + 0.5);
	int x;

	ASSERT(triwave_sr->n_channels == 1);

	x = triwave_sr->time >= C3_HALFPERIOD ? triwave_sr->time - C3_HALFPERIOD*3/2 : C3_HALFPERIOD/2 - triwave_sr->time;
	x *= vol;
	samples[0] += x;
}



static void triwave_end_sigrenderer(sigrenderer_t *sigrenderer)
{
	free(sigrenderer);
}



DUH_SIGTYPE_DESC triwave_desc = {
	0,
	NULL,
	&triwave_start_sigrenderer,
	NULL,
	&triwave_sigrenderer_get_samples,
	&triwave_sigrenderer_get_current_sample,
	&triwave_end_sigrenderer,
	NULL,
};
