#include <stdlib.h>
#include <math.h>
#include "main.h"
#include "tdumb.h"
#include "sqwave.h"



#define C3_HALFPERIOD 501



typedef struct SQWAVE_SIGRENDERER SQWAVE_SIGRENDERER;

struct SQWAVE_SIGRENDERER
{
	int n_channels;
	long time;
	int subtime;
	int phase;
};



static sigrenderer_t *sqwave_start_sigrenderer(DUH *duh, sigdata_t *sigdata, int n_channels, long pos)
{
	SQWAVE_SIGRENDERER *sqwave_sr = malloc(sizeof(*sqwave_sr));

	(void)duh;
	(void)sigdata;

	if (!sqwave_sr)
		return NULL;

	sqwave_sr->n_channels = n_channels;

	sqwave_sr->time = pos % (C3_HALFPERIOD * 2);
	sqwave_sr->subtime = 0;

	if (sqwave_sr->time >= C3_HALFPERIOD) {
		sqwave_sr->time -= C3_HALFPERIOD;
		sqwave_sr->phase = -1;
	} else
		sqwave_sr->phase = 1;

	return sqwave_sr;
}



static long sqwave_sigrenderer_get_samples(sigrenderer_t *sigrenderer, float volume, float delta, long size, sample_t **samples)
{
	SQWAVE_SIGRENDERER *sqwave_sr = sigrenderer;
	int dt = floor(delta * 65536 + 0.5);
	long s;
	int vol = floor(volume * (32767*256) + 0.5);

	ASSERT(sqwave_sr->n_channels == 1);

	for (s = 0; s < size; s++) {
		samples[0][s] += vol * sqwave_sr->phase;
		sqwave_sr->subtime += dt;
		sqwave_sr->time += sqwave_sr->subtime >> 16;
		sqwave_sr->subtime &= 65535;
		while (sqwave_sr->time >= 501) {
			sqwave_sr->time -= 501;
			sqwave_sr->phase = -sqwave_sr->phase;
		}
	}

	return size;
}



static void sqwave_sigrenderer_get_current_sample(sigrenderer_t *sigrenderer, float volume, sample_t *samples)
{
	SQWAVE_SIGRENDERER *sqwave_sr = sigrenderer;
	int vol = floor(volume * (32767*256) + 0.5);

	ASSERT(sqwave_sr->n_channels == 1);

	samples[0] += vol * sqwave_sr->phase;
}



static void sqwave_end_sigrenderer(sigrenderer_t *sigrenderer)
{
	free(sigrenderer);
}



DUH_SIGTYPE_DESC sqwave_desc = {
	0,
	NULL,
	&sqwave_start_sigrenderer,
	NULL,
	&sqwave_sigrenderer_get_samples,
	&sqwave_sigrenderer_get_current_sample,
	&sqwave_end_sigrenderer,
	NULL,
};
