#include <stdlib.h>
#include <aldumb.h>
#include "main.h"
#include "sfxplay.h"



struct SFX
{
	SFX *next;
	AL_DUH_PLAYER *dp;
	int voice;
};

#define SFX_VOICES 64
#define SFX_VOICE_RELEASED 1

static SFX *sfx_voice[SFX_VOICES];
int sfx_voice_flags[SFX_VOICES];


static long bufsize;
static int freq;



void init_sfx(void)
{
	int i;
	for (i = 0; i < SFX_VOICES; i++)
		sfx_voice[i] = NULL;

	dumb_resampling_quality = get_config_int("sound", "dumb_resampling_quality", 1);
	dumb_resampling_quality = MID(0, dumb_resampling_quality, 4);
	bufsize = get_config_int("sound", "dumb_buffer_size", 1024);
	bufsize = MID(256, bufsize, 65536);
	freq = get_config_int("sound", "dumb_rendering_frequency", 44100);
	freq = MID(8000, freq, 48000);
}



void shut_down_sfx(void)
{
	int i;
	for (i = 0; i < SFX_VOICES; i++)
		sfx_stop(sfx_voice[i]);

	set_config_int("sound", "dumb_resampling_quality", dumb_resampling_quality);
	set_config_int("sound", "dumb_buffer_size", bufsize);
	set_config_int("sound", "dumb_rendering_frequency", freq);
}



void sfx_poll(void)
{
	int i;
	for (i = 0; i < SFX_VOICES; i++) {
		if (sfx_voice[i]) {
			if (al_poll_duh(sfx_voice[i]->dp)) {
				if (sfx_voice_flags[i] & SFX_VOICE_RELEASED) {
					al_stop_duh(sfx_voice[i]->dp);
					free(sfx_voice[i]);
					sfx_voice[i] = NULL;
				}
			}
		}
	}
}



SFX *sfx_start(DUH *duh, int n_channels, long pos, float volume)
{
	int i;

	volume /= 4.0;

	for (i = 0; i < SFX_VOICES; i++) {
		if (!sfx_voice[i]) {
			SFX *sfx = malloc(sizeof(*sfx));

			if (!sfx)
				return NULL;

			sfx->dp = al_start_duh(duh, n_channels, pos, volume, bufsize, freq);

			if (!sfx->dp) {
				free(sfx);
				return NULL;
			}

			sfx->voice = i;
			sfx_voice[i] = sfx;
			sfx_voice_flags[i] = 0;

			return sfx;
		}
	}

	return NULL;
}



void sfx_stop(SFX *sfx)
{
	if (sfx) {
		sfx_voice[sfx->voice] = NULL;
		al_stop_duh(sfx->dp);
		free(sfx);
	}
}



void sfx_release(SFX *sfx)
{
	if (sfx)
		sfx_voice_flags[sfx->voice] |= SFX_VOICE_RELEASED;
}



void sfx_play(DUH *duh, int n_channels, long pos, float volume)
{
	sfx_release(sfx_start(duh, n_channels, pos, volume));
}

