#include "mathpi.h"
#include "main.h"
#include "game.h"
#include "player.h"
#include "timeloop.h"
#include "screen.h"
#include "fire.h"



typedef struct PLAYER_DATA PLAYER_DATA;

#define PD_FIRE_HELD 1

struct PLAYER_DATA
{
	GAME *game;
	int p;
	int flags;
	float phi, theta;
	float xv, yv, zv, phiv, thetav;
	int health;
};



static void update_player(GAME *game, SPRITE *sprite)
{
	PLAYER_DATA *pd = sprite->data;
	PLAYER_TRANS *ptrans = pd->game->ptrans[pd->p];

	unsigned char kl = ckey[pd->p][K_TURN_LEFT];
	unsigned char kr = ckey[pd->p][K_TURN_RIGHT];
	unsigned char kd = ckey[pd->p][K_LOOK_DOWN];
	unsigned char ku = ckey[pd->p][K_LOOK_UP];
	unsigned char kf = ckey[pd->p][K_WALK_FORWARDS];
	unsigned char kb = ckey[pd->p][K_STEP_BACKWARDS];
	unsigned char ksl = ckey[pd->p][K_SIDESTEP_LEFT];
	unsigned char ksr = ckey[pd->p][K_SIDESTEP_RIGHT];
	unsigned char kfire = ckey[pd->p][K_FIRE];

	float zlow;
	int outside;

	if (kfire) {
		if (pd->flags & PD_FIRE_HELD)
			kfire = 0;
		pd->flags |= PD_FIRE_HELD;
	} else
		pd->flags &= ~PD_FIRE_HELD;

	if (kl && !kr)
		pd->phiv -= 0.001;
	else if (kr && !kl)
		pd->phiv += 0.001;

	pd->phi += pd->phiv;
	pd->phiv *= 0.97;

	if (pd->phi >= 2*M_PI) pd->phi -= 2*M_PI;
	if (pd->phi < 0) pd->phi += 2*M_PI;

	if (kd && !ku)
		pd->thetav -= 0.0005;
	else if (ku && !kd)
		pd->thetav += 0.0005;

	pd->theta += pd->thetav;
	pd->theta *= 0.98;
	pd->thetav *= 0.97;

	pd->zv -= 0.001;

	pd->xv *= 0.95;
	pd->yv *= 0.95;
	pd->zv *= 0.95;

#if 0
	/* I couldn't get this code working as nicely as I'd have liked, so I
	 * disabled it. Oh well.
	 */
	zlow = get_ground_height(game->world, sprite->x + pd->xv, sprite->y + pd->yv, &outside) + sprite->zr;
	zlow -= sprite->z;

	if (zlow > 0) {
		if (outside) {
			float s = (0.45 / sprite->zr) * (sprite->z + sprite->zr);
			pd->xv *= s;
			pd->yv *= s;
			pd->zv *= 0.2;
			if (sprite->z < -sprite->zr) {
				sprite->flags |= SPRITE_DEAD;
				return;
			}
		}
		{
			float s = 1 - 100 * zlow;
			if (s < 0) s = 0;
			pd->xv *= s;
			pd->yv *= s;
			pd->zv *= s;
		}
		if (!outside) {
			float ztofloor = zlow;
			if (pd->zv < ztofloor) pd->zv = ztofloor;
		}
	}
#else
	zlow = get_ground_height(game->world, sprite->x + pd->xv, sprite->y + pd->yv, &outside) + sprite->zr;
	zlow -= sprite->z + pd->zv;

	if (zlow > 0) {
		if (outside)
			pd->zv *= 0.4;
		else
			pd->zv += zlow;
	} else
		outside = 0;
#endif

	sprite->x += pd->xv;
	sprite->y += pd->yv;
	sprite->z += pd->zv;

	if (outside) {
		if (sprite->z < -sprite->zr)
			sprite->flags |= SPRITE_DEAD;
	} else {
		/* This would go at the beginning of the function, without the
		 * enclosing if structure, if the above substitution had not been
		 * made.
		 */
		if (kf && !kb) {
			pd->xv += 0.0005 * sin(pd->phi);
			pd->yv -= 0.0005 * cos(pd->phi);
		} else if (kb && !kf) {
			pd->xv -= 0.0003 * sin(pd->phi);
			pd->yv += 0.0003 * cos(pd->phi);
		}

		if (ksr && !ksl) {
			pd->xv += 0.0004 * cos(pd->phi);
			pd->yv += 0.0004 * sin(pd->phi);
		} else if (ksl && !ksr) {
			pd->xv -= 0.0004 * cos(pd->phi);
			pd->yv -= 0.0004 * sin(pd->phi);
		}

		if (kfire)
			fire_bullet(game, ptrans, sprite->x, sprite->y, sprite->z + sprite->zr*0.75, pd->phi, pd->theta);
	}
}



static void destroy_player(void *data)
{
	PLAYER_DATA *pd = data;

	pd->game->ptrans[pd->p]->sprite = NULL;

	free(data);
}



static void shoot_player(PLAYER_TRANS *ptrans, SPRITE *sprite, float r, float zr)
{
	(void)r;
	(void)zr;

	player_deduct_health(sprite, 100);

	/* Lose 100 points for shooting another player. */
	ptrans->score -= 100;
}



void create_player(GAME *game, int p, float x, float y, float phi)
{
	PLAYER_DATA *pd = malloc(sizeof(*pd));
	float zr, z;

	if (!pd) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!\n");
		exit(1);
	}

	pd->game = game;
	pd->p = p;
	pd->flags = PD_FIRE_HELD;
	pd->phi = phi;
	pd->theta = 0;
	pd->thetav = pd->phiv = pd->zv = pd->yv = pd->xv = 0;
	pd->health = 1000;

	zr = 0.1;
	z = get_ground_height(game->world, x, y, NULL) + zr;
	game->ptrans[p]->sprite = add_sprite(game, 0, &update_player, x, y, z, 0.035, zr, &shoot_player, &destroy_player, pd, player_texture);

	if (!game->ptrans[p]->sprite) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!\n");
		exit(1);
	}
}



int player_get_health(SPRITE *sprite)
{
	PLAYER_DATA *pd = sprite->data;
	return pd->health;
}



void player_deduct_health(SPRITE *sprite, int n)
{
	PLAYER_DATA *pd = sprite->data;
	pd->health -= n;
	if (pd->health <= 0)
		sprite->flags |= SPRITE_DEAD;
}



void get_player_camera(PLAYER_TRANS *ptrans, CAMERA_POSITION *c)
{
	PLAYER_DATA *pd = ptrans->sprite->data;
	c->x = ptrans->sprite->x;
	c->y = ptrans->sprite->y;
	c->z = ptrans->sprite->z + ptrans->sprite->zr*0.75;
	c->phi = pd->phi;
	c->theta = pd->theta;
}

