#include <stdlib.h>
#include "mathpi.h"
#include "main.h"
#include "tdumb.h"
#include "pattern.h"



typedef struct PATTERN_SIGRENDERER PATTERN_SIGRENDERER;

struct PATTERN_SIGRENDERER
{
	DUH *duh;
	PATTERN *start;
	PATTERN *current;
	int n_channels;
	DUMB_CLICK_REMOVER **cr;
	DUH_SIGRENDERER *note[256];
	int volume[256];
	int pitch[256];
	int speed;
	long time_left;
	long sub_time_left;
};



static void process_command(PATTERN_SIGRENDERER *sigrenderer)
{
	for (;;) {
		PATTERN *pattern = sigrenderer->current;
		switch (pattern->command) {
			case P_LOOP:
				sigrenderer->current = sigrenderer->start;
				return;
			case P_ROW:
				sigrenderer->current++;
				return;
			case P_SPEED:
				sigrenderer->speed = (int)(unsigned short)pattern->p4 + ((int)pattern->p3 << 8);
				break;
			case P_NOTE:
				duh_end_sigrenderer(sigrenderer->note[pattern->p1]);
				if (pattern->p2) {
					int pos;
					sigrenderer->volume[pattern->p1] = pattern->p3;
					sigrenderer->pitch[pattern->p1] = pattern->p4;
					pos = ((float)pattern->p5 * sigrenderer->speed / 256.0) * pow(DUMB_PITCH_BASE, -pattern->p4);
					sigrenderer->note[pattern->p1] = duh_start_sigrenderer(sigrenderer->duh, pattern->p2, sigrenderer->n_channels, pos);
				} else
					sigrenderer->note[pattern->p1] = NULL;
				break;
			case P_PARAM:
				sigrenderer->volume[pattern->p1] = pattern->p3;
				sigrenderer->pitch[pattern->p1] = pattern->p4;
				break;
			default:
				/* Assume P_END */
				sigrenderer->current = NULL;
				return;
		}
		sigrenderer->current++;
	}
}



static sigrenderer_t *pattern_start_sigrenderer(DUH *duh, sigdata_t *sigdata, int n_channels, long pos)
{
	PATTERN_SIGRENDERER *sigrenderer = malloc(sizeof(*sigrenderer));
	int i;

	if (!sigrenderer)
		return NULL;

	sigrenderer->duh = duh;
	sigrenderer->n_channels = n_channels;
	sigrenderer->current = sigrenderer->start = sigdata;
	sigrenderer->speed = 65536;

	sigrenderer->cr = dumb_create_click_remover_array(n_channels);

	for (i = 0; i < 256; i++)
		sigrenderer->note[i] = NULL;

	sigrenderer->time_left = -pos;
	sigrenderer->sub_time_left = 0;

	return sigrenderer;
}



static long pattern_sigrenderer_get_samples(sigrenderer_t *vsigrenderer, float volume, float delta, long size, sample_t **samples)
{
	PATTERN_SIGRENDERER *sigrenderer = vsigrenderer;
	long s = 0;
	LONG_LONG t;
	long todo;
	int i;
	int dt = floor(delta * 65536 + 0.5);

	sample_t *sptr[2];
	sample_t sclick[2];

	ASSERT(sigrenderer->n_channels <= 2);

	for (i = 0; i < sigrenderer->n_channels; i++)
		sptr[i] = samples[i];

	while (s < size) {
		todo = (long)((((LONG_LONG)sigrenderer->time_left << 16) | sigrenderer->sub_time_left) / dt);
		while (todo <= 0) {
			if (!sigrenderer->current) goto finished;
			if (sigrenderer->current == sigrenderer->start) {
				for (i = 0; i < 256; i++) {
					duh_end_sigrenderer(sigrenderer->note[i]);
					sigrenderer->note[i] = NULL;
				}
			}
			process_command(sigrenderer);
			sigrenderer->time_left += sigrenderer->speed;
			todo = (long)((((LONG_LONG)sigrenderer->time_left << 16) | sigrenderer->sub_time_left) / dt);
		}

		if (todo > size - s)
			todo = size - s;

		for (i = 0; i < 256; i++) {
			if (sigrenderer->note[i]) {
				long l;
				float v = volume * sigrenderer->volume[i] / 255.0;
				dumb_silence(sclick, sigrenderer->n_channels);
				duh_sigrenderer_get_current_sample(sigrenderer->note[i], v, sclick);
				dumb_record_click_array(sigrenderer->n_channels, sigrenderer->cr, s, sclick);
				l = duh_sigrenderer_get_samples(sigrenderer->note[i],
					v, delta * pow(DUMB_PITCH_BASE, sigrenderer->pitch[i]),
					todo, sptr);
				dumb_silence(sclick, sigrenderer->n_channels);
				duh_sigrenderer_get_current_sample(sigrenderer->note[i], v, sclick);
				dumb_record_click_negative_array(sigrenderer->n_channels, sigrenderer->cr, s + l, sclick);
				if (l < todo) {
					duh_end_sigrenderer(sigrenderer->note[i]);
					sigrenderer->note[i] = NULL;
				}
			}
		}

		for (i = 0; i < sigrenderer->n_channels; i++)
			sptr[i] += todo;

		s += todo;

		t = sigrenderer->sub_time_left - (LONG_LONG)todo * dt;
		sigrenderer->sub_time_left = (long)t & 65535;
		sigrenderer->time_left += (long)(t >> 16);
	}

	finished:

	dumb_remove_clicks_array(sigrenderer->n_channels, sigrenderer->cr, samples, s, 512.0f);// / delta);

	return s;
}



static void pattern_sigrenderer_get_current_sample(sigrenderer_t *vsigrenderer, float volume, sample_t *samples)
{
	PATTERN_SIGRENDERER *sigrenderer = vsigrenderer;
	(void)volume;
	dumb_click_remover_get_offset_array(sigrenderer->n_channels, sigrenderer->cr, samples);
}



static void pattern_end_sigrenderer(sigrenderer_t *vsigrenderer)
{
	PATTERN_SIGRENDERER *sigrenderer = vsigrenderer;
	dumb_destroy_click_remover_array(sigrenderer->n_channels, sigrenderer->cr);
	free(vsigrenderer);
}



DUH_SIGTYPE_DESC pattern_desc = {
	0,
	NULL,
	&pattern_start_sigrenderer,
	NULL,
	&pattern_sigrenderer_get_samples,
	&pattern_sigrenderer_get_current_sample,
	&pattern_end_sigrenderer,
	NULL
};

