#include "main.h"

#define DEFINE_PATTERN_CONSTRUCTORS
#include "pattern.h"
#include "sqwave.h"
#include "triwave.h"
#include "noise.h"

#include "music.h"

#include "sfxplay.h"



#define H1 3072
#define H2 4869
#define H3 6144
#define H4 7133



#define SQ 1
#define TR 2
#define NS 3
#define BD 4
#define RB 5
#define BASS 6
#define HH 7
#define HHBEAT 8
#define SNROLL 9
#define SNRIFF 10
#define YAY 11
#define BASSLN1 12
#define BASSLN2 13
#define BASSLN3 14
#define BASSLN4 15
#define TUNE1 16
#define TUNE2 17
#define TUNE3 18
#define N_MUSIC_SIGNALS 19

static PATTERN pattern_bass_drum[] = {
	S(150,32),
	N(0,TR,255,24,    0*5,0),R(),
	P(0,   255,24, -100*5  ),R(),
	P(0,   255,24, -200*5  ),R(),
	P(0,   255,24, -295*5  ),R(),
	P(0,   255,24, -390*5  ),R(),
	P(0,   255,24, -480*5  ),R(),
	P(0,   255,24, -570*5  ),R(),
	P(0,   255,24, -655*5  ),R(),
	P(0,   255,24, -740*5  ),R(),
	P(0,   255,24, -820*5  ),R(),
	P(0,   255,24, -900*5  ),R(),
	P(0,   255,24, -975*5  ),R(),
	P(0,   255,24,-1050*5  ),R(),
	P(0,   255,24,-1120*5  ),R(),
	P(0,   255,24,-1190*5  ),R(),
	P(0,   255,24,-1255*5  ),R(),
	P(0,   255,24,-1320*5  ),R(),
	P(0,   255,24,-1380*5  ),R(),
	P(0,   255,24,-1440*5  ),R(),
	P(0,   255,24,-1495*5  ),R(),
	P(0,   255,24,-1550*5  ),R(),
	P(0,   255,24,-1600*5  ),R(),
	P(0,   255,24,-1650*5  ),R(),
	P(0,   255,24,-1695*5  ),R(),
	S(150,16),
	P(0,   255,24,-1740*5  ),R(),
	P(0,   242,24,-1780*5  ),R(),
	P(0,   230,24,-1820*5  ),R(),
	P(0,   217,24,-1855*5  ),R(),
	P(0,   204,24,-1890*5  ),R(),
	P(0,   191,24,-1920*5  ),R(),
	P(0,   179,24,-1950*5  ),R(),
	P(0,   166,24,-1975*5  ),R(),
	P(0,   153,24,-2000*5  ),R(),
	P(0,   140,24,-2020*5  ),R(),
	P(0,   128,24,-2040*5  ),R(),
	P(0,   115,24,-2055*5  ),R(),
	P(0,   102,24,-2070*5  ),R(),
	P(0,    89,24,-2080*5  ),R(),
	P(0,    77,24,-2090*5  ),R(),
	P(0,    64,24,-2095*5  ),R(),
	P(0,    51,24,-2100*5  ),R(),
	P(0,    38,24,-2100*5  ),R(),
	P(0,    26,24,-2100*5  ),R(),
	P(0,    13,24,-2100*5  ),E()
};

static PATTERN pattern_rub[] = {
	S(150,64),
	N(0,NS,  8,24,0,0),R(),
	P(0,    20,24,0  ),R(),
	P(0,    40,24,0  ),R(),
	P(0,    64,24,0  ),R(),
	P(0,    96,24,0  ),R(),
	P(0,   125,24,0  ),R(),
	P(0,   160,24,0  ),R(),
	P(0,   200,24,0  ),R(),
	P(0,   255,24,0  ),R(),
	P(0,   255,24,0  ),R(),
	P(0,   224,24,0  ),R(),
	P(0,   192,24,0  ),R(),
	P(0,   160,24,0  ),R(),
	P(0,   128,24,0  ),R(),
	P(0,   112,24,0  ),R(),
	P(0,    96,24,0  ),R(),
	P(0,    78,24,0  ),R(),
	P(0,    62,24,0  ),R(),
	P(0,    50,24,0  ),R(),
	P(0,    40,24,0  ),R(),
	P(0,    32,24,0  ),R(),
	P(0,    24,24,0  ),R(),
	P(0,    16,24,0  ),R(),
	P(0,     8,24,0  ),E()
};

static PATTERN pattern_bass[] = {
	S(150,16),
	N(0,BD,255,0,0,0),N(1,BD,255,12,0,0),R(),R(),
	R(),R(),
	R(),R(),
	R(),N(2,RB,255,0,0,0),R(),
	R(),R(),
	R(),R(),
	R(),R(),
	R(),E()
};

static PATTERN pattern_high_hat[] = {
	S(150,32),
	N(0,NS,255,84,0,0),R(),
	P(0,   224,84,0  ),R(),
	P(0,   192,84,0  ),R(),
	P(0,   160,84,0  ),R(),
	P(0,   128,84,0  ),R(),
	P(0,   112,84,0  ),R(),
	P(0,    96,84,0  ),R(),
	P(0,    80,84,0  ),R(),
	P(0,    64,84,0  ),R(),
	P(0,    56,84,0  ),R(),
	P(0,    48,84,0  ),R(),
	P(0,    44,84,0  ),R(),
	P(0,    40,84,0  ),R(),
	P(0,    36,84,0  ),R(),
	P(0,    34,84,0  ),R(),
	P(0,    32,84,0  ),E()
};

static PATTERN pattern_high_hat_beat[] = {
	S(150,16),
	R(),R(),R(),R(),
	N(0,HH,128,2,0,0),R(),R(),R(),N(0,0,0,0,0,0),R(),
	N(0,HH, 64,1,0,0),R(),R(),N(0,0,0,0,0,0),R(),R(),
	N(0,HH, 32,0,0,0),R(),R(),N(0,0,0,0,0,0),R(),R(),
	N(0,HH,192,3,0,0),R(),R(),R(),N(0,0,0,0,0,0),R(),
	N(0,HH,128,2,0,0),R(),R(),N(0,0,0,0,0,0),R(),R(),
	N(0,HH, 64,1,0,0),R(),R(),N(0,0,0,0,0,0),R(),R(),
	N(0,HH,255,4,0,0),R(),R(),R(),N(0,0,0,0,0,0),E()
};

static PATTERN pattern_snare_roll[] = {
	S(150,16),
	N(0,HH,255,-12,0,0),R(),P(0,64,-12,0),R(),
	N(0,HH,192,-12,0,0),R(),P(0,48,-12,0),R(),
	N(0,HH,160,-12,0,0),R(),P(0,40,-12,0),R(),
	N(0,HH,140,-12,0,0),R(),P(0,35,-12,0),R(),
	N(0,HH,128,-12,0,0),R(),P(0,32,-12,0),R(),
	N(0,HH,140,-12,0,0),R(),P(0,35,-12,0),R(),
	N(0,HH,160,-12,0,0),R(),P(0,40,-12,0),R(),
	N(0,HH,192,-12,0,0),R(),P(0,48,-12,0),E()
};

static PATTERN pattern_snare_riff[] = {
	S(150,16),
	N(0,HH, 32,-7,0,0),R(),P(0, 8,-7,0),R(),
	N(0,HH, 64,-7,0,0),R(),P(0,16,-7,0),R(),
	N(0,HH, 96,-7,0,0),R(),P(0,24,-7,0),R(),
	N(0,HH,128,-7,0,0),R(),P(0,32,-7,0),R(),
	N(0,HH,160,-7,0,0),R(),P(0,40,-7,0),R(),
	N(0,HH,192,-7,0,0),R(),P(0,48,-7,0),R(),
	N(0,HH,224,-7,0,0),R(),P(0,56,-7,0),R(),
	N(0,HH,255,-7,0,0),R(),P(0,64,-7,0),E()
};

static PATTERN pattern_yay[] = {
	S(150,64),
	N(0,TR, 32,51,   0*3/2,0),R(),
	P(0,    64,51, 100*3/2  ),R(),
	P(0,    96,51, 220*3/2  ),R(),
	P(0,   128,51, 360*3/2  ),R(),
	P(0,   160,51, 420*3/2  ),R(),
	P(0,   192,51, 600*3/2  ),R(),
	P(0,   224,51, 800*3/2  ),R(),
	P(0,   255,51,1020*3/2  ),R(),
	S(150,32),
	P(0,   255,51,1260*3/2  ),R(),
	P(0,   240,51,1210*3/2  ),R(),
	P(0,   224,51,1160*3/2  ),R(),
	P(0,   208,51,1110*3/2  ),R(),
	P(0,   192,51,1060*3/2  ),R(),
	P(0,   176,51,1010*3/2  ),R(),
	P(0,   160,51, 960*3/2  ),R(),
	P(0,   144,51, 910*3/2  ),R(),
	P(0,   128,51, 860*3/2  ),R(),
	P(0,   112,51, 810*3/2  ),R(),
	P(0,    96,51, 760*3/2  ),R(),
	P(0,    80,51, 710*3/2  ),R(),
	P(0,    64,51, 660*3/2  ),R(),
	P(0,    48,51, 610*3/2  ),R(),
	P(0,    32,51, 560*3/2  ),R(),
	P(0,    16,51, 510*3/2  ),R()
};

static PATTERN pattern_bassline1[] = {
	S(150,8),
	N(0,TR,255,0,0,0),R(),R(),R(),R(),
	N(0,TR,255,10,0,0),R(),R(),N(0,TR,255,12,0,0),R(),E()
};

static PATTERN pattern_bassline2[] = {
	S(150,8),
	N(0,TR,255,3,0,0),R(),R(),R(),R(),
	N(0,TR,255,10,0,0),R(),R(),N(0,TR,255,15,0,0),R(),E()
};

static PATTERN pattern_bassline3[] = {
	S(150,8),
	N(0,TR,255,-4,0,0),R(),R(),R(),R(),
	N(0,TR,255,5,0,0),R(),R(),N(0,TR,255,17,0,0),R(),E()
};

static PATTERN pattern_bassline4[] = {
	S(150,8),
	N(0,TR,255,-5,0,0),R(),R(),R(),R(),
	N(0,TR,255,7,0,0),R(),R(),N(0,TR,255,19,0,0),R(),E()
};

static PATTERN pattern_tune1[] = {
	S(150,4),
	N(0,SQ,255,24,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,34,0,0),R(),
	N(0,SQ,255,36,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,36,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,31,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,34,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,27,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,24,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,34,0,0),R(),
	N(0,SQ,255,36,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,36,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,31,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,34,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,24,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,27,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,34,0,0),R(),
	N(0,SQ,255,39,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,39,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,34,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,31,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,27,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,29,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,29,0,0),R(),
	N(0,SQ,255,41,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,31,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,31,0,0),R(),
	N(0,0 ,  0, 0,0,0),R(),
	N(0,SQ,255,43,0,0),E()
};

static PATTERN pattern_tune2[] = {
	S(150,4),
	N(0,SQ,255,24+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+12,0,0),R(),
	N(0,SQ,255,36+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,36+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,27+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,24+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+12,0,0),R(),
	N(0,SQ,255,36+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,36+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,24+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,27+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+12,0,0),R(),
	N(0,SQ,255,39+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,39+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,27+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,29+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,29+12,0,0),R(),
	N(0,SQ,255,41+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,31+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+12,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,43+12,0,0),E()
};

static PATTERN pattern_tune3[] = {
	S(150,4),
	N(0,SQ,255,24+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+24,0,0),R(),
	N(0,SQ,255,36+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,36+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,27+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,24+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+24,0,0),R(),
	N(0,SQ,255,36+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,36+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,24+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,27+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+24,0,0),R(),
	N(0,SQ,255,39+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,39+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,34+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,27+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,29+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,29+24,0,0),R(),
	N(0,SQ,255,41+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	R(),
	R(),
	R(),
	N(0,SQ,255,31+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,31+24,0,0),R(),
	N(0,0 ,  0, 0   ,0,0),R(),
	N(0,SQ,255,43+24,0,0),E()
};

static PATTERN pattern_music[] = {
	S(150,1),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),R(),
	S(150,2),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL, 16,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL, 32,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL, 48,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL, 64,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL, 80,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL, 96,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL,112,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL,128,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL,144,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL,160,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL,176,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL,192,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL,208,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(3,SNROLL,224,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(3,SNROLL,240,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	                    N(1,HH    ,255,0,0,0),N(3,SNRIFF,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,HH,255,-60,0,0),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH, 64,0,0,0),N(3,SNRIFF, 64,0,0,0),N(2,YAY, 64,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH, 48,0,0,0),N(3,SNRIFF, 48,0,0,0),N(2,YAY, 48,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH, 32,0,0,0),N(3,SNRIFF, 32,0,0,0),N(2,YAY, 32,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH, 24,0,0,0),N(3,SNRIFF, 24,0,0,0),N(2,YAY, 24,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH, 16,0,0,0),N(3,SNRIFF, 16,0,0,0),N(2,YAY, 16,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH, 12,0,0,0),N(3,SNRIFF, 12,0,0,0),N(2,YAY, 12,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  8,0,0,0),N(3,SNRIFF,  8,0,0,0),N(2,YAY,  8,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  6,0,0,0),N(3,SNRIFF,  6,0,0,0),N(2,YAY,  6,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  4,0,0,0),N(3,SNRIFF,  4,0,0,0),N(2,YAY,  4,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  3,0,0,0),N(3,SNRIFF,  3,0,0,0),N(2,YAY,  3,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  2,0,0,0),N(3,SNRIFF,  2,0,0,0),N(2,YAY,  2,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  2,0,0,0),N(3,SNRIFF,  2,0,0,0),N(2,YAY,  2,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  1,0,0,0),N(3,SNRIFF,  1,0,0,0),N(2,YAY,  1,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  1,0,0,0),N(3,SNRIFF,  1,0,0,0),N(2,YAY,  1,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  1,0,0,0),N(3,SNRIFF,  1,0,0,0),N(2,YAY,  1,0,0,0),R(),
	N(4,BASSLN1,255,0,0,0),R(),N(1,HH,  1,0,0,0),N(3,SNRIFF,  1,0,0,0),N(2,YAY,  1,0,0,0),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(5,TUNE1,128,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(6,TUNE1, 32,0,0,0),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(7,TUNE1,  8,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN3,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN3,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN4,255,0,0,0),R(),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN4,255,0,0,0),R(),R(),
	N(5,TUNE1,128,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(6,TUNE1, 32,0,0,0),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(7,TUNE1,  8,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN3,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN3,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN4,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN4,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(5,TUNE2,128,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(6,TUNE2, 32,0,0,0),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(7,TUNE2,  8,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN3,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN3,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN4,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN4,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(5,TUNE3,128,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),N(3,SNROLL, 16,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(6,TUNE3, 32,0,0,0),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),N(3,SNROLL, 32,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(7,TUNE3,  8,0,0,0),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),N(3,SNROLL, 48,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),N(3,SNROLL, 64,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),N(3,SNROLL, 80,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),N(3,SNROLL, 96,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN1,255,0,0,0),N(3,SNROLL,112,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN1,255,0,0,0),N(3,SNROLL,128,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),N(3,SNROLL,144,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),N(3,SNROLL,160,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN2,255,0,0,0),N(3,SNROLL,176,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN2,255,0,0,0),N(3,SNROLL,192,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN3,255,0,0,0),N(3,SNROLL,208,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN3,255,0,0,0),N(3,SNROLL,224,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(1,HHBEAT,255,0,0,0),N(4,BASSLN4,255,0,0,0),N(3,SNROLL,240,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),                      N(4,BASSLN4,255,0,0,0),N(3,SNRIFF,255,0,0,0),R(),N(2,YAY,128,0,0,0),R(),
	N(3,HH,255,-60,0,0),
	N(1,HH,255,0,0,0),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 64,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 60,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 56,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 52,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 48,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 44,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 40,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 36,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 32,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 28,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 24,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 20,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 16,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY, 12,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,  8,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),N(2,YAY,  4,0,0,0),R(),
	S(150,1),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,255,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,240,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,224,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,208,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,192,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,176,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,160,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,144,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,128,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1,112,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1, 96,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1, 80,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1, 64,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1, 48,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1, 32,0,0,0),R(),
	N(0,BASS,255,0,0,0),N(4,BASSLN1, 16,0,0,0),L()
};



static DUH_SIGTYPE_DESC *music_desc[] = {
	&pattern_desc,
	&sqwave_desc,
	&triwave_desc,
	&noise_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&pattern_desc
};

static void *music_signal[] = {
	pattern_music,
	NULL,
	NULL,
	NULL,
	pattern_bass_drum,
	pattern_rub,
	pattern_bass,
	pattern_high_hat,
	pattern_high_hat_beat,
	pattern_snare_roll,
	pattern_snare_riff,
	pattern_yay,
	pattern_bassline1,
	pattern_bassline2,
	pattern_bassline3,
	pattern_bassline4,
	pattern_tune1,
	pattern_tune2,
	pattern_tune3
};



static DUH *music = NULL;
static SFX *music_voice = NULL;



//#define UGLY_WRITE_MUSIC_HACK
#ifdef UGLY_WRITE_MUSIC_HACK
#include <aldumb.h>
struct SFX
{
	SFX *next;
	AL_DUH_PLAYER *dp;
	int voice;
};
static void callback(void *data, const sample_t *const *samples, int n_channels, long length)
{
	PACKFILE *f = data;
	int i;
	(void)n_channels;
	for (i = 0; i < length; i++)
		pack_iputw(MID(-32768, samples[0][i], 32767), f);
}
#endif
void init_music(void)
{
	music = make_duh(0, N_MUSIC_SIGNALS, music_desc, music_signal);
	music_voice = sfx_start(music, 1, 0, 1.0);
#ifdef UGLY_WRITE_MUSIC_HACK
	{
		DUH_SIGRENDERER *sr = al_duh_get_sigrenderer(music_voice->dp);
		PACKFILE *f = pack_fopen("test.pcm", F_WRITE);
		duh_sigrenderer_set_callback(sr, &callback, f);
	}
#endif
}

void shut_down_music(void)
{
	sfx_stop(music_voice);
	unload_duh(music);
}
