#include "main.h"
#include "tconfig.h"
#include "timeloop.h"
#include "menu.h"
#include "menuproc.h"
#include "m_multi.h"
#include "m_single.h"
#include "m_error.h"
#include "game.h"
#include "sfx.h"
#include "sfxplay.h"



#define MK_CONFIRM (MK_USER + 0)



PLAYER_TRANS multiplayer[MAX_PLAYERS] = {
	{"", {0, 0, 0, 0, 0, 0, 0}, NULL, 0},
	{"", {0, 0, 0, 0, 0, 0, 0}, NULL, 0},
	{"", {0, 0, 0, 0, 0, 0, 0}, NULL, 0},
	{"", {0, 0, 0, 0, 0, 0, 0}, NULL, 0}
};



static int mk_edit_player(MENU_SYSTEM *ms, MENU_ENTRY *me, int k)
{
	switch (k >> 8) {
		case KEY_ENTER:
		case KEY_SPACE:
			sfx_play(sfx_menu_enter, 1, 0, 1.0);
			run_single_player_menu(ms, &multiplayer[me->k1]);
			return 0;
		case KEY_DEL:
			multiplayer[me->k1].name[0] = 0;
			return 0;
	}

	return 0;
}



void run_multiplayer_menu(MENU_SYSTEM *ms)
{
	MENU_ENTRY me[] = {
		/* draw            , x                          , y                        , dp1                , key            , k1        , kp1 */
		{&md_textout_right , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*7/2,        "TOP LEFT: ", &mk_edit_player, 0         , NULL},
		{&md_textout_left  , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*7/2, multiplayer[0].name, NULL           , 0         , NULL},
		{&md_textout_right , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*5/2,       "TOP RIGHT: ", &mk_edit_player, 1         , NULL},
		{&md_textout_left  , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*5/2, multiplayer[1].name, NULL           , 0         , NULL},
		{&md_textout_right , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*3/2,     "BOTTOM LEFT: ", &mk_edit_player, 2         , NULL},
		{&md_textout_left  , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*3/2, multiplayer[2].name, NULL           , 0         , NULL},
		{&md_textout_right , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*1/2,    "BOTTOM RIGHT: ", &mk_edit_player, 3         , NULL},
		{&md_textout_left  , (GFX_W >> 1) - (FONT_W*5/2), (GFX_H >> 1) - FONT_H*1/2, multiplayer[3].name, NULL           , 0         , NULL},
		{&md_textout_centre, (GFX_W >> 1)               , (GFX_H >> 1) + FONT_H*3/2, "Play Game"        , &mk_exit       , MK_CONFIRM, NULL},
		{&md_textout_centre, (GFX_W >> 1)               , (GFX_H >> 1) + FONT_H*5/2, "Cancel"           , &mk_exit       , MK_END    , NULL},
		{NULL              , 0                          , 0                        , NULL               , NULL           , 0         , NULL}
	};

	int focus = 0;
	MENU_DATA *md;
	int i;

	resume:

	md = wrap_menu_data(ms, me, focus);
	i = timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
	focus = unwrap_menu_data(md);

	if (i == MK_CONFIRM) {
		int n_players = 0;
		for (i = 0; i < MAX_PLAYERS; i++)
			if (multiplayer[i].name[0])
				n_players++;
		if (n_players >= 2) {
			GAME *game = init_game(n_players, multiplayer, opt_n_teletubbies[opt_n_teletubbies_id]);
			if (game) {
				sfx_play(sfx_menu_enter, 1, 0, 1.0);
				new_timeloop(BPS_TO_TIMER(GAME_FPS), 10, &draw_game, &update_game, game);
				shut_down_game(game);
			} else
				run_error_menu(ms, "Out of memory!");
		} else
			run_error_menu(ms, "You must have at least two players.");
		goto resume;
	}

	sfx_play(sfx_menu_enter, 1, 0, 1.0);
}

