#include "main.h"
#include "tconfig.h"
#include "timeloop.h"
#include "screen.h"
#include "menu.h"
#include "menuproc.h"
#include "m_main.h"
#include "m_error.h"
#include "m_single.h"
#include "m_multi.h"
#include "m_option.h"
#include "m_credit.h"
#include "m_missn.h"
#include "sfx.h"
#include "sfxplay.h"



#define MK_OPTIONS (MK_USER + 0)



static void md_title(BITMAP *bmp, MENU_ENTRY *me, int focused)
{
	(void)focused;
	textout_centre(bmp, font, me->dp1, me->x, me->y, makecol(255,255,255));
}



static void mkc_mission(MENU_SYSTEM *ms)
{
	sfx_play(sfx_menu_enter, 1, 0, 1.0);
	run_mission_menu(ms);
}



static void mkc_play_game(MENU_SYSTEM *ms)
{
	sfx_play(sfx_menu_enter, 1, 0, 1.0);
	run_single_player_menu(ms, &single_player);
}



static void mkc_multiplayer(MENU_SYSTEM *ms)
{
	sfx_play(sfx_menu_enter, 1, 0, 1.0);
	run_multiplayer_menu(ms);
}



static void mkc_credits(MENU_SYSTEM *ms)
{
	sfx_play(sfx_menu_enter, 1, 0, 1.0);
	run_credits_menu(ms, 0);
}



void run_main_menu(MENU_SYSTEM *ms)
{
	restart:

	{
		MENU_ENTRY me[] = {
			/* draw            , x         , y                          , dp1           , key     , k1        , kp1 */
			{&md_title         , GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*8, "TeleHack"    , NULL    , 0         , NULL            },
			{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*4, "View Mission", &mk_call, 0         , &mkc_mission    },
			{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*2, "Play Game"   , &mk_call, 0         , &mkc_play_game  },
			{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) - (FONT_H/2)*0, "Multiplayer" , &mk_call, 0         , &mkc_multiplayer},
			{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*2, "Options"     , &mk_exit, MK_OPTIONS, NULL            },
			{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*4, "Credits"     , &mk_call, 0         , &mkc_credits    },
			{&md_textout_centre, GFX_W >> 1, (GFX_H >> 1) + (FONT_H/2)*6, "Exit"        , &mk_exit, MK_END    , NULL            },
			{NULL              , 0         , 0                          , NULL          , NULL    , 0         , NULL            }
		};

		MENU_DATA *md;
		int i;

		resume:

		md = wrap_menu_data(ms, me, 2);
		i = timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
		unwrap_menu_data(md);

		sfx_play(sfx_menu_enter, 1, 0, 1.0);

		if (i == MK_OPTIONS) {
			int new_gfx_mode_id = run_options_menu(ms);
			if (new_gfx_mode_id != opt_gfx_mode_id) {
				if (set_screen(8, opt_gfx_mode_w[new_gfx_mode_id], opt_gfx_mode_h[new_gfx_mode_id])) {
					run_error_menu(ms, "Selected graphics mode unavailable.");
					goto resume;
				}
				opt_gfx_mode_id = new_gfx_mode_id;
			}
			goto restart;
		}
	}

	run_credits_menu(ms, 1);
}

