OBJDIR := obj
DEPDIR := obj

SOURCES := $(wildcard *.c)
OBJECTS := $(patsubst %.c,$(OBJDIR)/%.o,$(SOURCES))

CC := gcc
CFLAGS := -W -Wall
CFLAGS += -O2 -ffast-math -fomit-frame-pointer

LIBS := -laldmb -ldumb `allegro-config --libs`

ifdef EFENCE
LIBS += -lefence
endif

telehack: $(OBJECTS)
	$(CC) $^ -o $@ $(LIBS)

$(OBJDIR)/%.o: %.c
	$(CC) $(CFLAGS) -c $< -o $@

$(DEPDIR)/%.d: %.c
	$(CC) -MM $(CFLAGS) $< | sed -e "s/^$*\.o:/$(OBJDIR)\/$*\.o $(DEPDIR)\/$*\.d:/" > $@

-include $(patsubst %.c,$(DEPDIR)/%.d,$(SOURCES))
