#include <allegro.h>
#include "main.h"
#include "game.h"
#include "demo.h"

int frames;
int fps;
BITMAP *page;

int storyscroll;
int storymode;
char story[] = {
	0x53, 0x74, 0x6F, 0x72, 0x79, 0x0D, 0x0A, 0x0D,
	0x0A, 0x49, 0x74, 0x27, 0x73, 0x20, 0x46, 0x72,
	0x69, 0x64, 0x61, 0x79, 0x20, 0x65, 0x76, 0x65,
	0x6E, 0x69, 0x6E, 0x67, 0x2C, 0x20, 0x61, 0x6E,
	0x64, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
	0x61, 0x20, 0x6D, 0x6F, 0x6E, 0x74, 0x68, 0x20,
	0x6F, 0x66, 0x0D, 0x0A, 0x63, 0x6F, 0x6C, 0x6C,
	0x65, 0x63, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x68,
	0x65, 0x72, 0x62, 0x73, 0x20, 0x61, 0x6E, 0x64,
	0x20, 0x6F, 0x74, 0x68, 0x65, 0x72, 0x20, 0x69,
	0x6E, 0x67, 0x72, 0x65, 0x64, 0x69, 0x65, 0x6E,
	0x74, 0x73, 0x2C, 0x20, 0x61, 0x6E, 0x64, 0x0D,
	0x0A, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x6E, 0x67, 0x20, 0x6D, 0x61, 0x67,
	0x69, 0x63, 0x20, 0x28, 0x61, 0x6E, 0x64, 0x20,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6E, 0x67, 0x20,
	0x73, 0x6F, 0x6D, 0x65, 0x20, 0x6F, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x69, 0x72, 0x0D, 0x0A, 0x73,
	0x70, 0x65, 0x6C, 0x6C, 0x73, 0x20, 0x6F, 0x6E,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x61, 0x72,
	0x6D, 0x65, 0x72, 0x73, 0x20, 0x6F, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x6E, 0x65, 0x61, 0x72,
	0x62, 0x79, 0x20, 0x76, 0x69, 0x6C, 0x6C, 0x61,
	0x67, 0x65, 0x29, 0x2C, 0x0D, 0x0A, 0x4C, 0x65,
	0x61, 0x6E, 0x6F, 0x72, 0x69, 0x63, 0x20, 0x61,
	0x6E, 0x64, 0x20, 0x4C, 0x65, 0x61, 0x72, 0x69,
	0x63, 0x2C, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74,
	0x77, 0x6F, 0x20, 0x6F, 0x6C, 0x64, 0x20, 0x77,
	0x69, 0x7A, 0x61, 0x72, 0x64, 0x73, 0x2C, 0x20,
	0x6D, 0x65, 0x65, 0x74, 0x20, 0x61, 0x74, 0x0D,
	0x0A, 0x74, 0x68, 0x65, 0x20, 0x6F, 0x6C, 0x64,
	0x20, 0x77, 0x69, 0x7A, 0x61, 0x72, 0x64, 0x27,
	0x73, 0x20, 0x74, 0x6F, 0x77, 0x65, 0x72, 0x2E,
	0x20, 0x49, 0x74, 0x27, 0x73, 0x20, 0x77, 0x68,
	0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x79,
	0x20, 0x6D, 0x65, 0x65, 0x74, 0x0D, 0x0A, 0x61,
	0x6C, 0x6D, 0x6F, 0x73, 0x74, 0x20, 0x65, 0x61,
	0x63, 0x68, 0x20, 0x6D, 0x6F, 0x6E, 0x74, 0x68,
	0x20, 0x73, 0x69, 0x6E, 0x63, 0x65, 0x20, 0x63,
	0x65, 0x6E, 0x74, 0x75, 0x72, 0x69, 0x65, 0x73,
	0x2C, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x77, 0x68,
	0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x79,
	0x0D, 0x0A, 0x70, 0x6C, 0x61, 0x79, 0x20, 0x73,
	0x6F, 0x6D, 0x65, 0x20, 0x6F, 0x66, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6D, 0x6F, 0x73, 0x74, 0x20,
	0x73, 0x74, 0x72, 0x61, 0x6E, 0x67, 0x65, 0x20,
	0x61, 0x6E, 0x64, 0x20, 0x6F, 0x64, 0x64, 0x69,
	0x73, 0x68, 0x73, 0x74, 0x20, 0x6D, 0x61, 0x67,
	0x69, 0x63, 0x61, 0x6C, 0x0D, 0x0A, 0x67, 0x61,
	0x6D, 0x65, 0x73, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A,
	0x4C, 0x65, 0x61, 0x6E, 0x6F, 0x72, 0x69, 0x63,
	0x20, 0x61, 0x6E, 0x64, 0x20, 0x4C, 0x65, 0x61,
	0x72, 0x69, 0x63, 0x73, 0x20, 0x66, 0x61, 0x76,
	0x6F, 0x72, 0x69, 0x74, 0x65, 0x20, 0x67, 0x61,
	0x6D, 0x65, 0x20, 0x69, 0x73, 0x20, 0x63, 0x61,
	0x6C, 0x6C, 0x65, 0x64, 0x20, 0x45, 0x67, 0x67,
	0x2D, 0x0D, 0x0A, 0x48, 0x61, 0x63, 0x6B, 0x2E,
	0x20, 0x4C, 0x65, 0x61, 0x6E, 0x6F, 0x72, 0x69,
	0x63, 0x20, 0x72, 0x75, 0x6D, 0x6D, 0x61, 0x67,
	0x65, 0x73, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x6F, 0x6C, 0x64, 0x20, 0x67, 0x61,
	0x6D, 0x65, 0x73, 0x20, 0x62, 0x6F, 0x78, 0x20,
	0x69, 0x6E, 0x0D, 0x0A, 0x74, 0x68, 0x65, 0x20,
	0x61, 0x74, 0x74, 0x69, 0x63, 0x20, 0x63, 0x68,
	0x61, 0x6D, 0x62, 0x65, 0x72, 0x20, 0x6F, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x6F, 0x77,
	0x65, 0x72, 0x2C, 0x20, 0x61, 0x6E, 0x64, 0x20,
	0x74, 0x61, 0x6B, 0x65, 0x73, 0x20, 0x6F, 0x75,
	0x74, 0x20, 0x61, 0x0D, 0x0A, 0x70, 0x69, 0x65,
	0x63, 0x65, 0x20, 0x6F, 0x66, 0x20, 0x66, 0x6F,
	0x6C, 0x64, 0x65, 0x64, 0x20, 0x70, 0x61, 0x70,
	0x65, 0x72, 0x2E, 0x20, 0x48, 0x65, 0x20, 0x75,
	0x6E, 0x66, 0x6F, 0x6C, 0x64, 0x73, 0x20, 0x69,
	0x74, 0x2C, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x70,
	0x6C, 0x61, 0x63, 0x65, 0x73, 0x0D, 0x0A, 0x69,
	0x74, 0x20, 0x6E, 0x65, 0x61, 0x72, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x63, 0x61, 0x6E, 0x64, 0x6C,
	0x65, 0x20, 0x6F, 0x6E, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x73, 0x6D, 0x61, 0x6C, 0x6C, 0x20, 0x74,
	0x61, 0x62, 0x6C, 0x65, 0x2E, 0x20, 0x49, 0x6E,
	0x20, 0x74, 0x68, 0x65, 0x0D, 0x0A, 0x6D, 0x6F,
	0x6D, 0x65, 0x6E, 0x74, 0x20, 0x69, 0x74, 0x20,
	0x69, 0x73, 0x20, 0x66, 0x6F, 0x6C, 0x64, 0x65,
	0x64, 0x20, 0x6F, 0x75, 0x74, 0x20, 0x74, 0x68,
	0x65, 0x72, 0x65, 0x2C, 0x20, 0x69, 0x74, 0x20,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x20, 0x67,
	0x6C, 0x6F, 0x77, 0x69, 0x6E, 0x67, 0x0D, 0x0A,
	0x6D, 0x61, 0x67, 0x69, 0x63, 0x61, 0x6C, 0x6C,
	0x79, 0x2C, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6D, 0x61, 0x70, 0x20, 0x64,
	0x72, 0x61, 0x77, 0x6E, 0x20, 0x6F, 0x6E, 0x74,
	0x6F, 0x20, 0x69, 0x74, 0x20, 0x65, 0x76, 0x6F,
	0x6C, 0x76, 0x65, 0x73, 0x20, 0x74, 0x6F, 0x0D,
	0x0A, 0x72, 0x65, 0x61, 0x6C, 0x20, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x20, 0x61, 0x6E, 0x64,
	0x20, 0x76, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x2E,
	0x0D, 0x0A, 0x0D, 0x0A, 0x4C, 0x65, 0x61, 0x72,
	0x69, 0x63, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x6D, 0x65, 0x61, 0x6E, 0x74, 0x69,
	0x6D, 0x65, 0x20, 0x66, 0x65, 0x74, 0x63, 0x68,
	0x65, 0x64, 0x20, 0x61, 0x20, 0x62, 0x6F, 0x78,
	0x2C, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61,
	0x20, 0x73, 0x6D, 0x61, 0x6C, 0x6C, 0x20, 0x0D,
	0x0A, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x2C, 0x20,
	0x73, 0x74, 0x72, 0x61, 0x6E, 0x67, 0x6C, 0x79,
	0x20, 0x67, 0x6C, 0x6F, 0x77, 0x69, 0x6E, 0x67,
	0x20, 0x73, 0x70, 0x68, 0x65, 0x72, 0x65, 0x2C,
	0x20, 0x74, 0x77, 0x6F, 0x20, 0x73, 0x6D, 0x61,
	0x6C, 0x6C, 0x20, 0x74, 0x6F, 0x77, 0x65, 0x72,
	0x73, 0x2C, 0x20, 0x0D, 0x0A, 0x61, 0x6E, 0x64,
	0x20, 0x73, 0x6F, 0x6D, 0x65, 0x20, 0x6F, 0x74,
	0x68, 0x65, 0x72, 0x20, 0x6F, 0x62, 0x6A, 0x65,
	0x63, 0x74, 0x73, 0x20, 0x69, 0x6E, 0x73, 0x69,
	0x64, 0x65, 0x2E, 0x20, 0x54, 0x68, 0x65, 0x20,
	0x73, 0x70, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69,
	0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0D, 0x0A,
	0x45, 0x67, 0x67, 0x2E, 0x20, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x61, 0x20, 0x73, 0x74, 0x6F, 0x6E,
	0x65, 0x20, 0x6F, 0x6E, 0x65, 0x20, 0x6F, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x6D, 0x20, 0x66, 0x6F,
	0x75, 0x6E, 0x64, 0x20, 0x73, 0x6F, 0x6D, 0x65,
	0x20, 0x74, 0x69, 0x6D, 0x65, 0x20, 0x61, 0x67,
	0x6F, 0x20, 0x0D, 0x0A, 0x69, 0x6E, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6D, 0x6F, 0x75, 0x6E, 0x74,
	0x61, 0x69, 0x6E, 0x73, 0x20, 0x28, 0x62, 0x6F,
	0x74, 0x68, 0x20, 0x63, 0x6C, 0x61, 0x6D, 0x65,
	0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x68,
	0x69, 0x73, 0x29, 0x2C, 0x20, 0x76, 0x65, 0x72,
	0x79, 0x20, 0x0D, 0x0A, 0x68, 0x65, 0x61, 0x76,
	0x79, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x20, 0x61, 0x20, 0x67, 0x72, 0x65,
	0x65, 0x6E, 0x69, 0x73, 0x68, 0x20, 0x67, 0x6C,
	0x6F, 0x77, 0x2E, 0x20, 0x42, 0x6F, 0x74, 0x68,
	0x20, 0x4C, 0x65, 0x61, 0x72, 0x69, 0x63, 0x20,
	0x61, 0x6E, 0x64, 0x20, 0x0D, 0x0A, 0x4C, 0x65,
	0x61, 0x6E, 0x6F, 0x72, 0x69, 0x63, 0x20, 0x67,
	0x72, 0x61, 0x62, 0x20, 0x61, 0x20, 0x74, 0x6F,
	0x77, 0x65, 0x72, 0x2C, 0x20, 0x61, 0x6E, 0x64,
	0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x20, 0x69,
	0x74, 0x20, 0x6F, 0x6E, 0x20, 0x61, 0x20, 0x73,
	0x70, 0x6F, 0x74, 0x20, 0x6F, 0x66, 0x20, 0x0D,
	0x0A, 0x74, 0x68, 0x65, 0x20, 0x6D, 0x61, 0x67,
	0x69, 0x63, 0x61, 0x6C, 0x20, 0x74, 0x61, 0x62,
	0x6C, 0x65, 0x2E, 0x20, 0x54, 0x68, 0x65, 0x20,
	0x45, 0x67, 0x67, 0x2D, 0x68, 0x61, 0x63, 0x6B,
	0x69, 0x6E, 0x67, 0x20, 0x63, 0x61, 0x6E, 0x20,
	0x62, 0x65, 0x67, 0x69, 0x6E, 0x2E, 0x0D, 0x0A,
	0x0D, 0x0A, 0x54, 0x68, 0x65, 0x20, 0x72, 0x75,
	0x6C, 0x65, 0x73, 0x20, 0x61, 0x72, 0x65, 0x20,
	0x61, 0x73, 0x74, 0x6F, 0x6E, 0x69, 0x73, 0x68,
	0x69, 0x6E, 0x67, 0x6C, 0x79, 0x20, 0x73, 0x69,
	0x6D, 0x70, 0x6C, 0x65, 0x2E, 0x20, 0x45, 0x61,
	0x63, 0x68, 0x20, 0x77, 0x69, 0x7A, 0x61, 0x72,
	0x64, 0x20, 0x0D, 0x0A, 0x6D, 0x61, 0x79, 0x20,
	0x72, 0x6F, 0x6C, 0x6C, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x45, 0x67, 0x67, 0x20, 0x66, 0x72, 0x6F,
	0x6D, 0x20, 0x68, 0x69, 0x73, 0x20, 0x74, 0x6F,
	0x77, 0x65, 0x72, 0x20, 0x69, 0x6E, 0x20, 0x74,
	0x75, 0x72, 0x6E, 0x2C, 0x20, 0x61, 0x6E, 0x64,
	0x20, 0x74, 0x72, 0x69, 0x65, 0x73, 0x20, 0x0D,
	0x0A, 0x74, 0x6F, 0x20, 0x64, 0x65, 0x73, 0x74,
	0x72, 0x6F, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x74, 0x6F, 0x77, 0x65, 0x72, 0x20, 0x6F, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x6F, 0x74, 0x68,
	0x65, 0x72, 0x20, 0x77, 0x69, 0x7A, 0x61, 0x72,
	0x64, 0x2E, 0x20, 0x57, 0x68, 0x65, 0x6E, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x0D, 0x0A, 0x45, 0x67,
	0x67, 0x20, 0x67, 0x65, 0x74, 0x73, 0x20, 0x74,
	0x6F, 0x6F, 0x20, 0x73, 0x6C, 0x6F, 0x77, 0x2C,
	0x20, 0x69, 0x74, 0x20, 0x65, 0x78, 0x70, 0x6C,
	0x6F, 0x64, 0x65, 0x73, 0x2E, 0x20, 0x54, 0x68,
	0x65, 0x20, 0x6D, 0x61, 0x67, 0x69, 0x63, 0x61,
	0x6C, 0x20, 0x0D, 0x0A, 0x70, 0x6C, 0x61, 0x79,
	0x66, 0x69, 0x65, 0x6C, 0x64, 0x20, 0x61, 0x6C,
	0x73, 0x6F, 0x20, 0x6D, 0x61, 0x6B, 0x65, 0x73,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x45, 0x67, 0x67,
	0x20, 0x6D, 0x61, 0x67, 0x69, 0x63, 0x61, 0x6C,
	0x6C, 0x79, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61,
	0x72, 0x20, 0x6F, 0x6E, 0x20, 0x0D, 0x0A, 0x74,
	0x68, 0x65, 0x20, 0x6F, 0x70, 0x70, 0x6F, 0x73,
	0x69, 0x74, 0x65, 0x20, 0x73, 0x69, 0x64, 0x65,
	0x20, 0x77, 0x68, 0x65, 0x6E, 0x20, 0x69, 0x74,
	0x20, 0x77, 0x6F, 0x75, 0x6C, 0x64, 0x20, 0x66,
	0x61, 0x6C, 0x6C, 0x20, 0x64, 0x6F, 0x77, 0x6E,
	0x20, 0x6F, 0x6E, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x0D, 0x0A, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x2E,
	0x20, 0x54, 0x68, 0x65, 0x20, 0x77, 0x69, 0x6E,
	0x6E, 0x65, 0x72, 0x20, 0x69, 0x73, 0x2C, 0x20,
	0x77, 0x68, 0x6F, 0x20, 0x63, 0x61, 0x6E, 0x20,
	0x61, 0x73, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74,
	0x20, 0x6E, 0x75, 0x6B, 0x65, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x0D, 0x0A, 0x6F, 0x74, 0x68, 0x65,
	0x72, 0x20, 0x6F, 0x6E, 0x65, 0x73, 0x20, 0x74,
	0x6F, 0x77, 0x65, 0x72, 0x2E, 0x20, 0x54, 0x68,
	0x65, 0x20, 0x6F, 0x74, 0x68, 0x65, 0x72, 0x20,
	0x6F, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x73, 0x20,
	0x69, 0x6E, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62,
	0x6F, 0x78, 0x20, 0x61, 0x72, 0x65, 0x20, 0x0D,
	0x0A, 0x73, 0x6F, 0x6D, 0x65, 0x20, 0x6D, 0x61,
	0x67, 0x69, 0x63, 0x61, 0x6C, 0x20, 0x62, 0x6F,
	0x6E, 0x75, 0x73, 0x20, 0x69, 0x74, 0x65, 0x6D,
	0x73, 0x2C, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
	0x20, 0x77, 0x69, 0x6C, 0x6C, 0x20, 0x61, 0x70,
	0x70, 0x65, 0x61, 0x72, 0x20, 0x6F, 0x6E, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x0D, 0x0A, 0x6D, 0x61,
	0x70, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
	0x65, 0x61, 0x63, 0x68, 0x20, 0x74, 0x75, 0x72,
	0x6E, 0x2C, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x62,
	0x72, 0x65, 0x61, 0x6B, 0x20, 0x6F, 0x70, 0x65,
	0x6E, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x0D, 0x0A, 0x72, 0x61, 0x64, 0x69, 0x61,
	0x74, 0x69, 0x6F, 0x6E, 0x20, 0x6F, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x72, 0x6F, 0x6C, 0x6C,
	0x69, 0x6E, 0x67, 0x20, 0x45, 0x67, 0x67, 0x2E,
	0x20, 0x54, 0x68, 0x65, 0x79, 0x20, 0x77, 0x69,
	0x6C, 0x6C, 0x20, 0x67, 0x69, 0x76, 0x65, 0x20,
	0x69, 0x74, 0x20, 0x61, 0x20, 0x0D, 0x0A, 0x6D,
	0x61, 0x67, 0x69, 0x63, 0x61, 0x6C, 0x20, 0x62,
	0x6F, 0x6F, 0x73, 0x74, 0x20, 0x6F, 0x66, 0x20,
	0x73, 0x6F, 0x6D, 0x65, 0x20, 0x73, 0x6F, 0x72,
	0x74, 0x2C, 0x20, 0x65, 0x69, 0x74, 0x68, 0x65,
	0x72, 0x20, 0x69, 0x6D, 0x6D, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x6C, 0x79, 0x20, 0x6F, 0x72,
	0x20, 0x0D, 0x0A, 0x73, 0x6F, 0x6D, 0x65, 0x74,
	0x69, 0x6D, 0x65, 0x73, 0x20, 0x6F, 0x6E, 0x6C,
	0x79, 0x20, 0x77, 0x68, 0x65, 0x6E, 0x20, 0x69,
	0x74, 0x20, 0x69, 0x73, 0x20, 0x72, 0x6F, 0x6C,
	0x6C, 0x65, 0x64, 0x20, 0x6E, 0x65, 0x78, 0x74,
	0x20, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x0D, 0x0A,
	0x0D, 0x0A, 0x0D, 0x0A, 0x45, 0x6E, 0x74, 0x72,
	0x79, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x53, 0x70, 0x65, 0x65, 0x64, 0x68,
	0x61, 0x63, 0x6B, 0x20, 0x32, 0x30, 0x30, 0x32,
	0x0D, 0x0A, 0x0D, 0x0A, 0x62, 0x79, 0x0D, 0x0A,
	0x0D, 0x0A, 0x6E, 0x65, 0x74, 0x77, 0x6F, 0x72,
	0x6D, 0x0D, 0x0A, 0x0D, 0x0A, 0x54, 0x68, 0x61,
	0x6E, 0x6B, 0x73, 0x0D, 0x0A, 0x0D, 0x0A, 0x53,
	0x68, 0x61, 0x77, 0x6E, 0x20, 0x48, 0x61, 0x72,
	0x67, 0x72, 0x65, 0x61, 0x76, 0x65, 0x73, 0x0D,
	0x0A, 0x28, 0x41, 0x6C, 0x6C, 0x65, 0x67, 0x72,
	0x6F, 0x2C, 0x20, 0x45, 0x67, 0x67, 0x29, 0x0D,
	0x0A, 0x0D, 0x0A, 0x41, 0x72, 0x72, 0x6F, 0x6E,
	0x20, 0x53, 0x68, 0x75, 0x74, 0x74, 0x0D, 0x0A,
	0x4D, 0x61, 0x74, 0x74, 0x68, 0x65, 0x77, 0x20,
	0x4C, 0x65, 0x76, 0x65, 0x72, 0x74, 0x6F, 0x6E,
	0x0D, 0x0A, 0x28, 0x53, 0x70, 0x65, 0x65, 0x64,
	0x68, 0x61, 0x63, 0x6B, 0x29, 0x0D, 0x0A, 0x0D,
	0x0A, 0x50, 0x65, 0x6F, 0x70, 0x6C, 0x65, 0x20,
	0x6F, 0x6E, 0x20, 0x23, 0x61, 0x6C, 0x6C, 0x65,
	0x67, 0x72, 0x6F, 0x2C, 0x20, 0x61, 0x6C, 0x6C,
	0x65, 0x67, 0x72, 0x6F, 0x2E, 0x63, 0x63, 0x2C,
	0x20, 0x5B, 0x41, 0x4C, 0x5D, 0x2C, 0x20, 0x5B,
	0x41, 0x47, 0x50, 0x5D, 0x2C, 0x20, 0x5B, 0x41,
	0x44, 0x5D, 0x2C, 0x20, 0x2E, 0x2E, 0x2E, 0x0D,
	0x0A, 0x00
};

static volatile int ticks = 0;
static void ticker(void)
{
	ticks++;
}

float rnd(void)
{
	return rand() / (float)(RAND_MAX);
}

static void run_init()
{       
	storymode = 1;
	storyscroll = 1500;
	demo_1();
}

static void run_end()
{
	exit(0);
}

static void run_frame()
{            
	while (keypressed()) {
		int k = readkey();

		k >>= 8;
		if (k == KEY_ESC ) {
			if (storymode) {
				run_end();
			} else {
				game_end();
				storymode = 1;
			}
		}
		if (k == KEY_F1) {
			game_init(1);
			storymode = 0;
		}
		if (k == KEY_F2) {
			game_init(0);
			storymode = 0;
		}
	}
	
	if (!storymode) game_process();
	if (storymode) {
		demo_2();
		storyscroll--;
	}
	
}

static void run_render()
{
	if (!storymode) game_render();
	
	if (storymode) {
		char *c = story;
		int y = storyscroll / 3;
		clear_to_color(page, makecol(0, 0, 0));
		
		demo_3();
				
		for (; *c; ) {
			char linebuf[256];
			char *l = linebuf;
			for (; *c != '\n' && *c != '\r' && *c ; c++, l++) *l = *c;
			*l = '\0';
			if (*c) {    
				c++;
				if (*c == '\n') c++;
			}
			
			{
				PALETTE pal;
				int i;
				float l = abs(SCREEN_H / 2 - y) / 100.0;
				l = 1 - (l * l) / 10.0;
				if (l < 0) l = 0;
				for (i = 0; i < 64; i++) {
					pal[i].r = i * l;
					pal[i].g = i * l;
					pal[i].b = i * l;
				}
				select_palette(pal);
			}
			
			textout_centre(page, font, linebuf, SCREEN_W / 2, y, -1);
			y += text_height(font);
			if (*c == '\r') y += 100;
		}
		
		{
			PALETTE pal;
			int i;
			for (i = 0; i < 64; i++) {
				pal[i].r = i;
				pal[i].g = 0;
				pal[i].b = 0;
			}
			select_palette(pal);
			textout(page, font, "F1 = Single Player Game", 0, 0, -1);
		}
		{
			PALETTE pal;
			int i;
			for (i = 0; i < 64; i++) {
				pal[i].r = 0;
				pal[i].g = i;
				pal[i].b = 0;
			}
			select_palette(pal);
			textout_right(page, font, "F2 = Multi Player Game", SCREEN_W - 1, 0, -1);
		}
		
		{
			PALETTE pal;
			int i;
			for (i = 0; i < 64; i++) {
				pal[i].r = i;
				pal[i].g = i;
				pal[i].b = i;
			}
			select_palette(pal);
		}
		
		
	}
	//textprintf_centre(page, font, SCREEN_W / 2, 0, -1, "%d fps", fps);
}

DATAFILE *dat;
int main(int anr, char *arg[])
{
	int gframes;
	int framecounttime, framecounter;

	srand(time(NULL));

	allegro_init();
	set_color_depth(16);
	if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0) {
		allegro_message("Cannot set graphics mode.\n");
		exit(-1);
	}
	
	dat = load_datafile("dat.dat");
	if (!dat)  {
		allegro_message("No data found.\n");
		exit(-1);
	}
	
	{
		font = dat[FONT_BMP].dat;
		text_mode(-1);
	}
	
	set_alpha_blender();
	
	install_keyboard();
	install_mouse();

	install_timer();

	install_int_ex(ticker, BPS_TO_TIMER(FPS));

	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	page = create_bitmap(SCREEN_W, SCREEN_H);
	
	run_init();

	framecounter = 0;
	framecounttime = ticks;
	gframes = ticks;
	frames = ticks;
	while (1) {

		while (frames <= ticks) {
			run_frame();
			frames++;
		}
		if(gframes < frames) {
			run_render();

			blit(page, screen, 0, 0, 0, 0, page->w, page->h);
			
			gframes = frames;
			framecounter++;

			if (ticks - framecounttime >= FPS) {
				fps = framecounter;
				framecounter = 0;
				framecounttime = ticks;
			}

		}

	}
	run_end();
	return -1;
}
END_OF_MAIN();









































































































