/* sprites.c
 * 
 *  Source for data encoded from sprites.dat .
 *  Do not hand edit.
 */

#include <allegro.h>
#include <allegro/internal/aintern.h>



static DATAFILE_PROPERTY drill_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "drill", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "0", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char drill_lines[] = 
"m$\0\0o&\x2\0q(\x4\0s*\x6\0u,\b\0w/\v\0y0\r\0{2\xf\0|4\x11\0\x7f""6\x14\0\x82:\x16\0\x86>\x1a\0\x89""A"
    "\x1d\0\x8a""A\x1d\0\x89@\x1f\0\x8e""E!\0\x96M)\0\x95M)\0\x97N*\0\x96N*\0\x97N,\0\x9eU1\0\xa3Z6\0\xa3Z6\0\xa5\\8\0"
    "\xa7^:\0\xa9`<\0\xa9`<\0\xa9`>\0\xab""bA\0\xad""eC\0\xb2iE\0"
"o&\x2\0q(\x4\0r*\x6\0u,\b\0w.\v\0x/\r\0{2\xf\0~5\x11\0~5\x14\0\x7f""6\x16\0\x84<\x18\0\x8c""C\x1f\0\x8f""F"
    "\"\0\x8b""C\x1f\0\x8c""D!\0\x92J&\0\x99P,\0\x95M)\0\x91H*\0\x95L,\0\x9aQ/\0\x9dU1\0\xa3Z6\0\xa3Z6\0\xa7^:\0"
    "\xae""fB\0\xb1hD\0\xac""c?\0\xab""bA\0\xad""eC\0\xb0gE\0\xb7nJ\0"
"r)\x5\0t+\a\0u,\b\0w.\v\0x/\r\0{3\xf\0~5\x11\0\x82""9\x15\0\x80""7\x16\0\x7f""6\x18\0\x86=\x1a\0\x8f""F\"\0\x8e""E"
    "!\0\x8d""E!\0\x90G#\0\x97N*\0\x9bR.\0\x95L*\0\x90H,\0\x97N/\0\x9bS1\0\x9eU3\0\x9eV5\0\xa2Y8\0\xa9`<\0"
    "\xb1iE\0\xb1hD\0\xb0gC\0\xafgC\0\xad""eE\0\xb2iG\0\xbarN\0"
"t+\a\0v.\n\0w/\v\0x/\r\0{2\xf\0~5\x11\0\x83:\x16\0\x86=\x19\0\x84;\x18\0\x83:\x1a\0\x88?\x1d\0\x8c""C\x1f\0\x8d""E"
    "!\0\x8c""D#\0\x92J&\0\x9bS/\0\x9eU1\0\x95L,\0\x92K/\0\x9aQ1\0\xa0W3\0\x9bR5\0\x98R8\0\x9dU:\0\xaa""a=\0"
    "\xb3jF\0\xb1iE\0\xb0gC\0\xb5lH\0\xb2iG\0\xb2iJ\0\xb9qM\0"
"u,\b\0w/\v\0x/\r\0{2\xf\0~5\x11\0\x83:\x16\0\x86=\x19\0\x87>\x1a\0\x87>\x1a\0\x88?\x1d\0\x8a""A\x1f\0\x8d""E!\0\x8d""D"
    "#\0\x8f""F&\0\x93J(\0\x9aQ-\0\x9eU1\0\x98O/\0\x94L1\0\x9cS3\0\xa6]9\0\xa2Y8\0\x9dU:\0\x9fW<\0\xab""b>\0"
    "\xb3jF\0\xb3jF\0\xb3jF\0\xb5lH\0\xb6nJ\0\xb3kL\0\xbbrN\0"
"w/\v\0w.\r\0x0\xf\0~5\x11\0\x84<\x18\0\x88?\x1b\0\x89@\x1c\0\x89@\x1c\0\x8b""B\x1e\0\x8e""E!\0\x8e""E!\0\x8e""F#\0\x8f""F"
    "&\0\x8e""F(\0\x95L*\0\x99P,\0\x9bS/\0\x9aQ1\0\x99P3\0\xa2Y5\0\xaa""a=\0\xaf""fB\0\xab""c?\0\xab""b>\0\xad""eA\0"
    "\xafgC\0\xb2iE\0\xb4kG\0\xb7oK\0\xb9qM\0\xbcsO\0\xbeuQ\0"
"{2\xe\0z1\xf\0x1\x11\0~5\x14\0\x86>\x1a\0\x8a""A\x1d\0\x87>\x1a\0\x89""A\x1d\0\x8e""E!\0\x92I%\0\x90H$\0\x90G&\0\x91H"
    "(\0\x96N*\0\x99Q-\0\x9aQ/\0\x97N1\0\x9bR3\0\x9eV5\0\xa2Y8\0\xac""c?\0\xb1iE\0\xb4kG\0\xb1iE\0\xac""cC\0"
    "\xa9`E\0\xb0gG\0\xb6nJ\0\xbbsO\0\xc4{W\0\xc6}Y\0\xc5|X\0"
"\x7f""6\x12\0~5\x11\0|3\x14\0}5\x16\0\x84;\x18\0\x84<\x1a\0\x83:\x1d\0\x85=\x1f\0\x8d""E!\0\x92J&\0\x93J&\0\x94L(\0\x99P"
    ",\0\xa0W3\0\xa2Y5\0\x9bS1\0\x99P3\0\x9eV5\0\xa0W8\0\xa0W:\0\xa4\\<\0\xab""b>\0\xad""eA\0\xac""cC\0\xa6`E\0"
    "\xa8""bG\0\xb1hJ\0\xb8pL\0\xbeuQ\0\xc8\x7f[\0\xca\x81]\0\xca\x82^\0"
"\x81""9\x15\0\x81""8\x14\0~5\x16\0\x81""8\x18\0\x82""9\x1a\0\x83:\x1d\0\x83=\x1f\0\x87>!\0\x8d""D#\0\x92J&\0\x94L(\0\x97O+\0\xa0W"
    "3\0\xa3Z6\0\xa1X4\0\xa1X4\0\xa2Y5\0\xa4\\8\0\xa3Z:\0\xa0W<\0\xa1Y>\0\xa4[A\0\xa6^C\0\xa8`E\0\xa8""bG\0"
    "\xac""dJ\0\xb4lL\0\xbbrN\0\xbeuQ\0\xc3zV\0\xc9\x81]\0\xcb\x83_\0"
"\x84;\x17\0\x85<\x18\0\x84<\x18\0\x84<\x1a\0\x88?\x1d\0\x89@\x1f\0\x8b""B!\0\x8d""D#\0\x8f""F&\0\x91H(\0\x93K*\0\x99P,\0\x9cS"
    "/\0\x9fV2\0\xa0W3\0\xa3Z6\0\xa8_;\0\xa8_;\0\xa7^<\0\xa7^>\0\xa8_A\0\xab""bC\0\xac""dE\0\xaf""fG\0\xb1hJ\0"
    "\xb4lL\0\xb9pN\0\xbeuQ\0\xc0wS\0\xc2zV\0\xc2yW\0\xc9\x80\\\0"
"\x86>\x1a\0\x8a""A\x1d\0\x87>\x1a\0\x89""A\x1d\0\x8c""C\x1f\0\x91H$\0\x90H$\0\x92J&\0\x91H(\0\x8f""F*\0\x93J,\0\x9bS/\0\x9dU"
    "1\0\x9bR3\0\xa0X5\0\xa5\\8\0\xa8_;\0\xaa""a=\0\xab""b>\0\xad""eA\0\xafgC\0\xb2iE\0\xb4kG\0\xb6nJ\0\xb8pL\0"
    "\xbbrN\0\xbdtP\0\xc0wS\0\xc5}Y\0\xc4{W\0\xbfvY\0\xc6}\\\0"
"\x87>\x1a\0\x89@\x1c\0\x89""A\x1d\0\x8b""C\x1f\0\x8e""E!\0\x90G#\0\x92J&\0\x93J(\0\x93K*\0\x93J,\0\x9bS/\0\xa3Z6\0\xa0W"
    "3\0\x9eV5\0\xa0W8\0\xa6^:\0\xa9`<\0\xab""b>\0\xad""eA\0\xb0gC\0\xb5lH\0\xb7nJ\0\xb7oK\0\xb6mL\0\xb7nN\0"
    "\xb8oP\0\xbbrS\0\xc1yU\0\xc5|X\0\xc6}Y\0\xc5|\\\0\xca\x82^\0"
"\x87>\x1a\0\x88?\x1d\0\x8a""A\x1f\0\x8c""D!\0\x8d""D#\0\x8e""E&\0\x8e""F(\0\x95L*\0\x97N,\0\x9cS/\0\xa5\\8\0\xa7^:\0\xa2Y"
    "5\0\x9fW8\0\xa6^:\0\xaa""a=\0\xab""b>\0\xab""bA\0\xad""eC\0\xb3jF\0\xbduQ\0\xbfvR\0\xbbsO\0\xb9pN\0\xb4kP\0"
    "\xb3nS\0\xb7pU\0\xc0wW\0\xc6}Y\0\xc8\x80\\\0\xca\x82^\0\xcf\x87""c\0"
"\x8c""C\x1f\0\x8c""C\x1f\0\x8c""D!\0\x8d""D#\0\x8b""B&\0\x8d""D(\0\x95L*\0\x99P,\0\x9aQ/\0\x9fV2\0\xa5\\8\0\xa5\\8\0\xa0W"
    "8\0\xa8_;\0\xae""fB\0\xae""eA\0\xad""eA\0\xad""eC\0\xac""dE\0\xb5lH\0\xbfvR\0\xc1xT\0\xbcsO\0\xb9pP\0\xbaqS\0"
    "\xb7pU\0\xbdtW\0\xc6}Y\0\xc9\x80\\\0\xcb\x83_\0\xce\x85""a\0\xd3\x8a""f\0"
"\x8e""E!\0\x8e""E!\0\x8e""F#\0\x8f""F&\0\x8d""D(\0\x95L*\0\x9cS/\0\x9cS/\0\x9aQ1\0\x9cS3\0\xa0X5\0\xa2Y8\0\xa6^"
    ":\0\xb1hD\0\xb3jF\0\xae""eA\0\xad""eC\0\xad""eE\0\xb0gG\0\xb6nJ\0\xbctP\0\xbeuQ\0\xb9pP\0\xbdtS\0\xbfwU\0"
    "\xc4{W\0\xcc\x83_\0\xd0\x87""c\0\xce\x85""a\0\xd0\x87""c\0\xd6\x8di\0\xd7\x8ej\0"
"\x8e""E!\0\x8e""F#\0\x90G&\0\x93J(\0\x95L*\0\x99Q-\0\x9eV2\0\x9dU1\0\xa0W3\0\xa3Z6\0\xa0W8\0\x9dU:\0\xa7^"
    "<\0\xb1hD\0\xb1iE\0\xafgC\0\xb3jF\0\xb4kG\0\xb1hJ\0\xb8pL\0\xbfvR\0\xbdtP\0\xbdtS\0\xbfwU\0\xc2yW\0"
    "\xc7~Z\0\xd0\x87""c\0\xd3\x8a""f\0\xd2\x8a""f\0\xd9\x90l\0\xdb\x92n\0\xda\x92n\0"
"\x90H$\0\x90G&\0\x91H(\0\x93K*\0\x97N,\0\x9cS/\0\x9dU1\0\xa2Z6\0\xa9""a=\0\xad""d@\0\xa6^:\0\xa0W<\0\xa4["
    ">\0\xad""eA\0\xb3jF\0\xbaqM\0\xbctP\0\xb7oK\0\xb6mL\0\xbbrN\0\xbeuQ\0\xc0wS\0\xc1yU\0\xc2yW\0\xc1xY\0"
    "\xc2y\\\0\xca\x82^\0\xcf\x87""c\0\xd3\x8a""f\0\xd9\x90l\0\xda\x92n\0\xd8\x8fk\0"
"\x92J&\0\x93J(\0\x8f""F*\0\x93J,\0\x9bS/\0\x9fV2\0\x9eU3\0\xa3Z6\0\xac""c?\0\xaf""fB\0\xaa""a=\0\xa7^>\0\xa9`"
    "A\0\xac""cC\0\xb3jF\0\xbctP\0\xbfvR\0\xbctP\0\xbcsO\0\xbeuQ\0\xbfwS\0\xc1yU\0\xc4{W\0\xc4{Y\0\xc0w\\\0"
    "\xc2y^\0\xc9\x80`\0\xcf\x86""b\0\xd2\x89""e\0\xd6\x8di\0\xd7\x8ej\0\xd6\x8ek\0"
"\x95M)\0\x95L*\0\x93J,\0\x9aQ/\0\xa1X4\0\xa1X4\0\x9dT5\0\x9bR8\0\xa3Z:\0\xa7^<\0\xa7^>\0\xa9`A\0\xad""e"
    "C\0\xb0gE\0\xb0gG\0\xb7oK\0\xbbsO\0\xbfvR\0\xc5|X\0\xc3zV\0\xc2zV\0\xc4{W\0\xc7~Z\0\xc9\x80\\\0\xca\x82^\0"
    "\xcb\x82`\0\xcb\x83""b\0\xcf\x87""e\0\xd2\x89g\0\xd6\x8di\0\xd8\x8fk\0\xda\x92n\0"
"\x9aQ-\0\x9cS/\0\x9bS/\0\xa0X4\0\xa7^:\0\xa3Z6\0\x98R8\0\x98U:\0\x9bW<\0\xa1Y>\0\xa3[A\0\xa6^C\0\xb0g"
    "E\0\xb5lH\0\xb7oK\0\xb8pL\0\xbbrN\0\xc0wS\0\xc7~Z\0\xc9\x81]\0\xc5|X\0\xc6}Y\0\xcb\x82^\0\xd2\x89""e\0\xd5\x8ch\0"
    "\xd2\x89""e\0\xd1\x89""e\0\xcf\x86g\0\xd2\x8ai\0\xd6\x8ek\0\xdb\x92n\0\xe1\x98t\0"
"\x9eU1\0\x9eV2\0\xa1X4\0\xa5\\8\0\xab""b>\0\xa7^:\0\xa0W:\0\x9fW<\0\xa4[>\0\xab""bA\0\xac""cC\0\xa9`E\0\xb0g"
    "G\0\xbarN\0\xbfvR\0\xbcsO\0\xbdtP\0\xc0wS\0\xc4|X\0\xc7~Z\0\xc6}Y\0\xc6}\\\0\xcb\x83_\0\xd4\x8bg\0\xd4\x8ch\0"
    "\xd7\x8ej\0\xd2\x89g\0\xd2\x8ai\0\xd3\x8ak\0\xd3\x8bn\0\xdb\x92p\0\xe1\x99u\0"
"\x9eV2\0\xa6]9\0\xa8_;\0\xa7_;\0\xad""d@\0\xae""fB\0\xab""c?\0\xaf""fB\0\xb6nJ\0\xbbrN\0\xbbrN\0\xb5lH\0\xb4k"
    "J\0\xbctP\0\xc1xT\0\xc0wS\0\xbfwS\0\xbfwU\0\xc2yW\0\xc4{Y\0\xc5|\\\0\xc4{^\0\xcd\x84`\0\xd2\x89""e\0\xd4\x8bg\0"
    "\xd2\x89g\0\xd2\x89i\0\xd0\x88k\0\xd3\x8bn\0\xd5\x8dp\0\xda\x91r\0\xe1\x98t\0"
"\xa0X4\0\xaa""a=\0\xad""d@\0\xaa""a=\0\xab""b>\0\xb1hD\0\xb1hD\0\xb5lH\0\xb9pL\0\xbaqM\0\xbctP\0\xbarN\0\xb9q"
    "M\0\xbfvR\0\xc3zV\0\xc0wS\0\xc1yU\0\xc0wW\0\xbfvY\0\xc5|\\\0\xc7~^\0\xc8\x7f`\0\xd0\x87""c\0\xd8\x8fk\0\xd4\x8bg\0"
    "\xd0\x87i\0\xd0\x88k\0\xd3\x8bn\0\xd6\x8dp\0\xdd\x95r\0\xe1\x98t\0\xe3\x9bw\0"
"\x9eU3\0\xa3Z6\0\xac""c?\0\xab""b>\0\xab""c?\0\xab""b>\0\xad""eA\0\xac""cC\0\xaa""bE\0\xab""bG\0\xaf""fJ\0\xb6mL\0\xbeu"
    "Q\0\xc1xT\0\xc2yU\0\xc1yU\0\xc2yW\0\xc1xY\0\xc0w\\\0\xc6}^\0\xcd\x84`\0\xd3\x8a""f\0\xdc\x94p\0\xde\x96r\0\xd9\x90l\0"
    "\xd8\x8fk\0\xd9\x90n\0\xda\x91p\0\xdf\x96r\0\xe5\x9cx\0\xe8\x9f{\0\xe6\x9dy\0"
"\x9bR5\0\x9fW8\0\xa8_;\0\xae""fB\0\xac""c?\0\xab""bA\0\xa8_C\0\xa8`E\0\xa8""bG\0\xa8""dJ\0\xaa""fL\0\xafiN\0\xb9p"
    "P\0\xc2yU\0\xc1yU\0\xbfvW\0\xc4{Y\0\xc5|\\\0\xc4{^\0\xc9\x80`\0\xd0\x87""c\0\xd9\x90l\0\xe3\x9av\0\xe0\x98t\0\xdd\x94p\0"
    "\xdf\x96r\0\xdf\x97s\0\xdd\x95r\0\xe1\x98t\0\xe7\x9ez\0\xe8\x9f{\0\xe8\x9f{\0"
"\xa4\\8\0\xa6^:\0\xaa""a=\0\xac""c?\0\xb0gC\0\xafgC\0\xb0gE\0\xb0gG\0\xb4kJ\0\xb8pL\0\xb7nN\0\xb3kP\0\xb6n"
    "S\0\xc1yU\0\xc7~Z\0\xc9\x80\\\0\xc9\x80\\\0\xca\x82^\0\xcb\x82`\0\xcd\x84""b\0\xd1\x89""e\0\xd4\x8bg\0\xd9\x90l\0\xde\x96r\0\xdd\x95q\0"
    "\xdf\x96r\0\xdf\x96r\0\xdd\x94t\0\xdf\x96w\0\xe6\x9dy\0\xe8\xa0|\0\xea\xa1}\0"
"\xac""c?\0\xae""fB\0\xac""c?\0\xae""eA\0\xb4kG\0\xbaqM\0\xb7nJ\0\xb7oK\0\xc1xT\0\xc4{W\0\xc3zV\0\xbbrS\0\xbar"
    "U\0\xc5|X\0\xce\x86""b\0\xd1\x88""d\0\xd0\x87""c\0\xce\x85""a\0\xcf\x86""b\0\xd1\x89""e\0\xd2\x89g\0\xce\x86i\0\xd1\x88k\0\xd7\x8en\0\xdd\x95q\0"
    "\xdf\x97s\0\xe0\x97t\0\xde\x95w\0\xe3\x9ay\0\xe7\x9e{\0\xea\xa1}\0\xed\xa4\x80\0"
"\xaa""a=\0\xa9`>\0\xa9`A\0\xad""eC\0\xb8oK\0\xbaqM\0\xb6nJ\0\xb4lL\0\xbcsO\0\xc5|X\0\xc3zV\0\xc1yU\0\xc5|"
    "X\0\xce\x85""a\0\xd3\x8a""f\0\xd0\x87""c\0\xce\x85""a\0\xcd\x84""b\0\xce\x85""e\0\xd0\x87g\0\xd2\x8ai\0\xd1\x88k\0\xd0\x8bn\0\xd4\x8dp\0\xdd\x95r\0"
    "\xe4\x9bw\0\xe3\x9bw\0\xe4\x9cy\0\xe6\x9d{\0\xe9\xa0}\0\xec\xa4\x80\0\xef\xa6\x82\0"
"\xa4[>\0\xa1[A\0\xa4^C\0\xa9`E\0\xb2iG\0\xb4kJ\0\xaf""fL\0\xb1iN\0\xb6mP\0\xbfwS\0\xc1yU\0\xc2yW\0\xc9\x80"
    "\\\0\xd1\x88""d\0\xd0\x87""c\0\xce\x85""a\0\xcd\x84""b\0\xc9\x81""e\0\xcc\x83g\0\xd2\x89i\0\xd4\x8bk\0\xd5\x8cn\0\xd2\x8dp\0\xd5\x90r\0\xe0\x97t\0"
    "\xe5\x9cx\0\xe7\x9ez\0\xe8\x9f{\0\xe9\xa0}\0\xea\xa1\x80\0\xef\xa6\x82\0\xf2\xa9\x85\0"
"\xab""bA\0\xa5^C\0\xa6`E\0\xad""dG\0\xad""dJ\0\xaf""fL\0\xb4kN\0\xb3kP\0\xbbrS\0\xc1yU\0\xc2yW\0\xbfvY\0\xc9\x80"
    "\\\0\xd2\x89""e\0\xd0\x87""c\0\xd0\x87""c\0\xd1\x89""e\0\xd0\x87g\0\xce\x86i\0\xd4\x8bk\0\xda\x92n\0\xda\x91p\0\xd8\x90r\0\xd9\x92t\0\xe2\x99w\0"
    "\xe9\xa0|\0\xe9\xa1}\0\xea\xa1}\0\xeb\xa2\x80\0\xed\xa4\x82\0\xf0\xa7\x84\0\xf3\xab\x87\0"
"\xb0gC\0\xb0gE\0\xb2iG\0\xb4kJ\0\xb8pL\0\xb9pN\0\xb9pP\0\xbbrS\0\xbfwU\0\xc8\x7f[\0\xc4{Y\0\xc2y\\\0\xcb\x83"
    "_\0\xd4\x8bg\0\xd3\x8a""f\0\xd2\x89""e\0\xd9\x90l\0\xd8\x8fk\0\xda\x92n\0\xdb\x92n\0\xdf\x97s\0\xe3\x9av\0\xe2\x99u\0\xe0\x97w\0\xe6\x9dy\0"
    "\xeb\xa2~\0\xec\xa3\x7f\0\xeb\xa3\x80\0\xed\xa4\x82\0\xef\xa6\x84\0\xf2\xa9\x86\0\xf5\xad\x89\0"
"\xb2iE\0\xb5lH\0\xb7oK\0\xbctP\0\xbeuQ\0\xc1xT\0\xbfwS\0\xbctU\0\xc4{W\0\xc7~Z\0\xc8\x80\\\0\xc9\x80^\0\xce\x85"
    "a\0\xd3\x8a""f\0\xd2\x89""e\0\xd4\x8bg\0\xd9\x90l\0\xdf\x96r\0\xe0\x97s\0\xdf\x97s\0\xe1\x98t\0\xe5\x9cx\0\xe8\x9f{\0\xe8\x9f{\0\xe8\xa0|\0"
    "\xeb\xa2~\0\xed\xa4\x80\0\xee\xa5\x82\0\xef\xa6\x84\0\xf2\xa9\x86\0\xf4\xac\x89\0\xf7\xae\x8b\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } drill = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    drill_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      drill_lines + 0,
      drill_lines + 128,
      drill_lines + 256,
      drill_lines + 384,
      drill_lines + 512,
      drill_lines + 640,
      drill_lines + 768,
      drill_lines + 896,
      drill_lines + 1024,
      drill_lines + 1152,
      drill_lines + 1280,
      drill_lines + 1408,
      drill_lines + 1536,
      drill_lines + 1664,
      drill_lines + 1792,
      drill_lines + 1920,
      drill_lines + 2048,
      drill_lines + 2176,
      drill_lines + 2304,
      drill_lines + 2432,
      drill_lines + 2560,
      drill_lines + 2688,
      drill_lines + 2816,
      drill_lines + 2944,
      drill_lines + 3072,
      drill_lines + 3200,
      drill_lines + 3328,
      drill_lines + 3456,
      drill_lines + 3584,
      drill_lines + 3712,
      drill_lines + 3840,
      drill_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY nodrill_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "nodrill", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "32", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char nodrill_lines[] = 
"$II\0'KK\0+OO\0/SS\0""2WW\0""4YY\0""8]]\0<aa\0@dd\0""Aff\0Gll\0Mqq\0Pu"
    "u\0Uzz\0^\x82\x82\0^\x83\x83\0`\x85\x85\0""c\x88\x88\0g\x8b\x8b\0k\x8f\x8f\0n\x93\x93\0n\x93\x93\0m\x91\x91\0q\x95\x95\0z\x9e\x9e\0"
    "\x7f\xa4\xa4\0\x83\xa8\xa8\0\x89\xad\xad\0\x89\xae\xae\0\x8b\xaf\xaf\0\x92\xb7\xb7\0\x98\xbd\xbd\0"
"'LL\0+PP\0/TT\0""2WW\0""6ZZ\0:^^\0>bb\0""Aff\0""Eii\0Imm\0Kpp\0Puu\0Rw"
    "w\0X||\0\\\x80\x80\0`\x85\x85\0""d\x89\x89\0j\x8f\x8f\0o\x93\x93\0q\x96\x96\0s\x98\x98\0q\x95\x95\0q\x94\x94\0z\x9e\x9e\0\x86\xab\xab\0"
    "\x8a\xaf\xaf\0\x8b\xb0\xb0\0\x8d\xb2\xb2\0\x8d\xb2\xb2\0\x8f\xb4\xb4\0\x98\xbc\xbc\0\x9f\xc4\xc4\0"
",QQ\0""0UU\0""5YY\0""6[[\0""8]]\0<aa\0""Aff\0""Fjj\0Lqq\0Mrr\0Puu\0Tyy\0Tx"
    "x\0Tyy\0]\x82\x82\0""d\x89\x89\0j\x8f\x8f\0q\x95\x95\0v\x9b\x9b\0x\x9d\x9d\0w\x9b\x9b\0v\x9a\x9a\0v\x9b\x9b\0\x81\xa6\xa6\0\x8c\xb1\xb1\0"
    "\x92\xb7\xb7\0\x94\xb8\xb8\0\x93\xb8\xb8\0\x94\xb9\xb9\0\x96\xbb\xbb\0\x9d\xc2\xc2\0\xa3\xc8\xc8\0"
"0UU\0""4XX\0""9^^\0:^^\0""7\\\\\0>cc\0""Eii\0Jnn\0Mrr\0Sxx\0W{{\0Z\x7f\x7f\0W|"
    "|\0V{{\0_\x84\x84\0k\x90\x90\0n\x92\x92\0q\x96\x96\0v\x9b\x9b\0w\x9b\x9b\0z\x9e\x9e\0z\x9e\x9e\0\x7f\xa4\xa4\0\x85\xaa\xaa\0\x89\xae\xae\0"
    "\x8f\xb4\xb4\0\x97\xbc\xbc\0\x9a\xbf\xbf\0\x99\xbe\xbe\0\x9b\xc0\xc0\0\xa1\xc5\xc5\0\xa5\xca\xca\0"
"2WW\0""7\\\\\0<aa\0""9^^\0:__\0""Bff\0Jnn\0Mrr\0Puu\0W{{\0`\x84\x84\0""d\x89\x89\0_\x84"
    "\x84\0^\x83\x83\0""e\x89\x89\0l\x90\x90\0o\x94\x94\0r\x97\x97\0v\x9a\x9a\0v\x9a\x9a\0u\x99\x99\0|\xa1\xa1\0\x83\xa8\xa8\0\x87\xab\xab\0\x88\xad\xad\0"
    "\x8b\xaf\xaf\0\x96\xbb\xbb\0\x9d\xc2\xc2\0\x9e\xc2\xc2\0\x9f\xc4\xc4\0\xa3\xc8\xc8\0\xa7\xcc\xcc\0"
"6ZZ\0:__\0>bb\0=bb\0>bb\0Gll\0Rvv\0Quu\0Puu\0X||\0""a\x86\x86\0""e\x8a\x8a\0g\x8c"
    "\x8c\0g\x8b\x8b\0i\x8d\x8d\0n\x93\x93\0r\x97\x97\0v\x9a\x9a\0z\x9e\x9e\0z\x9e\x9e\0x\x9d\x9d\0\x7f\xa3\xa3\0\x89\xad\xad\0\x8c\xb1\xb1\0\x89\xae\xae\0"
    "\x8d\xb2\xb2\0\x98\xbc\xbc\0\x9f\xc4\xc4\0\xa1\xc5\xc5\0\xa3\xc8\xc8\0\xa7\xcb\xcb\0\xaa\xcf\xcf\0"
"8]]\0<aa\0>cc\0@dd\0""Bff\0Mqq\0Uzz\0Tyy\0Oss\0Rww\0[\x80\x80\0""d\x89\x89\0g\x8b"
    "\x8b\0l\x90\x90\0n\x93\x93\0r\x97\x97\0w\x9b\x9b\0|\xa1\xa1\0\x80\xa5\xa5\0\x81\xa6\xa6\0\x83\xa8\xa8\0\x89\xae\xae\0\x93\xb8\xb8\0\x92\xb7\xb7\0\x92\xb7\xb7\0"
    "\x94\xb9\xb9\0\x99\xbe\xbe\0\x9e\xc3\xc3\0\xa2\xc7\xc7\0\xa5\xca\xca\0\xa9\xce\xce\0\xad\xd2\xd2\0"
"\x7f""6\x12\0~5\x11\0|3\x14\0}5\x16\0\x84;\x18\0\x84<\x1a\0\x83:\x1d\0\x85=\x1f\0\x8d""E!\0\x92J&\0\x93J&\0\x94L(\0\x99P"
    ",\0\xa0W3\0\xa2Y5\0\x9bS1\0\x99P3\0\x9eV5\0\xa0W8\0\xa0W:\0\xa4\\<\0\xab""b>\0\xad""eA\0\xac""cC\0\xa6`E\0"
    "\xa8""bG\0\xb1hJ\0\xb8pL\0\xbeuQ\0\xc8\x7f[\0\xca\x81]\0\xca\x82^\0"
"\x81""9\x15\0\x81""8\x14\0~5\x16\0\x81""8\x18\0\x82""9\x1a\0\x83:\x1d\0\x83=\x1f\0\x87>!\0\x8d""D#\0\x92J&\0\x94L(\0\x97O+\0\xa0W"
    "3\0\xa3Z6\0\xa1X4\0\xa1X4\0\xa2Y5\0\xa4\\8\0\xa3Z:\0\xa0W<\0\xa1Y>\0\xa4[A\0\xa6^C\0\xa8`E\0\xa8""bG\0"
    "\xac""dJ\0\xb4lL\0\xbbrN\0\xbeuQ\0\xc3zV\0\xc9\x81]\0\xcb\x83_\0"
"\x84;\x17\0\x85<\x18\0\x84<\x18\0\x84<\x1a\0\x88?\x1d\0\x89@\x1f\0\x8b""B!\0\x8d""D#\0\x8f""F&\0\x91H(\0\x93K*\0\x99P,\0\x9cS"
    "/\0\x9fV2\0\xa0W3\0\xa3Z6\0\xa8_;\0\xa8_;\0\xa7^<\0\xa7^>\0\xa8_A\0\xab""bC\0\xac""dE\0\xaf""fG\0\xb1hJ\0"
    "\xb4lL\0\xb9pN\0\xbeuQ\0\xc0wS\0\xc2zV\0\xc2yW\0\xc9\x80\\\0"
"\x86>\x1a\0\x8a""A\x1d\0\x87>\x1a\0\x89""A\x1d\0\x8c""C\x1f\0\x91H$\0\x90H$\0\x92J&\0\x91H(\0\x8f""F*\0\x93J,\0\x9bS/\0\x9dU"
    "1\0\x9bR3\0\xa0X5\0\xa5\\8\0\xa8_;\0\xaa""a=\0\xab""b>\0\xad""eA\0\xafgC\0\xb2iE\0\xb4kG\0\xb6nJ\0\xb8pL\0"
    "\xbbrN\0\xbdtP\0\xc0wS\0\xc5}Y\0\xc4{W\0\xbfvY\0\xc6}\\\0"
"\x87>\x1a\0\x89@\x1c\0\x89""A\x1d\0\x8b""C\x1f\0\x8e""E!\0\x90G#\0\x92J&\0\x93J(\0\x93K*\0\x93J,\0\x9bS/\0\xa3Z6\0\xa0W"
    "3\0\x9eV5\0\xa0W8\0\xa6^:\0\xa9`<\0\xab""b>\0\xad""eA\0\xb0gC\0\xb5lH\0\xb7nJ\0\xb7oK\0\xb6mL\0\xb7nN\0"
    "\xb8oP\0\xbbrS\0\xc1yU\0\xc5|X\0\xc6}Y\0\xc5|\\\0\xca\x82^\0"
"\x87>\x1a\0\x88?\x1d\0\x8a""A\x1f\0\x8c""D!\0\x8d""D#\0\x8e""E&\0\x8e""F(\0\x95L*\0\x97N,\0\x9cS/\0\xa5\\8\0\xa7^:\0\xa2Y"
    "5\0\x9fW8\0\xa6^:\0\xaa""a=\0\xab""b>\0\xab""bA\0\xad""eC\0\xb3jF\0\xbduQ\0\xbfvR\0\xbbsO\0\xb9pN\0\xb4kP\0"
    "\xb3nS\0\xb7pU\0\xc0wW\0\xc6}Y\0\xc8\x80\\\0\xca\x82^\0\xcf\x87""c\0"
"\x8c""C\x1f\0\x8c""C\x1f\0\x8c""D!\0\x8d""D#\0\x8b""B&\0\x8d""D(\0\x95L*\0\x99P,\0\x9aQ/\0\x9fV2\0\xa5\\8\0\xa5\\8\0\xa0W"
    "8\0\xa8_;\0\xae""fB\0\xae""eA\0\xad""eA\0\xad""eC\0\xac""dE\0\xb5lH\0\xbfvR\0\xc1xT\0\xbcsO\0\xb9pP\0\xbaqS\0"
    "\xb7pU\0\xbdtW\0\xc6}Y\0\xc9\x80\\\0\xcb\x83_\0\xce\x85""a\0\xd3\x8a""f\0"
"\x8e""E!\0\x8e""E!\0\x8e""F#\0\x8f""F&\0\x8d""D(\0\x95L*\0\x9cS/\0\x9cS/\0\x9aQ1\0\x9cS3\0\xa0X5\0\xa2Y8\0\xa6^"
    ":\0\xb1hD\0\xb3jF\0\xae""eA\0\xad""eC\0\xad""eE\0\xb0gG\0\xb6nJ\0\xbctP\0\xbeuQ\0\xb9pP\0\xbdtS\0\xbfwU\0"
    "\xc4{W\0\xcc\x83_\0\xd0\x87""c\0\xce\x85""a\0\xd0\x87""c\0\xd6\x8di\0\xd7\x8ej\0"
"\x8e""E!\0\x8e""F#\0\x90G&\0\x93J(\0\x95L*\0\x99Q-\0\x9eV2\0\x9dU1\0\xa0W3\0\xa3Z6\0\xa0W8\0\x9dU:\0\xa7^"
    "<\0\xb1hD\0\xb1iE\0\xafgC\0\xb3jF\0\xb4kG\0\xb1hJ\0\xb8pL\0\xbfvR\0\xbdtP\0\xbdtS\0\xbfwU\0\xc2yW\0"
    "\xc7~Z\0\xd0\x87""c\0\xd3\x8a""f\0\xd2\x8a""f\0\xd9\x90l\0\xdb\x92n\0\xda\x92n\0"
"\x90H$\0\x90G&\0\x91H(\0\x93K*\0\x97N,\0\x9cS/\0\x9dU1\0\xa2Z6\0\xa9""a=\0\xad""d@\0\xa6^:\0\xa0W<\0\xa4["
    ">\0\xad""eA\0\xb3jF\0\xbaqM\0\xbctP\0\xb7oK\0\xb6mL\0\xbbrN\0\xbeuQ\0\xc0wS\0\xc1yU\0\xc2yW\0\xc1xY\0"
    "\xc2y\\\0\xca\x82^\0\xcf\x87""c\0\xd3\x8a""f\0\xd9\x90l\0\xda\x92n\0\xd8\x8fk\0"
"\x92J&\0\x93J(\0\x8f""F*\0\x93J,\0\x9bS/\0\x9fV2\0\x9eU3\0\xa3Z6\0\xac""c?\0\xaf""fB\0\xaa""a=\0\xa7^>\0\xa9`"
    "A\0\xac""cC\0\xb3jF\0\xbctP\0\xbfvR\0\xbctP\0\xbcsO\0\xbeuQ\0\xbfwS\0\xc1yU\0\xc4{W\0\xc4{Y\0\xc0w\\\0"
    "\xc2y^\0\xc9\x80`\0\xcf\x86""b\0\xd2\x89""e\0\xd6\x8di\0\xd7\x8ej\0\xd6\x8ek\0"
"\x95M)\0\x95L*\0\x93J,\0\x9aQ/\0\xa1X4\0\xa1X4\0\x9dT5\0\x9bR8\0\xa3Z:\0\xa7^<\0\xa7^>\0\xa9`A\0\xad""e"
    "C\0\xb0gE\0\xb0gG\0\xb7oK\0\xbbsO\0\xbfvR\0\xc5|X\0\xc3zV\0\xc2zV\0\xc4{W\0\xc7~Z\0\xc9\x80\\\0\xca\x82^\0"
    "\xcb\x82`\0\xcb\x83""b\0\xcf\x87""e\0\xd2\x89g\0\xd6\x8di\0\xd8\x8fk\0\xda\x92n\0"
"\x9aQ-\0\x9cS/\0\x9bS/\0\xa0X4\0\xa7^:\0\xa3Z6\0\x98R8\0\x98U:\0\x9bW<\0\xa1Y>\0\xa3[A\0\xa6^C\0\xb0g"
    "E\0\xb5lH\0\xb7oK\0\xb8pL\0\xbbrN\0\xc0wS\0\xc7~Z\0\xc9\x81]\0\xc5|X\0\xc6}Y\0\xcb\x82^\0\xd2\x89""e\0\xd5\x8ch\0"
    "\xd2\x89""e\0\xd1\x89""e\0\xcf\x86g\0\xd2\x8ai\0\xd6\x8ek\0\xdb\x92n\0\xe1\x98t\0"
"\x9eU1\0\x9eV2\0\xa1X4\0\xa5\\8\0\xab""b>\0\xa7^:\0\xa0W:\0\x9fW<\0\xa4[>\0\xab""bA\0\xac""cC\0\xa9`E\0\xb0g"
    "G\0\xbarN\0\xbfvR\0\xbcsO\0\xbdtP\0\xc0wS\0\xc4|X\0\xc7~Z\0\xc6}Y\0\xc6}\\\0\xcb\x83_\0\xd4\x8bg\0\xd4\x8ch\0"
    "\xd7\x8ej\0\xd2\x89g\0\xd2\x8ai\0\xd3\x8ak\0\xd3\x8bn\0\xdb\x92p\0\xe1\x99u\0"
"\x9eV2\0\xa6]9\0\xa8_;\0\xa7_;\0\xad""d@\0\xae""fB\0\xab""c?\0\xaf""fB\0\xb6nJ\0\xbbrN\0\xbbrN\0\xb5lH\0\xb4k"
    "J\0\xbctP\0\xc1xT\0\xc0wS\0\xbfwS\0\xbfwU\0\xc2yW\0\xc4{Y\0\xc5|\\\0\xc4{^\0\xcd\x84`\0\xd2\x89""e\0\xd4\x8bg\0"
    "\xd2\x89g\0\xd2\x89i\0\xd0\x88k\0\xd3\x8bn\0\xd5\x8dp\0\xda\x91r\0\xe1\x98t\0"
"\xa0X4\0\xaa""a=\0\xad""d@\0\xaa""a=\0\xab""b>\0\xb1hD\0\xb1hD\0\xb5lH\0\xb9pL\0\xbaqM\0\xbctP\0\xbarN\0\xb9q"
    "M\0\xbfvR\0\xc3zV\0\xc0wS\0\xc1yU\0\xc0wW\0\xbfvY\0\xc5|\\\0\xc7~^\0\xc8\x7f`\0\xd0\x87""c\0\xd8\x8fk\0\xd4\x8bg\0"
    "\xd0\x87i\0\xd0\x88k\0\xd3\x8bn\0\xd6\x8dp\0\xdd\x95r\0\xe1\x98t\0\xe3\x9bw\0"
"\x9eU3\0\xa3Z6\0\xac""c?\0\xab""b>\0\xab""c?\0\xab""b>\0\xad""eA\0\xac""cC\0\xaa""bE\0\xab""bG\0\xaf""fJ\0\xb6mL\0\xbeu"
    "Q\0\xc1xT\0\xc2yU\0\xc1yU\0\xc2yW\0\xc1xY\0\xc0w\\\0\xc6}^\0\xcd\x84`\0\xd3\x8a""f\0\xdc\x94p\0\xde\x96r\0\xd9\x90l\0"
    "\xd8\x8fk\0\xd9\x90n\0\xda\x91p\0\xdf\x96r\0\xe5\x9cx\0\xe8\x9f{\0\xe6\x9dy\0"
"\x9bR5\0\x9fW8\0\xa8_;\0\xae""fB\0\xac""c?\0\xab""bA\0\xa8_C\0\xa8`E\0\xa8""bG\0\xa8""dJ\0\xaa""fL\0\xafiN\0\xb9p"
    "P\0\xc2yU\0\xc1yU\0\xbfvW\0\xc4{Y\0\xc5|\\\0\xc4{^\0\xc9\x80`\0\xd0\x87""c\0\xd9\x90l\0\xe3\x9av\0\xe0\x98t\0\xdd\x94p\0"
    "\xdf\x96r\0\xdf\x97s\0\xdd\x95r\0\xe1\x98t\0\xe7\x9ez\0\xe8\x9f{\0\xe8\x9f{\0"
"\xa4\\8\0\xa6^:\0\xaa""a=\0\xac""c?\0\xb0gC\0\xafgC\0\xb0gE\0\xb0gG\0\xb4kJ\0\xb8pL\0\xb7nN\0\xb3kP\0\xb6n"
    "S\0\xc1yU\0\xc7~Z\0\xc9\x80\\\0\xc9\x80\\\0\xca\x82^\0\xcb\x82`\0\xcd\x84""b\0\xd1\x89""e\0\xd4\x8bg\0\xd9\x90l\0\xde\x96r\0\xdd\x95q\0"
    "\xdf\x96r\0\xdf\x96r\0\xdd\x94t\0\xdf\x96w\0\xe6\x9dy\0\xe8\xa0|\0\xea\xa1}\0"
"\xac""c?\0\xae""fB\0\xac""c?\0\xae""eA\0\xb4kG\0\xbaqM\0\xb7nJ\0\xb7oK\0\xc1xT\0\xc4{W\0\xc3zV\0\xbbrS\0\xbar"
    "U\0\xc5|X\0\xce\x86""b\0\xd1\x88""d\0\xd0\x87""c\0\xce\x85""a\0\xcf\x86""b\0\xd1\x89""e\0\xd2\x89g\0\xce\x86i\0\xd1\x88k\0\xd7\x8en\0\xdd\x95q\0"
    "\xdf\x97s\0\xe0\x97t\0\xde\x95w\0\xe3\x9ay\0\xe7\x9e{\0\xea\xa1}\0\xed\xa4\x80\0"
"\xaa""a=\0\xa9`>\0\xa9`A\0\xad""eC\0\xb8oK\0\xbaqM\0\xb6nJ\0\xb4lL\0\xbcsO\0\xc5|X\0\xc3zV\0\xc1yU\0\xc5|"
    "X\0\xce\x85""a\0\xd3\x8a""f\0\xd0\x87""c\0\xce\x85""a\0\xcd\x84""b\0\xce\x85""e\0\xd0\x87g\0\xd2\x8ai\0\xd1\x88k\0\xd0\x8bn\0\xd4\x8dp\0\xdd\x95r\0"
    "\xe4\x9bw\0\xe3\x9bw\0\xe4\x9cy\0\xe6\x9d{\0\xe9\xa0}\0\xec\xa4\x80\0\xef\xa6\x82\0"
"\xa4[>\0\xa1[A\0\xa4^C\0\xa9`E\0\xb2iG\0\xb4kJ\0\xaf""fL\0\xb1iN\0\xb6mP\0\xbfwS\0\xc1yU\0\xc2yW\0\xc9\x80"
    "\\\0\xd1\x88""d\0\xd0\x87""c\0\xce\x85""a\0\xcd\x84""b\0\xc9\x81""e\0\xcc\x83g\0\xd2\x89i\0\xd4\x8bk\0\xd5\x8cn\0\xd2\x8dp\0\xd5\x90r\0\xe0\x97t\0"
    "\xe5\x9cx\0\xe7\x9ez\0\xe8\x9f{\0\xe9\xa0}\0\xea\xa1\x80\0\xef\xa6\x82\0\xf2\xa9\x85\0"
"\xab""bA\0\xa5^C\0\xa6`E\0\xad""dG\0\xad""dJ\0\xaf""fL\0\xb4kN\0\xb3kP\0\xbbrS\0\xc1yU\0\xc2yW\0\xbfvY\0\xc9\x80"
    "\\\0\xd2\x89""e\0\xd0\x87""c\0\xd0\x87""c\0\xd1\x89""e\0\xd0\x87g\0\xce\x86i\0\xd4\x8bk\0\xda\x92n\0\xda\x91p\0\xd8\x90r\0\xd9\x92t\0\xe2\x99w\0"
    "\xe9\xa0|\0\xe9\xa1}\0\xea\xa1}\0\xeb\xa2\x80\0\xed\xa4\x82\0\xf0\xa7\x84\0\xf3\xab\x87\0"
"\xb0gC\0\xb0gE\0\xb2iG\0\xb4kJ\0\xb8pL\0\xb9pN\0\xb9pP\0\xbbrS\0\xbfwU\0\xc8\x7f[\0\xc4{Y\0\xc2y\\\0\xcb\x83"
    "_\0\xd4\x8bg\0\xd3\x8a""f\0\xd2\x89""e\0\xd9\x90l\0\xd8\x8fk\0\xda\x92n\0\xdb\x92n\0\xdf\x97s\0\xe3\x9av\0\xe2\x99u\0\xe0\x97w\0\xe6\x9dy\0"
    "\xeb\xa2~\0\xec\xa3\x7f\0\xeb\xa3\x80\0\xed\xa4\x82\0\xef\xa6\x84\0\xf2\xa9\x86\0\xf5\xad\x89\0"
"\xb2iE\0\xb5lH\0\xb7oK\0\xbctP\0\xbeuQ\0\xc1xT\0\xbfwS\0\xbctU\0\xc4{W\0\xc7~Z\0\xc8\x80\\\0\xc9\x80^\0\xce\x85"
    "a\0\xd3\x8a""f\0\xd2\x89""e\0\xd4\x8bg\0\xd9\x90l\0\xdf\x96r\0\xe0\x97s\0\xdf\x97s\0\xe1\x98t\0\xe5\x9cx\0\xe8\x9f{\0\xe8\x9f{\0\xe8\xa0|\0"
    "\xeb\xa2~\0\xed\xa4\x80\0\xee\xa5\x82\0\xef\xa6\x84\0\xf2\xa9\x86\0\xf4\xac\x89\0\xf7\xae\x8b\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } nodrill = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    nodrill_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      nodrill_lines + 0,
      nodrill_lines + 128,
      nodrill_lines + 256,
      nodrill_lines + 384,
      nodrill_lines + 512,
      nodrill_lines + 640,
      nodrill_lines + 768,
      nodrill_lines + 896,
      nodrill_lines + 1024,
      nodrill_lines + 1152,
      nodrill_lines + 1280,
      nodrill_lines + 1408,
      nodrill_lines + 1536,
      nodrill_lines + 1664,
      nodrill_lines + 1792,
      nodrill_lines + 1920,
      nodrill_lines + 2048,
      nodrill_lines + 2176,
      nodrill_lines + 2304,
      nodrill_lines + 2432,
      nodrill_lines + 2560,
      nodrill_lines + 2688,
      nodrill_lines + 2816,
      nodrill_lines + 2944,
      nodrill_lines + 3072,
      nodrill_lines + 3200,
      nodrill_lines + 3328,
      nodrill_lines + 3456,
      nodrill_lines + 3584,
      nodrill_lines + 3712,
      nodrill_lines + 3840,
      nodrill_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY ladder_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "ladder", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "64", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char ladder_lines[] = 
"\x90H$\0|4\x10\0\x84<\x18\0\x90H$\0\x90H$\0|4\x10\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x8c""D \0\x90H$\0\xa0X4\0\xa0X4\0\x98P,\0\x90H$\0"
"\xa0X4\0\x8c""D \0|4\x10\0|4\x10\0x0\f\0x0\f\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x98P,\0\xa0X4\0\xa0X4\0\x8c""D \0|4\x10\0x0\f\0"
"\x98P,\0\x98P,\0|4\x10\0p(\x4\0l$\0\0x0\f\0\x84<\x18\0\xa4\\8\0\xb4lH\0\xac""d@\0\x8c""D \0x0\f\0|4"
    "\x10\0\xa0X4\0\xac""d@\0\xac""d@\0\xa4\\8\0\xa0X4\0|4\x10\0x0\f\0\x90H$\0\x98P,\0\x90H$\0\x84<\x18\0\x8c""D \0"
    "\x98P,\0\x90H$\0\xa4\\8\0\xa0X4\0\x84<\x18\0p(\x4\0p(\x4\0"
"\x84<\x18\0\xa0X4\0\x98P,\0x0\f\0l$\0\0\x84<\x18\0\x90H$\0\x98P,\0\xa4\\8\0\xa4\\8\0\x98P,\0x0\f\0|4"
    "\x10\0\xa0X4\0\xb4lH\0\xb4lH\0\xb4lH\0\xac""d@\0\xa0X4\0\x84<\x18\0\x84<\x18\0\x98P,\0\xa0X4\0\x98P,\0\x84<\x18\0"
    "|4\x10\0\x98P,\0\xa0X4\0\x98P,\0|4\x10\0|4\x10\0p(\x4\0"
"\x84<\x18\0\xa4\\8\0\xa0X4\0|4\x10\0l$\0\0x0\f\0p(\x4\0x0\f\0\x84<\x18\0\x98P,\0\x84<\x18\0p(\x4\0|4"
    "\x10\0\xa0X4\0\xac""d@\0\xa4\\8\0\x90H$\0x0\f\0p(\x4\0x0\f\0\x84<\x18\0|4\x10\0x0\f\0x0\f\0\x98P,\0"
    "\xa0X4\0\x98P,\0\xa0X4\0\x84<\x18\0|4\x10\0x0\f\0x0\f\0"
"\x98P,\0\xa4\\8\0\x98P,\0x0\f\0l$\0\0\x84<\x18\0\x8c""D \0\x84<\x18\0\x98P,\0\xa0X4\0\x90H$\0x0\f\0\x84<"
    "\x18\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X4\0\x8c""D \0\x84<\x18\0\x98P,\0\xa0X4\0\x98P,\0\x84<\x18\0\x84<\x18\0\xa0X4\0"
    "\xa4\\8\0\xa4\\8\0\xa0X4\0\x8c""D \0\x84<\x18\0\x8c""D \0x0\f\0"
"\x98P,\0\xa0X4\0\x84<\x18\0|4\x10\0x0\f\0\x98P,\0\x90H$\0\x8c""D \0\xa0X4\0\xac""d@\0\x8c""D \0|4\x10\0\x90H"
    "$\0\xa4\\8\0\xa4\\8\0\x90H$\0\x90H$\0\x98P,\0\xa0X4\0\xa4\\8\0\xa4\\8\0\xa0X4\0\xa0X4\0\x98P,\0\x8c""D \0"
    "\xa0X4\0\xa0X4\0\xa0X4\0\xa0X4\0\xa4\\8\0\xa0X4\0\x84<\x18\0"
"\x90H$\0\x84<\x18\0\x84<\x18\0\x98P,\0\x98P,\0|4\x10\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x84<\x18\0\x84<\x18\0\xa0X4\0\xac""d@\0\xa4\\8\0\x98P,\0"
"\x8c""D \0\x8c""D \0\x98P,\0\xa4\\8\0\xa4\\8\0\x98P,\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0p(\x4\0x0\f\0|4\x10\0\x98P,\0\x98P,\0\x8c""D \0"
"\x98P,\0\xa0X4\0\xa4\\8\0\xa0X4\0\xa4\\8\0\x98P,\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0p(\x4\0p(\x4\0|4\x10\0\x84<\x18\0\x84<\x18\0\x8c""D \0"
"\x8c""D \0\xa0X4\0\xa0X4\0\xa4\\8\0\xa0X4\0\xa0X4\0\xac""d@\0\xa4\\8\0\xa4\\8\0\xa0X4\0\x90H$\0x0\f\0p("
    "\x4\0x0\f\0x0\f\0|4\x10\0\x8c""D \0\x8c""D \0\xa0X4\0\xa0X4\0\x84<\x18\0p(\x4\0p(\x4\0x0\f\0|4\x10\0"
    "x0\f\0|4\x10\0\x90H$\0\x8c""D \0\x98P,\0\x98P,\0\x90H$\0"
"\x84<\x18\0|4\x10\0\x8c""D \0\xa4\\8\0\xa0X4\0\xa4\\8\0\xac""d@\0\xa4\\8\0\xa4\\8\0\xa4\\8\0\x8c""D \0x0\f\0p("
    "\x4\0p(\x4\0p(\x4\0x0\f\0x0\f\0\x84<\x18\0\x8c""D \0\x98P,\0|4\x10\0p(\x4\0x0\f\0|4\x10\0x0\f\0"
    "p(\x4\0|4\x10\0\xa0X4\0\xa4\\8\0\xa4\\8\0\xac""d@\0\xac""d@\0"
"|4\x10\0x0\f\0|4\x10\0\xa0X4\0\xa4\\8\0\xa4\\8\0\xa0X4\0\x8c""D \0\x90H$\0\xa4\\8\0\x98P,\0x0\f\0p("
    "\x4\0\x84<\x18\0|4\x10\0\x84<\x18\0\x8c""D \0\x84<\x18\0\x98P,\0\xa0X4\0\x8c""D \0\x84<\x18\0\x98P,\0\x98P,\0\x8c""D \0"
    "p(\x4\0|4\x10\0\xac""d@\0\xa0X4\0\xa4\\8\0\xa4\\8\0\xa4\\8\0"
"\x8c""D \0p(\x4\0|4\x10\0\xa0X4\0\xa4\\8\0\x98P,\0\x84<\x18\0\x84<\x18\0\xa0X4\0\xac""d@\0\xa0X4\0|4\x10\0p("
    "\x4\0|4\x10\0\x98P,\0\xa4\\8\0\xa0X4\0\x90H$\0\x98P,\0\xa0X4\0\x98P,\0\xa0X4\0\xa4\\8\0\xa4\\8\0\x84<\x18\0"
    "p(\x4\0|4\x10\0\xa0X4\0\x98P,\0\x90H$\0\x84<\x18\0\x84<\x18\0"
"\x8c""D \0|4\x10\0\x8c""D \0\xa0X4\0\xa4\\8\0|4\x10\0x0\f\0\x8c""D \0\xa0X4\0\xac""d@\0\xa4\\8\0\x8c""D \0|4"
    "\x10\0\x8c""D \0\xa0X4\0\xac""d@\0\xa4\\8\0\xa4\\8\0\x8c""D \0\x8c""D \0\x90H$\0\x8c""D \0\xa0X4\0\xa0X4\0\x8c""D \0"
    "x0\f\0|4\x10\0\x8c""D \0\x8c""D \0\x8c""D \0\x84<\x18\0|4\x10\0"
"\x90H$\0\x98P,\0\xa0X4\0\x98P,\0\x8c""D \0\x90H$\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x84<\x18\0|4\x10\0\x90H$\0\xa0X4\0\xa0X4\0\x90H$\0"
"\xa4\\8\0\xa4\\8\0\xa4\\8\0\x84<\x18\0|4\x10\0\x90H$\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x84<\x18\0\x84<\x18\0\xa0X4\0\xb4lH\0\xac""d@\0\x98P,\0"
"\x90H$\0\xa0X4\0\x98P,\0|4\x10\0x0\f\0\x8c""D \0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x8c""D \0|4\x10\0\x90H$\0\xa4\\8\0\xa0X4\0\x8c""D \0"
"\x84<\x18\0\x84<\x18\0\x8c""D \0x0\f\0x0\f\0\x98P,\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0|4\x10\0|4\x10\0|4\x10\0\x8c""D \0\x90H$\0\x8c""D \0"
"\x90H$\0\x84<\x18\0x0\f\0x0\f\0|4\x10\0l$\0\0p(\x4\0x0\f\0\x8c""D \0\xa4\\8\0\xa4\\8\0\x98P,\0\xa0X"
    "4\0\x8c""D \0\x84<\x18\0\x90H$\0\x98P,\0\x90H$\0\x84<\x18\0\x98P,\0\x90H$\0|4\x10\0x0\f\0x0\f\0x0\f\0"
    "|4\x10\0\x84<\x18\0\x90H$\0\x84<\x18\0\x8c""D \0\x90H$\0\x8c""D \0"
"\x98P,\0\x98P,\0\x84<\x18\0\x84<\x18\0\x90H$\0x0\f\0x0\f\0p(\x4\0x0\f\0\x90H$\0\xa0X4\0\xa4\\8\0\xa4\\"
    "8\0\x98P,\0|4\x10\0x0\f\0|4\x10\0x0\f\0x0\f\0x0\f\0|4\x10\0\x84<\x18\0\x90H$\0\x90H$\0\x84<\x18\0"
    "\xa0X4\0\xa4\\8\0\xa4\\8\0\xa4\\8\0\xa4\\8\0\x98P,\0\x84<\x18\0"
"\x90H$\0\xa0X4\0\xa4\\8\0\xa4\\8\0\xa0X4\0\x98P,\0\x90H$\0|4\x10\0x0\f\0|4\x10\0\x8c""D \0\xa4\\8\0\xb4l"
    "H\0\xa0X4\0|4\x10\0l$\0\0l$\0\0p(\x4\0x0\f\0x0\f\0|4\x10\0\x98P,\0\xa0X4\0\x8c""D \0\x90H$\0"
    "\x98P,\0\xa4\\8\0\xa0X4\0\xa4\\8\0\xac""d@\0\xa0X4\0|4\x10\0"
"\x8c""D \0\xa0X4\0\xac""d@\0\xa4\\8\0\x98P,\0\xa4\\8\0\x98P,\0\x84<\x18\0\x84<\x18\0x0\f\0|4\x10\0\xa0X4\0\xac""d"
    "@\0\x98P,\0x0\f\0l$\0\0p(\x4\0|4\x10\0\x98P,\0\x90H$\0\x8c""D \0\xa0X4\0\xa0X4\0\x84<\x18\0x0\f\0"
    "|4\x10\0\x8c""D \0|4\x10\0\x84<\x18\0\x98P,\0\x90H$\0x0\f\0"
"\x8c""D \0\xa4\\8\0\xa4\\8\0\x8c""D \0|4\x10\0\xa4\\8\0\x8c""D \0\x84<\x18\0\x8c""D \0x0\f\0|4\x10\0\xa0X4\0\xac""d"
    "@\0\x90H$\0\x84<\x18\0x0\f\0x0\f\0\x90H$\0\xa0X4\0\xa0X4\0\x90H$\0\xa4\\8\0\xa0X4\0\x84<\x18\0p(\x4\0"
    "p(\x4\0|4\x10\0x0\f\0|4\x10\0|4\x10\0|4\x10\0x0\f\0"
"\x98P,\0\xa4\\8\0\xa0X4\0\x84<\x18\0p(\x4\0p(\x4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0|4\x10\0\x8c""D \0\x90H$\0\x84<\x18\0\x84<\x18\0\x8c""D \0"
"\x98P,\0\x90H$\0\x90H$\0\x90H$\0|4\x10\0x0\f\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0|4\x10\0|4\x10\0\x98P,\0\xa0X4\0\xa4\\8\0\x98P,\0"
"\x8c""D \0|4\x10\0x0\f\0|4\x10\0\x8c""D \0\x8c""D \0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\x84<\x18\0x0\f\0\x84<\x18\0\xa4\\8\0\xb4lH\0\xa4\\8\0"
"|4\x10\0\x84<\x18\0|4\x10\0\x84<\x18\0\x8c""D \0\x98P,\0\x8c""D \0\xa0X4\0\xa4\\8\0\xa0X4\0|4\x10\0|4\x10\0\x98P"
    ",\0\xa0X4\0\x98P,\0\xa0X4\0\x98P,\0x0\f\0l$\0\0p(\x4\0\x84<\x18\0\xa0X4\0\xa4\\8\0\x98P,\0\x84<\x18\0"
    "\x8c""D \0\xa4\\8\0x0\f\0|4\x10\0\x98P,\0\xac""d@\0\xa4\\8\0"
"\x90H$\0\xa0X4\0\xa0X4\0\xa0X4\0\xa0X4\0|4\x10\0\x84<\x18\0\x90H$\0\xac""d@\0\xac""d@\0\x98P,\0\x84<\x18\0\x84<"
    "\x18\0\xa0X4\0\xa4\\8\0\xa4\\8\0\xa0X4\0\x84<\x18\0x0\f\0p(\x4\0|4\x10\0\xa0X4\0\xb4lH\0\xa4\\8\0\x8c""D \0"
    "\x84<\x18\0\x98P,\0x0\f\0x0\f\0\x8c""D \0\x90H$\0\xa4\\8\0"
"\x90H$\0\xa0X4\0\xa4\\8\0\xac""d@\0\xac""d@\0|4\x10\0\x98P,\0\xa0X4\0\xa4\\8\0\xa4\\8\0\x98P,\0|4\x10\0\x84<"
    "\x18\0\x84<\x18\0\x98P,\0\x98P,\0\x8c""D \0\x98P,\0\x90H$\0x0\f\0x0\f\0\x90H$\0\xa0X4\0\xa0X4\0\xa0X4\0"
    "\x98P,\0\x84<\x18\0p(\x4\0x0\f\0|4\x10\0\x8c""D \0\xa0X4\0"
"x0\f\0|4\x10\0\x84<\x18\0\xa0X4\0\xa4\\8\0\xa0X4\0\xac""d@\0\xac""d@\0\x98P,\0\x98P,\0|4\x10\0x0\f\0p("
    "\x4\0|4\x10\0|4\x10\0|4\x10\0\x84<\x18\0\xa0X4\0\xa4\\8\0\x8c""D \0|4\x10\0|4\x10\0|4\x10\0\x8c""D \0\xa4\\8\0"
    "\xa0X4\0|4\x10\0x0\f\0|4\x10\0\x90H$\0\x98P,\0\x90H$\0"
"x0\f\0x0\f\0|4\x10\0\x90H$\0\xa0X4\0\xa4\\8\0\xb4lH\0\xa4\\8\0\x98P,\0|4\x10\0|4\x10\0x0\f\0x0"
    "\f\0|4\x10\0\x8c""D \0|4\x10\0|4\x10\0\x98P,\0\x98P,\0\x90H$\0\x84<\x18\0x0\f\0p(\x4\0\x84<\x18\0\xa0X4\0"
    "\xa4\\8\0\x8c""D \0\x8c""D \0\x8c""D \0\xa4\\8\0\xa4\\8\0\x90H$\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } ladder = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    ladder_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      ladder_lines + 0,
      ladder_lines + 128,
      ladder_lines + 256,
      ladder_lines + 384,
      ladder_lines + 512,
      ladder_lines + 640,
      ladder_lines + 768,
      ladder_lines + 896,
      ladder_lines + 1024,
      ladder_lines + 1152,
      ladder_lines + 1280,
      ladder_lines + 1408,
      ladder_lines + 1536,
      ladder_lines + 1664,
      ladder_lines + 1792,
      ladder_lines + 1920,
      ladder_lines + 2048,
      ladder_lines + 2176,
      ladder_lines + 2304,
      ladder_lines + 2432,
      ladder_lines + 2560,
      ladder_lines + 2688,
      ladder_lines + 2816,
      ladder_lines + 2944,
      ladder_lines + 3072,
      ladder_lines + 3200,
      ladder_lines + 3328,
      ladder_lines + 3456,
      ladder_lines + 3584,
      ladder_lines + 3712,
      ladder_lines + 3840,
      ladder_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY egg_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "egg", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "96", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char egg_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0|\xe8\xe8\0l\xd8\xd8\0""d\xd0\xd0\0""d\xd0\xd0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0""d\xd0"
    "\xd0\0x\xe4\xe4\0|\xe8\xe8\0l\xd8\xd8\0X\xc4\xc4\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0X\xc4\xc4\0h\xd4\xd4\0X\xc4"
    "\xc4\0""d\xd0\xd0\0l\xd8\xd8\0h\xd4\xd4\0h\xd4\xd4\0l\xd8\xd8\0p\xdc\xdc\0|\xe8\xe8\0|\xe8\xe8\0""d\xd0\xd0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0<\xa8\xa8\0\\\xc8\xc8\0p\xdc\xdc\0\\\xc8"
    "\xc8\0""D\xb0\xb0\0X\xc4\xc4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0p\xdc\xdc\0x\xe4\xe4\0|\xe8\xe8\0h\xd4\xd4\0""D\xb0\xb0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0X\xc4\xc4\0H\xb4\xb4\0""d\xd0\xd0\0x\xe4\xe4\0""d\xd0"
    "\xd0\0""D\xb0\xb0\0<\xa8\xa8\0X\xc4\xc4\0h\xd4\xd4\0l\xd8\xd8\0h\xd4\xd4\0l\xd8\xd8\0p\xdc\xdc\0l\xd8\xd8\0`\xcc\xcc\0`\xcc\xcc\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0""d\xd0\xd0\0""d\xd0\xd0\0h\xd4\xd4\0l\xd8\xd8\0l\xd8"
    "\xd8\0X\xc4\xc4\0H\xb4\xb4\0""D\xb0\xb0\0`\xcc\xcc\0p\xdc\xdc\0l\xd8\xd8\0\\\xc8\xc8\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0t\xe0\xe0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0p\xdc"
    "\xdc\0t\xe0\xe0\0h\xd4\xd4\0T\xc0\xc0\0H\xb4\xb4\0\\\xc8\xc8\0l\xd8\xd8\0h\xd4\xd4\0\\\xc8\xc8\0""d\xd0\xd0\0h\xd4\xd4\0l\xd8\xd8\0p\xdc\xdc\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0t\xe0"
    "\xe0\0\x80\xec\xec\0\x80\xec\xec\0""d\xd0\xd0\0H\xb4\xb4\0H\xb4\xb4\0`\xcc\xcc\0h\xd4\xd4\0""d\xd0\xd0\0X\xc4\xc4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0h\xd4\xd4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0p\xdc"
    "\xdc\0|\xe8\xe8\0x\xe4\xe4\0""d\xd0\xd0\0X\xc4\xc4\0X\xc4\xc4\0T\xc0\xc0\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0t\xe0\xe0\0t\xe0\xe0\0"
    "p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0H\xb4\xb4\0X\xc4\xc4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8"
    "\xd8\0p\xdc\xdc\0l\xd8\xd8\0X\xc4\xc4\0l\xd8\xd8\0p\xdc\xdc\0l\xd8\xd8\0h\xd4\xd4\0|\xe8\xe8\0|\xe8\xe8\0|\xe8\xe8\0|\xe8\xe8\0|\xe8\xe8\0"
    "p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0H\xb4\xb4\0H\xb4\xb4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8"
    "\xd8\0l\xd8\xd8\0""d\xd0\xd0\0\\\xc8\xc8\0\\\xc8\xc8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0t\xe0\xe0\0|\xe8\xe8\0x\xe4\xe4\0x\xe4\xe4\0|\xe8\xe8\0"
    "p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0""d\xd0\xd0\0""d\xd0\xd0\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0"
    "\xd0\0\\\xc8\xc8\0\\\xc8\xc8\0\\\xc8\xc8\0L\xb8\xb8\0L\xb8\xb8\0`\xcc\xcc\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0p\xdc\xdc\0p\xdc\xdc\0"
    "p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0x\xe4\xe4\0|\xe8\xe8\0|\xe8\xe8\0p\xdc\xdc\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0"
    "\xd0\0P\xbc\xbc\0T\xc0\xc0\0""d\xd0\xd0\0\\\xc8\xc8\0L\xb8\xb8\0\\\xc8\xc8\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0\xd0\0h\xd4\xd4\0p\xdc\xdc\0"
    "p\xdc\xdc\0p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0x\xe4\xe4\0\x84\xf0\xf0\0\x84\xf0\xf0\0x\xe4\xe4\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0"
    "\xd0\0\\\xc8\xc8\0""d\xd0\xd0\0x\xe4\xe4\0x\xe4\xe4\0l\xd8\xd8\0\\\xc8\xc8\0X\xc4\xc4\0H\xb4\xb4\0\\\xc8\xc8\0\\\xc8\xc8\0L\xb8\xb8\0\\\xc8\xc8\0"
    "p\xdc\xdc\0p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0p\xdc\xdc\0|\xe8\xe8\0|\xe8\xe8\0x\xe4\xe4\0x\xe4\xe4\0l\xd8\xd8\0""d\xd0\xd0\0""d\xd0"
    "\xd0\0l\xd8\xd8\0t\xe0\xe0\0\x84\xf0\xf0\0\x84\xf0\xf0\0t\xe0\xe0\0""d\xd0\xd0\0H\xb4\xb4\0H\xb4\xb4\0\\\xc8\xc8\0\\\xc8\xc8\0""D\xb0\xb0\0@\xac\xac\0"
    "X\xc4\xc4\0l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0\xd0\0h\xd4\xd4\0l\xd8\xd8\0\\\xc8\xc8\0H\xb4\xb4\0\\\xc8"
    "\xc8\0l\xd8\xd8\0t\xe0\xe0\0\x84\xf0\xf0\0\x88\xf4\xf4\0|\xe8\xe8\0l\xd8\xd8\0""d\xd0\xd0\0`\xcc\xcc\0""d\xd0\xd0\0""d\xd0\xd0\0X\xc4\xc4\0""D\xb0\xb0\0"
    "L\xb8\xb8\0p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0h\xd4\xd4\0X\xc4\xc4\0""D\xb0\xb0\0L\xb8\xb8\0X\xc4\xc4\0@\xac\xac\0<\xa8\xa8\0X\xc4"
    "\xc4\0p\xdc\xdc\0x\xe4\xe4\0\x80\xec\xec\0\x80\xec\xec\0|\xe8\xe8\0|\xe8\xe8\0x\xe4\xe4\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0\xd0\0\\\xc8\xc8\0"
    "`\xcc\xcc\0x\xe4\xe4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0h\xd4\xd4\0H\xb4\xb4\0H\xb4\xb4\0\\\xc8\xc8\0\\\xc8\xc8\0@\xac\xac\0<\xa8\xa8\0\\\xc8"
    "\xc8\0|\xe8\xe8\0\x80\xec\xec\0x\xe4\xe4\0t\xe0\xe0\0t\xe0\xe0\0t\xe0\xe0\0p\xdc\xdc\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0"
    "l\xd8\xd8\0t\xe0\xe0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0X\xc4\xc4\0""d\xd0\xd0\0t\xe0\xe0\0p\xdc\xdc\0T\xc0\xc0\0""D\xb0\xb0\0\\\xc8"
    "\xc8\0|\xe8\xe8\0\x80\xec\xec\0t\xe0\xe0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0"
    "l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0|\xe8\xe8\0x\xe4\xe4\0p\xdc\xdc\0`\xcc\xcc\0P\xbc\xbc\0`\xcc"
    "\xcc\0l\xd8\xd8\0l\xd8\xd8\0p\xdc\xdc\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0"
    "l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x80\xec\xec\0\x84\xf0\xf0\0t\xe0\xe0\0l\xd8\xd8\0h\xd4\xd4\0l\xd8\xd8\0l\xd8"
    "\xd8\0`\xcc\xcc\0T\xc0\xc0\0`\xcc\xcc\0h\xd4\xd4\0\\\xc8\xc8\0\\\xc8\xc8\0h\xd4\xd4\0l\xd8\xd8\0h\xd4\xd4\0""d\xd0\xd0\0""d\xd0\xd0\0l\xd8\xd8\0"
    "l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x90\xfc\xfc\0\x88\xf4\xf4\0t\xe0\xe0\0l\xd8\xd8\0l\xd8\xd8\0x\xe4\xe4\0p\xdc"
    "\xdc\0T\xc0\xc0\0H\xb4\xb4\0\\\xc8\xc8\0l\xd8\xd8\0L\xb8\xb8\0H\xb4\xb4\0""d\xd0\xd0\0x\xe4\xe4\0""d\xd0\xd0\0H\xb4\xb4\0X\xc4\xc4\0""d\xd0\xd0\0"
    "l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0|\xe8\xe8\0l\xd8\xd8\0l\xd8\xd8\0t\xe0\xe0\0t\xe0\xe0\0""d\xd0"
    "\xd0\0@\xac\xac\0@\xac\xac\0""d\xd0\xd0\0p\xdc\xdc\0X\xc4\xc4\0H\xb4\xb4\0h\xd4\xd4\0|\xe8\xe8\0l\xd8\xd8\0L\xb8\xb8\0""D\xb0\xb0\0X\xc4\xc4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0`\xcc\xcc\0t\xe0\xe0\0|\xe8\xe8\0l\xd8\xd8\0\\\xc8"
    "\xc8\0""D\xb0\xb0\0H\xb4\xb4\0\\\xc8\xc8\0l\xd8\xd8\0`\xcc\xcc\0""d\xd0\xd0\0l\xd8\xd8\0|\xe8\xe8\0x\xe4\xe4\0h\xd4\xd4\0X\xc4\xc4\0@\xac\xac\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0x\xe4\xe4\0t\xe0\xe0\0l\xd8\xd8\0h\xd4"
    "\xd4\0""d\xd0\xd0\0""d\xd0\xd0\0X\xc4\xc4\0P\xbc\xbc\0X\xc4\xc4\0\\\xc8\xc8\0`\xcc\xcc\0""d\xd0\xd0\0l\xd8\xd8\0x\xe4\xe4\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0x\xe4\xe4\0p\xdc\xdc\0p\xdc\xdc\0p\xdc\xdc\0t\xe0"
    "\xe0\0|\xe8\xe8\0t\xe0\xe0\0X\xc4\xc4\0""D\xb0\xb0\0P\xbc\xbc\0P\xbc\xbc\0P\xbc\xbc\0\\\xc8\xc8\0X\xc4\xc4\0l\xd8\xd8\0t\xe0\xe0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0h\xd4\xd4\0h\xd4\xd4\0p\xdc\xdc\0t\xe0"
    "\xe0\0p\xdc\xdc\0l\xd8\xd8\0H\xb4\xb4\0H\xb4\xb4\0X\xc4\xc4\0`\xcc\xcc\0`\xcc\xcc\0`\xcc\xcc\0h\xd4\xd4\0h\xd4\xd4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0X\xc4\xc4\0X\xc4\xc4\0P\xbc"
    "\xbc\0""d\xd0\xd0\0`\xcc\xcc\0L\xb8\xb8\0\\\xc8\xc8\0p\xdc\xdc\0p\xdc\xdc\0p\xdc\xdc\0x\xe4\xe4\0p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0""D\xb0"
    "\xb0\0\\\xc8\xc8\0""d\xd0\xd0\0\\\xc8\xc8\0""d\xd0\xd0\0p\xdc\xdc\0p\xdc\xdc\0t\xe0\xe0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0X\xc4\xc4\0P\xbc\xbc\0H\xb4\xb4\0X\xc4\xc4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } egg = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    egg_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      egg_lines + 0,
      egg_lines + 128,
      egg_lines + 256,
      egg_lines + 384,
      egg_lines + 512,
      egg_lines + 640,
      egg_lines + 768,
      egg_lines + 896,
      egg_lines + 1024,
      egg_lines + 1152,
      egg_lines + 1280,
      egg_lines + 1408,
      egg_lines + 1536,
      egg_lines + 1664,
      egg_lines + 1792,
      egg_lines + 1920,
      egg_lines + 2048,
      egg_lines + 2176,
      egg_lines + 2304,
      egg_lines + 2432,
      egg_lines + 2560,
      egg_lines + 2688,
      egg_lines + 2816,
      egg_lines + 2944,
      egg_lines + 3072,
      egg_lines + 3200,
      egg_lines + 3328,
      egg_lines + 3456,
      egg_lines + 3584,
      egg_lines + 3712,
      egg_lines + 3840,
      egg_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rope_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rope", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "128", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rope_lines[] = 
"p(\x4\0l$\0\0p(\x4\0|4\x10\0\x84<\x18\0x0\f\0P\b\0\0""D\0\0\0P\b\0\0l$\0\0l$\0\0X\x10\0\0P\b"
    "\0\0X\x10\0\0x0\f\0\x8c""D \0p(\x4\0l$\0\0""d\x1c\0\0P\b\0\0P\b\0\0""d\x1c\0\0x0\f\0x0\f\0l$\0\0"
    "H\0\0\0X\x10\0\0l$\0\0|4\x10\0p(\x4\0|4\x10\0|4\x10\0"
"x0\f\0p(\x4\0p(\x4\0x0\f\0\x8c""D \0\x90H$\0p(\x4\0H\0\0\0X\x10\0\0""d\x1c\0\0""d\x1c\0\0P\b\0\0P\b"
    "\0\0p(\x4\0\x8c""D \0x0\f\0l$\0\0""d\x1c\0\0""d\x1c\0\0""d\x1c\0\0""d\x1c\0\0l$\0\0p(\x4\0|4\x10\0""d\x1c\0\0"
    "H\0\0\0P\b\0\0p(\x4\0x0\f\0x0\f\0x0\f\0|4\x10\0"
"\x90H$\0\x84<\x18\0p(\x4\0l$\0\0x0\f\0\x90H$\0\x84<\x18\0""d\x1c\0\0X\x10\0\0""d\x1c\0\0\\\x14\0\0X\x10\0\0""d\x1c"
    "\0\0\x90H$\0\x98P,\0p(\x4\0P\b\0\0\\\x14\0\0l$\0\0x0\f\0\x8c""D \0|4\x10\0p(\x4\0""d\x1c\0\0""d\x1c\0\0"
    "d\x1c\0\0p(\x4\0x0\f\0l$\0\0l$\0\0p(\x4\0\x84<\x18\0"
"\xa4\\8\0\x90H$\0l$\0\0""d\x1c\0\0p(\x4\0|4\x10\0|4\x10\0X\x10\0\0P\b\0\0p(\x4\0p(\x4\0X\x10\0\0l$"
    "\0\0\x90H$\0\x98P,\0l$\0\0H\0\0\0X\x10\0\0""d\x1c\0\0p(\x4\0\x8c""D \0\x90H$\0l$\0\0H\0\0\0X\x10\0\0"
    "\x8c""D \0\x90H$\0l$\0\0P\b\0\0""d\x1c\0\0|4\x10\0\x8c""D \0"
"\x84<\x18\0x0\f\0\\\x14\0\0\\\x14\0\0\\\x14\0\0""d\x1c\0\0\\\x14\0\0X\x10\0\0l$\0\0\x90H$\0\x8c""D \0l$\0\0X\x10"
    "\0\0|4\x10\0\x90H$\0l$\0\0H\0\0\0X\x10\0\0""d\x1c\0\0\\\x14\0\0x0\f\0\x8c""D \0l$\0\0H\0\0\0l$\0\0"
    "\x98P,\0\x98P,\0X\x10\0\0""D\0\0\0\\\x14\0\0l$\0\0x0\f\0"
"X\x10\0\0""d\x1c\0\0l$\0\0""d\x1c\0\0X\x10\0\0P\b\0\0X\x10\0\0""d\x1c\0\0|4\x10\0\x98P,\0\x90H$\0p(\x4\0""d\x1c"
    "\0\0p(\x4\0\x84<\x18\0l$\0\0P\b\0\0\\\x14\0\0""d\x1c\0\0""d\x1c\0\0l$\0\0p(\x4\0l$\0\0""d\x1c\0\0p(\x4\0"
    "\x90H$\0\x8c""D \0""d\x1c\0\0H\0\0\0\\\x14\0\0""d\x1c\0\0X\x10\0\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rope = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rope_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rope_lines + 0,
      rope_lines + 128,
      rope_lines + 256,
      rope_lines + 384,
      rope_lines + 512,
      rope_lines + 640,
      rope_lines + 768,
      rope_lines + 896,
      rope_lines + 1024,
      rope_lines + 1152,
      rope_lines + 1280,
      rope_lines + 1408,
      rope_lines + 1536,
      rope_lines + 1664,
      rope_lines + 1792,
      rope_lines + 1920,
      rope_lines + 2048,
      rope_lines + 2176,
      rope_lines + 2304,
      rope_lines + 2432,
      rope_lines + 2560,
      rope_lines + 2688,
      rope_lines + 2816,
      rope_lines + 2944,
      rope_lines + 3072,
      rope_lines + 3200,
      rope_lines + 3328,
      rope_lines + 3456,
      rope_lines + 3584,
      rope_lines + 3712,
      rope_lines + 3840,
      rope_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY trap_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "trap", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "160", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char trap_lines[] = 
"m$\0\0o&\x2\0q(\x4\0s*\x6\0u,\b\0w/\v\0y0\r\0{2\xf\0|4\x11\0\x7f""6\x14\0\x82:\x16\0\x86>\x1a\0\x89""A"
    "\x1d\0\x8a""A\x1d\0\x89@\x1f\0\x8e""E!\0\x96M)\0\x95M)\0\x97N*\0\x96N*\0\x97N,\0\x9eU1\0\xa3Z6\0\xa3Z6\0\xa5\\8\0"
    "\xa7^:\0\xa9`<\0\xa9`<\0\xa9`>\0\xab""bA\0\xad""eC\0\xb2iE\0"
"o&\x2\0q(\x4\0r*\x6\0u,\b\0w.\v\0x/\r\0{2\xf\0~5\x11\0~5\x14\0\x7f""6\x16\0\x84<\x18\0\x8c""C\x1f\0\x8f""F"
    "\"\0\x8b""C\x1f\0\x8c""D!\0\x92J&\0\x99P,\0\x95M)\0\x91H*\0\x95L,\0\x9aQ/\0\x9dU1\0\xa3Z6\0\xa3Z6\0\xa7^:\0"
    "\xae""fB\0\xb1hD\0\xac""c?\0\xab""bA\0\xad""eC\0\xb0gE\0\xb7nJ\0"
"r)\x5\0t+\a\0u,\b\0w.\v\0x/\r\0{3\xf\0~5\x11\0\x82""9\x15\0\x80""7\x16\0\x7f""6\x18\0\x86=\x1a\0\x8f""F\"\0\x8e""E"
    "!\0\x8d""E!\0\x90G#\0\x97N*\0\x9bR.\0\x95L*\0\x90H,\0\x97N/\0\x9bS1\0\x9eU3\0\x9eV5\0\xa2Y8\0\xa9`<\0"
    "\xb1iE\0\xb1hD\0\xb0gC\0\xafgC\0\xad""eE\0\xb2iG\0\xbarN\0"
"t+\a\0v.\n\0w/\v\0x/\r\0{2\xf\0~5\x11\0\x83:\x16\0\x86=\x19\0\x84;\x18\0\x83:\x1a\0\x88?\x1d\0\x8c""C\x1f\0\x8d""E"
    "!\0\x8c""D#\0\x92J&\0\x9bS/\0\x9eU1\0\x95L,\0\x92K/\0\x9aQ1\0\xa0W3\0\x9bR5\0\x98R8\0\x9dU:\0\xaa""a=\0"
    "\xb3jF\0\xb1iE\0\xb0gC\0\xb5lH\0\xb2iG\0\xb2iJ\0\xb9qM\0"
"u,\b\0w/\v\0x/\r\0{2\xf\0~5\x11\0\x83:\x16\0\x86=\x19\0\x87>\x1a\0\x87>\x1a\0\x88?\x1d\0\x8a""A\x1f\0\x8d""E!\0\x8d""D"
    "#\0\x8f""F&\0\x93J(\0\x9aQ-\0\x9eU1\0\x98O/\0\x94L1\0\x9cS3\0\xa6]9\0\xa2Y8\0\x9dU:\0\x9fW<\0\xab""b>\0"
    "\xb3jF\0\xb3jF\0\xb3jF\0\xb5lH\0\xb6nJ\0\xb3kL\0\xbbrN\0"
"w/\v\0w.\r\0x0\xf\0~5\x11\0|\xe8\xe8\0|\xe8\xe8\0""d\xd0\xd0\0H\xb4\xb4\0X\xc4\xc4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8"
    "\xd8\0l\xd8\xd8\0""d\xd0\xd0\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0h\xd4\xd4\0\\\xc8\xc8\0X\xc4\xc4\0""D\xb0\xb0\0X\xc4\xc4\0t\xe0\xe0\0|\xe8\xe8\0"
    "x\xe4\xe4\0p\xdc\xdc\0\\\xc8\xc8\0\xb7oK\0\xb9qM\0\xbcsO\0\xbeuQ\0"
"{2\xe\0z1\xf\0x1\x11\0~5\x14\0|\xe8\xe8\0|\xe8\xe8\0t\xe0\xe0\0h\xd4\xd4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8"
    "\xd8\0\\\xc8\xc8\0H\xb4\xb4\0L\xb8\xb8\0h\xd4\xd4\0h\xd4\xd4\0X\xc4\xc4\0h\xd4\xd4\0h\xd4\xd4\0""d\xd0\xd0\0h\xd4\xd4\0t\xe0\xe0\0|\xe8\xe8\0"
    "x\xe4\xe4\0x\xe4\xe4\0\\\xc8\xc8\0\xbbsO\0\xc4{W\0\xc6}Y\0\xc5|X\0"
"\x7f""6\x12\0~5\x11\0|3\x14\0}5\x16\0h\xd4\xd4\0`\xcc\xcc\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0"
    "\xd0\0\\\xc8\xc8\0L\xb8\xb8\0`\xcc\xcc\0t\xe0\xe0\0l\xd8\xd8\0l\xd8\xd8\0t\xe0\xe0\0x\xe4\xe4\0t\xe0\xe0\0p\xdc\xdc\0p\xdc\xdc\0l\xd8\xd8\0"
    "p\xdc\xdc\0h\xd4\xd4\0T\xc0\xc0\0\xbeuQ\0\xc8\x7f[\0\xca\x81]\0\xca\x82^\0"
"\x81""9\x15\0\x81""8\x14\0~5\x16\0\x81""8\x18\0H\xb4\xb4\0""D\xb0\xb0\0L\xb8\xb8\0l\xd8\xd8\0x\xe4\xe4\0l\xd8\xd8\0""d\xd0\xd0\0X\xc4\xc4\0""d\xd0"
    "\xd0\0\\\xc8\xc8\0`\xcc\xcc\0p\xdc\xdc\0|\xe8\xe8\0t\xe0\xe0\0t\xe0\xe0\0|\xe8\xe8\0\x80\xec\xec\0|\xe8\xe8\0p\xdc\xdc\0h\xd4\xd4\0""d\xd0\xd0\0"
    "l\xd8\xd8\0""d\xd0\xd0\0""D\xb0\xb0\0\xbeuQ\0\xc3zV\0\xc9\x81]\0\xcb\x83_\0"
"\x84;\x17\0\x85<\x18\0\x84<\x18\0\x84<\x1a\0P\xbc\xbc\0<\xa8\xa8\0\\\xc8\xc8\0t\xe0\xe0\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0\xd0\0l\xd8\xd8\0h\xd4"
    "\xd4\0\\\xc8\xc8\0L\xb8\xb8\0`\xcc\xcc\0t\xe0\xe0\0p\xdc\xdc\0p\xdc\xdc\0|\xe8\xe8\0x\xe4\xe4\0t\xe0\xe0\0""d\xd0\xd0\0L\xb8\xb8\0X\xc4\xc4\0"
    "d\xd0\xd0\0""d\xd0\xd0\0X\xc4\xc4\0\xc0wS\0\xc2zV\0\xc2yW\0\xc9\x80\\\0"
"\x86>\x1a\0\x8a""A\x1d\0\x87>\x1a\0\x89""A\x1d\0T\xc0\xc0\0""d\xd0\xd0\0p\xdc\xdc\0|\xe8\xe8\0""d\xd0\xd0\0T\xc0\xc0\0l\xd8\xd8\0|\xe8\xe8\0p\xdc"
    "\xdc\0X\xc4\xc4\0<\xa8\xa8\0""8\xa4\xa4\0X\xc4\xc4\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0p\xdc\xdc\0l\xd8\xd8\0`\xcc\xcc\0H\xb4\xb4\0H\xb4\xb4\0"
    "d\xd0\xd0\0l\xd8\xd8\0""d\xd0\xd0\0\xc5}Y\0\xc4{W\0\xbfvY\0\xc6}\\\0"
"\x87>\x1a\0\x89@\x1c\0\x89""A\x1d\0\x8b""C\x1f\0l\xd8\xd8\0x\xe4\xe4\0|\xe8\xe8\0p\xdc\xdc\0`\xcc\xcc\0T\xc0\xc0\0""d\xd0\xd0\0t\xe0\xe0\0x\xe4"
    "\xe4\0`\xcc\xcc\0H\xb4\xb4\0@\xac\xac\0L\xb8\xb8\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0\xd0\0h\xd4\xd4\0t\xe0\xe0\0h\xd4\xd4\0`\xcc\xcc\0`\xcc\xcc\0"
    "h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0\xc5|X\0\xc6}Y\0\xc5|\\\0\xca\x82^\0"
"\x87>\x1a\0\x88?\x1d\0\x8a""A\x1f\0\x8c""D!\0\x80\xec\xec\0\x84\xf0\xf0\0p\xdc\xdc\0h\xd4\xd4\0\\\xc8\xc8\0""d\xd0\xd0\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8"
    "\xd8\0l\xd8\xd8\0h\xd4\xd4\0h\xd4\xd4\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0\xd0\0P\xbc\xbc\0`\xcc\xcc\0h\xd4\xd4\0l\xd8\xd8\0p\xdc\xdc\0x\xe4\xe4\0"
    "p\xdc\xdc\0l\xd8\xd8\0l\xd8\xd8\0\xc6}Y\0\xc8\x80\\\0\xca\x82^\0\xcf\x87""c\0"
"\x8c""C\x1f\0\x8c""C\x1f\0\x8c""D!\0\x8d""D#\0\x8b""B&\0\x8d""D(\0\x95L*\0\x99P,\0\x9aQ/\0\x9fV2\0\xa5\\8\0\xa5\\8\0\xa0W"
    "8\0X\xc4\xc4\0l\xd8\xd8\0p\xdc\xdc\0t\xe0\xe0\0|\xe8\xe8\0x\xe4\xe4\0\xb5lH\0\xbfvR\0\xc1xT\0\xbcsO\0\xb9pP\0\xbaqS\0"
    "\xb7pU\0\xbdtW\0\xc6}Y\0\xc9\x80\\\0\xcb\x83_\0\xce\x85""a\0\xd3\x8a""f\0"
"\x8e""E!\0\x8e""E!\0\x8e""F#\0\x8f""F&\0\x8d""D(\0\x95L*\0\x9cS/\0\x9cS/\0\x9aQ1\0\x9cS3\0\xa0X5\0\xa2Y8\0\xa6^"
    ":\0""d\xd0\xd0\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0t\xe0\xe0\0|\xe8\xe8\0\xb6nJ\0\xbctP\0\xbeuQ\0\xb9pP\0\xbdtS\0\xbfwU\0"
    "\xc4{W\0\xcc\x83_\0\xd0\x87""c\0\xce\x85""a\0\xd0\x87""c\0\xd6\x8di\0\xd7\x8ej\0"
"\x8e""E!\0\x8e""F#\0\x90G&\0\x93J(\0\x95L*\0\x99Q-\0\x9eV2\0\x9dU1\0\xa0W3\0\xa3Z6\0\xa0W8\0\x9dU:\0\xa7^"
    "<\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0\xd0\0""d\xd0\xd0\0p\xdc\xdc\0p\xdc\xdc\0\xb8pL\0\xbfvR\0\xbdtP\0\xbdtS\0\xbfwU\0\xc2yW\0"
    "\xc7~Z\0\xd0\x87""c\0\xd3\x8a""f\0\xd2\x8a""f\0\xd9\x90l\0\xdb\x92n\0\xda\x92n\0"
"\x90H$\0\x90G&\0\x91H(\0\x93K*\0\x97N,\0\x9cS/\0\x9dU1\0\xa2Z6\0\xa9""a=\0\xad""d@\0\xa6^:\0\xa0W<\0\xa4["
    ">\0""d\xd0\xd0\0\\\xc8\xc8\0P\xbc\xbc\0`\xcc\xcc\0p\xdc\xdc\0x\xe4\xe4\0\xbbrN\0\xbeuQ\0\xc0wS\0\xc1yU\0\xc2yW\0\xc1xY\0"
    "\xc2y\\\0\xca\x82^\0\xcf\x87""c\0\xd3\x8a""f\0\xd9\x90l\0\xda\x92n\0\xd8\x8fk\0"
"\x92J&\0\x93J(\0\x8f""F*\0\x93J,\0\x9bS/\0\x9fV2\0\x9eU3\0\xa3Z6\0\xac""c?\0\xaf""fB\0\xaa""a=\0\xa7^>\0\xa9`"
    "A\0l\xd8\xd8\0\\\xc8\xc8\0H\xb4\xb4\0T\xc0\xc0\0t\xe0\xe0\0t\xe0\xe0\0\xbeuQ\0\xbfwS\0\xc1yU\0\xc4{W\0\xc4{Y\0\xc0w\\\0"
    "\xc2y^\0\xc9\x80`\0\xcf\x86""b\0\xd2\x89""e\0\xd6\x8di\0\xd7\x8ej\0\xd6\x8ek\0"
"\x95M)\0\x95L*\0\x93J,\0\x9aQ/\0\xa1X4\0\xa1X4\0\x9dT5\0\x9bR8\0\xa3Z:\0\xa7^<\0\xa7^>\0\xa9`A\0\xad""e"
    "C\0\x84\xf0\xf0\0p\xdc\xdc\0H\xb4\xb4\0H\xb4\xb4\0h\xd4\xd4\0|\xe8\xe8\0\xc3zV\0\xc2zV\0\xc4{W\0\xc7~Z\0\xc9\x80\\\0\xca\x82^\0"
    "\xcb\x82`\0\xcb\x83""b\0\xcf\x87""e\0\xd2\x89g\0\xd6\x8di\0\xd8\x8fk\0\xda\x92n\0"
"\x9aQ-\0\x9cS/\0\x9bS/\0\xa0X4\0\xa7^:\0\xa3Z6\0\x98R8\0\x98U:\0\x9bW<\0\xa1Y>\0\xa3[A\0\xa6^C\0\xb0g"
    "E\0\x84\xf0\xf0\0p\xdc\xdc\0X\xc4\xc4\0H\xb4\xb4\0l\xd8\xd8\0x\xe4\xe4\0\xc9\x81]\0\xc5|X\0\xc6}Y\0\xcb\x82^\0\xd2\x89""e\0\xd5\x8ch\0"
    "\xd2\x89""e\0\xd1\x89""e\0\xcf\x86g\0\xd2\x8ai\0\xd6\x8ek\0\xdb\x92n\0\xe1\x98t\0"
"\x9eU1\0\x9eV2\0\xa1X4\0\xa5\\8\0\xab""b>\0\xa7^:\0\xa0W:\0\x9fW<\0\xa4[>\0\xab""bA\0\xac""cC\0\xa9`E\0\xb0g"
    "G\0h\xd4\xd4\0\\\xc8\xc8\0H\xb4\xb4\0X\xc4\xc4\0t\xe0\xe0\0t\xe0\xe0\0\xc7~Z\0\xc6}Y\0\xc6}\\\0\xcb\x83_\0\xd4\x8bg\0\xd4\x8ch\0"
    "\xd7\x8ej\0\xd2\x89g\0\xd2\x8ai\0\xd3\x8ak\0\xd3\x8bn\0\xdb\x92p\0\xe1\x99u\0"
"\x9eV2\0\xa6]9\0\xa8_;\0\xa7_;\0\xad""d@\0\xae""fB\0\xab""c?\0\xaf""fB\0\xb6nJ\0\xbbrN\0\xbbrN\0\xb5lH\0\xb4k"
    "J\0`\xcc\xcc\0H\xb4\xb4\0<\xa8\xa8\0T\xc0\xc0\0l\xd8\xd8\0l\xd8\xd8\0\xc4{Y\0\xc5|\\\0\xc4{^\0\xcd\x84`\0\xd2\x89""e\0\xd4\x8bg\0"
    "\xd2\x89g\0\xd2\x89i\0\xd0\x88k\0\xd3\x8bn\0\xd5\x8dp\0\xda\x91r\0\xe1\x98t\0"
"\xa0X4\0\xaa""a=\0\xad""d@\0\xaa""a=\0\xab""b>\0\xb1hD\0\xb1hD\0\xb5lH\0\xb9pL\0\xbaqM\0\xbctP\0\xbarN\0\xb9q"
    "M\0l\xd8\xd8\0`\xcc\xcc\0H\xb4\xb4\0L\xb8\xb8\0h\xd4\xd4\0h\xd4\xd4\0\xc5|\\\0\xc7~^\0\xc8\x7f`\0\xd0\x87""c\0\xd8\x8fk\0\xd4\x8bg\0"
    "\xd0\x87i\0\xd0\x88k\0\xd3\x8bn\0\xd6\x8dp\0\xdd\x95r\0\xe1\x98t\0\xe3\x9bw\0"
"\x9eU3\0\xa3Z6\0\xac""c?\0\xab""b>\0\xab""c?\0\xab""b>\0\xad""eA\0\xac""cC\0\xaa""bE\0\xab""bG\0\xaf""fJ\0\xb6mL\0\xbeu"
    "Q\0|\xe8\xe8\0x\xe4\xe4\0`\xcc\xcc\0""d\xd0\xd0\0t\xe0\xe0\0h\xd4\xd4\0\xc6}^\0\xcd\x84`\0\xd3\x8a""f\0\xdc\x94p\0\xde\x96r\0\xd9\x90l\0"
    "\xd8\x8fk\0\xd9\x90n\0\xda\x91p\0\xdf\x96r\0\xe5\x9cx\0\xe8\x9f{\0\xe6\x9dy\0"
"\x9bR5\0\x9fW8\0\xa8_;\0\xae""fB\0\xac""c?\0\xab""bA\0\xa8_C\0\xa8`E\0\xa8""bG\0\xa8""dJ\0\xaa""fL\0\xafiN\0\xb9p"
    "P\0|\xe8\xe8\0t\xe0\xe0\0l\xd8\xd8\0p\xdc\xdc\0|\xe8\xe8\0p\xdc\xdc\0\xc9\x80`\0\xd0\x87""c\0\xd9\x90l\0\xe3\x9av\0\xe0\x98t\0\xdd\x94p\0"
    "\xdf\x96r\0\xdf\x97s\0\xdd\x95r\0\xe1\x98t\0\xe7\x9ez\0\xe8\x9f{\0\xe8\x9f{\0"
"\xa4\\8\0\xa6^:\0\xaa""a=\0\xac""c?\0\xb0gC\0\xafgC\0\xb0gE\0\xb0gG\0\xb4kJ\0\xb8pL\0\xb7nN\0\xb3kP\0\xb6n"
    "S\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0p\xdc\xdc\0x\xe4\xe4\0t\xe0\xe0\0\xcd\x84""b\0\xd1\x89""e\0\xd4\x8bg\0\xd9\x90l\0\xde\x96r\0\xdd\x95q\0"
    "\xdf\x96r\0\xdf\x96r\0\xdd\x94t\0\xdf\x96w\0\xe6\x9dy\0\xe8\xa0|\0\xea\xa1}\0"
"\xac""c?\0\xae""fB\0\xac""c?\0\xae""eA\0\xb4kG\0\xbaqM\0\xb7nJ\0\xb7oK\0\xc1xT\0\xc4{W\0\xc3zV\0\xbbrS\0\xbar"
    "U\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0h\xd4\xd4\0\xd1\x89""e\0\xd2\x89g\0\xce\x86i\0\xd1\x88k\0\xd7\x8en\0\xdd\x95q\0"
    "\xdf\x97s\0\xe0\x97t\0\xde\x95w\0\xe3\x9ay\0\xe7\x9e{\0\xea\xa1}\0\xed\xa4\x80\0"
"\xaa""a=\0\xa9`>\0\xa9`A\0\xad""eC\0\xb8oK\0\xbaqM\0\xb6nJ\0\xb4lL\0\xbcsO\0\xc5|X\0\xc3zV\0\xc1yU\0\xc5|"
    "X\0p\xdc\xdc\0l\xd8\xd8\0""d\xd0\xd0\0T\xc0\xc0\0L\xb8\xb8\0\\\xc8\xc8\0\xd0\x87g\0\xd2\x8ai\0\xd1\x88k\0\xd0\x8bn\0\xd4\x8dp\0\xdd\x95r\0"
    "\xe4\x9bw\0\xe3\x9bw\0\xe4\x9cy\0\xe6\x9d{\0\xe9\xa0}\0\xec\xa4\x80\0\xef\xa6\x82\0"
"\xa4[>\0\xa1[A\0\xa4^C\0\xa9`E\0\xb2iG\0\xb4kJ\0\xaf""fL\0\xb1iN\0\xb6mP\0\xbfwS\0\xc1yU\0\xc2yW\0\xc9\x80"
    "\\\0\xd1\x88""d\0\xd0\x87""c\0\xce\x85""a\0\xcd\x84""b\0\xc9\x81""e\0\xcc\x83g\0\xd2\x89i\0\xd4\x8bk\0\xd5\x8cn\0\xd2\x8dp\0\xd5\x90r\0\xe0\x97t\0"
    "\xe5\x9cx\0\xe7\x9ez\0\xe8\x9f{\0\xe9\xa0}\0\xea\xa1\x80\0\xef\xa6\x82\0\xf2\xa9\x85\0"
"\xab""bA\0\xa5^C\0\xa6`E\0\xad""dG\0\xad""dJ\0\xaf""fL\0\xb4kN\0\xb3kP\0\xbbrS\0\xc1yU\0\xc2yW\0\xbfvY\0\xc9\x80"
    "\\\0\xd2\x89""e\0\xd0\x87""c\0\xd0\x87""c\0\xd1\x89""e\0\xd0\x87g\0\xce\x86i\0\xd4\x8bk\0\xda\x92n\0\xda\x91p\0\xd8\x90r\0\xd9\x92t\0\xe2\x99w\0"
    "\xe9\xa0|\0\xe9\xa1}\0\xea\xa1}\0\xeb\xa2\x80\0\xed\xa4\x82\0\xf0\xa7\x84\0\xf3\xab\x87\0"
"\xb0gC\0\xb0gE\0\xb2iG\0\xb4kJ\0\xb8pL\0\xb9pN\0\xb9pP\0\xbbrS\0\xbfwU\0\xc8\x7f[\0\xc4{Y\0\xc2y\\\0\xcb\x83"
    "_\0\xd4\x8bg\0\xd3\x8a""f\0\xd2\x89""e\0\xd9\x90l\0\xd8\x8fk\0\xda\x92n\0\xdb\x92n\0\xdf\x97s\0\xe3\x9av\0\xe2\x99u\0\xe0\x97w\0\xe6\x9dy\0"
    "\xeb\xa2~\0\xec\xa3\x7f\0\xeb\xa3\x80\0\xed\xa4\x82\0\xef\xa6\x84\0\xf2\xa9\x86\0\xf5\xad\x89\0"
"\xb2iE\0\xb5lH\0\xb7oK\0\xbctP\0\xbeuQ\0\xc1xT\0\xbfwS\0\xbctU\0\xc4{W\0\xc7~Z\0\xc8\x80\\\0\xc9\x80^\0\xce\x85"
    "a\0\xd3\x8a""f\0\xd2\x89""e\0\xd4\x8bg\0\xd9\x90l\0\xdf\x96r\0\xe0\x97s\0\xdf\x97s\0\xe1\x98t\0\xe5\x9cx\0\xe8\x9f{\0\xe8\x9f{\0\xe8\xa0|\0"
    "\xeb\xa2~\0\xed\xa4\x80\0\xee\xa5\x82\0\xef\xa6\x84\0\xf2\xa9\x86\0\xf4\xac\x89\0\xf7\xae\x8b\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } trap = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    trap_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      trap_lines + 0,
      trap_lines + 128,
      trap_lines + 256,
      trap_lines + 384,
      trap_lines + 512,
      trap_lines + 640,
      trap_lines + 768,
      trap_lines + 896,
      trap_lines + 1024,
      trap_lines + 1152,
      trap_lines + 1280,
      trap_lines + 1408,
      trap_lines + 1536,
      trap_lines + 1664,
      trap_lines + 1792,
      trap_lines + 1920,
      trap_lines + 2048,
      trap_lines + 2176,
      trap_lines + 2304,
      trap_lines + 2432,
      trap_lines + 2560,
      trap_lines + 2688,
      trap_lines + 2816,
      trap_lines + 2944,
      trap_lines + 3072,
      trap_lines + 3200,
      trap_lines + 3328,
      trap_lines + 3456,
      trap_lines + 3584,
      trap_lines + 3712,
      trap_lines + 3840,
      trap_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY invladder_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "invladder", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "192", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char invladder_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0|\xe8\xe8\0`\xcc\xcc\0H\xb4\xb4\0X\xc4\xc4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0x\xe4\xe4\0|\xe8\xe8\0""d\xd0\xd0\0P\xbc\xbc\0\\\xc8\xc8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0x\xe4\xe4\0p\xdc\xdc\0h\xd4\xd4\0""d\xd0\xd0\0""d\xd0\xd0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0p\xdc\xdc\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0h\xd4\xd4\0l\xd8\xd8\0|\xe8\xe8\0|\xe8\xe8\0x\xe4\xe4\0h\xd4\xd4\0H\xb4\xb4\0H\xb4\xb4\0""d\xd0\xd0\0|\xe8\xe8\0\x80\xec\xec\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0p\xdc\xdc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0T\xc0\xc0\0""d\xd0\xd0\0t\xe0\xe0\0l\xd8\xd8\0\\\xc8\xc8\0X\xc4\xc4\0P\xbc\xbc\0H\xb4\xb4\0`\xcc\xcc\0l\xd8\xd8\0h\xd4\xd4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0x\xe4\xe4\0p\xdc\xdc\0l\xd8\xd8\0p\xdc\xdc\0`\xcc\xcc\0\xff\0\xff\0h\xd4\xd4\0""d\xd0\xd0\0p\xdc\xdc\0x\xe4\xe4\0l\xd8"
    "\xd8\0T\xc0\xc0\0""d\xd0\xd0\0h\xd4\xd4\0L\xb8\xb8\0<\xa8\xa8\0""D\xb0\xb0\0X\xc4\xc4\0h\xd4\xd4\0h\xd4\xd4\0""d\xd0\xd0\0P\xbc\xbc\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0p\xdc\xdc\0p\xdc\xdc\0l\xd8\xd8\0t\xe0\xe0\0h\xd4\xd4\0\xff\0\xff\0h\xd4\xd4\0T\xc0\xc0\0X\xc4\xc4\0l\xd8\xd8\0l\xd8"
    "\xd8\0p\xdc\xdc\0t\xe0\xe0\0X\xc4\xc4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0""d\xd0\xd0\0X\xc4\xc4\0X\xc4\xc4\0X\xc4\xc4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0`\xcc\xcc\0l\xd8\xd8\0p\xdc\xdc\0|\xe8\xe8\0h\xd4\xd4\0\xff\0\xff\0""d\xd0\xd0\0\\\xc8\xc8\0\\\xc8\xc8\0""d\xd0\xd0\0l\xd8"
    "\xd8\0p\xdc\xdc\0|\xe8\xe8\0h\xd4\xd4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0|\xe8\xe8\0x\xe4\xe4\0`\xcc\xcc\0H\xb4\xb4\0""D\xb0\xb0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0h\xd4\xd4\0|\xe8\xe8\0l\xd8\xd8\0""d\xd0\xd0\0""d\xd0\xd0\0l\xd8\xd8\0\\\xc8\xc8\0""D\xb0\xb0\0""D\xb0\xb0\0h\xd4\xd4\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0t\xe0\xe0\0l\xd8\xd8\0T\xc0\xc0\0<\xa8\xa8\0H\xb4\xb4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0""d\xd0\xd0\0p\xdc\xdc\0""d\xd0\xd0\0X\xc4\xc4\0X\xc4\xc4\0\\\xc8\xc8\0P\xbc\xbc\0<\xa8\xa8\0@\xac\xac\0h\xd4\xd4\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0\\\xc8\xc8\0<\xa8\xa8\0@\xac\xac\0\\\xc8\xc8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0\\\xc8\xc8\0<\xa8\xa8\0@\xac\xac\0h\xd4\xd4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0""d\xd0\xd0\0X\xc4\xc4\0L\xb8\xb8\0h\xd4\xd4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0""d\xd0\xd0\0""d\xd0\xd0\0h\xd4\xd4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0h\xd4\xd4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0H\xb4\xb4\0X\xc4\xc4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0`\xcc\xcc\0l\xd8\xd8\0`\xcc\xcc\0H\xb4\xb4\0T\xc0\xc0\0X\xc4\xc4\0`\xcc\xcc\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0H\xb4\xb4\0H\xb4\xb4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0h\xd4\xd4\0L\xb8\xb8\0""D\xb0\xb0\0H\xb4\xb4\0""d\xd0\xd0\0l\xd8\xd8\0l\xd8\xd8\0`\xcc\xcc\0`\xcc\xcc\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0""d\xd0\xd0\0""d\xd0\xd0\0h\xd4\xd4\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0X\xc4\xc4\0H\xb4\xb4\0X\xc4\xc4\0l\xd8\xd8\0t\xe0\xe0\0\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0t\xe0\xe0\0l\xd8\xd8\0p\xdc"
    "\xdc\0x\xe4\xe4\0""d\xd0\xd0\0T\xc0\xc0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0|\xe8\xe8\0|\xe8\xe8\0p\xdc\xdc\0l\xd8\xd8\0l\xd8\xd8\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0""D\xb0\xb0\0X\xc4\xc4\0l\xd8\xd8\0|\xe8\xe8\0\x84\xf0\xf0\0\xff\0\xff\0\xff\0\xff\0p\xdc\xdc\0p\xdc\xdc\0p\xdc\xdc\0p\xdc"
    "\xdc\0p\xdc\xdc\0h\xd4\xd4\0X\xc4\xc4\0H\xb4\xb4\0H\xb4\xb4\0H\xb4\xb4\0h\xd4\xd4\0|\xe8\xe8\0p\xdc\xdc\0X\xc4\xc4\0""d\xd0\xd0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0<\xa8\xa8\0""D\xb0\xb0\0l\xd8\xd8\0\x80\xec\xec\0\x84\xf0\xf0\0\xff\0\xff\0\xff\0\xff\0t\xe0\xe0\0p\xdc\xdc\0l\xd8\xd8\0`\xcc"
    "\xcc\0\\\xc8\xc8\0X\xc4\xc4\0H\xb4\xb4\0X\xc4\xc4\0X\xc4\xc4\0l\xd8\xd8\0t\xe0\xe0\0\\\xc8\xc8\0""D\xb0\xb0\0H\xb4\xb4\0`\xcc\xcc\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0""4\xa0\xa0\0<\xa8\xa8\0""d\xd0\xd0\0|\xe8\xe8\0|\xe8\xe8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0X\xc4\xc4\0\\\xc8\xc8\0""d\xd0\xd0\0\\\xc8\xc8\0l\xd8\xd8\0t\xe0\xe0\0h\xd4\xd4\0@\xac\xac\0""8\xa4\xa4\0X\xc4\xc4\0p\xdc\xdc\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0<\xa8\xa8\0@\xac\xac\0h\xd4\xd4\0|\xe8\xe8\0l\xd8\xd8\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0H\xb4\xb4\0""d\xd0\xd0\0""d\xd0\xd0\0\\\xc8\xc8\0""d\xd0\xd0\0t\xe0\xe0\0h\xd4\xd4\0@\xac\xac\0@\xac\xac\0""d\xd0\xd0\0p\xdc\xdc\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0P\xbc\xbc\0@\xac\xac\0X\xc4\xc4\0t\xe0\xe0\0""d\xd0\xd0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0X\xc4\xc4\0""D\xb0\xb0\0H\xb4\xb4\0h\xd4\xd4\0`\xcc\xcc\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0`\xcc\xcc\0L\xb8\xb8\0P\xbc\xbc\0X\xc4\xc4\0X\xc4\xc4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0l\xd8\xd8\0h\xd4\xd4\0X\xc4\xc4\0""D\xb0\xb0\0H\xb4\xb4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } invladder = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    invladder_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      invladder_lines + 0,
      invladder_lines + 128,
      invladder_lines + 256,
      invladder_lines + 384,
      invladder_lines + 512,
      invladder_lines + 640,
      invladder_lines + 768,
      invladder_lines + 896,
      invladder_lines + 1024,
      invladder_lines + 1152,
      invladder_lines + 1280,
      invladder_lines + 1408,
      invladder_lines + 1536,
      invladder_lines + 1664,
      invladder_lines + 1792,
      invladder_lines + 1920,
      invladder_lines + 2048,
      invladder_lines + 2176,
      invladder_lines + 2304,
      invladder_lines + 2432,
      invladder_lines + 2560,
      invladder_lines + 2688,
      invladder_lines + 2816,
      invladder_lines + 2944,
      invladder_lines + 3072,
      invladder_lines + 3200,
      invladder_lines + 3328,
      invladder_lines + 3456,
      invladder_lines + 3584,
      invladder_lines + 3712,
      invladder_lines + 3840,
      invladder_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chicken1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chicken1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "224", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chicken1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xe0\xe0t\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xec\xec\x80\0\xe8\xe8|\0\xd4\xd4h\0\xe0\xe0t\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xcc\xcc`\0\xcc\xcc`\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xf4\xf4\x88\0\xec\xec\x80\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xd4\xd4h\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xc0\xc0T\0\xcc\xcc`\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xb4\xb4H\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xe8\xe8|\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xcc\xcc`\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xd8\xd8l\0\xe8\xe8|\0\xd4\xd4h\0\xc0\xc0T\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chicken1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chicken1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chicken1_lines + 0,
      chicken1_lines + 128,
      chicken1_lines + 256,
      chicken1_lines + 384,
      chicken1_lines + 512,
      chicken1_lines + 640,
      chicken1_lines + 768,
      chicken1_lines + 896,
      chicken1_lines + 1024,
      chicken1_lines + 1152,
      chicken1_lines + 1280,
      chicken1_lines + 1408,
      chicken1_lines + 1536,
      chicken1_lines + 1664,
      chicken1_lines + 1792,
      chicken1_lines + 1920,
      chicken1_lines + 2048,
      chicken1_lines + 2176,
      chicken1_lines + 2304,
      chicken1_lines + 2432,
      chicken1_lines + 2560,
      chicken1_lines + 2688,
      chicken1_lines + 2816,
      chicken1_lines + 2944,
      chicken1_lines + 3072,
      chicken1_lines + 3200,
      chicken1_lines + 3328,
      chicken1_lines + 3456,
      chicken1_lines + 3584,
      chicken1_lines + 3712,
      chicken1_lines + 3840,
      chicken1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenleft0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenleft0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "256", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenleft0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xe0\xe0"
    "t\0\xc0\xc0T\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xe0\xe0t\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xd4\xd4"
    "h\0\xc4\xc4X\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xcc\xcc`\0\xcc\xcc`\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xec\xec\x80\0\xf4\xf4"
    "\x88\0\xec\xec\x80\0\xe8\xe8|\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4"
    "h\0\xec\xec\x80\0\xe8\xe8|\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xb4\xb4H\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xcc\xcc`\0\xc0\xc0T\0\xc0\xc0T\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xcc\xcc`\0\x1b\x1a""4\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0"
    "\xd4\xd4h\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0\xe8\xe8|\0\xd4\xd4h\0\xc4\xc4"
    "X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xc0\xc0T\0\xd4\xd4h\0"
    "\xe8\xe8|\0\xd8\xd8l\0\xd4\xd4h\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenleft0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenleft0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenleft0_lines + 0,
      chickenleft0_lines + 128,
      chickenleft0_lines + 256,
      chickenleft0_lines + 384,
      chickenleft0_lines + 512,
      chickenleft0_lines + 640,
      chickenleft0_lines + 768,
      chickenleft0_lines + 896,
      chickenleft0_lines + 1024,
      chickenleft0_lines + 1152,
      chickenleft0_lines + 1280,
      chickenleft0_lines + 1408,
      chickenleft0_lines + 1536,
      chickenleft0_lines + 1664,
      chickenleft0_lines + 1792,
      chickenleft0_lines + 1920,
      chickenleft0_lines + 2048,
      chickenleft0_lines + 2176,
      chickenleft0_lines + 2304,
      chickenleft0_lines + 2432,
      chickenleft0_lines + 2560,
      chickenleft0_lines + 2688,
      chickenleft0_lines + 2816,
      chickenleft0_lines + 2944,
      chickenleft0_lines + 3072,
      chickenleft0_lines + 3200,
      chickenleft0_lines + 3328,
      chickenleft0_lines + 3456,
      chickenleft0_lines + 3584,
      chickenleft0_lines + 3712,
      chickenleft0_lines + 3840,
      chickenleft0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenleft1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenleft1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "288", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenleft1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xe0\xe0"
    "t\0\xc0\xc0T\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xe0\xe0t\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xd4\xd4"
    "h\0\xc4\xc4X\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xcc\xcc`\0\xcc\xcc`\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xec\xec\x80\0\xf4\xf4"
    "\x88\0\xec\xec\x80\0\xe8\xe8|\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xfc\xfc\x90\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\x94\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xb0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xb0\0"
    "\xff\xff\xb4\0\xf4\xf4\x88\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff"
    "\xa0\0\xff\xff\x94\0\xff\xff\x9c\0\xff\xff\xb4\0\xff\xff\xb0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xe8\xe8|\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenleft1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenleft1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenleft1_lines + 0,
      chickenleft1_lines + 128,
      chickenleft1_lines + 256,
      chickenleft1_lines + 384,
      chickenleft1_lines + 512,
      chickenleft1_lines + 640,
      chickenleft1_lines + 768,
      chickenleft1_lines + 896,
      chickenleft1_lines + 1024,
      chickenleft1_lines + 1152,
      chickenleft1_lines + 1280,
      chickenleft1_lines + 1408,
      chickenleft1_lines + 1536,
      chickenleft1_lines + 1664,
      chickenleft1_lines + 1792,
      chickenleft1_lines + 1920,
      chickenleft1_lines + 2048,
      chickenleft1_lines + 2176,
      chickenleft1_lines + 2304,
      chickenleft1_lines + 2432,
      chickenleft1_lines + 2560,
      chickenleft1_lines + 2688,
      chickenleft1_lines + 2816,
      chickenleft1_lines + 2944,
      chickenleft1_lines + 3072,
      chickenleft1_lines + 3200,
      chickenleft1_lines + 3328,
      chickenleft1_lines + 3456,
      chickenleft1_lines + 3584,
      chickenleft1_lines + 3712,
      chickenleft1_lines + 3840,
      chickenleft1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenright0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenright0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "320", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenright0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xe0\xe0t\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xec\xec\x80\0\xe8\xe8|\0\xd4\xd4h\0\xe0\xe0t\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xcc\xcc`\0\xcc\xcc`\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xf4\xf4\x88\0\xec\xec\x80\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xd4\xd4h\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xc0\xc0T\0\xcc\xcc`\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xb4\xb4H\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xe8\xe8|\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xcc\xcc`\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xd8\xd8l\0\xe8\xe8|\0\xd4\xd4h\0\xc0\xc0T\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenright0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenright0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenright0_lines + 0,
      chickenright0_lines + 128,
      chickenright0_lines + 256,
      chickenright0_lines + 384,
      chickenright0_lines + 512,
      chickenright0_lines + 640,
      chickenright0_lines + 768,
      chickenright0_lines + 896,
      chickenright0_lines + 1024,
      chickenright0_lines + 1152,
      chickenright0_lines + 1280,
      chickenright0_lines + 1408,
      chickenright0_lines + 1536,
      chickenright0_lines + 1664,
      chickenright0_lines + 1792,
      chickenright0_lines + 1920,
      chickenright0_lines + 2048,
      chickenright0_lines + 2176,
      chickenright0_lines + 2304,
      chickenright0_lines + 2432,
      chickenright0_lines + 2560,
      chickenright0_lines + 2688,
      chickenright0_lines + 2816,
      chickenright0_lines + 2944,
      chickenright0_lines + 3072,
      chickenright0_lines + 3200,
      chickenright0_lines + 3328,
      chickenright0_lines + 3456,
      chickenright0_lines + 3584,
      chickenright0_lines + 3712,
      chickenright0_lines + 3840,
      chickenright0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenright1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenright1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "352", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenright1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xe0\xe0t\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xec\xec\x80\0\xe8\xe8|\0\xd4\xd4h\0\xe0\xe0t\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xcc\xcc`\0\xcc\xcc`\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xf4\xf4\x88\0\xec\xec\x80\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xfc\xfc\x90\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\x94\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\xf4\xf4\x88\0\xff\xff\xb4\0\xff\xff\xb0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\x94\0\xff\xff\xb0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xe8\xe8|\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xff\xff\x94\0\xff\xff\xb0\0\xff\xff\xb4\0\xff\xff\x9c\0\xff\xff\x94\0\xff\xff\xa0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenright1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenright1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenright1_lines + 0,
      chickenright1_lines + 128,
      chickenright1_lines + 256,
      chickenright1_lines + 384,
      chickenright1_lines + 512,
      chickenright1_lines + 640,
      chickenright1_lines + 768,
      chickenright1_lines + 896,
      chickenright1_lines + 1024,
      chickenright1_lines + 1152,
      chickenright1_lines + 1280,
      chickenright1_lines + 1408,
      chickenright1_lines + 1536,
      chickenright1_lines + 1664,
      chickenright1_lines + 1792,
      chickenright1_lines + 1920,
      chickenright1_lines + 2048,
      chickenright1_lines + 2176,
      chickenright1_lines + 2304,
      chickenright1_lines + 2432,
      chickenright1_lines + 2560,
      chickenright1_lines + 2688,
      chickenright1_lines + 2816,
      chickenright1_lines + 2944,
      chickenright1_lines + 3072,
      chickenright1_lines + 3200,
      chickenright1_lines + 3328,
      chickenright1_lines + 3456,
      chickenright1_lines + 3584,
      chickenright1_lines + 3712,
      chickenright1_lines + 3840,
      chickenright1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenclimb0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenclimb0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "384", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenclimb0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xd8\xd8l\0\xe8\xe8|\0\xd4\xd4h\0\xc0\xc0T\0\xc4\xc4"
    "X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenclimb0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenclimb0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenclimb0_lines + 0,
      chickenclimb0_lines + 128,
      chickenclimb0_lines + 256,
      chickenclimb0_lines + 384,
      chickenclimb0_lines + 512,
      chickenclimb0_lines + 640,
      chickenclimb0_lines + 768,
      chickenclimb0_lines + 896,
      chickenclimb0_lines + 1024,
      chickenclimb0_lines + 1152,
      chickenclimb0_lines + 1280,
      chickenclimb0_lines + 1408,
      chickenclimb0_lines + 1536,
      chickenclimb0_lines + 1664,
      chickenclimb0_lines + 1792,
      chickenclimb0_lines + 1920,
      chickenclimb0_lines + 2048,
      chickenclimb0_lines + 2176,
      chickenclimb0_lines + 2304,
      chickenclimb0_lines + 2432,
      chickenclimb0_lines + 2560,
      chickenclimb0_lines + 2688,
      chickenclimb0_lines + 2816,
      chickenclimb0_lines + 2944,
      chickenclimb0_lines + 3072,
      chickenclimb0_lines + 3200,
      chickenclimb0_lines + 3328,
      chickenclimb0_lines + 3456,
      chickenclimb0_lines + 3584,
      chickenclimb0_lines + 3712,
      chickenclimb0_lines + 3840,
      chickenclimb0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenclimb1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenclimb1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "416", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenclimb1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x1b\x1a""4\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xd8\xd8l\0\xe8\xe8|\0\xd4\xd4h\0\xc0\xc0T\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenclimb1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenclimb1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenclimb1_lines + 0,
      chickenclimb1_lines + 128,
      chickenclimb1_lines + 256,
      chickenclimb1_lines + 384,
      chickenclimb1_lines + 512,
      chickenclimb1_lines + 640,
      chickenclimb1_lines + 768,
      chickenclimb1_lines + 896,
      chickenclimb1_lines + 1024,
      chickenclimb1_lines + 1152,
      chickenclimb1_lines + 1280,
      chickenclimb1_lines + 1408,
      chickenclimb1_lines + 1536,
      chickenclimb1_lines + 1664,
      chickenclimb1_lines + 1792,
      chickenclimb1_lines + 1920,
      chickenclimb1_lines + 2048,
      chickenclimb1_lines + 2176,
      chickenclimb1_lines + 2304,
      chickenclimb1_lines + 2432,
      chickenclimb1_lines + 2560,
      chickenclimb1_lines + 2688,
      chickenclimb1_lines + 2816,
      chickenclimb1_lines + 2944,
      chickenclimb1_lines + 3072,
      chickenclimb1_lines + 3200,
      chickenclimb1_lines + 3328,
      chickenclimb1_lines + 3456,
      chickenclimb1_lines + 3584,
      chickenclimb1_lines + 3712,
      chickenclimb1_lines + 3840,
      chickenclimb1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenropeleft0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenropeleft0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "448", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenropeleft0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff"
    "\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff"
    "\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xe0\xe0t\0\xd4\xd4h\0\xe8\xe8|\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0"
    "\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xcc\xcc`\0\xcc\xcc`\0\x1b\x1a""4\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4"
    "h\0\xec\xec\x80\0\xe8\xe8|\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xb4\xb4H\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xcc\xcc`\0\xc0\xc0T\0\xc0\xc0T\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xcc\xcc`\0\x1b\x1a""4\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0"
    "\xd4\xd4h\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0\xe8\xe8|\0\xd4\xd4h\0\xc4\xc4"
    "X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xc0\xc0T\0\xd4\xd4h\0"
    "\xe8\xe8|\0\xd8\xd8l\0\xd4\xd4h\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenropeleft0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenropeleft0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenropeleft0_lines + 0,
      chickenropeleft0_lines + 128,
      chickenropeleft0_lines + 256,
      chickenropeleft0_lines + 384,
      chickenropeleft0_lines + 512,
      chickenropeleft0_lines + 640,
      chickenropeleft0_lines + 768,
      chickenropeleft0_lines + 896,
      chickenropeleft0_lines + 1024,
      chickenropeleft0_lines + 1152,
      chickenropeleft0_lines + 1280,
      chickenropeleft0_lines + 1408,
      chickenropeleft0_lines + 1536,
      chickenropeleft0_lines + 1664,
      chickenropeleft0_lines + 1792,
      chickenropeleft0_lines + 1920,
      chickenropeleft0_lines + 2048,
      chickenropeleft0_lines + 2176,
      chickenropeleft0_lines + 2304,
      chickenropeleft0_lines + 2432,
      chickenropeleft0_lines + 2560,
      chickenropeleft0_lines + 2688,
      chickenropeleft0_lines + 2816,
      chickenropeleft0_lines + 2944,
      chickenropeleft0_lines + 3072,
      chickenropeleft0_lines + 3200,
      chickenropeleft0_lines + 3328,
      chickenropeleft0_lines + 3456,
      chickenropeleft0_lines + 3584,
      chickenropeleft0_lines + 3712,
      chickenropeleft0_lines + 3840,
      chickenropeleft0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenropeleft1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenropeleft1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "480", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenropeleft1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0"
    "\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xe0\xe0"
    "t\0\xc0\xc0T\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xe0\xe0t\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xd4\xd4"
    "h\0\xc4\xc4X\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xcc\xcc`\0\xcc\xcc`\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xec\xec\x80\0\xf4\xf4"
    "\x88\0\xec\xec\x80\0\xe8\xe8|\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0"
    "\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0"
    "\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xfc\xfc\x90\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\x94\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xb0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xb0\0"
    "\xff\xff\xb4\0\xf4\xf4\x88\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff"
    "\xa0\0\xff\xff\x94\0\xff\xff\x9c\0\xff\xff\xb4\0\xff\xff\xb0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xe8\xe8|\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenropeleft1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenropeleft1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenropeleft1_lines + 0,
      chickenropeleft1_lines + 128,
      chickenropeleft1_lines + 256,
      chickenropeleft1_lines + 384,
      chickenropeleft1_lines + 512,
      chickenropeleft1_lines + 640,
      chickenropeleft1_lines + 768,
      chickenropeleft1_lines + 896,
      chickenropeleft1_lines + 1024,
      chickenropeleft1_lines + 1152,
      chickenropeleft1_lines + 1280,
      chickenropeleft1_lines + 1408,
      chickenropeleft1_lines + 1536,
      chickenropeleft1_lines + 1664,
      chickenropeleft1_lines + 1792,
      chickenropeleft1_lines + 1920,
      chickenropeleft1_lines + 2048,
      chickenropeleft1_lines + 2176,
      chickenropeleft1_lines + 2304,
      chickenropeleft1_lines + 2432,
      chickenropeleft1_lines + 2560,
      chickenropeleft1_lines + 2688,
      chickenropeleft1_lines + 2816,
      chickenropeleft1_lines + 2944,
      chickenropeleft1_lines + 3072,
      chickenropeleft1_lines + 3200,
      chickenropeleft1_lines + 3328,
      chickenropeleft1_lines + 3456,
      chickenropeleft1_lines + 3584,
      chickenropeleft1_lines + 3712,
      chickenropeleft1_lines + 3840,
      chickenropeleft1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenroperight0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenroperight0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "512", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenroperight0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xd4\xd4h\0\xe0\xe0t\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\xcc\xcc`\0\xcc\xcc`\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff"
    "\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff"
    "\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xd4\xd4h\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xc0\xc0T\0\xcc\xcc`\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xb4\xb4H\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xe8\xe8|\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xcc\xcc`\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xd4\xd4h\0\xd8\xd8l\0\xe8\xe8|\0\xd4\xd4h\0\xc0\xc0T\0\xc4\xc4X\0\x1b\x1a""4\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xe8\xe8|\0\xec\xec\x80\0\xec\xec\x80\0\xec\xec\x80\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenroperight0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenroperight0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenroperight0_lines + 0,
      chickenroperight0_lines + 128,
      chickenroperight0_lines + 256,
      chickenroperight0_lines + 384,
      chickenroperight0_lines + 512,
      chickenroperight0_lines + 640,
      chickenroperight0_lines + 768,
      chickenroperight0_lines + 896,
      chickenroperight0_lines + 1024,
      chickenroperight0_lines + 1152,
      chickenroperight0_lines + 1280,
      chickenroperight0_lines + 1408,
      chickenroperight0_lines + 1536,
      chickenroperight0_lines + 1664,
      chickenroperight0_lines + 1792,
      chickenroperight0_lines + 1920,
      chickenroperight0_lines + 2048,
      chickenroperight0_lines + 2176,
      chickenroperight0_lines + 2304,
      chickenroperight0_lines + 2432,
      chickenroperight0_lines + 2560,
      chickenroperight0_lines + 2688,
      chickenroperight0_lines + 2816,
      chickenroperight0_lines + 2944,
      chickenroperight0_lines + 3072,
      chickenroperight0_lines + 3200,
      chickenroperight0_lines + 3328,
      chickenroperight0_lines + 3456,
      chickenroperight0_lines + 3584,
      chickenroperight0_lines + 3712,
      chickenroperight0_lines + 3840,
      chickenroperight0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY chickenroperight1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "chickenroperight1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "544", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char chickenroperight1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc0\xc0T\0\xe0\xe0t\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xc4\xc4X\0\xd4\xd4h\0\xec\xec\x80\0\xe8\xe8|\0\xd4\xd4h\0\xe0\xe0t\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xcc\xcc`\0\xcc\xcc`\0\xe8\xe8|\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xe8\xe8|\0\xec\xec\x80\0\xf4\xf4\x88\0\xec\xec\x80\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0"
    "\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0"
    "\0\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0"
    "\0\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff\xff\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\0\0\0\0\xff\xff"
    "\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\xff"
    "\xff\0\xff\xff\xff\0\xff\xff\xff\0\x1b\x1a""4\0\x1b\x1a""4\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xfc\xfc\x90\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a"
    "4\0\x1b\x1a""4\0\x1b\x1a""4\0\x1b\x1a""4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\xff\x94\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\x94\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xec\xec\x80\0\0\0\0\0\xf4\xf4\x88\0\xff\xff\xb4\0\xff\xff\xb0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xff\xff\x94\0\xff\xff\xb0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xf4\xf4\x88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xe8\xe8|\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xff\xff\x94\0\xff\xff\xb0\0\xff\xff\xb4\0\xff\xff\x9c\0\xff\xff\x94\0\xff\xff\xa0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } chickenroperight1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    chickenroperight1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      chickenroperight1_lines + 0,
      chickenroperight1_lines + 128,
      chickenroperight1_lines + 256,
      chickenroperight1_lines + 384,
      chickenroperight1_lines + 512,
      chickenroperight1_lines + 640,
      chickenroperight1_lines + 768,
      chickenroperight1_lines + 896,
      chickenroperight1_lines + 1024,
      chickenroperight1_lines + 1152,
      chickenroperight1_lines + 1280,
      chickenroperight1_lines + 1408,
      chickenroperight1_lines + 1536,
      chickenroperight1_lines + 1664,
      chickenroperight1_lines + 1792,
      chickenroperight1_lines + 1920,
      chickenroperight1_lines + 2048,
      chickenroperight1_lines + 2176,
      chickenroperight1_lines + 2304,
      chickenroperight1_lines + 2432,
      chickenroperight1_lines + 2560,
      chickenroperight1_lines + 2688,
      chickenroperight1_lines + 2816,
      chickenroperight1_lines + 2944,
      chickenroperight1_lines + 3072,
      chickenroperight1_lines + 3200,
      chickenroperight1_lines + 3328,
      chickenroperight1_lines + 3456,
      chickenroperight1_lines + 3584,
      chickenroperight1_lines + 3712,
      chickenroperight1_lines + 3840,
      chickenroperight1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbit1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbit1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "576", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbit1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb4lH\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xb4lH\0\xb8pL\0\xb8pL\0\xb8pL\0\xb4lH\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa4\\8\0\0\0\0\0\xcc\x84`\0\xd4\x8ch\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x8c""D \0\x90H$\0\xb8pL\0\xd4\x8ch\0\xc4|X\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\x8c""D \0\x8c""D \0\0\0\0\0\0\0\0\0\xc4|X\0\xd8\x90l\0\xd4\x8ch\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0\xa0X4\0\0\0\0\0\xe8\xc4\xe8\0\xfc\xd8\xfc\0\0\0\0\0\xcc\x84`\0\xc0xT\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0\xac""d@\0\0\0\0\0\0\0\0\0\x98P,\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xc0xT\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xe0\x98t\0\xd8\x90l\0\xb4lH\0\xa4\\8\0\xa4\\8\0\xac""d@\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xac""d@\0\xa0X4\0\x98P"
    ",\0\xac""d@\0\0\0\0\0\xac""d@\0\xa0X4\0\0\0\0\0\xa4\\8\0\xa0X4\0\x90H$\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xb8pL\0\xb8pL\0\xa0X4\0\0\0\0\0\xac""d@\0\xb4lH\0\xa4\\8\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\xb4lH\0\0\0\0\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x98P,\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x8c""D \0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\0$\0\0\0H\0\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xb4lH\0\xb4lH\0\xac""d@\0\xa4\\8\0\xa4\\"
    "8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xb8pL\0\xb4lH\0\xc0xT\0"
    "\xcc\x84`\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbit1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbit1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbit1_lines + 0,
      rabbit1_lines + 128,
      rabbit1_lines + 256,
      rabbit1_lines + 384,
      rabbit1_lines + 512,
      rabbit1_lines + 640,
      rabbit1_lines + 768,
      rabbit1_lines + 896,
      rabbit1_lines + 1024,
      rabbit1_lines + 1152,
      rabbit1_lines + 1280,
      rabbit1_lines + 1408,
      rabbit1_lines + 1536,
      rabbit1_lines + 1664,
      rabbit1_lines + 1792,
      rabbit1_lines + 1920,
      rabbit1_lines + 2048,
      rabbit1_lines + 2176,
      rabbit1_lines + 2304,
      rabbit1_lines + 2432,
      rabbit1_lines + 2560,
      rabbit1_lines + 2688,
      rabbit1_lines + 2816,
      rabbit1_lines + 2944,
      rabbit1_lines + 3072,
      rabbit1_lines + 3200,
      rabbit1_lines + 3328,
      rabbit1_lines + 3456,
      rabbit1_lines + 3584,
      rabbit1_lines + 3712,
      rabbit1_lines + 3840,
      rabbit1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitleft0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitleft0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "608", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitleft0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0|4\x10\0\x98P,\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0l$\0\0p(\x4\0"
    "x0\f\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0x0\f\0\x84<\x18\0\0\0\0\0\0\0\0\0\xb4lH\0\xa0X4\0\xac""d@\0\xac""d@\0\xa4\\8\0\0\0\0\0|4\x10\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0x0\f\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\xac""d@\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x98P,\0\xa4\\8\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\xac""d@\0\xa4\\8\0\x84<\x18\0x0\f\0|4\x10\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x98P,\0\xa0X4\0\xa0X4\0\x98P,\0|4\x10\0x0\f\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\x98P,\0\0\0\0\0\0\0\0\0\x98P,\0\x98P,\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0\x80""A!\0\0\0\0\0p(\x4\0\x84<\x18\0\xa0X4\0\xa4\\8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0{:\x1a\0l$\0\0p(\x4\0\x84<\x18\0\xa4\\8\0\xb4lH\0\xac""d@\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0|4\x10\0l$\0\0x0\f\0\x98P,\0\xac""d@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0\xa0X4\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0|4\x10\0x0\f\0x0\f\0|4\x10\0|4\x10\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa0X4\0\xb8pL\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x8c""D \0\xa0X4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x84<\x18\0\x90H$\0\xa0X"
    "4\0\xa4\\8\0\0\0\0\0\xa0X4\0\xac""d@\0\0\0\0\0\xac""d@\0\x98P,\0\xa0X4\0\xac""d@\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\xa4\\8\0\xb4l"
    "H\0\xac""d@\0\0\0\0\0\xa0X4\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xb4lH\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x98P,\0\xa0X4\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\x8c""D \0\x98P,\0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xa0X4\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x84<\x18\0\xac""d@\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x8c""D \0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0@\xac@\0,\x98,\0\0H\0\0\0$\0\0\0\\\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0P"
    "\0\0""8\xa4""8\0$\x90$\0\0\x14\0\0\0\0\0\0\0\\\0\0H\xb4H\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\x14\0\0\0\b\0\0\0\x1c"
    "\0\0\0P\0\0\0""0\0\0\0\0\0\0\0\0\0\0\0""D\0\0""8\xa4""8\0\0""d\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0""0\0\0\0(\0\0\0\x1c"
    "\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0,\x98,\0\0H\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0""4"
    "\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0\0\0\0\0(\0\0\0X\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|4\x10\0\x80""8\x14\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0|4\x10\0l$\0\0l$\0\0\x80""8\x14\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xcc\x84`\0\xc0xT\0\x90H$\0\x88@\x1c\0\x88@\x1c\0\x90H$\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x80""8\x14\0\x88@\x1c\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitleft0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitleft0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitleft0_lines + 0,
      rabbitleft0_lines + 128,
      rabbitleft0_lines + 256,
      rabbitleft0_lines + 384,
      rabbitleft0_lines + 512,
      rabbitleft0_lines + 640,
      rabbitleft0_lines + 768,
      rabbitleft0_lines + 896,
      rabbitleft0_lines + 1024,
      rabbitleft0_lines + 1152,
      rabbitleft0_lines + 1280,
      rabbitleft0_lines + 1408,
      rabbitleft0_lines + 1536,
      rabbitleft0_lines + 1664,
      rabbitleft0_lines + 1792,
      rabbitleft0_lines + 1920,
      rabbitleft0_lines + 2048,
      rabbitleft0_lines + 2176,
      rabbitleft0_lines + 2304,
      rabbitleft0_lines + 2432,
      rabbitleft0_lines + 2560,
      rabbitleft0_lines + 2688,
      rabbitleft0_lines + 2816,
      rabbitleft0_lines + 2944,
      rabbitleft0_lines + 3072,
      rabbitleft0_lines + 3200,
      rabbitleft0_lines + 3328,
      rabbitleft0_lines + 3456,
      rabbitleft0_lines + 3584,
      rabbitleft0_lines + 3712,
      rabbitleft0_lines + 3840,
      rabbitleft0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitleft1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitleft1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "640", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitleft1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0|4\x10\0\x98P,\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0l$\0\0p(\x4\0"
    "x0\f\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0x0\f\0\x84<\x18\0\0\0\0\0\0\0\0\0\xb4lH\0\xa0X4\0\xac""d@\0\xac""d@\0\xa4\\8\0\0\0\0\0|4\x10\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0x0\f\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\xac""d@\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x98P,\0\xa4\\8\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\xac""d@\0\xa4\\8\0\x84<\x18\0x0\f\0|4\x10\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x98P,\0\xa0X4\0\xa0X4\0\x98P,\0|4\x10\0x0\f\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\x98P,\0\0\0\0\0\0\0\0\0\x98P,\0\x98P,\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0\x80""A!\0\0\0\0\0p(\x4\0\x84<\x18\0\xa0X4\0\xa4\\8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0{:\x1a\0l$\0\0p(\x4\0\x84<\x18\0\xa4\\8\0\xb4lH\0\xac""d@\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0|4\x10\0l$\0\0x0\f\0\x98P,\0\xac""d@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0\xa0X4\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0|4\x10\0x0\f\0x0\f\0|4\x10\0|4\x10\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa0X4\0\xb8pL\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x8c""D \0\xa0X4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x84<\x18\0\x90H$\0\xa0X"
    "4\0\xa4\\8\0\0\0\0\0\xa0X4\0\xac""d@\0\0\0\0\0\xac""d@\0\x98P,\0\xa0X4\0\xac""d@\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\xa4\\8\0\xb4l"
    "H\0\xac""d@\0\0\0\0\0\xa0X4\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xb4lH\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x98P,\0\xa0X4\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\x8c""D \0\x98P,\0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xa0X4\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x84<\x18\0\xac""d@\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x8c""D \0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0@\xac@\0,\x98,\0\0H\0\0\0$\0\0\0\\\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x9cT0\0\x94L(\0\xa0X4\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0P"
    "\0\0""8\xa4""8\0$\x90$\0\0\x14\0\0\0\0\0\0\0\\\0\0H\xb4H\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x92I$\0\x92I$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\b\0\0\0\x1c"
    "\0\0\0P\0\0\0""0\0\0\0\0\0\0\0\0\0\0\0""D\0\0""8\xa4""8\0\0""d\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\0\0\0\0|4\x10\0\0\0\0\0\0""0\0\0\0(\0\0\0\x1c"
    "\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0,\x98,\0\0H\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xc4|X\0\0\0\0\0`\x18\0\0t,\b\0\0\0\0\0\0\0\0\0\0\0\0\0\0""4"
    "\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0\0\0\0\0(\0\0\0X\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xd0\x88""d\0\0\0\0\0l$\0\0t,\b\0\x88@\x1c\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xd0\x88""d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xa8`<\0\x80""8\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x94L(\0t,\b\0\x80""8\x14\0\x90H$\0\x92I$\0\x92I$\0\xb0hD\0\xc4|X\0\xc4|X\0\xb0hD\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitleft1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitleft1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitleft1_lines + 0,
      rabbitleft1_lines + 128,
      rabbitleft1_lines + 256,
      rabbitleft1_lines + 384,
      rabbitleft1_lines + 512,
      rabbitleft1_lines + 640,
      rabbitleft1_lines + 768,
      rabbitleft1_lines + 896,
      rabbitleft1_lines + 1024,
      rabbitleft1_lines + 1152,
      rabbitleft1_lines + 1280,
      rabbitleft1_lines + 1408,
      rabbitleft1_lines + 1536,
      rabbitleft1_lines + 1664,
      rabbitleft1_lines + 1792,
      rabbitleft1_lines + 1920,
      rabbitleft1_lines + 2048,
      rabbitleft1_lines + 2176,
      rabbitleft1_lines + 2304,
      rabbitleft1_lines + 2432,
      rabbitleft1_lines + 2560,
      rabbitleft1_lines + 2688,
      rabbitleft1_lines + 2816,
      rabbitleft1_lines + 2944,
      rabbitleft1_lines + 3072,
      rabbitleft1_lines + 3200,
      rabbitleft1_lines + 3328,
      rabbitleft1_lines + 3456,
      rabbitleft1_lines + 3584,
      rabbitleft1_lines + 3712,
      rabbitleft1_lines + 3840,
      rabbitleft1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitright0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitright0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "672", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitright0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0x0\f\0p(\x4\0l$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xac""d@\0\x98P,\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0|4\x10\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\0\0\0\0\x84<\x18\0x0\f\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\0\0\0\0\0\0\0\0x0\f\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0|4\x10\0x0\f\0\x84<\x18\0\xa4\\8\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0x0\f\0|4\x10\0\x98P,\0\xa0X4\0\xa0X4\0\x98P,\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x84<\x18\0\x98P,\0\x98P,\0\0\0\0\0\0\0\0\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\xa4\\8\0\xa0X4\0\x84<\x18\0p(\x4\0\0\0\0\0\x80""A!\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0\xb4lH\0\xa4\\8\0\x84<\x18\0p(\x4\0l$\0\0{:\x1a\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xb4lH\0\xac""d@\0\x98P,\0x0\f\0l$\0\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0\xa0X4\0\x90H$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0|4\x10\0|4\x10\0x0\f\0x0\f\0|4\x10\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xac""d@\0\xa0X4\0\x98P"
    ",\0\xac""d@\0\0\0\0\0\xac""d@\0\xa0X4\0\0\0\0\0\xa4\\8\0\xa0X4\0\x90H$\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xb8pL\0\xb8pL\0\xa0X4\0\0\0\0\0\xac""d@\0\xb4lH\0\xa4\\8\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\xb4lH\0\0\0\0\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x98P,\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x8c""D \0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\0$\0\0\0H\0\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x80""8\x14\0|4\x10\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x80""8\x14\0l$\0\0l$\0\0|4\x10\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x88@\x1c\0\x80""8\x14\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\x88@\x1c\0\x88@\x1c\0\x90H$\0\xc0xT\0"
    "\xcc\x84`\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitright0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitright0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitright0_lines + 0,
      rabbitright0_lines + 128,
      rabbitright0_lines + 256,
      rabbitright0_lines + 384,
      rabbitright0_lines + 512,
      rabbitright0_lines + 640,
      rabbitright0_lines + 768,
      rabbitright0_lines + 896,
      rabbitright0_lines + 1024,
      rabbitright0_lines + 1152,
      rabbitright0_lines + 1280,
      rabbitright0_lines + 1408,
      rabbitright0_lines + 1536,
      rabbitright0_lines + 1664,
      rabbitright0_lines + 1792,
      rabbitright0_lines + 1920,
      rabbitright0_lines + 2048,
      rabbitright0_lines + 2176,
      rabbitright0_lines + 2304,
      rabbitright0_lines + 2432,
      rabbitright0_lines + 2560,
      rabbitright0_lines + 2688,
      rabbitright0_lines + 2816,
      rabbitright0_lines + 2944,
      rabbitright0_lines + 3072,
      rabbitright0_lines + 3200,
      rabbitright0_lines + 3328,
      rabbitright0_lines + 3456,
      rabbitright0_lines + 3584,
      rabbitright0_lines + 3712,
      rabbitright0_lines + 3840,
      rabbitright0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitright1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitright1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "704", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitright1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0x0\f\0p(\x4\0l$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xac""d@\0\x98P,\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0|4\x10\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\0\0\0\0\x84<\x18\0x0\f\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\0\0\0\0\0\0\0\0x0\f\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0|4\x10\0x0\f\0\x84<\x18\0\xa4\\8\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0x0\f\0|4\x10\0\x98P,\0\xa0X4\0\xa0X4\0\x98P,\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x84<\x18\0\x98P,\0\x98P,\0\0\0\0\0\0\0\0\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\xa4\\8\0\xa0X4\0\x84<\x18\0p(\x4\0\0\0\0\0\x80""A!\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0\xb4lH\0\xa4\\8\0\x84<\x18\0p(\x4\0l$\0\0{:\x1a\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xb4lH\0\xac""d@\0\x98P,\0x0\f\0l$\0\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0\xa0X4\0\x90H$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0|4\x10\0|4\x10\0x0\f\0x0\f\0|4\x10\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xac""d@\0\xa0X4\0\x98P"
    ",\0\xac""d@\0\0\0\0\0\xac""d@\0\xa0X4\0\0\0\0\0\xa4\\8\0\xa0X4\0\x90H$\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xb8pL\0\xb8pL\0\xa0X4\0\0\0\0\0\xac""d@\0\xb4lH\0\xa4\\8\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\xb4lH\0\0\0\0\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x98P,\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x8c""D \0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\0$\0\0\0H\0\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa0X4\0"
    "\x94L(\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\x92I$\0\x92I$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0|4\x10\0\0\0\0\0"
    "\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0t,\b\0`\x18\0\0"
    "\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x88@\x1c\0t,\b\0l$\0\0"
    "\0\0\0\0\xd0\x88""d\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80""8\x14\0\xa8`<\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\xd0\x88""d\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb0hD\0\xc4|X\0\xc4|X\0\xb0hD\0\x92I$\0\x92I"
    "$\0\x90H$\0\x80""8\x14\0t,\b\0\x94L(\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitright1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitright1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitright1_lines + 0,
      rabbitright1_lines + 128,
      rabbitright1_lines + 256,
      rabbitright1_lines + 384,
      rabbitright1_lines + 512,
      rabbitright1_lines + 640,
      rabbitright1_lines + 768,
      rabbitright1_lines + 896,
      rabbitright1_lines + 1024,
      rabbitright1_lines + 1152,
      rabbitright1_lines + 1280,
      rabbitright1_lines + 1408,
      rabbitright1_lines + 1536,
      rabbitright1_lines + 1664,
      rabbitright1_lines + 1792,
      rabbitright1_lines + 1920,
      rabbitright1_lines + 2048,
      rabbitright1_lines + 2176,
      rabbitright1_lines + 2304,
      rabbitright1_lines + 2432,
      rabbitright1_lines + 2560,
      rabbitright1_lines + 2688,
      rabbitright1_lines + 2816,
      rabbitright1_lines + 2944,
      rabbitright1_lines + 3072,
      rabbitright1_lines + 3200,
      rabbitright1_lines + 3328,
      rabbitright1_lines + 3456,
      rabbitright1_lines + 3584,
      rabbitright1_lines + 3712,
      rabbitright1_lines + 3840,
      rabbitright1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitclimb0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitclimb0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "736", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitclimb0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb4lH\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\x9cT0\0\xb0hD\0\xa8`<\0\x90H$\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0\0\0\0\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x94L(\0\x94L(\0\x9cT0\0\xa0X4\0\xa0X4\0\x94L(\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x9cT0\0\x90H$\0\x88@\x1c\0\xa8`<\0\xa8`<\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\x80""8\x14\0\x88@\x1c\0\x94L(\0\xb0hD\0\x9cT0\0|4\x10\0\xd4\x8ch\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0|4\x10\0|4\x10\0\x94L(\0\xa8`<\0\x90H$\0t,\b\0\xc0xT\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x80""8\x14\0\x90H$\0\x9cT0\0\xa0X4\0\x94L(\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x88@\x1c\0\x90H$\0\xa0X4\0\xa8`<\0\x94L(\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x88@\x1c\0|4\x10\0\x90H$\0\x9cT0\0\x9cT0\0\x9cT0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80""8\x14\0|4\x10\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xac""d@\0\xa0X4\0\x98P"
    ",\0\xac""d@\0\0\0\0\0\xac""d@\0\xa0X4\0\0\0\0\0\xa4\\8\0\xa8`<\0\x94L(\0\x80""8\x14\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xb8pL\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\xb4lH\0\0\0\0\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x98P,\0\x8c""D \0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xff\xff\xff\0\xff\xff\xff\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\xff\xff\xff\0\xff\xff\xff\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xb4lH\0\xb4lH\0\xac""d@\0\xa4\\8\0\xa4\\"
    "8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xb8pL\0\xb4lH\0\xc0xT\0"
    "\xcc\x84`\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitclimb0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitclimb0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitclimb0_lines + 0,
      rabbitclimb0_lines + 128,
      rabbitclimb0_lines + 256,
      rabbitclimb0_lines + 384,
      rabbitclimb0_lines + 512,
      rabbitclimb0_lines + 640,
      rabbitclimb0_lines + 768,
      rabbitclimb0_lines + 896,
      rabbitclimb0_lines + 1024,
      rabbitclimb0_lines + 1152,
      rabbitclimb0_lines + 1280,
      rabbitclimb0_lines + 1408,
      rabbitclimb0_lines + 1536,
      rabbitclimb0_lines + 1664,
      rabbitclimb0_lines + 1792,
      rabbitclimb0_lines + 1920,
      rabbitclimb0_lines + 2048,
      rabbitclimb0_lines + 2176,
      rabbitclimb0_lines + 2304,
      rabbitclimb0_lines + 2432,
      rabbitclimb0_lines + 2560,
      rabbitclimb0_lines + 2688,
      rabbitclimb0_lines + 2816,
      rabbitclimb0_lines + 2944,
      rabbitclimb0_lines + 3072,
      rabbitclimb0_lines + 3200,
      rabbitclimb0_lines + 3328,
      rabbitclimb0_lines + 3456,
      rabbitclimb0_lines + 3584,
      rabbitclimb0_lines + 3712,
      rabbitclimb0_lines + 3840,
      rabbitclimb0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitclimb1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitclimb1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "768", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitclimb1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb4lH\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\x9cT0\0\xb0hD\0\xa8`<\0\x90H$\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0\0\0\0\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x94L(\0\x94L(\0\x9cT0\0\xa0X4\0\xa0X4\0\x94L(\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x9cT0\0\x90H$\0\x88@\x1c\0\xa8`<\0\xa8`<\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\x80""8\x14\0\x88@\x1c\0\x94L(\0\xb0hD\0\x9cT0\0|4\x10\0\xd4\x8ch\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0|4\x10\0|4\x10\0\x94L(\0\xa8`<\0\x90H$\0t,\b\0\xc0xT\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x80""8\x14\0\x90H$\0\x9cT0\0\xa0X4\0\x94L(\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x88@\x1c\0\x90H$\0\xa0X4\0\xa8`<\0\x94L(\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0h \0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x88@\x1c\0|4\x10\0\x90H$\0\x9cT0\0\x9cT0\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0l$\0\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x94L(\0\xbctP\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x9cT0\0\xc4|X\0\xc8\x80\\\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x94L(\0\xb0hD\0\x98P"
    ",\0\xac""d@\0\0\0\0\0\xac""d@\0\xa0X4\0\0\0\0\0\xa4\\8\0\xa8`<\0\xa0X4\0\xa8`<\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xb8pL\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0hD\0\xb4lH\0\xb4lH\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x98P,\0\x8c""D \0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xa0X4\0\xb4lH\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xff\xff\xff\0\xff\xff\xff\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\xff\xff\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\xff\xff\xff\0\xff\xff\xff\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xb4lH\0\xb4lH\0\xac""d@\0\xa4\\8\0\xa4\\"
    "8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xb8pL\0\xb4lH\0\xc0xT\0"
    "\xcc\x84`\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitclimb1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitclimb1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitclimb1_lines + 0,
      rabbitclimb1_lines + 128,
      rabbitclimb1_lines + 256,
      rabbitclimb1_lines + 384,
      rabbitclimb1_lines + 512,
      rabbitclimb1_lines + 640,
      rabbitclimb1_lines + 768,
      rabbitclimb1_lines + 896,
      rabbitclimb1_lines + 1024,
      rabbitclimb1_lines + 1152,
      rabbitclimb1_lines + 1280,
      rabbitclimb1_lines + 1408,
      rabbitclimb1_lines + 1536,
      rabbitclimb1_lines + 1664,
      rabbitclimb1_lines + 1792,
      rabbitclimb1_lines + 1920,
      rabbitclimb1_lines + 2048,
      rabbitclimb1_lines + 2176,
      rabbitclimb1_lines + 2304,
      rabbitclimb1_lines + 2432,
      rabbitclimb1_lines + 2560,
      rabbitclimb1_lines + 2688,
      rabbitclimb1_lines + 2816,
      rabbitclimb1_lines + 2944,
      rabbitclimb1_lines + 3072,
      rabbitclimb1_lines + 3200,
      rabbitclimb1_lines + 3328,
      rabbitclimb1_lines + 3456,
      rabbitclimb1_lines + 3584,
      rabbitclimb1_lines + 3712,
      rabbitclimb1_lines + 3840,
      rabbitclimb1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitfalling_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitfalling", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "800", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitfalling_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb4lH\0\xb4lH\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xb4lH\0\xb8pL\0\xb8pL\0\xb8pL\0\xb4lH\0\xb4lH\0\0\0\0\0\xff\0\xff\0\0\0\0\0\x98P,\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa4\\8\0\0\0\0\0\xcc\x84`\0\xd4\x8ch\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x8c""D \0\x90H$\0\xb8pL\0\xd4\x8ch\0\xc4|X\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\x8c""D \0\x8c""D \0\0\0\0\0\0\0\0\0\xc4|X\0\xd8\x90l\0\xd4\x8ch\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0\xa0X4\0\0\0\0\0\xe8\xc4\xe8\0\xfc\xd8\xfc\0\0\0\0\0\xcc\x84`\0\xc0xT\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0\xac""d@\0\0\0\0\0\0\0\0\0\x98P,\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xc0xT\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xe0\x98t\0\xd8\x90l\0\xb4lH\0\xa4\\8\0\xa4\\8\0\xac""d@\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x80""8\x14\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\x88@\x1c\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x88@\x1c\0\x80""8\x14\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x90H$\0\x80""8\x14\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0h \0\0|4\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0|4\x10\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x80""8\x14\0h \0\0\x94L(\0\xac""d@\0\0\0\0\0\x98P"
    ",\0\xac""d@\0\0\0\0\0\0\0\0\0\xa0X4\0\0\0\0\0\xa4\\8\0\xa0X4\0\0\0\0\0\x84<\x18\0\xa0X4\0\x9cT0\0\x90H$\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0$l\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x1c""d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0$l\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0""D\0\0\x14\\\0\0""4|\x10\0\0\0"
    "\0\0\x1c""d\0\0\x14\\\0\0\x1c""d\0\0\0\0\0\0(p\x4\0(p\x4\0\x14\\\0\0\0\0\0\0\0""D\0\0\x14\\\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0$l\0\0""0x"
    "\f\0\0\0\0\0H\x90$\0""0x\f\0(p\x4\0\0\0\0\0\bP\0\0\0\0\0\0\x10X\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0""0x"
    "\f\0P\x98,\0\0\0\0\0""4|\x10\0$l\0\0\0\0\0\0\0H\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\x90H$\0|4\x10\0l$\0\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x88@\x1c\0\x80""8\x14\0\0\0\0\0\0\0\0\0t,\b\0\x88@\x1c\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x80""8\x14\0\x88@\x1c\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\xa0X4\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa8`<\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xbct"
    "P\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xc4|X\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xbct"
    "P\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\x88@\x1c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb4lH\0\xb4lH\0\xb4lH\0\xac""d@\0\xa4\\8\0\xa4\\"
    "8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\xb8pL\0\xb8pL\0\xb8pL\0\xb4lH\0\xc0xT\0"
    "\xcc\x84`\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitfalling = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitfalling_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitfalling_lines + 0,
      rabbitfalling_lines + 128,
      rabbitfalling_lines + 256,
      rabbitfalling_lines + 384,
      rabbitfalling_lines + 512,
      rabbitfalling_lines + 640,
      rabbitfalling_lines + 768,
      rabbitfalling_lines + 896,
      rabbitfalling_lines + 1024,
      rabbitfalling_lines + 1152,
      rabbitfalling_lines + 1280,
      rabbitfalling_lines + 1408,
      rabbitfalling_lines + 1536,
      rabbitfalling_lines + 1664,
      rabbitfalling_lines + 1792,
      rabbitfalling_lines + 1920,
      rabbitfalling_lines + 2048,
      rabbitfalling_lines + 2176,
      rabbitfalling_lines + 2304,
      rabbitfalling_lines + 2432,
      rabbitfalling_lines + 2560,
      rabbitfalling_lines + 2688,
      rabbitfalling_lines + 2816,
      rabbitfalling_lines + 2944,
      rabbitfalling_lines + 3072,
      rabbitfalling_lines + 3200,
      rabbitfalling_lines + 3328,
      rabbitfalling_lines + 3456,
      rabbitfalling_lines + 3584,
      rabbitfalling_lines + 3712,
      rabbitfalling_lines + 3840,
      rabbitfalling_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitropeleft0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitropeleft0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "832", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitropeleft0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\x98P,\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0\x94L(\0"
    "\xa8`<\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x9cT0\0\x80""8\x14\0\0\0\0\0\xb4lH\0\xa0X4\0\xac""d@\0\xac""d@\0\0\0\0\0\x90H$\0\x94L(\0"
    "\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x94L(\0\x88@\x1c\0\0\0\0\0\xb4lH\0\xac""d@\0\xac""d@\0\0\0\0\0\x90H$\0\x90H$\0\x90H$\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x90H$\0\x90H$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0l$\0\0\x90H$\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x80""8\x14\0\x90H$\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xc4|X\0\xd8\x90l\0\xb0hD\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\0\0\0\0\x80""8\x14\0\x90H$\0\0\0\0\0|4\x10\0\0\0\0\0\0\0\0\0\xc4|X\0\xd8\x90l\0\xbctP\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x98P,\0\0\0\0\0\x80""8\x14\0\x90H$\0\0\0\0\0x0\f\0\0\0\0\0\x94L(\0\xa0X4\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\x98P,\0\0\0\0\0\x94L(\0\x9cT0\0\0\0\0\0\x84<\x18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4lH\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0\x80""A!\0\0\0\0\0\xb0hD\0\xb4lH\0\x90H$\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0{:\x1a\0\0\0\0\0\xbctP\0\xbctP\0\x9cT0\0\0\0\0\0\xac""d@\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0|4\x10\0\0\0\0\0\xa0X4\0\xbctP\0\xa8`<\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x9cT0\0\xb4lH\0\xb4lH\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0\0\0\0\0\x9cT0\0\xb4lH\0\xa8`<\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x9cT0\0\xa8`<\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\x94L(\0\x94L(\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\x94L(\0\x90H$\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\xa8`<\0\x94L(\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb0hD\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x8c""D \0\x98P,\0\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x84<\x18\0\xac""d@\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x8c""D \0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0@\xac@\0,\x98,\0\0H\0\0\0$\0\0\0\\\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0P"
    "\0\0""8\xa4""8\0$\x90$\0\0\x14\0\0\0\0\0\0\0\\\0\0H\xb4H\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\x14\0\0\0\b\0\0\0\x1c"
    "\0\0\0P\0\0\0""0\0\0\0\0\0\0\0\0\0\0\0""D\0\0""8\xa4""8\0\0""d\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0""0\0\0\0(\0\0\0\x1c"
    "\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0,\x98,\0\0H\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0""4"
    "\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0\0\0\0\0(\0\0\0X\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|4\x10\0\x80""8\x14\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0|4\x10\0l$\0\0l$\0\0\x80""8\x14\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xcc\x84`\0\xc0xT\0\x90H$\0\x88@\x1c\0\x88@\x1c\0\x90H$\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x80""8\x14\0\x88@\x1c\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitropeleft0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitropeleft0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitropeleft0_lines + 0,
      rabbitropeleft0_lines + 128,
      rabbitropeleft0_lines + 256,
      rabbitropeleft0_lines + 384,
      rabbitropeleft0_lines + 512,
      rabbitropeleft0_lines + 640,
      rabbitropeleft0_lines + 768,
      rabbitropeleft0_lines + 896,
      rabbitropeleft0_lines + 1024,
      rabbitropeleft0_lines + 1152,
      rabbitropeleft0_lines + 1280,
      rabbitropeleft0_lines + 1408,
      rabbitropeleft0_lines + 1536,
      rabbitropeleft0_lines + 1664,
      rabbitropeleft0_lines + 1792,
      rabbitropeleft0_lines + 1920,
      rabbitropeleft0_lines + 2048,
      rabbitropeleft0_lines + 2176,
      rabbitropeleft0_lines + 2304,
      rabbitropeleft0_lines + 2432,
      rabbitropeleft0_lines + 2560,
      rabbitropeleft0_lines + 2688,
      rabbitropeleft0_lines + 2816,
      rabbitropeleft0_lines + 2944,
      rabbitropeleft0_lines + 3072,
      rabbitropeleft0_lines + 3200,
      rabbitropeleft0_lines + 3328,
      rabbitropeleft0_lines + 3456,
      rabbitropeleft0_lines + 3584,
      rabbitropeleft0_lines + 3712,
      rabbitropeleft0_lines + 3840,
      rabbitropeleft0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitropeleft1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitropeleft1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "864", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitropeleft1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0|4\x10\0\x98P,\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0l$\0\0p(\x4\0"
    "x0\f\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0x0\f\0\x84<\x18\0\0\0\0\0\0\0\0\0\xb4lH\0\xa0X4\0\xac""d@\0\xac""d@\0\xa4\\8\0\0\0\0\0|4\x10\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x94L(\0\xa8`<\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0x0\f\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4lH\0\xac""d@\0\xac""d@\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x88@\x1c\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x98P,\0\xa4\\8\0\0\0\0\0\0\0\0\0\x9cT0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\xac""d@\0\xa4\\8\0\x84<\x18\0x0\f\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x9cT0\0\x90H$\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x98P,\0\xa0X4\0\xa0X4\0\x98P,\0|4\x10\0x0\f\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x88@\x1c\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0\x98P,\0\0\0\0\0\0\0\0\0\x98P,\0\x98P,\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0|4\x10\0l$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0\x80""A!\0\0\0\0\0p(\x4\0\x84<\x18\0\xa0X4\0\xa4\\8\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0l$\0\0l$\0\0|4\x10\0\0\0\0\0\0\0\0\0\xff\xaa\xff\0\0\0"
    "\0\0{:\x1a\0l$\0\0p(\x4\0\x84<\x18\0\xa4\\8\0\xb4lH\0\xac""d@\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x80""8\x14\0\x80""8\x14\0\x80""8\x14\0\x88@\x1c\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0|4\x10\0l$\0\0x0\f\0\x98P,\0\xac""d@\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x90H$\0\x90H$\0\x94L(\0\xa8`<\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0\xa0X4\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x94L(\0\x94L(\0\x9cT0\0\x9cT0\0\0\0"
    "\0\0\xa0X4\0|4\x10\0x0\f\0x0\f\0|4\x10\0|4\x10\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\x88@\x1c\0\xb0hD\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xa0X4\0\xb8pL\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x94L(\0\xb4lH\0\xb4l"
    "H\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb0hD\0\x9cT"
    "0\0\0\0\0\0\0\0\0\0\x8c""D \0\xa0X4\0\0\0\0\0\x94L(\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x9cT0\0\x94L"
    "(\0\x88@\x1c\0\0\0\0\0\xa0X4\0\xac""d@\0\0\0\0\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x94L"
    "(\0\x90H$\0\0\0\0\0\xa0X4\0\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\x8c""D \0\x98P,\0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x84<\x18\0\xac""d@\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\x84<\x18\0\x8c""D \0\xb4lH\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0@\xac@\0,\x98,\0\0H\0\0\0$\0\0\0\\\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x9cT0\0\x94L(\0\xa0X4\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0P"
    "\0\0""8\xa4""8\0$\x90$\0\0\x14\0\0\0\0\0\0\0\\\0\0H\xb4H\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x92I$\0\x92I$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\b\0\0\0\x1c"
    "\0\0\0P\0\0\0""0\0\0\0\0\0\0\0\0\0\0\0""D\0\0""8\xa4""8\0\0""d\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\0\0\0\0|4\x10\0\0\0\0\0\0""0\0\0\0(\0\0\0\x1c"
    "\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0,\x98,\0\0H\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xc4|X\0\0\0\0\0`\x18\0\0t,\b\0\0\0\0\0\0\0\0\0\0\0\0\0\0""4"
    "\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0\0\0\0\0(\0\0\0X\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xd0\x88""d\0\0\0\0\0l$\0\0t,\b\0\x88@\x1c\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xd0\x88""d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xa8`<\0\x80""8\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x94L(\0t,\b\0\x80""8\x14\0\x90H$\0\x92I$\0\x92I$\0\xb0hD\0\xc4|X\0\xc4|X\0\xb0hD\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitropeleft1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitropeleft1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitropeleft1_lines + 0,
      rabbitropeleft1_lines + 128,
      rabbitropeleft1_lines + 256,
      rabbitropeleft1_lines + 384,
      rabbitropeleft1_lines + 512,
      rabbitropeleft1_lines + 640,
      rabbitropeleft1_lines + 768,
      rabbitropeleft1_lines + 896,
      rabbitropeleft1_lines + 1024,
      rabbitropeleft1_lines + 1152,
      rabbitropeleft1_lines + 1280,
      rabbitropeleft1_lines + 1408,
      rabbitropeleft1_lines + 1536,
      rabbitropeleft1_lines + 1664,
      rabbitropeleft1_lines + 1792,
      rabbitropeleft1_lines + 1920,
      rabbitropeleft1_lines + 2048,
      rabbitropeleft1_lines + 2176,
      rabbitropeleft1_lines + 2304,
      rabbitropeleft1_lines + 2432,
      rabbitropeleft1_lines + 2560,
      rabbitropeleft1_lines + 2688,
      rabbitropeleft1_lines + 2816,
      rabbitropeleft1_lines + 2944,
      rabbitropeleft1_lines + 3072,
      rabbitropeleft1_lines + 3200,
      rabbitropeleft1_lines + 3328,
      rabbitropeleft1_lines + 3456,
      rabbitropeleft1_lines + 3584,
      rabbitropeleft1_lines + 3712,
      rabbitropeleft1_lines + 3840,
      rabbitropeleft1_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitroperight0_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitroperight0", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "896", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitroperight0_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa8`<\0\x94L(\0\x90H$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x98P,\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x9cT0\0\x94L(\0\x90H$\0\0\0\0\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\x80""8\x14\0\x9cT0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x90H$\0\x90H$\0\x90H$\0\0\0\0\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\x88@\x1c\0\x94L(\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0l$\0\0\xa0X4\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\x90H$\0\x90H$\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\xb0hD\0\xd8\x90l\0\xc4|X\0\0\0\0\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x90H$\0\x80""8\x14\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xbctP\0\xd8\x90l\0\xc4|X\0\0\0\0\0\0\0"
    "\0\0|4\x10\0\0\0\0\0\x90H$\0\x80""8\x14\0\0\0\0\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0X4\0\x94L(\0\0\0"
    "\0\0x0\f\0\0\0\0\0\x90H$\0\x80""8\x14\0\0\0\0\0\x98P,\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\x84<\x18\0\0\0\0\0\x9cT0\0\x94L(\0\0\0\0\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\0\0\0\0\x90H$\0\xb4lH\0\xb0hD\0\0\0\0\0\x80""A!\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0\0\0\0\0\x9cT0\0\xbctP\0\xbctP\0\0\0\0\0{:\x1a\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\xa8`<\0\xbctP\0\xa0X4\0\0\0\0\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\xb4lH\0\xb4lH\0\x9cT0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\xa8`<\0\xb4lH\0\x9cT0\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xa8`<\0\x9cT0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x94L(\0\x94L(\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x90H$\0\x94L(\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\x94L(\0\xa8`<\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\xb0hD\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\0\0\0\0\x98P,\0\x8c""D \0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x8c""D \0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\0$\0\0\0H\0\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x80""8\x14\0|4\x10\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x80""8\x14\0l$\0\0l$\0\0|4\x10\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xb8pL\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\x88@\x1c\0\x80""8\x14\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x90H$\0\x88@\x1c\0\x88@\x1c\0\x90H$\0\xc0xT\0"
    "\xcc\x84`\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitroperight0 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitroperight0_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitroperight0_lines + 0,
      rabbitroperight0_lines + 128,
      rabbitroperight0_lines + 256,
      rabbitroperight0_lines + 384,
      rabbitroperight0_lines + 512,
      rabbitroperight0_lines + 640,
      rabbitroperight0_lines + 768,
      rabbitroperight0_lines + 896,
      rabbitroperight0_lines + 1024,
      rabbitroperight0_lines + 1152,
      rabbitroperight0_lines + 1280,
      rabbitroperight0_lines + 1408,
      rabbitroperight0_lines + 1536,
      rabbitroperight0_lines + 1664,
      rabbitroperight0_lines + 1792,
      rabbitroperight0_lines + 1920,
      rabbitroperight0_lines + 2048,
      rabbitroperight0_lines + 2176,
      rabbitroperight0_lines + 2304,
      rabbitroperight0_lines + 2432,
      rabbitroperight0_lines + 2560,
      rabbitroperight0_lines + 2688,
      rabbitroperight0_lines + 2816,
      rabbitroperight0_lines + 2944,
      rabbitroperight0_lines + 3072,
      rabbitroperight0_lines + 3200,
      rabbitroperight0_lines + 3328,
      rabbitroperight0_lines + 3456,
      rabbitroperight0_lines + 3584,
      rabbitroperight0_lines + 3712,
      rabbitroperight0_lines + 3840,
      rabbitroperight0_lines + 3968,
      0 }
};



static DATAFILE_PROPERTY rabbitroperight1_prop[] = {
    { "12-21-2005, 8:47", DAT_ID('D', 'A', 'T', 'E') },
    { "rabbitroperight1", DAT_ID('N', 'A', 'M', 'E') },
    { "d:\\Programming\\eggrun\\data\\tst.bmp", DAT_ID('O', 'R', 'I', 'G') },
    { "928", DAT_ID('X', 'P', 'O', 'S') },
    { "32", DAT_ID('X', 'S', 'I', 'Z') },
    { "0", DAT_ID('Y', 'P', 'O', 'S') },
    { "32", DAT_ID('Y', 'S', 'I', 'Z') },
    { 0, DAT_END }
};

static unsigned char rabbitroperight1_lines[] = 
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0x0\f\0p(\x4\0l$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\xac""d@\0\x98P,\0|4\x10\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0|4\x10\0\0\0\0\0\xa4\\8\0\xac""d@\0\xac""d@\0\xa0X"
    "4\0\xb4lH\0\0\0\0\0\0\0\0\0\x84<\x18\0x0\f\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\x9cT0\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xac""d@\0\xac""d@\0\xac""d"
    "@\0\xb4lH\0\0\0\0\0\0\0\0\0\0\0\0\0x0\f\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\xa8`<\0\x94L(\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\x9cT0\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\8\0\0\0\0\0\xff\0\xff\0\0\0\0\0\x9cT"
    "0\0\0\0\0\0\0\0\0\0\xa4\\8\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\x90H$\0\x88@\x1c\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\0\0\0\0\0\0"
    "\0\0|4\x10\0x0\f\0\x84<\x18\0\xa4\\8\0\xac""d@\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0"
    "\x90H$\0\x90H$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb8pL\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0x0\f\0|4\x10\0\x98P,\0\xa0X4\0\xa0X4\0\x98P,\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\x90H$\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb4lH\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x84<\x18\0\x98P,\0\x98P,\0\0\0\0\0\0\0\0\0\x98P,\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\x88@\x1c\0"
    "\x88@\x1c\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xa4\\"
    "8\0\xa4\\8\0\xa0X4\0\x84<\x18\0p(\x4\0\0\0\0\0\x80""A!\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\0\0\0\0\0\0\0\0l$\0\0"
    "|4\x10\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xac""d"
    "@\0\xb4lH\0\xa4\\8\0\x84<\x18\0p(\x4\0l$\0\0{:\x1a\0\0\0\0\0\xff\xaa\xff\0\0\0\0\0\0\0\0\0|4\x10\0l$\0\0"
    "l$\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xb4lH\0\xac""d@\0\x98P,\0x0\f\0l$\0\0|4\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\x88@\x1c\0\x80""8\x14\0\x80""8\x14\0"
    "\x80""8\x14\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\xa0X4\0\xa0X4\0\x90H$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8`<\0\x94L(\0\x90H$\0\x90H$\0"
    "\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0|4\x10\0|4\x10\0x0\f\0x0\f\0|4\x10\0\xa0X4\0\0\0\0\0\x9cT0\0\x9cT0\0\x94L(\0\x94L(\0\0\0\0\0"
    "\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\xb8pL\0\xa0X4\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0hD\0\x88@\x1c\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x90H$\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4lH\0\xb4lH\0\x94L(\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x94L(\0\0\0\0\0\xa0X4\0\x8c""D \0\0\0\0\0\0\0\0\0\x9cT0\0\xb0hD\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\x9cT0\0\0\0\0\0\xac""d@\0\xa0X4\0\0\0\0\0\x88@\x1c\0\x94L(\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xb8pL\0\xa0X4\0\0\0\0\0\x90H$\0\x94L(\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x98P,\0\x8c""D \0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xb8pL\0\xac""d@\0\x84<\x18\0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\xc4|X\0\xb4lH\0\x8c""D \0\x84<\x18\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0"
    "\0\0\0\0\0\0\0\\\0\0\0$\0\0\0H\0\0,\x98,\0@\xac@\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0H\xb4H\0\0\\\0\0\0\0\0\0\0\x14\0\0$\x90$\0""8\xa4""8\0\0P\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\0\0\0\0\xa0X4\0"
    "\x94L(\0\x9cT0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0""d"
    "\0\0""8\xa4""8\0\0""D\0\0\0\0\0\0\0\0\0\0\0""0\0\0\0P\0\0\0\x1c\0\0\0\b\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\x92I$\0\x92I$\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0H"
    "\0\0,\x98,\0\0<\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x1c\0\0\0(\0\0\0""0\0\0\0\0\0\0|4\x10\0\0\0\0\0"
    "\0\0\0\0\xa0X4\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\x10"
    "\0\0\0X\0\0\0(\0\0\0\0\0\0\0\x1c\0\0\0""0\0\0\0\x1c\0\0\0""4\0\0\0\0\0\0\0\0\0\0\0\0\0\0t,\b\0`\x18\0\0"
    "\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x88@\x1c\0t,\b\0l$\0\0"
    "\0\0\0\0\xd0\x88""d\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80""8\x14\0\xa8`<\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\xd0\x88""d\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\xb0hD\0\xc4|X\0\xc4|X\0\xb0hD\0\x92I$\0\x92I"
    "$\0\x90H$\0\x80""8\x14\0t,\b\0\x94L(\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\0\0\0\0\xc4|X\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
"\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
    "\xff\0\xff\0\0\0\0\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0"
;

static struct { int w, h; int clip; int cl, cr, ct, cb;
                GFX_VTABLE *vtable; void *write_bank; void *read_bank;
                void *dat; unsigned long id; void *extra;
                int x_ofs; int y_ofs; int seg; unsigned char *line[33]; } rabbitroperight1 = {
    32, 32, /* width, height */
    0, 0, 0, 0, 0, /* clip */
    (GFX_VTABLE *)32, /* bpp */
    0, 0, /* write_bank, read_bank */
    rabbitroperight1_lines, /* data */
    0, 0, 0, 0, 0,
    { /* line[] array */
      rabbitroperight1_lines + 0,
      rabbitroperight1_lines + 128,
      rabbitroperight1_lines + 256,
      rabbitroperight1_lines + 384,
      rabbitroperight1_lines + 512,
      rabbitroperight1_lines + 640,
      rabbitroperight1_lines + 768,
      rabbitroperight1_lines + 896,
      rabbitroperight1_lines + 1024,
      rabbitroperight1_lines + 1152,
      rabbitroperight1_lines + 1280,
      rabbitroperight1_lines + 1408,
      rabbitroperight1_lines + 1536,
      rabbitroperight1_lines + 1664,
      rabbitroperight1_lines + 1792,
      rabbitroperight1_lines + 1920,
      rabbitroperight1_lines + 2048,
      rabbitroperight1_lines + 2176,
      rabbitroperight1_lines + 2304,
      rabbitroperight1_lines + 2432,
      rabbitroperight1_lines + 2560,
      rabbitroperight1_lines + 2688,
      rabbitroperight1_lines + 2816,
      rabbitroperight1_lines + 2944,
      rabbitroperight1_lines + 3072,
      rabbitroperight1_lines + 3200,
      rabbitroperight1_lines + 3328,
      rabbitroperight1_lines + 3456,
      rabbitroperight1_lines + 3584,
      rabbitroperight1_lines + 3712,
      rabbitroperight1_lines + 3840,
      rabbitroperight1_lines + 3968,
      0 }
};



DATAFILE data[] = {
    { &drill, DAT_ID('B', 'M', 'P', ' '), 3078, drill_prop },
    { &nodrill, DAT_ID('B', 'M', 'P', ' '), 3078, nodrill_prop },
    { &ladder, DAT_ID('B', 'M', 'P', ' '), 3078, ladder_prop },
    { &egg, DAT_ID('B', 'M', 'P', ' '), 3078, egg_prop },
    { &rope, DAT_ID('B', 'M', 'P', ' '), 3078, rope_prop },
    { &trap, DAT_ID('B', 'M', 'P', ' '), 3078, trap_prop },
    { &invladder, DAT_ID('B', 'M', 'P', ' '), 3078, invladder_prop },
    { &chicken1, DAT_ID('B', 'M', 'P', ' '), 3078, chicken1_prop },
    { &chickenleft0, DAT_ID('B', 'M', 'P', ' '), 3078, chickenleft0_prop },
    { &chickenleft1, DAT_ID('B', 'M', 'P', ' '), 3078, chickenleft1_prop },
    { &chickenright0, DAT_ID('B', 'M', 'P', ' '), 3078, chickenright0_prop },
    { &chickenright1, DAT_ID('B', 'M', 'P', ' '), 3078, chickenright1_prop },
    { &chickenclimb0, DAT_ID('B', 'M', 'P', ' '), 3078, chickenclimb0_prop },
    { &chickenclimb1, DAT_ID('B', 'M', 'P', ' '), 3078, chickenclimb1_prop },
    { &chickenropeleft0, DAT_ID('B', 'M', 'P', ' '), 3078, chickenropeleft0_prop },
    { &chickenropeleft1, DAT_ID('B', 'M', 'P', ' '), 3078, chickenropeleft1_prop },
    { &chickenroperight0, DAT_ID('B', 'M', 'P', ' '), 3078, chickenroperight0_prop },
    { &chickenroperight1, DAT_ID('B', 'M', 'P', ' '), 3078, chickenroperight1_prop },
    { &rabbit1, DAT_ID('B', 'M', 'P', ' '), 3078, rabbit1_prop },
    { &rabbitleft0, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitleft0_prop },
    { &rabbitleft1, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitleft1_prop },
    { &rabbitright0, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitright0_prop },
    { &rabbitright1, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitright1_prop },
    { &rabbitclimb0, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitclimb0_prop },
    { &rabbitclimb1, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitclimb1_prop },
    { &rabbitfalling, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitfalling_prop },
    { &rabbitropeleft0, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitropeleft0_prop },
    { &rabbitropeleft1, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitropeleft1_prop },
    { &rabbitroperight0, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitroperight0_prop },
    { &rabbitroperight1, DAT_ID('B', 'M', 'P', ' '), 3078, rabbitroperight1_prop },
    { 0, DAT_END, 0, 0 }
};



#ifdef ALLEGRO_USE_CONSTRUCTOR
CONSTRUCTOR_FUNCTION(static void _construct_me(void));
static void _construct_me(void)
{
    _construct_datafile(data);
}
#endif



/* end of sprites.c */



