#include <time.h>
#include <string>
#include <allegro.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <ppcol.h>
using namespace std;

#define MAX_XV 5
#define MAX_YV 5
#define SHOT_XV 7
#define SHOT_YV 7
#define ACCELDIV 5  //the higher this number, the slower the acceleration
#define MAX_SHOTS 30
#define MAX_EXPLOSIONS 50

#define NUM_POWUPS 2  //number of different ship powerups
#define MAX_POWUPS 5  //number of powerups that can be on the screen at once

#define POWDAT 3  //where the powerup data begins in the datafile

#define pi M_PI

volatile int counter;
volatile int fps_counter;

char msg[30];
int gameover;
int rounds;
int draw;
int friction;

typedef struct expl
{
  int x;
  int y;
  float frame;
  int type;
  int exist;
} expl;

typedef struct p_up
{
  int x;
  int y;
  int type;
  int exist;
} p_up;

typedef struct cannon
{
  float x;
  float y;
  float xv;
  float yv;
  int exist;
  int time;
  int rot;
  int frame;
} cannon;

typedef struct duelship
{
  float x;
  float y;
  float xv;
  float yv;
  int health;
  int firetime;
  int rot;
  int power[NUM_POWUPS];
  int roundswon;
  cannon missile;
  cannon shot[MAX_SHOTS];
} duelship;

expl explosion[MAX_EXPLOSIONS];
p_up powerup[MAX_POWUPS];
duelship ship[2];

void init();
void menu();
void logic();
void check_keys();
void draw_ships();
void draw_shots();
void draw_stats();
void draw_powerups();
void draw_explosions();
void fire_missile(int z);
void create_powerup();
void activate_powerup(int s, int type);
void create_explosion(int x, int y, int type);
int rotate_to_target(cannon m, duelship t);
int create_shot(int z);
int side_shot(int z);
float abs(float z);

BITMAP *back_buffer;
BITMAP *rotate[2];
BITMAP *missilerot;
DATAFILE *graphics;
DATAFILE *missile;
DATAFILE *medexp;
DATAFILE *smallexp;

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

void fps_handler()
{
  fps_counter++;
}
END_OF_FUNCTION(fps_handler);

int main()
{
  srand(time(NULL));
  BEGIN_COLOR_DEPTH_LIST
    COLOR_DEPTH_8
  END_COLOR_DEPTH_LIST
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(timer_handler);
  LOCK_VARIABLE(fps_counter);
  LOCK_FUNCTION(fps_handler);
  allegro_init();
  install_keyboard();
  install_timer();
  install_int_ex(timer_handler, BPS_TO_TIMER(50));
  install_int_ex(fps_handler, BPS_TO_TIMER(1));
  if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    return 1;
  }
  graphics = load_datafile("duel.dat");
  if (!graphics)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load duel.dat\n%s\n", allegro_error);
    return 1;
  }
  missile = (DATAFILE *)graphics[6].dat;
  medexp = (DATAFILE *)graphics[8].dat;
  smallexp = (DATAFILE *)graphics[9].dat;
  back_buffer = create_bitmap(640, 480);
  clear(back_buffer);
  rotate[0] = create_bitmap(25, 25);
  clear(rotate[0]);
  rotate[1] = create_bitmap(25, 25);
  clear(rotate[1]);
  missilerot = create_bitmap(25, 25);
  clear(missilerot);
  counter = 0;
  fps_counter = 0;
  gameover = -1;
  draw = 0;
  friction = 0;
  init();
  while (gameover != 1)
  {
    while (counter > 0)
    {
      if (key[KEY_ESC])
      {
        gameover = 1;
      }
      if (key[KEY_P])
      {
        while (key[KEY_P])
        {
        }
        while (!key[KEY_P])
        {
        }
        while (key[KEY_P])
        {
        }
        counter = 0;
      }
      switch(gameover)
      {
        case -1:
          menu();
          break;
        case 0:
          logic();
          break;
      }
      draw = 1;
      counter--;
    }
    if (draw == 1)
    {
      blit(back_buffer, screen, 0, 0, 0, 0, 640, 480);
      draw = 0;
    }
  }
  destroy_bitmap(back_buffer);
  destroy_bitmap(rotate[0]);
  destroy_bitmap(rotate[1]);
  destroy_bitmap(missilerot);
  unload_datafile(graphics);
  return 0;
}
END_OF_MAIN();




void init()
{
  int i;
  int j;
  i = 0;
  while (i < MAX_SHOTS)
  {
    ship[0].shot[i].exist = 0;
    ship[1].shot[i].exist = 0;
    i++;
  }
  i = 0;
  while (i < 2)
  {
    ship[i].x = 20 + 590 * i;
    ship[i].y = 240;
    ship[i].xv = 0;
    ship[i].yv = 0;
    ship[i].health = 100;
    ship[i].firetime = 0;
    ship[i].rot = 0 + (128 * i);
    ship[i].missile.exist = 0;
    j = 0;
    while (j < 5)
    {
      ship[i].shot[j].exist = 0;
      ship[i].shot[j].time = 0;
      j++;
    }
    j = 0;
    while (j < NUM_POWUPS)
    {
      ship[i].power[j] = 0;
      j++;
    }
    j = 0;
    while (j < MAX_POWUPS)
    {
      powerup[j].exist = 0;
      j++;
    }
    j = 0;
    while (j < MAX_EXPLOSIONS)
    {
      explosion[j].exist = 0;
      j++;
    }
    i++;
  }
}





void menu()
{
  static int choice = 0;
  static int keydelay = 0;
  clear(back_buffer);
  draw_sprite(back_buffer, (BITMAP *)graphics[7].dat, 213, 50);
  if (choice == 0)
  {
    textout_centre(back_buffer, font, "1 Round", 320, 150, 15);
  }
  else
  {
    textout_centre(back_buffer, font, "1 Round", 320, 150, 25);
  }
  if (choice == 1)
  {
    textout_centre(back_buffer, font, "3 Rounds", 320, 170, 15);
  }
  else
  {
    textout_centre(back_buffer, font, "3 Rounds", 320, 170, 25);
  }
  if (choice == 2)
  {
    textout_centre(back_buffer, font, "5 Rounds", 320, 190, 15);
  }
  else
  {
    textout_centre(back_buffer, font, "5 Rounds", 320, 190, 25);
  }
  if (choice == 3)
  {
    sprintf(msg, "Friction:  %-1d", friction);
    textout_centre(back_buffer, font, msg, 320, 230, 15);
    if (keydelay == 0)
    {
      if (key[KEY_LEFT])
      {
        if (friction > 0)
        {
          friction -= 5;
        }
        keydelay = 10;
      }
      if (key[KEY_RIGHT])
      {
        if (friction < 100)
        {
          friction += 5;
        }
        keydelay = 10;
      }
    }
  }
  else
  {
    sprintf(msg, "Friction:  %-1d", friction);
    textout_centre(back_buffer, font, msg, 320, 230, 25);
  }
  if (keydelay == 0)
  {
    if (key[KEY_UP])
    {
      if (choice > 0)
      {
        choice--;
      }
      keydelay = 10;
    }
    if (key[KEY_DOWN])
    {
      if (choice < 3)
      {
        choice++;
      }
      keydelay = 10;
    }
    if ((key[KEY_ENTER]) && (choice != 3))
    {
      switch(choice)
      {
        case 0:
          rounds = 1;
          break;
        case 1:
          rounds = 3;
          break;
        case 2:
          rounds = 5;
          break;
      }
      ship[0].roundswon = 0;
      ship[1].roundswon = 0;
      init();
      gameover = 0;  //go to logic
      keydelay = 10;
    }
  }
  else
  {
    keydelay--;
  }
}





void logic()
{
  static int roundnum = 1;
  static int start_time = 50;
  static int windelay = 75;  //1.5 second win-delay
  clear(back_buffer);
  if (start_time > 0)
  {
    draw_ships();
    sprintf(msg, "Round %-1d", roundnum);
    textout_centre(back_buffer, font, msg, 320, 200, 15);
    start_time--;
  }
  else if ((ship[0].health > 0) && (ship[1].health > 0))
  {
    check_keys();
    draw_ships();
    draw_powerups();
    draw_shots();
    draw_stats();
    draw_explosions();
    if (rand()%500 == 1)  //should create one roughly every 10 seconds
    {
      create_powerup();
    }
  }
  else
  {
    if (windelay > 0)
    {
      draw_ships();
      draw_explosions();
      if (ship[0].health > 0)
      {
        create_explosion(int(ship[1].x - 16 + rand()%25), int(ship[1].y - 16 + rand()%25), 0);
      }
      else
      {
        create_explosion(int(ship[0].x - 16 + rand()%25), int(ship[0].y - 16 + rand()%25), 0);
      }
      windelay--;
    }
    else
    {
      if (windelay == 0)
      {
        if (ship[0].health > 0)
        {
          ship[0].roundswon++;
        }
        else
        {
          ship[1].roundswon++;
        }
        rounds--;
        roundnum++;
        windelay = -1;
      }
      if (rounds == 0)
      {
        textout_centre(back_buffer, font, "G A M E   O V E R", 320, 195, 15);
        if (ship[0].roundswon > ship[1].roundswon)
        {
          textout_centre(back_buffer, font, "Player 1 Wins", 320, 210, 15);
        }
        else
        {
          textout_centre(back_buffer, font, "Player 2 Wins", 320, 210, 15);
        }
        if (key[KEY_ENTER])
        {
          gameover = -1;
          roundnum = 1;
          start_time = 50;
          windelay = 75;
        }
      }
      else
      {
        init();
        start_time = 50;
        windelay = 75;
      }
    }
  }
}





void check_keys()
{
  int moved[2];
  float x = 0;
  float y = 0;
  moved[0] = 0;
  moved[1] = 0;  
  //player 1
  if (ship[0].firetime > 0)
  {
    ship[0].firetime--;
  }
  if (ship[1].firetime > 0)
  {
    ship[1].firetime--;
  }  
  if ((key[KEY_W]) || (key[KEY_S]))  //thrust
  {
    moved[0] = 1;
    if (key[KEY_W])
    {
      x = cos(float(ship[0].rot) * pi / 128) / ACCELDIV;
      y = sin(float(ship[0].rot) * pi / 128) / ACCELDIV;
    }
    else  //reverse
    {
      x = -cos(float(ship[0].rot) * pi / 128) / (ACCELDIV * 2);
      y = -sin(float(ship[0].rot) * pi / 128) / (ACCELDIV * 2);
    }
    if (abs(ship[0].xv + x) < MAX_XV)
    {
      ship[0].xv += x;
    }
    if (abs(ship[0].yv + y) < MAX_YV)
    {
      ship[0].yv += y;
    }
  }
  if (key[KEY_A])
  {
    ship[0].rot--;
    if (ship[0].rot < 0)
    {
      ship[0].rot += 256;
    }
  }
  if (key[KEY_D])
  {
    ship[0].rot++;
    if (ship[0].rot > 256)
    {
      ship[0].rot -= 256;
    }
  }
  if (key[KEY_C])
  {
    if ((ship[0].missile.exist == 0) && (ship[0].power[0] > 0))
    {
      fire_missile(0);
      ship[0].power[0]--;
    }
  }
  if (key[KEY_V])
  {
    if (ship[0].firetime == 0)
    {
      if (create_shot(0) != -1)
      {
        ship[0].firetime = 20;
        if (ship[0].power[1] == 1)  //if triple fire powerup is active
        {
          side_shot(0);
        }
      }
    }
  }
  //player 2
  if ((key[KEY_UP]) || (key[KEY_DOWN]))  //thrust
  {
    moved[1] = 1;
    if (key[KEY_UP])
    {
      x = cos(float(ship[1].rot) * pi / 128) / ACCELDIV;
      y = sin(float(ship[1].rot) * pi / 128) / ACCELDIV;
    }
    else  //reverse
    {
      x = -cos(float(ship[1].rot) * pi / 128) / (ACCELDIV * 2);
      y = -sin(float(ship[1].rot) * pi / 128) / (ACCELDIV * 2);
    }
    if (abs(ship[1].xv + x) < MAX_XV)
    {
      ship[1].xv += x;
    }
    if (abs(ship[1].yv + y) < MAX_YV)
    {
      ship[1].yv += y;
    }
  }
  if (key[KEY_LEFT])
  {
    ship[1].rot--;
    if (ship[1].rot < 0)
    {
      ship[1].rot += 256;
    }
  }
  if (key[KEY_RIGHT])
  {
    ship[1].rot++;
    if (ship[1].rot > 256)
    {
      ship[1].rot -= 256;
    }    
  }
  if (key[KEY_RCONTROL])
  {
    if ((ship[1].missile.exist == 0) && (ship[1].power[0] > 0))
    {
      fire_missile(1);
      ship[1].power[0]--;
    }
  }  
  if (key[KEY_RSHIFT])
  {
    if (ship[1].firetime == 0)
    {
      if (create_shot(1) != -1)
      {
        ship[1].firetime = 20;
        if (ship[1].power[1] == 1)  //if triple fire powerup is active
        {
          side_shot(1);
        }        
      }
    }
  }
  if (friction > 0)
  {
    if (moved[0] == 0)
    {
      ship[0].xv -= (ship[0].xv * (float(friction) / 1000));
      ship[0].yv -= (ship[0].yv * (float(friction) / 1000));
    }
    if (moved[1] == 0)
    {
      ship[1].xv -= (ship[1].xv * (float(friction) / 1000));
      ship[1].yv -= (ship[1].yv * (float(friction) / 1000));
    }
  }
}





void draw_ships()
{
  int i = 0;
  int j;
  clear(rotate[0]);
  clear(rotate[1]);
  while (i < 2)
  {
    ship[i].x += ship[i].xv;
    ship[i].y += ship[i].yv;
    if (ship[i].x > 640)
    {
      ship[i].x -= 655;
    }
    else if (ship[i].x < -15)
    {
      ship[i].x += 640;
    }
    if (ship[i].y > 480)
    {
      ship[i].y -= 495;
    }
    else if (ship[i].y < -15)
    {
      ship[i].y += 480;
    }
    rotate_sprite(rotate[i], (BITMAP *)graphics[i].dat, 0, 0, itofix(ship[i].rot));
    draw_sprite(back_buffer, rotate[i], int(ship[i].x), int(ship[i].y));
    j = 0;
    while (j < MAX_POWUPS)
    {
      if (powerup[j].exist == 1)
      {
        if (check_pp_collision((BITMAP *)graphics[POWDAT].dat, rotate[i], powerup[j].x, powerup[j].y, int(ship[i].x), int(ship[i].y)) == 1)
        {
          activate_powerup(i, powerup[j].type);
          powerup[j].exist = 0;
        }
      }
      j++;
    }
    i++;
  }
}





float abs(float z)
{
  if (z < 0)
  {
    return -z;
  }
  else
  {
    return z;
  }
}





int create_shot(int z)
{
  int i = 0;
  while (i < MAX_SHOTS)
  {
    if (ship[z].shot[i].exist == 0)
    {
      ship[z].shot[i].exist = 1;
      ship[z].shot[i].time = 75;  //1.5 second shot
      ship[z].shot[i].x = ship[z].x + 12 + (8 * cos(float(ship[z].rot) * pi / 128));
      ship[z].shot[i].y = ship[z].y + 12 + (8 * sin(float(ship[z].rot) * pi / 128));
      ship[z].shot[i].xv = SHOT_XV * cos(float(ship[z].rot) * pi / 128);
      ship[z].shot[i].yv = SHOT_YV * sin(float(ship[z].rot) * pi / 128);
      i = MAX_SHOTS;
    }
    i++;
  }
}





int side_shot(int z)
{
  int u = 0;
  int i = 0;
  while (u < 2)
  {
    i = 0;
    while (i < MAX_SHOTS)
    {
      if (ship[z].shot[i].exist == 0)
      {
        ship[z].shot[i].exist = 1;
        ship[z].shot[i].time = 75;  //1.5 second shot
        ship[z].shot[i].x = ship[z].x + 12 + (8 * cos(float(ship[z].rot + 64 + (128 * u)) * pi / 128));
        ship[z].shot[i].y = ship[z].y + 12 + (8 * sin(float(ship[z].rot + 64 + (128 * u)) * pi / 128));
        ship[z].shot[i].xv = SHOT_XV * cos(float(ship[z].rot + 64 + (128 * u)) * pi / 128);
        ship[z].shot[i].yv = SHOT_YV * sin(float(ship[z].rot + 64 + (128 * u)) * pi / 128);
        i = MAX_SHOTS;
      }
      i++;
    }
    u++;
  }
}





void fire_missile(int z)
{
  ship[z].missile.exist = 1;
  ship[z].missile.x = ship[z].x;// + (8 * cos(float(ship[z].rot) * pi / 128));
  ship[z].missile.y = ship[z].y;// + (8 * sin(float(ship[z].rot) * pi / 128));
  ship[z].missile.xv = 0;//(SHOT_XV + 1) * cos(float(ship[z].rot) * pi / 128);
  ship[z].missile.yv = 0;//(SHOT_YV + 1) * sin(float(ship[z].rot) * pi / 128);
  ship[z].missile.rot = ship[z].rot;
  ship[z].missile.time = 500;  //10-second missile lifespan
}





void draw_shots()
{
  int z = 0;
  int i;
  int o;
  float x;
  float y;
  float r;
  while (z < 2)
  {
    clear(missilerot);
    if (z == 1)
    {
      o = 0;
    }
    else
    {
      o = 1;
    }
    i = 0;
    while (i < MAX_SHOTS)
    {
      if (ship[z].shot[i].exist == 1)
      {
        ship[z].shot[i].time--;
        if (ship[z].shot[i].time == 0)
        {
          ship[z].shot[i].exist = 0;
        }
        ship[z].shot[i].x += ship[z].shot[i].xv;
        if (ship[z].shot[i].x > 640)
        {
          ship[z].shot[i].x -= 645;
        }
        else if (ship[z].shot[i].x < -5)
        {
          ship[z].shot[i].x += 645;
        }
        if (ship[z].shot[i].y > 480)
        {
          ship[z].shot[i].y -= 485;
        }
        else if (ship[z].shot[i].y < -5)
        {
          ship[z].shot[i].y += 485;
        }
        ship[z].shot[i].y += ship[z].shot[i].yv;
        draw_sprite(back_buffer, (BITMAP *)graphics[2].dat, int(ship[z].shot[i].x), int(ship[z].shot[i].y));
        if (check_pp_collision((BITMAP *)graphics[2].dat, rotate[o], int(ship[z].shot[i].x), int(ship[z].shot[i].y), int(ship[o].x), int(ship[o].y)) == 1)
        {
          create_explosion(int(ship[z].shot[i].x) - 5, int(ship[z].shot[i].y) - 5, 1);
          ship[o].health -= 5;
          ship[z].shot[i].exist = 0;
          ship[z].shot[i].time = 0;
        }
      }
      i++;
    }
    if (ship[z].missile.exist == 1)
    {
      ship[z].missile.time--;
      if (ship[z].missile.time <= 0)
      {
        create_explosion(int(ship[z].missile.x), int(ship[z].missile.y), 0);
        ship[z].missile.exist = 0;
      }
      ship[z].missile.frame += 1;
      if (ship[z].missile.frame > 2)
      {
        ship[z].missile.frame = 0;
      }
      ship[z].missile.rot += rotate_to_target(ship[z].missile, ship[o]);
      if (ship[z].missile.rot > 256)
      {
        ship[z].missile.rot -= 256;
      }
      if (ship[z].missile.rot < 0)
      {
        ship[z].missile.rot += 256;
      }
      x = cos(float(ship[z].missile.rot) * pi / 128);
      y = sin(float(ship[z].missile.rot) * pi / 128);
      if (abs(ship[z].missile.xv + x) < SHOT_XV + 1)
      {
        ship[z].missile.xv += x;
      }
      if (abs(ship[z].missile.yv + y) < SHOT_YV + 1)
      {
        ship[z].missile.yv += y;
      }
      ship[z].missile.x += ship[z].missile.xv;
      ship[z].missile.y += ship[z].missile.yv;
      if (ship[z].missile.x > 640)
      {
        ship[z].missile.x -= 655;
      }
      else if (ship[z].missile.x < -15)
      {
        ship[z].missile.x += 640;
      }
      if (ship[z].missile.y > 480)
      {
        ship[z].missile.y -= 495;
      }
      else if (ship[z].missile.y < -15)
      {
        ship[z].missile.y += 480;
      }
      rotate_sprite(missilerot, (BITMAP *)missile[ship[z].missile.frame].dat, 0, 0, itofix(ship[z].missile.rot));
      draw_sprite(back_buffer, missilerot, int(ship[z].missile.x), int(ship[z].missile.y));
      if (check_pp_collision(missilerot, rotate[o], int(ship[z].missile.x), int(ship[z].missile.y), int(ship[o].x), int(ship[o].y)) == 1)
      {
        create_explosion(int(ship[z].missile.x), int(ship[z].missile.y), 0);
        ship[o].health -= 25;
        ship[z].missile.exist = 0;
      }
    }
    z++;
  }
}





void draw_stats()
{
  if (ship[0].health > 0)
  {
    sprintf(msg, "%-1d", ship[0].health);
    textout(back_buffer, font, msg, 5, 5, 15);
    hline(back_buffer, 30, 7, 319 + ((ship[0].health - 100) * 3), 12);
    if (ship[0].power[0] > 0)
    {
      sprintf(msg, "%-1d", ship[0].power[0]);
      textout(back_buffer, font, msg, 5, 15, 15);
    }
  }
  if (ship[1].health > 0)
  {
    sprintf(msg, "%-1d", ship[1].health);
    textout_right(back_buffer, font, msg, 635, 5, 15);
    hline(back_buffer, 610, 7, 321 - ((ship[1].health - 100) * 3), 10);
    if (ship[1].power[0] > 0)
    {
      sprintf(msg, "%-1d", ship[1].power[0]);
      textout_right(back_buffer, font, msg, 635, 15, 15);
    }    
  }
}





int rotate_to_target(cannon m, duelship t)
{
  float q = atan2((m.y - t.y), (m.x - t.x));
  float w = float(m.rot);
  q *= 128 / pi;
  while (q < 0)
  {
    q += 256;
  }
  if (m.x < t.x)  //I couldn't explain how this code works if my life depended on it.
  {
    w += 128;
    while (w > 256)
    {
      w -= 256;
    }
    if (q < w)
    {
      return -4;
    }
    else
    {
      return 4;
    }
  }
  else
  {
    q += 128;
    while (q > 256)
    {
      q -= 256;
    }
    if (q < w)
    {
      return -4;
    }
    else
    {
      return 4;
    }
  }
}





void create_powerup()
{
  int i = 0;
  int z = -1;
  while (i < MAX_POWUPS)
  {
    if (powerup[i].exist == 0)
    {
      z = i;
      i = MAX_POWUPS;
    }
    i++;
  }
  if (z != -1)
  {
    powerup[z].exist = 1;
    powerup[z].x = 10 + rand()%610;
    powerup[z].y = 20 + rand()%445;
    powerup[z].type = rand()%3;
  }
}





void draw_powerups()
{
  int i = 0;
  while (i < MAX_POWUPS)
  {
    if (powerup[i].exist == 1)
    {
      draw_sprite(back_buffer, (BITMAP *)graphics[POWDAT + powerup[i].type].dat, powerup[i].x, powerup[i].y);
    }
    i++;
  }
}





void activate_powerup(int s, int type)
{
  switch(type)
  {
    case 0:  //missile
      ship[s].power[0]++;
      break;
    case 1:  //triple fire
      ship[s].power[1] = 1;
      break;
    case 2:  //repair pack
      ship[s].health += 30;
      if (ship[s].health > 100)
      {
        ship[s].health = 100;
      }
      break;
  }
}





void create_explosion(int x, int y, int type)
{
  int i = 0;
  int z = -1;
  while (i < MAX_EXPLOSIONS)
  {
    if (explosion[i].exist == 0)
    {
      z = i;
      i = MAX_EXPLOSIONS;
    }
    i++;
  }
  if (z != -1)
  {
    explosion[z].exist = 1;
    explosion[z].x = x;
    explosion[z].y = y;
    explosion[z].frame = 0;
    explosion[z].type = type;
  }
}





void draw_explosions()
{
  int i = 0;
  while (i < MAX_EXPLOSIONS)
  {
    if (explosion[i].exist == 1)
    {
      switch(explosion[i].type)
      {
        case 0:  //medium explosion
          draw_sprite(back_buffer, (BITMAP *)medexp[int(explosion[i].frame)].dat, explosion[i].x, explosion[i].y);
          explosion[i].frame += .5;
          if (int(explosion[i].frame) > 14)
          {
            explosion[i].exist = 0;
          }
          break;
        case 1:  //small explosion
          draw_sprite(back_buffer, (BITMAP *)smallexp[int(explosion[i].frame)].dat, explosion[i].x, explosion[i].y);
          explosion[i].frame += .5;
          if (int(explosion[i].frame) > 8)
          {
            explosion[i].exist = 0;
          }
          break;
      }
    }
    i++;
  }
}
