/***********************************************************************************
Project: Duel 2
By FrankyR (Richard Cassan)
Email: FrankyR_ca@yahoo.ca
Webpage: http://www.geocities.com/frankyr_ca

Note on the code: it is not yet fully commented as of now, and I may or may not be commenting 
it any more in the near future, so please don't complain, I commented it a bit. 

5034
************************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include "allegro.h"
//#include "winalleg.h"
#include "aldumb.h"
//#include <ppcol.h>
#include "CAnim.h"
#include "wdisplay.h"
//#include "jgmod.h"
#include "logo.h"

#include "duel2_story.h"
#include "duel2_defines.h"

#include "CStarfield.h"
#include "CCountdown.h"
#include "CParts.h"
#include "CExplosion.h"
#include "CWalls.h"
#include "CProjs.h"
#include "CWep.h"
#include "CPowerups.h"
#include "CAsteroids.h"
#include "CShip.h"
#include "CHighscores.h"

#include "duel2.h"

#define TARGET_FPS  30
#define BPS 30

volatile int msec,sec;
int cycles=0;
int esc=0;
int out=0;

int playing_game=0;
int editing=0;
int game_mode=0;
int paused=0;
int number_of_maps=0;

int current_mod=0;
int number_of_mods=0;

int kills=0;

//JGMOD *song;
DUH *current_song;
AL_DUH_PLAYER *mod_player;

float timer=0;

void startup(void);
void one_loop(void);
void go_sec(void);

void draw_all(void);
void move_all(void);
int check_dead(int n);
void get_keys_player1(void);
void get_keys_player2(void);

void menu(void);
int menu_move(int *selection);
void menu_draw(int selection);
void play_story(void);
void init_all(void);

void select_map(void);

void create_powerup(float x, float y, int n);
void equip(int ship_no, int weapon, int amount);
void asteroid_level_up(void);
void create_new_asteroids(int n);
void show_scores(void);

void add_random_powerup(int time, CWalls *walls);

int display_countdown(BITMAP *backgr, int x, int y);
void end_game(void);
void next_song(void);



int ast_level=0, ast_score=0, old_ast_score=0;
int next_level_wait=0;

BITMAP *backgr, *black;
DATAFILE *data, *story;

BITMAP *textures[20], *texture;

PALETTE pal;

RGB red={255,0,0};


CParts parts;
CShip ship[40];
CProjs projs;
CWalls walls, maps[20];
CPowerups powerups;
wdisplay messages;
CAsteroids asteroids;
CStarfield starfield;
CCountdown countdown;
logo openin;


CHighscores missile_scores, one_drone, two_drone, asters, two_asters,aster_avoid;

CAnim s_pic;

int number_of_ships=1;
int number_of_textures=0;

int countdown_on=0;

void go_sec()
	{
    msec++;
    sec++;
	}
END_OF_FUNCTION(go_sec);

int logo_on=1;
int story_on=1;

void play_song(char *filename)
{
    if(current_song)
    {
        //unload the current song
        al_stop_duh(mod_player);
        unload_duh(current_song);
        current_song=0;
    }    
    current_song= dumb_load_xm(filename);
    mod_player=al_start_duh(current_song, 2, 0,0.8f, 512, 10000); 
      
}   
int incr;
int count;
//DWORD skFlags;

/*void restoreSK(void)
{
    STICKYKEYS info;
    info.cbSize=sizeof(STICKYKEYS);
    bool result = SystemParametersInfo(
      SPI_GETSTICKYKEYS,   // get mouse information 
      sizeof(STICKYKEYS),              // size of the structure
      &info,    // holds mouse information
      0);             // not used 

    if( result )
    {
      info.dwFlags = skFlags;

      SystemParametersInfo(
      SPI_SETSTICKYKEYS,   // get mouse information 
      sizeof(STICKYKEYS),              // size of the structure
      &info,    // holds mouse information
         0);  
    }  
}  */      

int main(void)
	{
 
//SPI_GETSTICKYKEYS
    /*STICKYKEYS info;
    info.cbSize=sizeof(STICKYKEYS);
    bool result = SystemParametersInfo(
      SPI_GETSTICKYKEYS,   // get mouse information 
      sizeof(STICKYKEYS),              // size of the structure
      &info,    // holds mouse information
      0);             // not used 

    if( result )
    {
        skFlags = info.dwFlags;      //save the old state of the flags
        
        FILE *t = fopen("SKset","rt");
        if(t)
        {
            if(!feof(t))
            {
                fscanf(t,"%d",&skFlags);
            } 
            fclose(t);      
        }    

       
       
      info.dwFlags &= (!SKF_HOTKEYACTIVE);

      FILE *f =fopen("SKset","wt");
      if(f)
      {
          fprintf(f,"%d",skFlags);
          fclose(f);
      }        

      SystemParametersInfo(
      SPI_SETSTICKYKEYS,   // get mouse information 
      sizeof(STICKYKEYS),              // size of the structure
      &info,    // holds mouse information
         0);   
        atexit(&restoreSK);
    }*/

     startup();

	 missile_scores.load_scores("duel2_highscores/missile.hs");
	 one_drone.load_scores("duel2_highscores/one_drone.hs");
	 two_drone.load_scores("duel2_highscores/two_drone.hs");
	 asters.load_scores("duel2_highscores/asters.hs");
	 two_asters.load_scores("duel2_highscores/two_asters.hs");
	 aster_avoid.load_scores("duel2_highscores/aster_avoid.hs");

	 current_mod=rand()%number_of_mods;

	 //song=load_mod("music/Wb.xm");
	 play_song("music/Wb.xm");
	 //play_mod(song,FALSE);
    //try{

	 while(logo_on==1)
	 {
		while(sec>cycles && logo_on==1)
		{
		    al_poll_duh(mod_player);
		    cycles++;
			rectfill(backgr,0,0,640,480,0);

			if(openin.move()==1)
				logo_on=0;


			openin.draw(backgr);

			blit(backgr,screen,0,0,0,0,640,480);
		}
	 }
	 rectfill(backgr,0,0,640,480,0);
	 
     cycles=0;
     sec=0;

    while (out==0)
    {

        //menu, etc.
        play_story();
	    menu();
        // if(esc==1)
        //   out=1

        incr=(int)((1/(float)TARGET_FPS) * (float)BPS);
        count=msec+incr;
        while(esc==0)  //when not trying to leave game
        {
            al_poll_duh(mod_player);
            if( (msec>=(int)floor(count)) && esc==0)      //regulates time
            {
                one_loop();
                count=msec + incr;
            }
        }
    }

	 missile_scores.save_scores("duel2_highscores/missile.hs");
	 one_drone.save_scores("duel2_highscores/one_drone.hs");
	 two_drone.save_scores("duel2_highscores/two_drone.hs");
	 asters.save_scores("duel2_highscores/asters.hs");
	 two_asters.save_scores("duel2_highscores/two_asters.hs");
	 aster_avoid.save_scores("duel2_highscores/aster_avoid.hs");

    al_stop_duh(mod_player);
    if(current_song)
        unload_duh(current_song);
        
	destroy_bitmap(backgr);
	//destroy_bitmap(texture);
	/*for(int n=0 ; n<20 ; n++)
	{
	    if(textures[n])
		  destroy_bitmap(textures[n]);
    } */   

	for(int n=0 ; n<20 ; n++)
		ship[n].destroy();
	projs.dest();
	parts.dest();
	powerups.dest();

	unload_datafile(data);

	allegro_exit();
    /*} catch(int e)
    {
        restoreSK();   
    }  
    
      FILE *f =fopen("SKset","wt");
      if(f)
      {
          fprintf(f,"");  //clear the file
          fclose(f);
      }*/     
    }
END_OF_MAIN();


void startup(void)
     {
     char * noise;
     int x,y;
     allegro_init();
     install_keyboard();
     install_timer();
     install_mouse();

     set_color_depth(16);

     set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
     
      atexit(&dumb_exit);
     dumb_register_stdfiles();
     
	 //reserve_voices(20,-1);
     if(install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL)<0)
     {
     exit(0);
     }

     /*if(install_mod(16)<0)
     {
     exit(0);
     }*/

     srand(time(0));


	 data=load_datafile("duel2.dat");
	 story=load_datafile("duel2_s.dat");
	 

     backgr=create_bitmap(SCREEN_W,SCREEN_H);
	 black=create_bitmap(SCREEN_W,SCREEN_H);

	 rectfill(backgr,0,0,SCREEN_W,SCREEN_H,0);

	 number_of_mods=3;

	 s_pic.init();


	 //creates a sheild animation
	 for(int n=0 ; n<4 ; n++)
		s_pic.add_bmp((BITMAP*)data[s1+n].dat);



	 //create number for the countdown
	 number oone={0,0,1,(BITMAP*)data[one_pic].dat,(SAMPLE*)data[countdown_sound].dat};
	 number ttwo={0,0,1,(BITMAP*)data[two_pic].dat,(SAMPLE*)data[countdown_sound].dat};
	 number tthree={0,0,1,(BITMAP*)data[three_pic].dat,(SAMPLE*)data[countdown_sound].dat};
	 number ggo={0,0,1,(BITMAP*)data[go_pic].dat,(SAMPLE*)data[countdown_end].dat};

	 //initalize the countdown with the above numbers
	 countdown.init(oone,ttwo,tthree,ggo);

	 init_all();

	 for(int n=0 ; n<20 ; n++)	//initalizes 20 blank maps
		 maps[n].init();

	 //loads up all of the maps
	 maps[0].load("duel2_maps/test.map");
	 maps[1].load("duel2_maps/test2.map");
	 maps[2].load("duel2_maps/test3.map");
	 maps[3].load("duel2_maps/test4.map");
	 maps[4].load("duel2_maps/test5.map");
	 maps[5].load("duel2_maps/test6.map");
	 maps[6].load("duel2_maps/test7.map");
	 number_of_maps=7;

	 number_of_maps++;		//an empty map

	 walls=maps[0];			//default game map to map 0


	 textures[0]=(BITMAP*)data[texture1].dat;
	 textures[1]=(BITMAP*)data[texture2].dat;
	 number_of_textures=2;

	 textures[number_of_textures]=NULL;
	 number_of_textures++;

	 texture=textures[0];	//default game texture to texture 0


	 missile_scores.init("Missile Avoid",0);	//0 means sort descending, 1 means sort ascending
     one_drone.init("One Player Drone Kill",0);
	 two_drone.init("Two Player Drone Kill",0);
	 asters.init("One Player Asteroids",0);
	 two_asters.init("Two Player Asteroids",0);
	 aster_avoid.init("Asteroid Avoid",0);


	 //init the starfield to be displayed
	 starfield.init();


	 //init the opening logo animation
	 openin.init(load_bmp("logo.bmp",(RGB*)pal),load_sample("thund.wav"),SCREEN_W,SCREEN_H);

	 //set_mod_volume(180);

	 playing_game=1;

	 set_mouse_range(0,0,639,429);

     LOCK_VARIABLE(sec);
     LOCK_FUNCTION(go_sec);


	//set_trans_blender(100,100,200,100);

	//install_int_ex(go_sec, BPS_TO_TIMER(40));
	install_int_ex(go_sec, BPS_TO_TIMER(BPS));
}



int check_dead(int n)	//checks to see if ship n has 'died' and does everything needed
{
	int ret=0;
	int x,y;
	int again=0;


	if(ship[n].check_dead()==1)  //1 means it just died
	{
		//make an explosion
		parts.create_explosion2(ship[n].ret_x(1),ship[n].ret_y(1),50,(SAMPLE*)data[explode1].dat);

		//if the player is human controlled, respawn it. If it's out of lives, the function
		//respawn will return 1 if the ship has no lives left, otherwise it returns 0.
		if(n==0 && ship[0].ret_ai()==0)
            {
            if(game_mode==6 || game_mode==7 || game_mode==8)   //if playing asteroids
			     ret=ship[0].respawn(330,240);
            else
                ret=ship[0].respawn(590,350);
            }

		else if(n==1 && ship[1].ret_ai()==0)
            {
            if(game_mode==6 || game_mode==7)   //if playing asteroids
			     ret=ship[1].respawn(300,240);
            else
                ret=ship[1].respawn(50,350);
            }

		//if the ship is ai controlled, and the game mode is 4 or 2 (drone kill games) 
		else if(ship[n].ret_ai()==1 && (game_mode==4 || game_mode==2))	//ai ship during during drone kill
		{

			ret=1000;	//the return value is set to 1000 to say that an ai ship was respawned
			do
			{
				//make a random position for the ship
				x=rand()%500;
				x+=40;
				y=rand()%300;
				y+=40;

				//go through all of the other ships
				for(int n2=0 ; n2<number_of_ships ; n2++)
				{
					if(n!=n2)
					{
						//and make sure it is not about to be respawned on top of another ship
						again=ship[n].check_col_with_ship(&ship[n2]);
						//check_col_with_ship will return 1 if they are colliding
					}
				}

			}
			//keep going through the loop untill again=0 (the ship is not colliding with another)
			while(again==1);


			ship[n].respawn(x,y);	//respawn the ship to the chosen position
			ship[n].set_life(30);	//set it's life to 30 (full life for a drone)

			//variables for making the circle of parts when an ai ship is respawned
			float dx,dy;
			float ang=0;
			RGB col={200,200,0};
			

			for(int n=0 ; n<360 ; n++)	//go through a full circle
			{
				if(n%2==0)
				{
					//make it green one time
					col.r=200;
					col.g=200;
					col.b=0;
				}
				else
				{
					//and make it cyan the time
					col.r=0;
					col.g=200;
					col.b=200;
				}

				
				ang=Degree*n;	//get the angle for the particle to be shot at
				dy=-cos(ang);	//set the dx
				dx=sin(ang);	//and the dy based on the angle

				//create a new part with the above info
				parts.create_new(x,y,col,dx,dy,1,4);
			}

		}

	}

	//return the ret value
	//1 means that a human ship ran out of lives
	//0 means that a human ship either didn't die, or was respawned
	//1000 means that an ai ship was respawned
	return ret;
}

void move_all(void)
{
	int hit=0;		//hit keeps track of whether or not two ships collided
	int dead_ret=0;	
	int powerup_num=0;

	parts.move_all();
	projs.move_all(&parts);
	projs.check_col_with_walls(&walls,&parts);

	//goes through all of the ships
	for(int n1=0 ; n1<number_of_ships ; n1++)
		for(int n2=0 ; n2<number_of_ships ; n2++)
		{
			if(n1!=n2)	//don't check it the ships is hitting itself
			{
				//make all of ship[n1]'s homing projectiles home onto ship[n2]'s position
				projs.home_all(ship[n2].ret_x(0),ship[n2].ret_y(0),n1);

				if(game_mode!=5) //in missile avoid ships don't hit each other
				{
					//check for collision between ship[n1] and ship[n2] 
					//this function takes care of all the damage done, and physics of the collision
					//if two ships hit each other, 'hit' is set to 1
					hit=ship[n1].check_col_with_ship(&ship[n2]);
				}
			}

			//hit 1 means two ships hit
			//game mode 1 equals tag
			if(hit==1 && game_mode==1)
			{
				//so if they are plaing tag, and the ships hit, the game should toggle the 'it' status 
				//of both of the ships.
				ship[0].toggle_it();
				ship[1].toggle_it();;
			}
		}

	//goes through all of the ships
	for(int n=0 ; n<number_of_ships ; n++)
	{
		//mvoe the ship accorinding to it's current momentum (dx, dy)
		ship[n].move();

		//check to see if it has hit any walls (the function handels all aspects of the collision)
		ship[n].check_col_with_walls(&walls);

		//check to see if any projectiles has hit the ship
		//the parts are passed for the sake of any explosions
		ship[n].check_col_with_projs(&projs, &parts);

		//gets the number of any powerup the ship collected (0 means no collision)
		//the function handel the powerup if it is collected
		powerup_num=ship[n].check_col_with_powerups(&powerups, &parts);
		

		//if the player is playing asteroids, check for collision will asteroids
		if(game_mode==6 || game_mode==7 || game_mode==8)
			ship[n].check_col_with_asteroids(&asteroids, &parts);

		//display appropriate message for the powerup
		if(powerup_num==1)
			messages.set_message("Triple Shot Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==2)
			messages.set_message("Spread Shot Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==3)
			messages.set_message("Spray Shot Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==4)
			messages.set_message("Wrath Missiles",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==5)
			messages.set_message("Homing Missiles",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==6)
			messages.set_message("Rebound Shot Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==7)
			messages.set_message("Gatling Gun Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==9)
			messages.set_message("Reverse Tri-Shot Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==10)
			messages.set_message("4 Dir Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==11)
			messages.set_message("Stun Shot Ammo",SCREEN_W/2,SCREEN_H,0,-4);
		else if(powerup_num==12)
			messages.set_message("Mines",SCREEN_W/2,SCREEN_H,0,-4);



		//check to see if the ship has been destroyed (respawns if neccessary)
		dead_ret=check_dead(n);

		if(game_mode==7)	//2 player asteroids
		{
			if( ship[0].is_alive()==0 && ship[1].is_alive()==0 )
				end_game();
		}
		//if a ship is out of lives, and that ship is not ai controlled, pause the game
		else if(dead_ret==1 && ship[n].ret_ai()==0)
		{
			end_game();
		}

		//dead_ret 1000 means that a drone has been killed
		else if(dead_ret==1000)
			kills++;	//increase the kill counter

		//updates that values for the ship's old_dx and old_dy
		ship[n].update_old_d();

		//if ship is ai controlled
		if(ship[n].ret_ai()==1)
		{
			if(game_mode==5)	//if the game is missile avoid
			{
				//tell the ai ship to shoot every 40 cycles
				ship[n].ai_shoot(40,&projs);

				//tell it to continue rotating
				ship[n].ai_rotate();
			}
			else if(game_mode==4 || game_mode==2)	//if the game move is a drone kill mode
			{
				//get the drone to move aimlessly around the screen
				ship[n].drone_move();
                //if(n==0)
                //    ship[n].drone_move(&ship[0],&projs);
			}
		}



	}


	//if the game mode is asteroids
	if(game_mode==6 || game_mode==7)
	{
		//check to see if any asteroids have collided with any projectiles
		//this functoin takes care of everything needed
		if(asteroids.check_col_with_projs(&projs,&parts)==1)
			//if so, increase the game score
			ast_score+=50;


		//give a life up every 8500 points to up to 85 000 points
		for(int m=1 ; m<10 ; m++)
		{
			//checks to see if last loop the asteroids score was below the amount to get a life
			//upm and this loop it is above or equal the amount to get a live up
			if(old_ast_score<8500*m && ast_score>=8500*m)
			{
				messages.set_message("Life Up!",SCREEN_W/2,SCREEN_H,0,-4);
				for(int n=0 ; n<number_of_ships ; n++)	//give every ship a life
				{
					if(ship[n].is_alive()==1)	//as long as it is alive
						ship[n].up_lives();
				}
			}
		}
	

		//move all of the asteroids
		asteroids.move_all();

		//if there are no asteroids left
		if(asteroids.check_all()==0)
		{
			if(next_level_wait==0)
				//set wait for next level to 60 cycles
				next_level_wait=60;

			//and level up the asteroids game
			asteroid_level_up();
		}

		if(next_level_wait>0)
			next_level_wait--;

	}
	
	if(game_mode==8)   //asteroids avoid
	{
	    //move all of the asteroids
		asteroids.move_all();
	}

	if(game_mode==1 || game_mode==4 || game_mode==2)	//if playing tag or drone kill
		timer-=0.025;	//timer counts down

	else if(game_mode==5 || game_mode==8)		//playing missile avoid or asteroid avoid
		timer+=0.025;	//timer counts up

	if(game_mode==0)									//playing duel
		add_random_powerup(800, &walls);//add a new powerup every 800 cycles

	if(timer<=0)						
	{
		if(game_mode==1 || game_mode==4 || game_mode==2)	//games with a timer
			end_game();
	}

	old_ast_score=ast_score;

	starfield.move();	//move the entire starfield

}

void draw_all(void)
{
	starfield.draw(backgr);

	parts.draw_all(backgr,0,0);		//draw all of the particles
	projs.draw_all(backgr,0,0);		//draw all of the projectiles
	walls.draw_all(backgr,texture);	//draw all of the walls

	powerups.draw_all(backgr,&parts);	//draw all of the powerups

	for(int n=0 ; n<number_of_ships ; n++)
	{
		ship[n].draw(backgr,0,0);

	}

	if(game_mode==6 || game_mode==7 || game_mode==8)	//game modes 6 and 7 are asteroid games
		asteroids.draw_all(backgr,0,0);

	//the cool loking bar at the bottom of the screen
	draw_sprite(backgr,(BITMAP*)data[info_bar].dat,0,430);


	if(ship[0].ret_ai()==0)	//if ship 0 is not at controlled
		ship[0].draw_life(backgr,420,430,(FONT*)data[f1].dat,red);	//draw it's life


	if(number_of_ships>=2)	//if there are at least 2 ships
		if(ship[1].ret_ai()==0)	//and ship 1 is not ai controlled
			ship[1].draw_life(backgr,5,430,(FONT*)data[f1].dat,red);	//draw it's life

	if(game_mode==1 || game_mode==5 || game_mode==4 || game_mode==2 || game_mode==8) //if playing a timed mode
	{
		textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,0,makecol(0,255,0),-1,"%0.0f",timer);
		if(game_mode==4 || game_mode==2)	//if playing drone kill
			textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,25,makecol(0,200,0),-1,"%d",kills);
	}

	if(game_mode==6 || game_mode==7)	//6 and 7 are asteroid game modes
	{
		//write the asteroids score, and level
		textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,0,makecol(0,255,0),-1,"Score %d",ast_score);
		textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,30,makecol(0,200,0),-1,"Level %d",ast_level);
	}

	//write any messages
	messages.write_message(backgr,(FONT*)data[f1].dat,red);

	//if countdown is on (3,2,1,go at the start of a game)
	if(countdown_on==1)
	{
		countdown.draw(backgr);
		paused=1;	//the game is paused
	}


}

void get_keys_player1(void)
{
	if(key[KEY_UP])
	{
		ship[0].move_forward();
		ship[0].create_exaust(&parts);
	}

	if(key[KEY_LEFT])
		ship[0].turn_left();
	if(key[KEY_RIGHT])
		ship[0].turn_right();

	if(key[KEY_RCONTROL])
        {
		ship[0].shoot(&projs);
        }

	if(key[KEY_BACKSLASH] || key[KEY_RSHIFT])
		ship[0].switch_weapon();
}


void get_keys_player2(void)
{
	if(key[KEY_W])
	{
		ship[1].move_forward();
		ship[1].create_exaust(&parts);
	}

	if(key[KEY_A])
		ship[1].turn_left();
	if(key[KEY_D])
		ship[1].turn_right();

	if(key[KEY_LCONTROL])
        {
		ship[1].shoot(&projs);
        }

	if(key[KEY_TAB] || key[KEY_LSHIFT])
		ship[1].switch_weapon();
}



void draw_editing(void);
void work_editing(void);
void create_rect(int x1, int y1, int x2, int y2);
void draw_grid(void);

int mdown=0;
int top_x=0,top_y=0;
int draw_box=0;
int draw_g=0;

int mx=0,my=0;

int grid_size=10;


void draw_grid(void)
{
	for(int x=0 ; x<SCREEN_W ; x+=grid_size)
		line(backgr,x,0,x,430,makecol(100,0,0));


	for(int y=0 ; y<430 ; y+=grid_size)
	{
		line(backgr,0,y,SCREEN_W,y,makecol(100,0,0));
	}
}

void draw_editing(void)
{
	//draws the walls

	walls.draw_all(backgr,(BITMAP*)data[texture2].dat/*NULL*/);

	for(int n=0 ; n<number_of_ships ; n++)
	{
		ship[n].draw(backgr,0,0);

	}

	if(draw_g==1)
		draw_grid();

	rectfill(backgr,0,430,639,479,makecol(100,0,0));

	if(draw_box==1)
		rect(backgr,top_x,top_y,mx,my,makecol(0,0,255));

	circlefill(backgr,mx,my,2,makecol(0,255,0));
}





void work_editing(void)
{
	mx=mouse_x/grid_size;
	my=mouse_y/grid_size;

	mx*=grid_size;
	my*=grid_size;

	//if clicking mouse, and it is not already down
	if(mouse_b==1 && mdown==0)
	{
		mdown=1;
		top_x=mx;
		top_y=my;
		draw_box=1;
	}

	//if releaseing mouse
	else if(mouse_b==0 && mdown==1)
	{
		create_rect(top_x,top_y,mx,my);
		draw_box=0;
		top_x=0;
		top_y=0;
		mdown=0;
	}

	if(key[KEY_G])
	{
		if(draw_g==0)
			draw_g=1;
		else if(draw_g==1)
			draw_g=0;

		rest(100);
	}

	if(key[KEY_S])
		walls.save("duel2_maps/test8.map");

	if(key[KEY_L])
		walls.load("duel2_maps/test.map");

	if(key[KEY_UP] && grid_size<50)
		grid_size++;
	else if(key[KEY_DOWN] && grid_size>2)
		grid_size--;

}

void create_rect(int x1, int y1, int x2, int y2)
{
	int temp=0;

	if(x1>x2)
	{
		temp=x2;
		x2=x1;
		x1=temp;
	}
	if(y1>y2)
	{
		temp=y2;
		y2=y1;
		y1=temp;
	}

	walls.new_rect(x1,y1,x2,y2);
}

void one_loop(void)
	{
    cycles++;
    rectfill(backgr,0,0,SCREEN_W,SCREEN_H,0);

    if(key[KEY_ESC])
       esc=1;

	else if(playing_game==1)
	{
		if(paused==0)
			move_all();

		messages.move_message();

		draw_all();

		if(key[KEY_Q])
		{
			BITMAP *shot;
			PALETTE pal;

			get_palette(pal);

			shot=create_sub_bitmap(screen,0,0,SCREEN_W,SCREEN_H);

			save_bmp("duel_shot.bmp",shot,pal);

			destroy_bitmap(shot);
		}

		if(countdown_on==1)
			if(countdown.move()==1)
			{
				countdown_on=0;
				paused=0;
				rectfill(backgr,0,0,640,480,255);
			}

		if(paused==0)
		{
			//only allow ship to be controlled if it is alive
			if(ship[0].is_alive()==1)
				get_keys_player1();

			//only allow play 2 to control ship if it is not ai controlled, and is alive
			if(ship[1].ret_ai()==0 && ship[1].is_alive()==1)
				get_keys_player2();
		}
	}

	if(key[KEY_P])
	{
		editing=1;
		playing_game=0;
	}
	else if(key[KEY_O])
	{
		editing=0;
		playing_game=1;
	}


	if(editing==1)
	{
		draw_editing();

		work_editing();
	}

	if(/*is_mod_playing()==FALSE*/duh_get_length(current_song) == al_duh_get_position(mod_player) || al_duh_get_position(mod_player)==-1 )
	{
		next_song();
	}

	if(esc==0)	//only draw to screen if the person is not quitting
		blit(backgr,screen,0,0,0,0,SCREEN_W,SCREEN_H);
    }

//get the length of the hypotenuse of a right angle triangle
float get_dist(float x1,float y1,float x2,float y2)
	{
     float tx,ty,td;
     tx=x1-x2;
     ty=y1-y2;
     tx*=tx;
     ty*=ty;
     tx+=ty;
     td=sqrt(tx);
     return(td);
    }




void menu(void)
{
	//set_trans_blender(255,255,255,255);
	
	 int trans_amount=255;
     int selection=0;   //number for which option is selected
     int end_menu=0; //flag set to one when the menu is exited
	 //int change_selection_wait=0;


     sec=0;
     cycles=0;
	 paused=0;

	 if(esc==1)
	 {
		 /*destroy_mod(song);
		 song=load_mod("music/Wb.xm");
		 play_mod(song,FALSE);*/
		 play_song("music/Wb.xm");
	 }

	//save the highscores every time the menu starts
    missile_scores.save_scores("duel2_highscores/missile.hs");
	one_drone.save_scores("duel2_highscores/one_drone.hs");
	two_drone.save_scores("duel2_highscores/two_drone.hs");
	asters.save_scores("duel2_highscores/asters.hs");
	two_asters.save_scores("duel2_highscores/two_asters.hs");
	aster_avoid.save_scores("duel2_highscores/aster_avoid.hs");

    play_sample((SAMPLE*)data[countdown_end].dat,100,125,1000,FALSE);

     while(key[KEY_ENTER]) {}

     incr=(int)((1/(float)TARGET_FPS) * (float)BPS);
     count=msec+incr;
     
    while(end_menu==0)
    {
        al_poll_duh(mod_player);
        if(msec>=(int)floor(count))
		{
            
            end_menu = menu_move(&selection);
            count=msec + incr;
      	}
          	
        menu_draw(selection);


    }

       if(selection==0)	//play duel
         {
		   esc=0;
		   game_mode=0;
		   number_of_ships=2;
		   init_all();

		   select_map();

		   //sets game mode at zero (duel mode)
		   ship[0].set_game_mode(0);
		   ship[1].set_game_mode(0);		   


		   //sets starting lives at 7 for a match of duel
		   ship[0].set_lives(7);
		   ship[1].set_lives(7);
         }
       else if(selection==1) //play tag
         {
		   esc=0;
		   game_mode=1;
		   number_of_ships=2;
		   init_all();

		   select_map();

		   //sets game mode at one (tag mode)
		   ship[0].set_game_mode(1);
		   ship[1].set_game_mode(1);

		   //give the player a virtually unlimited number of lives
		   ship[0].set_lives(1000);
		   ship[1].set_lives(1000);

			//set the ship 0 to 'it'
		   ship[cycles%2].it=1;

		   //sets the timer for the match to 180 sec (3 min)
		   timer=180;
         }

	   else if(selection==2)	//drone kill
	   {
		   float num=0;

		   esc=0;
		   game_mode=2;			//game mode is 3

		   kills=0;


		   number_of_ships=11;
		   init_all();

		   ship[0].set_game_mode(2);
		   ship[1].set_game_mode(2);

		   //give both player 99 lives (so they won't die)
		   ship[0].set_lives(99);
		   ship[1].set_lives(99);

		   num=600/number_of_ships;

		   for(int n=2 ; n<number_of_ships ; n++)
		   {

			   ship[n].set_ai(1);

			   ship[n].set_game_mode(2);

				ship[n].set_life(30);
	            ship[n].set_lives(99);

			   ship[n].set_pos(n*num+10,200);
		   }

		   equip(0,0,9000);	//give player a standard gun
		   equip(1,0,9000);	//give player a standard gun

		   walls=maps[1];  

		   timer=180;
	   }
	   else if(selection==3)	//2 player asteroids
	   {
		   esc=0;
		   game_mode=7;

		   number_of_ships=2;
		   init_all();

		   equip(0,0,9000);
		   equip(1,0,9000);

		   ship[0].set_game_mode(6);

		   walls=maps[number_of_maps];

		   next_level_wait=30;

		   asteroid_level_up();
	   }

	   else if(selection==4)	//drone kill
		{
		   float num=0;

		   esc=0;
		   game_mode=4;			//game mode is 4

		   kills=0;


		   number_of_ships=10;
		   init_all();

		   ship[0].set_game_mode(5);
		   ship[0].set_lives(99);

		   num=600/number_of_ships;

		   for(int n=1 ; n<number_of_ships ; n++)
		   {
			   ship[n].set_ai(1);

			   ship[n].set_game_mode(4);
			   ship[n].set_lives(99);

				ship[n].set_life(30);

			   ship[n].set_pos(n*num+10,200);
		   }

		   equip(0,0,9000);	//give player a standard gun

		   walls=maps[1];  

		   timer=180;
	   }

	   else if(selection==5)	//missile avoid
	   {
		   esc=0;
		   game_mode=5;			//game mode is 5

		   number_of_ships=2;
		   init_all();



		   ship[1].set_ai(1);
		   equip(1,5,9000);


		   //sets game mode at five (missile avoid game)
		   ship[0].set_game_mode(5);
		   ship[1].set_game_mode(5);

		   ship[1].set_pos(SCREEN_W/2,SCREEN_H/2);

		   walls=maps[0];  

		   timer=0;
	   }

	   else if(selection==6)	//asteroids
	   {
		   esc=0;
		   game_mode=6;

		   number_of_ships=1;
		   init_all();

		   equip(0,0,9000);

		   ship[0].set_game_mode(6);

		   walls=maps[number_of_maps];

			next_level_wait=30;

		   asteroid_level_up();

	   }
	   
	   else if(selection==7) //1p asteroid avoid
	   {
	       esc=0;
		   game_mode=8;

		   number_of_ships=1;
		   init_all();

		   equip(0,0,0);   //give no ammo

		   ship[0].set_game_mode(8);

		   walls=maps[number_of_maps];

		   //next_level_wait=30;
		   
		   timer=0;

		   ast_level=8;
		   //asteroid_level_up();
		   create_new_asteroids(12);
	   }

	   else if(selection==8) //hi scores
	   {
		   show_scores();
           esc=1;
	   }

       else if(selection==9) //exit
         {
		    esc=1;
			out=1;
         }


	   if(selection!=8)
	   {
		   next_song();
	   }

       sec=0;
       cycles=0;
	   countdown_on=1;

       key[KEY_ESC]=false;
    }

int menu_move(int *selection)
{
    int end_menu=0;
    static bool pressed=false;
    cycles++;
    starfield.move();

			   
    if(key[KEY_UP] || key[KEY_DOWN] || key[KEY_ENTER])
    {
        if(pressed==false)
        {
    	if(key[KEY_UP])
      	    {
        	(*selection)--;
        	
        	play_sample((SAMPLE*)data[menu1].dat,255,128,1000,FALSE);
        	}
    	else if(key[KEY_DOWN])
        	{
        	(*selection)++;
        	
        	play_sample((SAMPLE*)data[menu1].dat,255,128,1000,FALSE);
        	}

    	if(key[KEY_ENTER])
        	{
        	end_menu=1;
        	play_sample((SAMPLE*)data[menu2].dat,255,128,1000,FALSE);
            }
        }
        pressed=true;
    }
    else
        pressed=false;        

	if((*selection)>9)
    	(*selection)=0;
	else if((*selection)<0)
    	(*selection)=9;
     
    return end_menu;    
}


void menu_draw(int selection)
{
    //rectfill(backgr,0,0,SCREEN_W,SCREEN_H,makecol(0,0,0));
    clear_to_color(backgr,makecol(0,0,0));
    starfield.draw(backgr);
    draw_sprite(backgr,(BITMAP*)data[title_pic].dat,320-((BITMAP*)data[title_pic].dat)->w/2,5);

    textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200-1,200-1,makecol(100,100,50),-1,"2 Player Games");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440-1,200-1,makecol(100,100,50),-1,"1 Player Games");

    textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,200,makecol(200,170,100),-1,"2 Player Games");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,200,makecol(200,170,100),-1,"1 Player Games");
	
		   
    textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,230,makecol(150,100,30),-1,"Duel");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,260,makecol(150,100,30),-1,"Tag");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,290,makecol(150,100,30),-1,"Drone Kill");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,320,makecol(150,100,30),-1,"Asteroids");


	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,230,makecol(150,100,30),-1,"Drone Kill");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,260,makecol(150,100,30),-1,"Missile Avoid");
	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,290,makecol(150,100,30),-1,"Asteroids");
    textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,320,makecol(150,100,30),-1,"Asteroid Avoid");

	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,360,makecol(150,100,30),-1,"Hi Scores");

	textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,390,makecol(150,100,30),-1,"Exit");

	textprintf_ex(backgr,font,0,450,makecol(200,200,200),-1,"Version 1.15 by Richard Cassan");
    textprintf_ex(backgr,font,0,460,makecol(200,200,200),-1,"http://www.ts-games.com");


	if(selection==0)
	   textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,230,makecol(200,50,0),-1,"Duel");
	else if(selection==1)
	   textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,260,makecol(200,50,0),-1,"Tag");
    else if(selection==2)
	   textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,290,makecol(200,50,0),-1,"Drone Kill");
	else if(selection==3)
	   textprintf_centre_ex(backgr,(FONT*)data[f1].dat,200,320,makecol(200,50,0),-1,"Asteroids");


    else if(selection==4)
        textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,230,makecol(200,50,0),-1,"Drone Kill");
    else if(selection==5)
        textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,260,makecol(200,50,0),-1,"Missile Avoid");
    else if(selection==6)
		textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,290,makecol(200,50,0),-1,"Asteroids");
	else if(selection==7)
        textprintf_centre_ex(backgr,(FONT*)data[f1].dat,440,320,makecol(200,50,0),-1,"Asteroid Avoid");

	else if(selection==8 /*|| selection==3*/)
        textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,360,makecol(200,50,0),-1,"Hi Scores");

	else if(selection==9 /*|| selection==3*/)
       textprintf_centre_ex(backgr,(FONT*)data[f1].dat,SCREEN_W/2,390,makecol(200,50,0),-1,"Exit"); 
        
    blit(backgr,screen,0,0,0,0,SCREEN_W,SCREEN_H);     
}        

void init_all(void)
{
	 parts.init();		//a set of parts for the game to use (exaust, explosion, etc)
	 projs.init((SAMPLE*)data[explode2].dat);		//a set of projectiles for the players to shoot
	 walls.init();		//the walls in the arena
	 powerups.init();
	 asteroids.init((SAMPLE*)data[rock_explode].dat);



	// walls.new_rect(100,100,200,200);

	 messages.init();


	 for(int n=0 ; n<number_of_ships ; n++) 
		ship[n].init((BITMAP*)data[ship4].dat,5,n, s_pic,(SAMPLE*)data[shield].dat,0);


	 ship[0].init((BITMAP*)data[ship3].dat,5, 0, s_pic,(SAMPLE*)data[shield].dat,0);

	 if(game_mode!=4 && number_of_ships>=2)
	 {
		//in 2p drone kill, or 2p asteroids, give both players the same num so they can't hurt each other
		if(game_mode==2 || game_mode==7) 
			ship[1].init((BITMAP*)data[ship1].dat,5, 0, s_pic,(SAMPLE*)data[shield].dat,0);
		else
			ship[1].init((BITMAP*)data[ship1].dat,5, 1, s_pic,(SAMPLE*)data[shield].dat,0);
	 
		ship[1].set_pos(50,350);
	 }



	 ship[0].set_pos(590,350);

	 //set_trans_blender(200,100,100,150);
	
	 //pic  damage  speed  type  max ammo   cooldown
	//equips all of the ships with all of the weapons
	 //all weapons start with zero ammo (the same as not having the weapon)
	 //they can only use the weapon after ammo is given to it (either by equipping it or
	 //picking up a powerup)
	for(int n=0 ; n<number_of_ships ; n++)
	 {
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 1  ,0  ,8,"Single Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 3  ,0  ,8,"Triple Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 4  ,0  ,8,"Spread Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 2  ,0  ,20,"Spray Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[missile].dat,   30, 4, 1  ,0  ,20,"Wrath Missile",(SAMPLE*)data[shoot_missile].dat);
		ship[n].add_wep((BITMAP*)data[missile].dat,   30, 4, 5  ,0  ,25,"Homing Missile",(SAMPLE*)data[shoot_missile].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     8,  4, 6  ,0  ,10,"Rebound Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     3,  4, 7  ,0  ,2, "Gatling Shot",(SAMPLE*)data[shoot_laser].dat);
	    ship[n].add_wep((BITMAP*)data[missile].dat,   30, 4, 8  ,0  ,35,"Rebound Homing",(SAMPLE*)data[shoot_missile].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 9  ,0  ,10,"Reverse Tri-Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 10 ,0  ,8 ,"4 Dir-Shot",(SAMPLE*)data[shoot_laser].dat);
		ship[n].add_wep((BITMAP*)data[shot1].dat,     10, 4, 12 ,0  ,10,"Stun Shot",(SAMPLE*)data[shoot_laser].dat);

		if(n==0)
			ship[n].add_wep((BITMAP*)data[mine].dat,  35, 4, 11 ,0  ,35,"Mine",(SAMPLE*)data[shoot_laser].dat);
		else if(n==1)
			ship[n].add_wep((BITMAP*)data[mine2].dat, 35, 4, 11 ,0  ,35,"Mine",(SAMPLE*)data[shoot_laser].dat);



	 }

	countdown.reset();


	if(game_mode==0 )	//equip weapons for duel
	{
		equip(0,0,1000);
		equip(0,1,200);
		equip(0,3,2);
		equip(0,4,35);

		equip(1,0,1000);
		equip(1,1,200);
		equip(1,3,2);
		equip(1,4,35);
	}

	
	ast_level=0;
	ast_score=0;

	//loads the map
	walls.load("duel2_maps/test.map");

}

void create_powerup(float x, float y, int n)
{
	//picture,type,amount,x,y

	if(n==1)	//triple shot
		//200 more triple shot ammo
		powerups.create_new((BITMAP*)data[powerup1].dat,n,200,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==2)	//spread shot
		//100 more spread shot ammo
		powerups.create_new((BITMAP*)data[powerup2].dat,n,100,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==3)	//spray shot
		//2 more spray shot ammo
		powerups.create_new((BITMAP*)data[powerup4].dat,n,2,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==4)	//wrath
		//20 more wrath missiles
		powerups.create_new((BITMAP*)data[powerup3].dat,n,20,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==5)	//homing missiles
		//10 more homing missiles
		powerups.create_new((BITMAP*)data[powerup5].dat,n,10,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==6)	//rebound laser
		//20 more rebound shots
		powerups.create_new((BITMAP*)data[powerup6].dat,n,20,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==7)	//gatling laser
		//500 more gatling laser ammo
		powerups.create_new((BITMAP*)data[powerup7].dat,n,500,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==8)	//rebound homing
		//10 more rebound homing
		powerups.create_new((BITMAP*)data[powerup8].dat,n,10,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==9)	//reverse tri
		//100 more reverse tri ammo
		powerups.create_new((BITMAP*)data[powerup12].dat,n,100,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==10)	//4-dir
		//100 more 4 dir ammo
		powerups.create_new((BITMAP*)data[powerup9].dat,n,100,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==11)	//stun shot
		//5 more stun shot ammo
		powerups.create_new((BITMAP*)data[powerup1].dat,n,5,x,y,(SAMPLE*)data[pickup].dat);

	else if(n==12)	//mines
		//10 more mines
		powerups.create_new((BITMAP*)data[powerup1].dat,n,10,x,y,(SAMPLE*)data[pickup].dat);

}

void equip(int ship_no, int weapon, int amount)
{
	ship[ship_no].set_ammo(weapon,amount);
}

void select_map(void)
{
	int end_menu=0;
	int selection=0,selection2=0;
	int stretching=0;
	float scaled=3;


	rest(100);

	while(end_menu==0)
       {
        al_poll_duh(mod_player);
        if(sec>cycles)
          {
           cycles++;
     	   rectfill(backgr,0,0,SCREEN_W,SCREEN_H,makecol(0,0,0));
		 //  rectfill(map,0,0,213,160,0);

		   //draws map onto the map bitmap
		  

			if(stretching==0)
			{
				textprintf_ex(backgr,(FONT*)data[f1].dat,250,25,makecol(0,0,255),-1,"Please Select A Map");
				textprintf_ex(backgr,(FONT*)data[f1].dat,250,50,makecol(255,0,0),-1,"Left and Right to Change Map");
				textprintf_ex(backgr,(FONT*)data[f1].dat,250,75,makecol(0,255,0),-1,"Up and Down to Change Texture");
				textprintf_ex(backgr,(FONT*)data[f1].dat,250,100,makecol(255,255,255),-1,"Enter to Continue");

				textprintf_ex(backgr,(FONT*)data[f1].dat,50,180,makecol(0,0,255),-1,"Map %d",selection+1);
				textprintf_ex(backgr,(FONT*)data[f1].dat,50,205,makecol(255,0,0),-1,"Texture %d",selection2+1);
			}


		//	stretch_blit(map,backgr,0,0,213,160,0,0,(int)(213*sw),(int)(160*sh));
			maps[selection].draw_all_scaled(backgr,textures[selection2],scaled);



			if(key[KEY_LEFT] && selection>0 && stretching==0)
			{
				selection--;
				play_sample((SAMPLE*)data[menu1].dat,255,128,1000,FALSE);
				rest(100);
			}

			else if(key[KEY_RIGHT] && selection<number_of_maps-1 && stretching==0)
			{
				selection++;
				play_sample((SAMPLE*)data[menu1].dat,255,128,1000,FALSE);
				rest(100);
			}



			if(key[KEY_DOWN] && selection2>0 && stretching==0)
			{
				selection2--;
				play_sample((SAMPLE*)data[menu1].dat,255,128,1000,FALSE);
				rest(100);
			}

			else if(key[KEY_UP] && selection2<number_of_textures-1 && stretching==0)
			{
				selection2++;
				play_sample((SAMPLE*)data[menu1].dat,255,128,1000,FALSE);
				rest(100);
			}


		   if(key[KEY_ENTER] && stretching==0)
		   {
			   stretching=50;
			   play_sample((SAMPLE*)data[menu2].dat,255,128,1000,FALSE);
		   }

		   blit(backgr,screen,0,0,0,0,SCREEN_W,SCREEN_H);


		   if(stretching>0)
		   {
			   stretching--;
			   scaled-=.04;
		   }


		   if(scaled<=1.1)
			   end_menu=1;
		}
	}
	walls=maps[selection];
	texture=textures[selection2];
}

void add_random_powerup(int time, CWalls *walls)
{
	static int count=0;
	int x,y,powerup;

	if(count==0)
	{
		count=time;


		do //keep picking new positions untill it's not touching a wall
		{
			//random position for the powerup
			x=rand()%580;
			x+=30;
			y=rand()%350;
			y+=30;
		}
		while(walls->check_col_with_rect(x,y,x+15,y+15)==1);

		powerup=rand()%100;
		
		if(powerup>=0 && powerup<12)	//12% chance
			powerup=1;	//triple
		else if(powerup>=12 && powerup<22)	//10% chance
			powerup=2;	//spread
		else if(powerup>=22 && powerup<27)	//5% chance
			powerup=3;	//spray
		else if(powerup>=27 && powerup<37)	//10% chance
			powerup=4;	//wrath
		else if(powerup>=37 && powerup<47)	//10% chance
			powerup=5;	//homing
		else if(powerup>=47 && powerup<55)	//7% chance
			powerup=6;	//rebound laser
		else if(powerup>=55 && powerup<66)	//11% chance
			powerup=7;	//gatling
		else if(powerup>=66 && powerup<73)	//7% chance
			powerup=9;	//reverse tri
		else if(powerup>=73 && powerup<83)	//10% chance
			powerup=10;	//4 dir
		else if(powerup>=83 && powerup<91)	//8% chance
			powerup=11;	//stun shot
		else if(powerup>=91 && powerup<100)	//9% chance
			powerup=12;	//mine
		
		create_powerup(x,y,powerup);
	}
	else
		count--;
}

void asteroid_level_up()
{
	if(next_level_wait==0 || next_level_wait==1)
	{
		ast_level++;

		if(ast_level==1)
		{
			messages.set_message("Level 1",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(2);
		}
		else if(ast_level==2)
		{
			messages.set_message("Level 2",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(3);
			ast_score+=1000;
		}
		else if(ast_level==3)
		{
			messages.set_message("Level 3",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(4);
			ast_score+=1500;
		}
		else if(ast_level==4)
		{
			messages.set_message("Level 4",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(5);
			ast_score+=2000;
		}
		else if(ast_level==5)
		{
			messages.set_message("Level 5",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(6);
			ast_score+=2500;
		}
		else if(ast_level==6)
		{
			messages.set_message("Level 6",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(7);
			ast_score+=3000;
		}
		else if(ast_level==7)
		{
			messages.set_message("Level 7",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(8);
			ast_score+=3500;
		}
		else if(ast_level==8)
		{
			messages.set_message("Level 8",SCREEN_W/2,SCREEN_H,0,-3);
			create_new_asteroids(9);
			ast_score+=4000;
		}
		else if(ast_level>8)
		{

		    create_new_asteroids(ast_level+1);
		    
		    if(game_mode!=8)   //asteroid avoid
            {  
              //if playing asteroid avoid, don't display level up notice
      		      char level_name[20];
                  sprintf(level_name,"Level %d",ast_level);
      		      ast_score+=4000 + (ast_level-8)*500;
      		      messages.set_message(level_name,SCREEN_W/2,SCREEN_H,0,-3);
		    }

		    
		}
	}

}

void create_new_asteroids(int n)
{	
	float x,y;

	for(int count=0; count<n ; count++)
	{
		x=rand()%SCREEN_W;
		y=rand()%430;

		if(x>y)
		{
			y=0;
		}
		else if(y>x)
		{
			x=0;
		}

		asteroids.create_new(x,y,Degree*(rand()%360),1.5,(BITMAP*)data[asteroid3].dat,
			(BITMAP*)data[asteroid2].dat,
			(BITMAP*)data[asteroid1].dat,3);

	}	
}

void show_scores(void)
{
	static int game=0;
	int number_of_games=6;
	int stop=0;

    clear_keybuf();

    al_pause_duh(mod_player);

	while(stop==0)
	{
        clear(backgr);
        

		if(game<0)
			game=number_of_games-1;
		else if(game>=number_of_games)
			game=0;

		
		if(game==0)
			missile_scores.display_scores(backgr,(FONT*)data[f2].dat,0,0);
		else if(game==1)
			one_drone.display_scores(backgr,(FONT*)data[f2].dat,0,0);
		else if(game==2)
			two_drone.display_scores(backgr,(FONT*)data[f2].dat,0,0);
		else if(game==3)
			asters.display_scores(backgr,(FONT*)data[f2].dat,0,0);
		else if(game==4)
			two_asters.display_scores(backgr,(FONT*)data[f2].dat,0,0);
		else if(game==5)
			aster_avoid.display_scores(backgr,(FONT*)data[f2].dat,0,0);

	    blit(backgr,screen,0,0,0,0,640,480);

		if(readkey())
		{
			if(key[KEY_LEFT])
				game-=1;
			else if(key[KEY_RIGHT])
				game+=1;
			else
				stop=1;
        }
	}
	clear_keybuf();
	al_resume_duh(mod_player);
}


void end_game(void)
{
	paused=1;	//pause the game
	esc=1;		//quits the current game mode

	//if(game_mode==0 || game_mode==1)	//in duel and tag, show who wins.
//	{

		//clear(screen);

		if(game_mode==1)   //tag
		{
			if(ship[0].ret_it_counter() < ship[1].ret_it_counter() )
				textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Player 1 Wins!");

			else if(ship[0].ret_it_counter() > ship[1].ret_it_counter() )
				textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Player 2 Wins!");
		}
		else if(game_mode==0)    //duel
		{
            if(ship[1].is_alive()==0)
				textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Player 1 Wins!");
			else if(ship[0].is_alive()==0)
				textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Player 2 Wins!");
            else
                textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Blah");
        }
        else if(game_mode==5)    //missile avoid
        {
            textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Game Over. Your time was: %d seconds",(int)timer);    
        }
        else if(game_mode==4 || game_mode==2) //one or two player drone kill
        {
            textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Game Over. Your score was: %d kills",kills);    
        }
        else if(game_mode==6 || game_mode==7)
        {
            textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Game Over. Your score was: %d points",ast_score);    
        }
        else if(game_mode==8)
        {
            textprintf_centre_ex(screen,(FONT*)data[f3].dat,320,200,makecol(255,0,0),-1,"Game Over. Your time was: %d seconds",(int)timer);    
        }

		textprintf_centre_ex(screen,(FONT*)data[f2].dat,320,400,makecol(255,255,0),-1,"Hit ENTER");


		while(!key[KEY_ENTER]) {}

//	}

	if(game_mode==5)	//missile avoid
		missile_scores.get_name((int)timer,(FONT*)data[f1].dat);
	else if(game_mode==4)	//one player drone kill
		one_drone.get_name(kills,(FONT*)data[f1].dat);
	else if(game_mode==2)	//two player drone kill
		two_drone.get_name(kills,(FONT*)data[f1].dat);
	else if(game_mode==6)	//asteroids
		asters.get_name(ast_score,(FONT*)data[f1].dat);
	else if(game_mode==7)	//two player asteroids
		two_asters.get_name(ast_score,(FONT*)data[f1].dat);
	else if(game_mode==8)	//two player asteroids
		aster_avoid.get_name((int)timer,(FONT*)data[f1].dat);
}

void next_song(void)
{
//	destroy_mod(song);
	current_mod++;

	if(current_mod==0)
		//song=load_mod("music/Cc15.xm");
		play_song("music/Cc15.xm");
	else if(current_mod==1)
		//song=load_mod("music/Tra.xm");
		play_song("music/Tra.xm");
	else if(current_mod==2)
		//song=load_mod("music/Ta.xm");
		play_song("music/Ta.xm");

	//play_mod(song,FALSE);
	
	if(current_mod>=number_of_mods-1)
		current_mod=0;
}

void play_story(void)
{
    int text_no=0;

    sec=0;
    cycles=0;
    count=msec+incr;
    while(story_on==1)
    {
        
    if(msec>=(int)floor(count))     //regulates time
    {
        al_poll_duh(mod_player);
        cycles++;
                        
       blit((BITMAP*)story[background].dat,backgr,0,0,0,0,640,480);
                   
                   
       if(text_no==0)
            draw_sprite(backgr,(BITMAP*)story[text1].dat,5,5);
       else if(text_no==1)
            draw_sprite(backgr,(BITMAP*)story[text2].dat,5,35);
       else if(text_no==2)
            draw_sprite(backgr,(BITMAP*)story[text3].dat,5,65);
       else if(text_no==3)
            draw_sprite(backgr,(BITMAP*)story[text4].dat,5,95);
            
        blit(backgr,screen,0,0,0,0,640,480);
               

       textprintf_centre_ex(screen,(FONT*)data[f2].dat,320,450,makecol(200,0,0),-1,"Hit Enter (Esc To Skip Intro)");
       if(key[KEY_ENTER])
       {
            text_no++;
            while(key[KEY_ENTER]);
        }    
       cycles=0;
       sec=0;

                         
      if(text_no==4 || key[KEY_ESC])
           story_on=0;
       count=msec + incr;
    }
    }
}
   
