class CWep
{
private:
	proj_att att;		//the attributes for any projectile the weapon fires
	int type;
	int exist;
	int ammo, max_ammo;	//current and max ammo
	int cool_left, max_cool;	//amount of cooldown time left, and the starting cooldown
	int owner;
	char *name;
	SAMPLE *launch;

public:
	void init(void);
	void dest(void);

	//creates a new weapon
	void create(BITMAP *pic, int damage, float speed, int _type, int _max_ammo, int _max_cool, int _owner, char *_name,
		SAMPLE *_launch);

	//fires a new projectile of this weapon from the projectile bank passed to it
	void shoot(CProjs *projs, float x, float y, float angle);  
	void count(void);
	int ret_ammo(void);
	int ret_type(void);
	void write_name(BITMAP *backgr, int x, int y, FONT *f, RGB colour);
	void set_ammo(int n);
};

void CWep::set_ammo(int n)
{
	ammo=n;
}

void CWep::write_name(BITMAP *backgr, int x, int y, FONT *f, RGB colour)
{
	textprintf_ex(backgr,f,x,y,makecol(colour.r,colour.g,colour.b),-1,"%s",name);
}

int CWep::ret_type(void)
{
	return type;
}

int CWep::ret_ammo(void)
{
	return ammo;
}

void CWep::count(void)
{
	if(cool_left>0)
		cool_left--;
}

void CWep::shoot(CProjs *projs, float x, float y, float angle)
{
	int a=0;

	if(ammo>0 && cool_left==0)
	{
		x-=att.pic->w/2;
		y-=att.pic->h/2;


		play_sample(launch,250,125,1000,FALSE);

		if(type==1 || type==5 || type==6 || type==8 || type==11 || type==12)	//single shot
			projs->create_new(x,y,angle,att,type,owner);

		else if(type==2)	//circle spray
		{
			for(int n=0 ; n<256 ; n++)
				projs->create_new(x,y,n/Rad2AllegroDeg,att,type,owner);
		}

		else if(type==3)	//triple shot
		{
			projs->create_new(x,y,angle-2*Degree,att,type,owner);
			projs->create_new(x,y,angle,att,type,owner);
			projs->create_new(x,y,angle+2*Degree,att,type,owner);
		}
		else if(type==4)	//five shot
		{
			projs->create_new(x,y,angle-4*Degree,att,type,owner);
			projs->create_new(x,y,angle-2*Degree,att,type,owner);
			projs->create_new(x,y,angle,att,type,owner);
			projs->create_new(x,y,angle+2*Degree,att,type,owner);
			projs->create_new(x,y,angle+4*Degree,att,type,owner);
		}
		else if(type==7)	//gatling gun
		{
			a=rand()%6;
			a-=3;
			projs->create_new(x,y,angle+a*Degree,att,type,owner);
		}
		else if(type==9)	//rear triple shot
		{
			projs->create_new(x,y,angle-2*Degree,att,type,owner);
			projs->create_new(x,y,angle,att,type,owner);
			projs->create_new(x,y,angle+2*Degree,att,type,owner);

			projs->create_new(x,y,angle-2*Degree+M_PI,att,type,owner);
			projs->create_new(x,y,angle+M_PI,att,type,owner);
			projs->create_new(x,y,angle+2*Degree+M_PI,att,type,owner);
		}
		else if(type==10)
		{
			projs->create_new(x,y,angle,att,type,owner);
			projs->create_new(x,y,angle+Degree*90,att,type,owner);
			projs->create_new(x,y,angle+Degree*180,att,type,owner);
			projs->create_new(x,y,angle+Degree*270,att,type,owner);
		}

		cool_left=max_cool;
		ammo--;
	}
}


void CWep::create(BITMAP *pic, int damage, float speed, int _type, int _max_ammo, int _max_cool, int _owner, char *_name,
				  SAMPLE *_launch)
{
	att.pic=pic;
	att.damage=damage;
	att.speed=speed;
	type=_type;

	max_ammo=_max_ammo;
	ammo=max_ammo;

	max_cool = _max_cool;
	cool_left=0;

	owner=_owner;

	name=_name;
	launch=_launch;
}


void CWep::dest(void)
{
	//destroy_bitmap(att.pic);
	//destroy_sample(launch);
}

void CWep::init(void)
{
	type=0;
	exist=0;

	ammo=0;
	max_ammo=0;

	cool_left=0;
	max_cool=0;
}

