class CWall
{
private:
	rectangle r;
	int exist;

public:
	void init(void);
	void set_rect(float x1, float y1, float x2, float y2/*, BITMAP *texture*/);
	void draw(BITMAP* backgr, BITMAP *texture);
	void draw_scaled(BITMAP *backgr, BITMAP *texture, float div);
	int check_col_with_rect(rectangle r2);
	void save(FILE *fp);
	void load(FILE *fp);

};

void CWall::save(FILE *fp)
{
	fprintf(fp,"%d ",r.x1);
	fprintf(fp,"%d ",r.y1);
	fprintf(fp,"%d ",r.x2);
	fprintf(fp,"%d ",r.y2);
}

void CWall::load(FILE *fp)
{
	fscanf(fp,"%d ",&r.x1);
	fscanf(fp,"%d ",&r.y1);
	fscanf(fp,"%d ",&r.x2);
	fscanf(fp,"%d ",&r.y2);
	exist=1;
}

int CWall::check_col_with_rect(rectangle r2)
{
	int ret=0;
	ret=bounding_col(r,r2);
	return ret;
}


void CWall::init(void)
{
	exist=0;
}

void CWall::set_rect(float x1, float y1, float x2, float y2/*, BITMAP *_texture*/)
{
	r.x1=(int)x1;
	r.y1=(int)y1;
	r.x2=(int)x2;
	r.y2=(int)y2;
	exist=1;
	//texture=_texture;
}

void CWall::draw(BITMAP *backgr, BITMAP *texture)
{
	if(exist==1)
	{
		if(texture)
			blit(texture,backgr,(int)r.x1,(int)r.y1,(int)r.x1,(int)r.y1 , (int)(r.x2-r.x1) , (int)(r.y2-r.y1));
		else
			rect(backgr, (int)r.x1 , (int)r.y1 , (int)r.x2 , (int)r.y2 , makecol(0,0,255));
	}
}

void CWall::draw_scaled(BITMAP *backgr, BITMAP *texture, float div)
{
	if(exist==1)
	{
		if(texture)
			blit(texture,backgr,(int)(r.x1/div),(int)(r.y1/div),(int)(r.x1/div),(int)(r.y1/div) , (int)(r.x2/div-r.x1/div) , (int)(r.y2/div-r.y1/div));
		else
			rect(backgr, (int)(r.x1/div) , (int)(r.y1/div) , (int)(r.x2/div) , (int)(r.y2/div) , makecol(0,0,255));
	}
}

class CWalls
{
private:
	CWall wall[50];
	int next_wall;

public:
	void init(void);
	void new_rect(float x1, float y1, float x2, float y2/*, BITMAP *texture*/);
	void draw_all(BITMAP *backgr, BITMAP *texture);
	void draw_all_scaled(BITMAP *backgr, BITMAP *texture, float div);
	int check_col_with_rect(int x1,int y1, int x2, int y2);

	void save(char *name);
	void load(char *name);
};

void CWalls::load(char *name)
{
	int number_of_walls=0;
	 FILE *fp;
     fp=fopen(name,"r");

	 fscanf(fp,"%d ",&number_of_walls);

	 for(int n=0 ; n<number_of_walls ; n++)
	 {
		 wall[n].load(fp);
	 }
	 next_wall=number_of_walls;
	 fclose(fp);
}

void CWalls::save(char *name)
{
	 FILE *fp;
     fp=fopen(name,"w");

	 fprintf(fp,"%d ",next_wall);

	 for(int n=0 ; n<next_wall ; n++)
	 {
		 wall[n].save(fp);
	 }
	 fclose(fp);
}

int CWalls::check_col_with_rect(int x1,int y1, int x2, int y2)
{
	int ret=0;
	rectangle temp={x1,y1,x2,y2};

	for(int n=0 ; n<50 ; n++)
	{
		ret=wall[n].check_col_with_rect(temp);
		if(ret!=0)
			break;
	}

	return ret;
}

void CWalls::draw_all(BITMAP *backgr, BITMAP *texture)
{
	for(int n=0 ; n<50 ; n++)
		wall[n].draw(backgr,texture);
}

void CWalls::draw_all_scaled(BITMAP *backgr, BITMAP *texture, float div)
{
	for(int n=0 ; n<50 ; n++)
		wall[n].draw_scaled(backgr,texture,div);
}

void CWalls::new_rect(float x1, float y1, float x2, float y2/*, BITMAP *texture*/)
{
	if(next_wall<49)
	{
		wall[next_wall].set_rect(x1,y1,x2,y2/*,texture*/);
		next_wall++;
	}
}

void CWalls::init(void)
{
	for(int n=0 ; n<50 ; n++)
		wall[n].init();
	next_wall=0;
}

