/****************************************************************************************
By FrankyR
FrankyR_ca@yahoo.ca
http://www.geocities.com/frankyr_ca

This is my class for creating a great, multi layer moving 2D starfield in 16 bit colour.
You can use it in your games as long as you give me credit for it.
****************************************************************************************/

#define number_of_stars		600	//the number of stars to display at any one time
#define number_of_layers	7	//the number of layers to make it up of

//a structure to hold the info for one star
typedef struct
{
	float x,y;		//it's current x,y position
	float dx,dy;	//it's delta x and delta y (how it's moving)
	int layer;		//the layer of the starfield it's on
	RGB colour;		//the colour for the star
} onestar;


class CStarfield
{
private:
	onestar star [number_of_stars];	//define an array of single stars
	
public:
	void init(void);				//the function to initalize everything
	void draw(BITMAP *backgr);		//draws the starfield onto the bitmap 'backgr'
	void move(void);				//moves all of the stars
};

void CStarfield::move(void)
{
	for(int n=0 ; n<number_of_stars ; n++)	//goes through all of the stars
	{
		//mvoe the star in the x and y directions
		star[n].y+=star[n].dy;
		star[n].x+=star[n].dx;

		//if the star goes off of the edge, put it back on the other side
		if(star[n].y>=SCREEN_H) 
		{
			//star[n].x=rand()%SCREEN_W;
			star[n].y=0;
		}
		else if(star[n].y<0)
		{
			//star[n].x=rand()%SCREEN_W;
			star[n].y=SCREEN_H;
		}
		else if(star[n].x>=SCREEN_W)
		{
			star[n].x=0;
			star[n].y=rand()%SCREEN_H;
		}
		else if(star[n].x<0)
		{
			star[n].x=SCREEN_W;
			star[n].y=rand()%SCREEN_H;
		}


	}
}

void CStarfield::draw(BITMAP *backgr)	//draws the stars
{
	for(int n=0 ; n<number_of_stars ; n++)	//goes through all of the stars
	{
		//puts the pixel for the star onto the memory bitmap
		( (short*) backgr->line [(int)star[n].y] ) [ (int)star[n].x ] = 
			makecol(star[n].colour.r,star[n].colour.g,star[n].colour.b);
	}
}


void CStarfield::init(void)
{
	RGB temp;
	int colour_level;
	int colour;

	for(int n=0 ; n<number_of_stars ; n++)	//goes through all of the stars
	{
		//gives the star a random position on the screen
		star[n].x=rand()%SCREEN_W;
		star[n].y=rand()%SCREEN_H;

		//puts the star on a random layer
		star[n].layer=rand()%number_of_layers;
		star[n].layer++;

		//sets the star's default value
		temp.r=200;
		temp.g=200;
		temp.b=200;

		//chooses a random colour: blueish, or yellowish
		colour=rand()%3;

		//if value is 0 or 1, make the blue value a bit stronger to tint it blue
		if(colour==0)
			temp.b=255;
		else if(colour==1)
			temp.b=255;

		//if value is 2, make the green and red values a bit stronger to tint it yellow
		else if(colour==2)
		{
			temp.g=255;
			temp.r=255;
		}

		//set the colour level (brightness) of the star beased on it's layer
		//the further back it is, the fainter it is
		colour_level=(200/number_of_layers) * star[n].layer;

		//decrease all of the colours to the proper brightness
		temp.r-=colour_level;
		temp.g-=colour_level;
		temp.b-=colour_level;

		//set the star's colour to the one I just made
		star[n].colour=temp;

		//in this starfield I want the stars to move from the top to the bottom

		star[n].dx=0;	//so there is no x movement

		//and I set the y movement to a level based on the layer it's on
		//the further away it is, the slower it moves.
		star[n].dy=number_of_layers-star[n].layer+0.5;
	}
}

