typedef struct
{
	int damage;
	float speed;
	BITMAP *pic;
}proj_att;



class CProj
{
private:
	float x,y;
	float dx,dy;
	float angle;					//angle in rads
	proj_att att;
	int type;
	int exist;
	SAMPLE *explode;


	float anglev;			//angle is in rads
	float accel,angle_accel;
	float damp,angle_damp;

public:
	int owner;
	void init(SAMPLE *_explode);
	void dest(void);
	void create(float _x, float _y, float _angle, proj_att _att, int _type, int _owner);
	void move(CParts *parts);
	void home(float tx, float ty);
	void turn_right(void);
	void turn_left(void);


	void draw(BITMAP *backgr, float sx, float sy);

	int check_col_with_bitmap(BITMAP *pic, int ex, int ey, int ship, CParts *parts);

	void check_col_with_walls(CWalls *walls, CParts *parts);

	void not_fired(CParts *parts);
};

void CProj::not_fired(CParts *parts)
{
	int size=att.damage;
	float dx,dy;
	float ang=0;
	RGB col={0,200,200};

	exist=0;

	if(size>30)
		size=30;

	//if(type==4 || type
	if(att.damage>10)
		//e.create(x+att.pic->w/2,y+att.pic->h/2,size,parts,explode);
		parts->create_explosion2(x+att.pic->w/2,y+att.pic->h/2,size,explode);
	else if(type!=12)	//all laser blasts
		parts->create_sparks(parts,x,y,angle-M_PI);
	else if(type==12)	//stun shot
	{
		for(int n=0 ; n<360 ; n++)
		{
			ang=Degree*n;
			dy=-cos(ang);
			dx=sin(ang);
			parts->create_new(x,y,col,dx,dy,1,3);
			parts->create_new(x,y,col,dx,dy,2,3);
		}
	}

	

}

void CProj::dest(void)
{
	//destroy_bitmap(att.pic);
}

void CProj::home(float tx, float ty)
{
	if((type==5 || type==8) && exist==1)		//type 5 is homing missile
	{
		int tempx,tempy;
		tempx = (int)(tx-x);
		tempy=  (int)(ty-y);

		angle = atan2(tempy, tempx);

		angle+=M_PI/2;
		//x=tx;
		//y=ty;


	//	angle=atan2(40,40);
		//angle=M_PI/2;
	}
}

void CProj::check_col_with_walls(CWalls *walls, CParts *parts)
{
	if(exist==1)
	{
		if(type==6 || type==8)
		{
			if( walls->check_col_with_rect((int)x-4,(int)y-2,(int)x,(int)y+att.pic->h+2) ==1 )
			{

				dx*=-1;
				angle = atan2((int)dy, (int)dx);
				angle+=M_PI/2;
			}

			if( walls->check_col_with_rect((int)x+att.pic->w,(int)y-2,(int)x+att.pic->w+4,(int)y+att.pic->h+2) ==1 )
			{
				dx*=-1;
				angle = atan2((int)dy, (int)dx);
				angle+=M_PI/2;
			}


			if( walls->check_col_with_rect((int)x-2,(int)y-4,(int)x+att.pic->w+2,(int)y) ==1 )
			{

				dy*=-1;
				angle = atan2((int)dy, (int)dx);
				angle+=M_PI/2;
			}


			if( walls->check_col_with_rect((int)x-2,(int)y+att.pic->h,(int)x+att.pic->w+2,(int)y+att.pic->h+4) ==1 )
			{
				dy*=-1;
				angle = atan2((int)dy, (int)dx);
				angle+=M_PI/2;
			}

			//angle+=M_PI/2;
		}

		else if(walls->check_col_with_rect((int)x-4,(int)y,(int)x,(int)y+att.pic->h)==1)
		{
			not_fired(parts);
		}

	//angle = atan2((int)dy, (int)dx);
	}
}

int CProj::check_col_with_bitmap(BITMAP *pic, int ex, int ey, int ship, CParts *parts)
{
	int ret=0;

	if(exist==1)
	{		
		if(check_col(att.pic,pic,x,y,ex,ey)==1  &&  owner!=ship)
		{
			//explode

			if(type==12)
				ret=1000;
			else
				ret=att.damage;



			not_fired(parts);
		}
	}

	return ret;
}


void CProj::draw(BITMAP *backgr, float sx, float sy)
{
	if(exist==1)
	{
		rotate_sprite(backgr,att.pic,(int)x-(int)sx,(int)y-(int)sy,itofix((int)(angle*Rad2AllegroDeg)));
	}
}


void CProj::turn_right(void)
{
	if(exist==1)
		anglev+=angle_accel;
}

void CProj::turn_left(void)
{
	if(exist==1)
		anglev-=angle_accel;
}

void CProj::move(CParts *parts)
{
	if(/*(type==1 || type==2) &&*/ exist==1)
	{

		//when engines on (that is always for a projectile)
		dx += accel * sin(angle);  
		dy -= accel * cos(angle);

		//does every time
		anglev*=angle_damp;
		angle+=anglev;

		/*if(angle>2*M_PI)
			angle=0;
		if(angle<0)
			angle=2*M_PI;*/


		dx *=damp;
		dy *=damp;

		if(type==11)
			angle+=3*Degree;

		if(type!=11)//type 11 are mines, so they don't move
		{
			x+=dx;
			y+=dy;
		}



		//x+=dx*att.speed;
		//y+=dy*att.speed;

		//checks to see if ti went off of the edge

		if(x>SCREEN_W-att.pic->w)
			exist=0;
		else if(x<0-att.pic->w)
			exist=0;

		if(y>430-att.pic->h)
			exist=0;
		else if(y<0-att.pic->h)
			exist=0;


		if(att.damage==30)
			parts->create_exaust(att.pic,x,y,dx,dy);

	}
}

void CProj::create(float _x, float _y, float _angle, proj_att _att, int _type, int _owner)
{
	type=_type;

	exist=1;

	angle=_angle;

	dy=-cos(angle)*4;
	dx=sin(angle)*4;

	att=_att;

	x=_x;
	y=_y;

	owner=_owner;
}

void CProj::init(SAMPLE *_explode)
{
	x=0;
	y=0;
	dx=0;
	dy=0;
	angle=0;
	att.damage=0;
	att.speed=0;
	exist=0;


	anglev=0;

	accel=0.11;			
	damp =0.98;			//speed ship stops(ie friction) 0.99 stops slowly, 0.98 stops med 
	angle_accel=0.02;	//speed ship turns at 0.01 is good, 0.02 is too fast
	angle_damp=0.90;	//speed ship stops turning	.90 is good

	explode=_explode;
}


class CProjs
{
private:
	CProj proj[max_projs];
	int next_proj;

public:
	void init(SAMPLE *explode);
	void dest(void);
	void create_new(float x, float y, float angle, proj_att att, int type, int owner);
	void move_all(CParts *parts);
	void home_all(float tx, float ty, int _owner);
	void draw_all(BITMAP *backgr, float sx, float sy);
	int check_col_with_bitmap(BITMAP *pic, int x, int y, int ship, CParts *parts);  //return damage
	void check_col_with_walls(CWalls *walls, CParts *parts);


};

void CProjs::home_all(float tx, float ty, int _owner)
{
	for(int n=0 ; n<max_projs ; n++)
	{
		if(proj[n].owner==_owner)	//only home this projectile if it is owned by the right player
			proj[n].home(tx,ty);
	}
}

void CProjs::check_col_with_walls(CWalls *walls, CParts *parts)
{
	for(int n=0 ; n<max_projs ; n++)
		proj[n].check_col_with_walls(walls,parts);
}

int CProjs::check_col_with_bitmap(BITMAP *pic, int x, int y, int ship, CParts *parts)
{
	int ret=0;
	for(int n=0 ; n<max_projs ; n++)
	{
		//goes through all of projectiles and gets the damage they do to the object
		//all of the damage is added together
		ret=proj[n].check_col_with_bitmap(pic,x,y,ship,parts);
		if(ret!=0)
			break;
	}

	//return the total damage done
	return ret;
}


void CProjs::draw_all(BITMAP *backgr, float sx, float sy)
{
	for(int n=0 ; n<max_projs ; n++)
		proj[n].draw(backgr,sx,sy);
}

void CProjs::move_all(CParts *parts)
{
	for(int n=0 ; n<max_projs ; n++)
		proj[n].move(parts);
}

void CProjs::init(SAMPLE *explode)
{
	for(int n=0 ; n<max_projs ; n++)
		proj[n].init(explode);
	next_proj=0;
}

void CProjs::dest(void)
{
	for(int n=0 ; n<max_projs ; n++)
		proj[n].dest();
}

void CProjs::create_new(float x, float y, float angle, proj_att att, int type, int owner)
{
	proj[next_proj].create(x,y,angle,att,type,owner);

	next_proj++;
	if(next_proj>=max_projs-2)
		next_proj=0;
}

