class CPowerup
{
private:
	float x,y;
	BITMAP *pic;
	int exist;
	int life_left;
	SAMPLE *sound;

public:
	int type,value;

	void init(void);
	void dest(void);

	void create(BITMAP *_pic, int _type, int _value, float _x, float _y, SAMPLE *_sound);

	void draw(BITMAP *backgr, CParts *parts);
	void not_exist(CParts *parts);

	int check_col_with_bitmap(BITMAP *pic, float  x, float y, CParts *parts);
};

void CPowerup::dest(void)
{
	//destroy_bitmap(pic);
	//destroy_sample(sound);
}

int CPowerup::check_col_with_bitmap(BITMAP *spic, float  sx, float sy, CParts *parts)
{
	int ret=-1;

	if(exist==1)
	{
		if(check_col(pic,spic,x,y,sx,sy)==1)
		{
			not_exist(parts);
			ret=1;
		}
	}
	return ret;
}

void CPowerup::not_exist(CParts *parts)
{
	RGB col={0,0,0};
	float dx,dy,ang;
	float rnd;
	int r,g,b;

	exist=0;

	play_sample(sound,250,125,1000,FALSE);

	for(int n=0 ; n<360 ; n++)
		{
			rnd=rand()%20;
			rnd+=1;
			rnd/=10;

			r=rand()%255;
			g=rand()%255;
			b=rand()%255;

			col.r=r;
			col.g=g;
			col.b=b;

			ang=Degree*n;
			dy=-cos(ang);
			dx=sin(ang);
			parts->create_new(x+pic->w/2,y+pic->h/2,col,dx,dy,rnd,3);
			parts->create_new(x+pic->w/2,y+pic->h/2,col,dx,dy,rnd,3);
		}

}


void CPowerup::draw(BITMAP *backgr, CParts *parts)
{
	if(exist==1)
	{
		draw_sprite(backgr,pic,(int)x,(int)y);
		if(life_left>0)
			life_left--;

		if(life_left==0)
			not_exist(parts);
	}
}

void CPowerup::create(BITMAP *_pic, int _type, int _value, float _x, float _y, SAMPLE *_sound)
{
	x=_x;
	y=_y;
	pic=_pic;
	type=_type;
	value=_value;

	life_left=500;
	sound=_sound;

	exist=1;
}


void CPowerup::init(void)
{
	x=0;
	y=0;
	type=0;
	value=0;
	exist=0;
}


class CPowerups
{
private:
	CPowerup powerup[100];
	int current_powerup;

public:
	void init(void);
	void dest(void);

	void draw_all(BITMAP *backgr, CParts *parts);
	void create_new(BITMAP *pic, int type, int value, float x, float y, SAMPLE *sound);

	int check_col_with_bitmap(BITMAP *pic, float  x, float y, CParts *parts);

	int ret_type(int n);
	int ret_value(int n);

};

void CPowerups::dest(void)
{
	for(int n=0;  n<100 ; n++)
		powerup[n].dest();
}

int CPowerups::ret_type(int n)
{
	return powerup[n].type;
}

int CPowerups::ret_value(int n)
{
	return powerup[n].value;
}

int CPowerups::check_col_with_bitmap(BITMAP *pic, float  x, float y, CParts *parts)
{
	int ret=-1;
	for(int n=0 ; n<100  ; n++)
	{
		ret=powerup[n].check_col_with_bitmap(pic,x,y,parts);
		if(ret!=-1) //if it is touching
		{
			ret=n; //return the number of the powerup
			break;
		}
	}
	return ret;
}


void CPowerups::create_new(BITMAP *pic, int type, int value, float x, float y, SAMPLE *sound)
{
	powerup[current_powerup].create(pic,type,value,x,y,sound);
	current_powerup++;
	if(current_powerup>=99)
		current_powerup=0;
}

void CPowerups::init(void)
{
	for(int n=0 ; n<100 ; n++)
		powerup[n].init();
	current_powerup=0;
}

void CPowerups::draw_all(BITMAP *backgr, CParts *parts)
{
	for(int n=0 ; n<100 ; n++)
		powerup[n].draw(backgr,parts);
}

