class CPart
{
private:
	float x,y;		//position of part;
	BITMAP *pic;	//picture if particle is a picture
	RGB colour;		//colour if particle is a pixel
	float dx,dy;	//direction of movement
	float speed;
	int exist;
	int type;		//1 is bitmap, 2 is pixel
	int degrade;	//amount colour degrades over time

public:
	void init(void);
	void dest(void);
	void create(float _x, float _y, BITMAP *_pic, float _dx, float _dy, float _speed);
	void create(float _x, float _y, RGB _colour, float _dx, float _dy, float _speed, int _degrade);
	void draw(BITMAP *backgr, float s_x, float s_y);
	void move(void);
};

void CPart::move(void)
{
	if(exist==1)
	{
		x+=dx*speed;
		y+=dy*speed;

		if(degrade>0)
		{
			if(colour.r>=degrade)
				colour.r-=degrade;
			if(colour.g>=degrade)
				colour.g-=degrade;
			if(colour.b>=degrade)
				colour.b-=degrade;

			if(colour.r<20 && colour.g<20 && colour.b<20)
				exist=0;
		}

	}
}


void CPart::draw(BITMAP *backgr, float s_x, float s_y)
{
	if(exist==1)
	{
		if(x-s_x>0 && x-s_x<backgr->w  && y-s_y>0 && y-s_y<backgr->h) //clipping
		{
			if(type==1)
				draw_sprite(backgr,pic,(int)x-(int)s_x,(int)y-(int)s_y);
			else if(type==2)
			//	_putpixel16(backgr,(int)x-(int)s_x, (int)y-(int)s_y, makecol(colour.r,colour.g,colour.b));
			
			((short*)backgr->line[(int)y])[(int)x] = makecol(colour.r,colour.g,colour.b);
		}
		else
			exist=0;
	}
}

void CPart::create(float _x, float _y, BITMAP *_pic, float _dx, float _dy, float _speed)
{
	if(exist==0)
	{
		x=_x;
		y=_y;
		pic=_pic;
		dx=_dx;
		dy=_dy;
		speed=_speed;
		exist=1;
		type=1;
	}
}

void CPart::create(float _x, float _y, RGB _colour, float _dx, float _dy, float _speed, int _degrade)
{
	if(exist==0)
	{
		x=_x;
		y=_y;
		colour=_colour;
		dx=_dx;
		dy=_dy;
		speed=_speed;
		degrade=_degrade;
		exist=1;
		type=2;
	}
}

void CPart::dest(void)
{
	//destroy_bitmap(pic);
}

void CPart::init(void)
{
	x=0;
	y=0;
	dx=0;
	dy=0;
	speed=0;
	exist=0;
	type=0;
}


class CParts
{
private:
	CPart part[max_parts];
	int next_part;
public:
	void init(void);
	void dest(void);
	void draw_all(BITMAP *backgr, float s_x, float s_y);
	void create_new(float x, float y, BITMAP *pic, float dx, float dy, float speed);
	void create_new(float x, float y, RGB colour, float dx, float dy, float speed, int degrade);
	void move_all(void);
	void create_exaust(BITMAP *pic, float x, float y, float dx, float dy);

	void create_explosion(float x, float y, RGB colour, int number, int degrade, float speed);

	void create_explosion2(float cx, float cy, int _diameter, SAMPLE *ex);
	void create_sparks(CParts *parts, float x, float y, float angle);
};


void CParts::create_sparks(CParts *parts, float x, float y, float angle)
{
	float r;
	float dx,dy;
	RGB col={0,170,170};

	for(int n=0 ; n<5 ; n++)
	{
		r=rand()%60;
		r-=30;
		r/=Rad2AllegroDeg;

		dy=-cos(angle+r);
		dx=sin(angle+r);

		create_new(x,y,col,dx,dy,1,4);
	}
}

void CParts::create_explosion2(float cx, float cy, int diameter, SAMPLE *ex)
{
	RGB col={255,0,0};


	int rad=diameter/2;
	float dist;
	float div;
	int temp;
	float radiu=0;
	float dx,dy;
	int vol=0;
	float ang;
	float speed;
	float rand_speed;

	div=255/rad;

	vol=100+(diameter*4);
	if(vol>254)
		vol=254;

	play_sample(ex,vol,125,1000,FALSE);

	//creates the core explosion
	for(int x=-rad ; x<rad ; x++)
		for(int y=-rad ; y<rad  ; y++)
		{
			if( (x*x + y*y) < (rad*rad))
			{
				dist=get_dist(0,0,(float)x,(float)y);

				col.r=255-(int)( dist*div  );
		
				temp=(int)(col.r/1.2);
				col.g=rand()%temp;

				radiu = atan2(y, x);

				dy = -cos( radiu);
                dx = sin ( radiu);

				rand_speed=rand()%10;
				rand_speed/=100;

				create_new(x+cx,y+cy,col,dx,dy, 0.07+rand_speed ,1);

				create_new(x+cx,y+cy,col,dx,dy, 0.4 ,1);
			}
		}


	//creates the extra bit to go flying really far
	for(int n=0 ; n<diameter*1.5 ; n++)
	{
		col.r=255-rand()%100;
		
		temp=(int)(col.r/1.2);
		col.g=rand()%temp;

		ang=rand()%360;
		ang/=Rad2AllegroDeg;

		dy = -cos( ang);
        dx = sin ( ang);

		speed=rand()%30;
		speed+=1;

		speed/=10;

		create_new(cx,cy,col,dx,dy, speed ,1);
	}
}


void CParts::create_explosion(float x, float y, RGB colour, int number, int degrade, float speed)
{
	float dx,dy;
	float ang=0;
	int rand_angle=0;
	float rand_speed=0;
	int speed2=(int)(speed*100);

	
	for(int n=0 ; n<number ; n++)
	{	
		rand_angle=rand()%360;
		ang=Degree*rand_angle;

		rand_speed=rand()%speed2;
		rand_speed/=100;
		rand_speed+=speed/2;

		dy=-cos(ang);
		dx=sin(ang);
		create_new(x,y,colour,dx,dy, rand_speed ,degrade);
	}
}

void CParts::create_exaust(BITMAP *pic, float x, float y, float dx, float dy)
{
	RGB col={150,150,150};


	float mx=0,my=0;
	float ang=0,angle=0;
	float speed=0;
	int col_amount;

	for(int n=0 ; n<2 ; n++)
	{

		ang=rand()%2000;
		ang-=100;
		ang/=100;
		ang/=Rad2AllegroDeg;

		speed=rand()%10;
		speed+=2;
		speed/=10;

		col_amount=rand()%75;
		col_amount+=40;

		col.r=col_amount;
		col.g=col_amount;
		col.b=col_amount;

		angle = atan2(dy, dx);
		angle+=Degree*90;

		ang+=angle;

		mx = sin(ang);  
		my = -cos(ang);

		create_new(x+pic->w/2,y+pic->h/2,col,-mx,-my, speed ,1);
	}
}

void CParts::move_all(void)
{
	for(int n=0 ; n<max_parts ; n++)
		part[n].move();
}

void CParts::create_new(float x, float y, BITMAP *pic, float dx, float dy, float speed)
{
	part[next_part].create(x,y,pic,dx,dy,speed);
	next_part++;
	if(next_part>=max_parts-1)
		next_part=0;
}

void CParts::create_new(float x, float y, RGB colour, float dx, float dy, float speed, int degrade)
{
	part[next_part].create(x,y,colour,dx,dy,speed,degrade);
	next_part++;
	if(next_part>=max_parts-1)
		next_part=0;
}

void CParts::init(void)
{
	next_part=0;
	for(int n=0 ; n<max_parts ; n++)
		part[n].init();
}

void CParts::dest(void)
{
	for(int n=0 ; n<max_parts ; n++)
		part[n].dest();
}

void CParts::draw_all(BITMAP *backgr, float s_x, float s_y)
{
	for(int n=0 ; n<max_parts ; n++)
		part[n].draw(backgr,s_x,s_y);
}

