typedef struct	//a structure to hold one score and one name (max 20 chars)
{
	char name[20];
	int score;
} one_score;


class CHighscores
{
private:
	one_score score[11];	//a highscore list that holds a max of 11 scores
	int ascending;			//1=sort ascending, 0=sort descending
	char *title;

public:
	void init(char *_title, int _ascending);	//init with the title for the list, and how to sort it
	void add_score(char _name[20], int _score);	//adds a score, and automatically sorts the list
	void sort_scores(void);						//sort the scores
	void display_scores(BITMAP *backgr, FONT *f, int x, int y);	//draw the scores onto a bitmap
	void save_scores(char *filename);	//save scores to the given filename
	void load_scores(char *filename);	//load scores from the given filename
	void get_name(int s, FONT *f);		//get a name from the user, and then add it to the list
};

void CHighscores::get_name(int s, FONT *f)
{
	char word[20]="";

	//checks to see if the score belongs on the list
	if( (s > score[9].score && ascending==0) || (s<score[0].score && ascending==1) )
	{

		clear(screen);

		//defines a dialog for getting the user's name
		DIALOG input_dlg[] = {
			{ d_edit_proc , 200, 140, 100, 50, makecol(255,255,0), makecol(200,0,0), 0, D_EXIT, 20, 0, word},
		   { NULL },
		  };


		//prompts user for the name
		textprintf_ex(screen,f,200, 100,makecol(255,255,0),-1,"Please Enter Your Name");
   
		//and shows the dialog
		clear_keybuf();
		do_dialog(input_dlg,0);
		clear_keybuf();

		//add the score to the list
		add_score(word,s);
	}
}

void CHighscores::load_scores(char *filename)
{
	FILE *fp;

	//open the filename for reading
	fp=fopen(filename,"r");

    if(!fp)
    {
		exit(0);
    }

    for(int n=0; n<10 ; n++)
    {
		//get the 10 highscores and names
     	fscanf(fp,"%s",score[n].name);
     	fscanf(fp,"%d",&score[n].score);
    }

	//close the file
    fclose(fp);

	//sort the scores
	sort_scores();

}

void CHighscores::save_scores(char *filename)
{
	//same as above, but for saving

	FILE *fp;

	sort_scores();

    fp=fopen(filename,"w");
    if(!fp)
	{
		exit(0);
	}

    for(int n=0 ; n<10 ; n++)
    {
     	fprintf(fp,"%s\n",score[n].name);
     	fprintf(fp,"%d\n",score[n].score);
    }

	fclose(fp);
}


void CHighscores::display_scores(BITMAP *backgr, FONT *f, int x, int y)
{
	int height;

	height=text_height(f);

	//displays the list's title using defioned font
	textprintf_ex(backgr,f,x+2,y+2,makecol(0,255,0),-1,"%s",title);
	
	//goes through list, and displays all of the scores
	for(int n=0 ; n<10 ; n++)
	{
		textprintf_ex(backgr,f,x,y+40+n*(height+3),makecol(255,0,0),-1,"%20s %5d",score[n].name,score[n].score);
	}

	textprintf_centre_ex(backgr,font,320,465,makecol(255,255,0),-1,"Use the left and right arrows to switch lists.");
}


void CHighscores::sort_scores(void)
{
	//sorts the scores (yes, I know it's a really inefficient way, but it's just for a 
	//high score list, so I don't car about speed).

	one_score temp;	//one temp scores

	for(int x=0 ; x<10 ; x++)	//goes through both lists
    {
        for(int y=0 ; y<9 ; y++)
        {
			//basically is one score is bigger or smaller than the other depending on
			//sort status, switch the scores

            if(score[y+1].score>score[y].score  && ascending==0)
            {
				temp = score[y];
                score[y]=score[y+1];
                score[y+1]=temp;
            }

			else if(score[y+1].score<score[y].score  && ascending==1)
            {
				temp = score[y];
                score[y]=score[y+1];
                score[y+1]=temp;
            }


		}
	}
}

void CHighscores::add_score(char _name[20], int _score)
{
	//checks to see if the score belongs on the list
	if( (_score > score[9].score && ascending==0) || (_score < score[0].score && ascending==1) )
	{
		//adds it to the last spot
		strcpy(score[9].name,_name);
		score[9].score=_score;
		sort_scores();
	}
}

void CHighscores::init(char *_title, int _ascending)
{
	//initalizalizes(sp?) everything
	for(int n=0 ; n<10 ; n++)
	{
		strcpy(score[n].name," ");
		score[n].score=0;
	}
	ascending=_ascending;
	title=_title;
}

