typedef struct
{
	float x,y;
	float size;
	BITMAP *pic;
	SAMPLE *sound;
}number;


class CCountdown
{
private:
	int counter;
	int cur_num;
	number num[4];
	float size_amount;

public:
	void init(number oone, number ttwo, number tthree, number ggo);
	void draw(BITMAP *backgr);
	int move(void);
	void reset(void);

};

int CCountdown::move(void)
{
	if(cur_num>=0)
	{
		for(int n=2 ; n>=cur_num ; n--)
		{
			num[n].x-=6;
			num[n].y+=6;

			if(num[n].size==2.5)
				play_sample(num[n].sound,255,125,1000,FALSE);


			num[n].size-=.04;
		}

		if(num[cur_num].size<.1)
			cur_num--;
	}

	else if(cur_num==-1)
	{
		if(num[3].size==0)
			play_sample(num[3].sound,255,125,1000,FALSE);

		num[3].size+=size_amount;

		size_amount+=.01;

		num[3].x=SCREEN_W/2 - (num[3].pic->w*num[3].size)/2;
		num[3].y=SCREEN_H/2 - (num[3].pic->h*num[3].size)/2;

		if(num[3].size>=10)
			cur_num--;

	}


	if(cur_num<-1)
		return 1;
	else
		return 0;
}

void CCountdown::draw(BITMAP *backgr)
{
	for(int n=0 ; n<4 ; n++)
	{
		stretch_sprite(backgr,num[n].pic , (int)num[n].x , (int)num[n].y,(int)(num[n].pic->w*num[n].size),(int)(num[n].pic->h*num[n].size));
	}
}

void CCountdown::init(number oone, number ttwo, number tthree, number ggo)
{
	num[0]=oone;
	num[1]=ttwo;
	num[2]=tthree;
	num[3]=ggo;

	reset();
}

void CCountdown::reset(void)
{
	for(int n=0 ; n<3 ; n++)
	{
		num[n].x=SCREEN_W;
		num[n].y= -num[n].pic->h;
		num[n].size=2.5;
		//num[n].x=200;
		//num[n].y=200;
	}

	num[3].x=SCREEN_W/2 - num[3].pic->w/2;
	num[3].y=SCREEN_H/2 - num[3].pic->h/2;
	num[3].size=0;

	counter=30;
	cur_num=2;
	size_amount=.05;
}

