class CAsteroid
{
public:
	int exist;
	float x,y;
	int size;
	BITMAP* pic,*pic1,*pic2,*pic3;
	float angle;
	float speed;
	int draw_angle;


	void init(void);
	void dest(void);
	void create(float _x, float _y, float _angle, float _speed,BITMAP *_pic1,BITMAP *_pic2,BITMAP *_pic3, int _size);

	void draw(BITMAP *backgr, float s_x, float s_y);
	void move(void);

	void not_exist(void);

	int check_col_with_bmp(BITMAP *bmp, float bx, float by);

	int check_col_with_projs(CProjs *projs, CParts *parts);

};

int CAsteroid::check_col_with_projs(CProjs *projs, CParts *parts)
{
	int ret=0;

	if(exist==1)
	{

		//life goes down by the amount of damage done
		ret=projs->check_col_with_bitmap(pic,(int)x,(int)y,1000,parts);

		if(ret!=0)
		{
			exist=0;
			ret=1;
		}

	}

	return ret;
}

int CAsteroid::check_col_with_bmp(BITMAP *bmp, float bx, float by)
{
	int ret=0;

	if(exist==1)
	{
		if(check_col(pic,bmp,x,y,bx,by)==1)
		{
			ret=1;
			exist=0;
		}
	}

	return ret;
}

void CAsteroid::move(void)
{
	if(exist==1)
	{
		x+=sin(angle)  * speed;
		y+=-cos(angle) * speed;

		if(x>=SCREEN_W)
			x= 0 - pic->w;
		else if(x<=0-pic->w)
			x= SCREEN_W;
		
		if(y>=430)
			y= 0 -pic->h;
		else if(y<=0-pic->h)
			y=430;

		draw_angle++;
	}

}

void CAsteroid::draw(BITMAP *backgr, float s_x, float s_y)
{
	if(exist==1)
		//pic.draw_anim(backgr,(int)x-(int)s_x , (int)y-(int)s_y , 1 , 1 , 10);
		rotate_sprite(backgr,pic,(int)x-(int)s_x , (int)y-(int)s_y , itofix(draw_angle));
}	

void CAsteroid::create(float _x, float _y, float _angle, float _speed, BITMAP *_pic1,BITMAP *_pic2,BITMAP *_pic3, int _size)
{
	if(exist==0)
	{
		x=_x;
		y=_y;
		angle=_angle;
		pic1=_pic1;
		pic2=_pic2;
		pic3=_pic3;

		speed=_speed;
		size=_size;


		exist=1;

		if(size==1)
			pic=pic1;
		else if(size==2)
			pic=pic2;
		else if(size==3)
			pic=pic3;

		draw_angle=rand()%255;
	}
}

void CAsteroid::dest(void)
{
/*	pic.dest();
	pic1.dest();
	pic2.dest();
	pic3.dest();*/
}

void CAsteroid::init(void)
{
	x=0;
	y=0;
	angle=0;
	exist=0;
	speed=0;
}


class CAsteroids
{
private:
	CAsteroid asteroid[max_asteroids];
	int current_asteroid;
	SAMPLE *explode;
	
public:
	void init(SAMPLE *_explode);
	void dest(void);
	void draw_all(BITMAP *backgr, float s_x, float s_y);
	void move_all(void);
	void create_new(float x, float y, float angle, float speed, BITMAP *pic1,BITMAP *pic2, BITMAP *pic3, int size);
	int check_col_with_bmp(BITMAP *pic, float bx, float by, CParts *parts);

	void not_exist(int n, CParts *parts);
	int check_col_with_projs(CProjs *projs, CParts *parts);
	int check_all(void);

};

int CAsteroids::check_all(void)
{
	int counter=0;
	for(int n=0 ; n<max_asteroids ; n++)
	{
		if(asteroid[n].exist==1)
		{
			counter++;
			break;
		}
	}
	if(counter==0)
		return 0;
	else 
		return 1;
}

int CAsteroids::check_col_with_projs(CProjs *projs, CParts *parts)
{
	int ret=0;
	for(int n=0 ; n<max_asteroids ; n++)
	{
		if(asteroid[n].check_col_with_projs(projs,parts)==1)
		{
			not_exist(n,parts);
			ret=1;
			break;
		}
	}
	return ret;
}

void CAsteroids::not_exist(int n, CParts *parts)
{
	RGB col={150,150,150};

	if(asteroid[n].size>1)
	{
     	create_new(asteroid[n].x,asteroid[n].y,asteroid[n].angle+Degree*90,asteroid[n].speed+0.5,
			asteroid[n].pic1,asteroid[n].pic2,asteroid[n].pic3,
			asteroid[n].size-1);
		create_new(asteroid[n].x,asteroid[n].y,asteroid[n].angle-Degree*90,asteroid[n].speed+0.5,
			asteroid[n].pic1,asteroid[n].pic2,asteroid[n].pic3,
			asteroid[n].size-1);
	}

	play_sample(explode,255,125,1000,FALSE);

	parts->create_explosion(asteroid[n].x+asteroid[n].pic->w/2,
		asteroid[n].y+asteroid[n].pic->h/2,col,50*asteroid[n].size,0,5);

	col.r=100;
	col.b=100;
	col.g=100;

	parts->create_explosion(asteroid[n].x+asteroid[n].pic->w/2,
		asteroid[n].y+asteroid[n].pic->h/2,col,50*asteroid[n].size,0,5);
}


int CAsteroids::check_col_with_bmp(BITMAP *pic, float bx, float by, CParts *parts)
{
	int ret=0;
	for(int n=0 ; n<max_asteroids ; n++)
	{
		ret=asteroid[n].check_col_with_bmp(pic,bx,by);
		if(ret==1)
		{
			not_exist(n,parts);

			break;
		}
	}
	return ret;
}

void CAsteroids::init(SAMPLE *_explode)
{
	for(int n=0 ; n<max_asteroids ; n++)
		asteroid[n].init();
	current_asteroid=0;
	explode=_explode;
}

void CAsteroids::dest(void)
{
	for(int n=0 ; n<max_asteroids ; n++)
		asteroid[n].dest();
}

void CAsteroids::draw_all(BITMAP *backgr, float s_x, float s_y)
{
	for(int n=0 ; n<max_asteroids ; n++)
		asteroid[n].draw(backgr, s_x, s_y);
}

void CAsteroids::move_all(void)
{
	for(int n=0 ; n<max_asteroids ; n++)
		asteroid[n].move();
}

void CAsteroids::create_new(float x, float y, float angle, float speed, BITMAP *pic1,BITMAP *pic2, BITMAP *pic3, int size)
{
	asteroid[current_asteroid].create(x,y,angle,speed,pic1,pic2,pic3,size);
	current_asteroid++;
	if(current_asteroid>=max_asteroids-1)
		current_asteroid=0;
}

