#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <iostream>
#include "allegro.h"

fixed get_angle(float fx1,float fy1, float fx2, float fy2);
float get_dist(float x1,float y1,float x2,float y2);

//The CAnim class is for handling animations easily in a game

class CAnim
	{
     private:
        int number_of_frames;  //total frames used in animation
        int frame;             //current frame
        int rest;       //the number of loops left to wait before changing frames
        BITMAP *bmp[15];  //the array of frames
	public:
		float w,h;
    	void init(void); //initalizes all of the variables
        //draws the anim onto backgr at x,y.
        //sprit is for the drawing method: 0=blit, 1=draw_sprite, 2=draw_trans_sprite
        //going is a flag: 0=not going 1=going
        //delay is for the number of loops to wait before moving to the next frame
        int draw_anim(BITMAP *backgr, int x, int y, int sprit, int going, int delay);
        //adds a new frame to the animation (adjusts number_of_frames automatically)
        void add_bmp(BITMAP *pic);
	    //returns the current frame's bitmap
        BITMAP* ret_frame(void);
        //moves animation to frame n
        void set_frame(int n);
		void dest(void);
	};

void CAnim::dest(void)
{
	//for(int n=0 ; n<15 ; n++)
	//	destroy_bitmap(bmp[n]);
}

void CAnim :: set_frame(int n)
	{
     frame=n;
    }

BITMAP * CAnim::ret_frame(void)
	{
     return bmp[frame];
    }

void CAnim::init(void)
	{
     number_of_frames=-1;  //-1 means there are no frames in the animation
     frame=0;              //starts at frame 0
     rest=0;
	 w=0;
	 h=0;
    }

int CAnim::draw_anim(BITMAP *backgr, int x, int y, int sprit, int going, int delay)
	{
     int ret=0;   //the will-be return value

	 w=bmp[frame]->w;
	 h=bmp[frame]->h;
     if(number_of_frames!=-1)  //if the animation exists
       {

     	if(sprit==1)
     		draw_sprite(backgr,bmp[frame],x,y);
     	else if(sprit==0)
        	blit(bmp[frame],backgr,x,y,0,0,bmp[frame]->w,bmp[frame]->h);
     	else if(sprit==2)
        	draw_trans_sprite(backgr,bmp[frame],x,y);

        //if the current counter is smaller than the desired delay value
    	if(rest<delay)
      	   rest++; //increase it
    	else if(rest>=delay)
      	   rest=0;

        //if the the counter is equal to the desired delay
    	if(rest==delay)
        	{
            if(going==1) //and the animation is going
     	       frame++;

     	    if(frame>number_of_frames)  //if at the end of the animation
          	   {
       		   frame=0;  //moves back to start of animation
               ret=1000; //returns 1000 means is it is at the end of the animation
               }
            else
               ret=frame; //otherwise it returns the frame number
            }
        }
    return ret;
	}

void CAnim::add_bmp(BITMAP *pic)
	{
     if(number_of_frames<=14)
       number_of_frames++;
     bmp[number_of_frames]=pic;
    }







