#include <stdio.h>
#include <allegro.h>
#include <math.h>

#ifdef M_PI
#undef M_PI
#endif

#define M_PI 3.14159265358979323846

#define BUF_LEN 16384

SAMPLE *_tone_samp = NULL;
double _tone = 0.0;
double _dt = 0.0;
int _msec_tone_len=0;
int _msec_tone_cnt=0;
int _tone_playing=0;
int _tone_init=0;
int _tone_pan=0;
int _tone_voice=-1;

void _tone_timer(void)
{
	if(!_tone_init) return;

	if(_msec_tone_cnt > _msec_tone_len) {
		remove_int(_tone_timer);

		voice_stop(_tone_voice);
		_tone_playing = 0;
		_msec_tone_cnt = 0;
		_msec_tone_len = 0;
		return;
	}

	_msec_tone_cnt++;
}
END_OF_FUNCTION(_tone_timer);

int init_tone(void)
{
	LOCK_VARIABLE(_tone_voice);
	LOCK_VARIABLE(_tone);
	LOCK_VARIABLE(_dt);
	LOCK_VARIABLE(_msec_tone_len);
	LOCK_VARIABLE(_msec_tone_cnt);
	LOCK_VARIABLE(_tone_playing);
	LOCK_VARIABLE(_tone_init);

	_tone_init = 1;
	_tone_pan = 128;

	_tone_samp = create_sample(16, 1, 44100, BUF_LEN);
	if(!_tone_samp) return 0;

	return 1;
}

void free_tone(void)
{
	remove_int(_tone_timer);
	
	destroy_sample(_tone_samp);

	_tone_samp = NULL;
	_tone_voice = -1;
	_tone_init = 0;
	_tone_playing = 0;
}

int play_tone(double tone, int len)
{
	double t=0.0;
	unsigned short v=0;
	int i=0;
	unsigned short *_tone_data = NULL;

	if(!_tone_init) return 0;

	if(_tone_voice < 1)
		_tone_voice = allocate_voice(_tone_samp);
	//else
	//	reallocate_voice(_tone_voice, _tone_samp);

	voice_set_playmode(_tone_voice, PLAYMODE_LOOP);

	_tone_playing = 1;

	_msec_tone_len = len;

	_dt = (tone * 2 * M_PI) / 44100;

	_tone_data = _tone_samp->data;
	if(_tone_data) {

		for (i = 0; i < BUF_LEN; i++) {
			t += _dt;
			if (t > 2 * M_PI) t -= 2 * M_PI;
			v = 16384 + 16383 * sin(t);

			//v &= 0xF000;

			_tone_data[i] = v;
		}

		if(_tone_samp->stereo)
			for (i = BUF_LEN; i < BUF_LEN*2; i++) {
				t += _dt;
				if (t > 2 * M_PI) t -= 2 * M_PI;
				v = 16384 + 16383 * sin(t);

				//v &= 0xF000;

				_tone_data[i] = v;
			}

	}

	install_int(_tone_timer, 10);
	voice_start(_tone_voice);

	return 1;
}

void set_tone_pan(int pan)
{
	voice_set_pan(_tone_voice, pan);
}

#ifdef STANDALONE 
int main(int argc, char **argv)
{
	int tone = 0;
	int pan = 0,pd=0;
	allegro_init();
	install_keyboard();
	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
	
	init_tone();

	play_tone(420, 200);
	while(_tone_playing);
	
	while(!key[KEY_ESC]) {
		while(_tone_playing) ;
		
		play_tone(((readkey() >> 8)+10) * 10, 10);
		//clear_keybuf();
	}

	free_tone();
}
END_OF_MAIN();
#endif