#include <stdio.h>
#include <ctype.h>
#include <allegro.h>
#include "dr.h"
#include "menu.h"
#include "tone.h"

menu_t *cur_menu = NULL;
int exit_menu = 0;
int sel_item = 1;
int cur_item = 0;

MIDI *song = NULL;
MIDI *title_song = NULL;
int theme = 0;
int ptheme = 0;

int theme_cnt=2;
char **theme_files = NULL;
char **theme_names = NULL;

#define _do_draw(i) do{ cur_item=i; cur_menu[i].draw(cur_menu[i].text); }while(0)

void set_menu(menu_t *menu)
{
	cur_menu = menu;
	sel_item = 1;
}

char get_ascii(int key)
{
	return (key & 0xff);
}

int get_scancode(int key)
{
	return (key >> 8);
}

int menu_width = 0;
int menu_height = 0;
int menu_x=0, menu_y=0;


void mi_draw_string(char *string)
{
	int x = SCREEN_W/2;// - menu_width/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, string);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);


	textout(screen, font, string, x-tw/2, y, c);
}

void mi_msg_menu(int m, int c) {}

void mi_draw_menu(char *string)
{
	int w = 0, tw=0, h=0;
	int i;

	for(i=0; cur_menu[i].text; i++) {
		tw = text_length(font, cur_menu[i].text);
		if(tw > w) w = tw;
		h += text_height(font);
	}

	w += 40;
	h += 40;

	menu_x = SCREEN_W/2 - w/2;
	menu_y = SCREEN_H/2 - h/2;

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	rectfill(screen, SCREEN_W/2 - w/2, SCREEN_H/2 - h/2, SCREEN_W/2 - w/2 + w, SCREEN_H/2 - h/2 + h, makecol(150,150,150));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

	textout(screen, font, string, SCREEN_W/2 - text_length(font, cur_menu[0].text)/2, SCREEN_H/2 - h/2 + 5, makecol(255,255,255));
	hline(screen, SCREEN_W/2 - w/2, SCREEN_H/2 - h/2 + text_height(font)+5, SCREEN_W/2 - w/2 + w, makecol(200,200,200));

	rect(screen, SCREEN_W/2 - w/2 - 1, SCREEN_H/2 - h/2 - 1, SCREEN_W/2 - w/2 + w + 1, SCREEN_H/2 - h/2 + h + 1, makecol(255,255,255));
	rect(screen, SCREEN_W/2 - w/2 - 2, SCREEN_H/2 - h/2 - 2, SCREEN_W/2 - w/2 + w + 2, SCREEN_H/2 - h/2 + h + 2, makecol(0,0,0));

	menu_width = w;
	menu_height = h;
}

void mi_play_1p(int msg, int c)
{
	switch(msg) {
		case MENU_SELECT:
			cur_menu = NULL;
			if(!theme) stop_midi();
			else {
				play_midi(song, 1);
				ptheme = 1;
			}
			
			players = 0;
			play();
			score[0] = 0;
			level[0] = 0;
			break;
	}
}

void mi_conf_menu(int msg, int c)
{
	switch(msg) {
		case MENU_SELECT:
			_do_menu(conf_menu);
			break;
	}
}

void mi_inp_conf(int msg, int c)
{
	switch(msg) {
		case MENU_SELECT:
			_do_menu(inp_conf_menu);
			break;
	}
}

void mi_draw_speed(char *str)
{
	int x = SCREEN_W/2;// - menu_width/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, str);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char gss[][4] = { "Min", "Med", "Max" };

	textprintf(screen, font, x-tw/2-text_length(font, gss[speed])/2, y, c, "%s %s", str, gss[speed]);
}

void mi_set_speed(int msg, int c)
{
	switch(msg) {
		case MENU_LEFT:
			if(speed) speed--;
			break;

		case MENU_RIGHT:
			if(speed < 2) speed++;
			break;
	}
}

void mi_draw_theme(char *str)
{
	int x = SCREEN_W/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, str);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char gss[][6] = { "None ", "Chill", "Fever" };

	if(!theme_names || !theme_names[theme])
		textprintf(screen, font, x-tw/2-text_length(font, gss[theme])/2, y, c, "%s %s", str, gss[theme]);
	else {
		if(!theme_names[theme]) { printf("ummm... no theme %i\n",theme>0?theme:0); return; }
		textprintf(screen, font, x-tw/2-text_length(font, theme_names[theme])/2, y, c, "%s %s", str, theme_names[theme]);
	}
}

void mi_set_theme(int msg, int c)
{
	char songs[][10] = { {0}, "chill2.mid", "fever.mid" };
	switch(msg) {
		case MENU_LEFT:
			if(theme > 0) theme--;
			else theme = theme_cnt;
			break;

		case MENU_RIGHT:
			if(theme < theme_cnt) theme++;
			else theme = 0;
			break;
	}

	if(theme>0 && (theme_files && theme_files[theme])) {
		if(song) destroy_midi(song);
		song = load_midi(theme_files[theme]);
		play_midi(song, 1);
		ptheme = 1;
	} else
	if(songs[theme][0]) {
		if(song) destroy_midi(song);
		song = load_midi(songs[theme]);
		play_midi(song, 1);
		ptheme = 1;
	} else {
		stop_midi();
		play_midi(title_song, 1);
	}
}

void mi_set_p1_level(int msg, int c)
{
	switch(msg) {
		case MENU_LEFT:
			if(level[0]) level[0]--;
			break;

		case MENU_RIGHT:
			if(level[0] < 12) level[0]++;
			break;
	}
}

void mi_draw_p1_level(char *str)
{
	int x = SCREEN_W/2;// - menu_width/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, str);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char p1_level_str[3];

	sprintf(p1_level_str, "%2i", level[0]);

	textprintf(screen, font, x-tw/2-text_length(font, p1_level_str)/2, y, c, "%s %s", str, p1_level_str);
}


int snd = 255;
int fx = 255;
int music = 255;

void mi_set_snd(int msg, int c)
{
	switch(msg) {
		case MENU_LEFT:
			if(snd-5 >= 0) snd-=5;
			set_volume(snd, music);
			break;

		case MENU_RIGHT:
			if(snd+5 <= 255) snd+=5;
			set_volume(snd, music);
			break;
	}
}

void mi_draw_snd(char *str)
{
	int x = SCREEN_W/2;// - menu_width/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, str);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char snd_str[5];

	sprintf(snd_str, "%2i", snd);

	textprintf(screen, font, x-tw/2-text_length(font, snd_str)/2, y, c, "%s %s", str, snd_str);
}

void mi_set_music(int msg, int c)
{
	switch(msg) {
		case MENU_LEFT:
			if(music-5 >= 0) music-=5;
			set_volume(snd, music);
			break;

		case MENU_RIGHT:
			if(music+5 <= 255) music+=5;
			set_volume(snd, music);
			break;
	}
}

void mi_draw_music(char *str)
{
	int x = SCREEN_W/2;// - menu_width/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, str);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char music_str[5];

	sprintf(music_str, "%2i", music);

	textprintf(screen, font, x-tw/2-text_length(font, music_str)/2, y, c, "%s %s", str, music_str);
}

void mi_set_fx(int msg, int c)
{
	switch(msg) {
		case MENU_LEFT:
			if(fx-5 >= 0) fx-=5;
			voice_set_volume(_tone_voice, fx);
			break;

		case MENU_RIGHT:
			if(fx+5 <= 255) fx+=5;
			voice_set_volume(_tone_voice, fx);
			break;
	}
}

void mi_draw_fx(char *str)
{
	int x = SCREEN_W/2;// - menu_width/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, str);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char fx_str[5];

	sprintf(fx_str, "%2i", fx);

	textprintf(screen, font, x-tw/2-text_length(font, fx_str)/2, y, c, "%s %s", str, fx_str);
}


void mi_exit_menu(int m, int c)
{
	if(m == MENU_SELECT)
		exit_menu = 1;
}

void mi_draw_p1_inp(char *s)
{
	int x = SCREEN_W/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, s);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);
	char gss[][6] = { "Joy", "Kb " };

	textprintf(screen, font, x-tw/2-text_length(font, gss[input[0].typ])/2, y, c, "%s %s", s, gss[input[0].typ]);
}

void mi_set_p1_inp(int msg, int c)
{
	switch(msg) {
		case MENU_LEFT:
			if(input[0].typ == 0) input[0].typ = 1;
			else input[0].typ = 0;
			break;

		case MENU_RIGHT:
			if(input[0].typ == 0) input[0].typ = 1;
			else input[0].typ = 0;
			break;
	}

	init_input(PLAYER_ONE);
}

void mi_cnf_p1_inp(int m, int c)
{
	switch(m) {
		case MENU_SELECT:
			if(input[0].typ == PLY_INPUT_KEY)
				_do_menu(inp_p1_kb_conf_menu);
			break;
	}
}

void _mi_draw_imp_item(char *s)
{
	int x = SCREEN_W/2;
	int y = SCREEN_H/2 - menu_height/2 + (text_height(font) * (cur_item+1))+15;
	int tw = text_length(font, s);
	int c = cur_item == sel_item ? makecol(255,255,255) : makecol(200,200,200);

//	rectfill(screen, menu_x+1, y, menu_x+menu_width-2, y+text_height(font)-2, makecol(200,200,200));
	textprintf(screen, font, x-tw/2, y, c, "%s", s);
}

void mi_draw_inp_kb_up(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cup);

	_mi_draw_imp_item(str);
}

void mi_draw_inp_kb_down(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cdown);

	_mi_draw_imp_item(str);
}

void mi_draw_inp_kb_left(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cleft);

	_mi_draw_imp_item(str);
}
void mi_draw_inp_kb_right(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cright);

	_mi_draw_imp_item(str);
}
void mi_draw_inp_kb_fleft(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cflipl);

	_mi_draw_imp_item(str);
}
void mi_draw_inp_kb_fright(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cflipr);

	_mi_draw_imp_item(str);
}
void mi_draw_inp_kb_sel(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].csel);

	_mi_draw_imp_item(str);
}
void mi_draw_inp_kb_esc(char *s)
{
	char str[255];
	
	sprintf(str, "%s %s", s, input[0].cesc);

	_mi_draw_imp_item(str);
}

void _mi_msg_inp_kb_item(char *tmp, int c)
{
	int scan = get_scancode(c);

	switch(scan) {
		case KEY_ESC:       strcpy(tmp, "ESC");    break;
		case KEY_ENTER_PAD: /* empty */
		case KEY_ENTER:     strcpy(tmp, "ENTER");  break;
		case KEY_BACKSPACE: strcpy(tmp, "BS");     break;
		case KEY_SPACE:     strcpy(tmp, "SPACE");  break;
		case KEY_INSERT:    strcpy(tmp, "INSERT"); break;
		case KEY_DEL:       strcpy(tmp, "DELETE"); break;
		case KEY_HOME:      strcpy(tmp, "HOME");   break;
		case KEY_END:       strcpy(tmp, "END");    break;
		case KEY_PGUP:      strcpy(tmp, "PGUP");   break;
		case KEY_PGDN:      strcpy(tmp, "PGDN");   break;
		case KEY_UP:        strcpy(tmp, "UP");     break;
		case KEY_DOWN:      strcpy(tmp, "DOWN");   break;
		case KEY_LEFT:      strcpy(tmp, "LEFT");   break;
		case KEY_RIGHT:     strcpy(tmp, "RIGHT");  break;
		case KEY_TAB:       strcpy(tmp, "TAB");    break;
		case KEY_PRTSCR:    strcpy(tmp, "PRTSCR"); break;
		case KEY_PAUSE:     strcpy(tmp, "PAUSE");  break;
		case KEY_F1:        strcpy(tmp, "F1");     break;
		case KEY_F2:        strcpy(tmp, "F2");     break;
		case KEY_F3:        strcpy(tmp, "F3");     break;
		case KEY_F4:        strcpy(tmp, "F4");     break;
		case KEY_F5:        strcpy(tmp, "F5");     break;
		case KEY_F6:        strcpy(tmp, "F6");     break;
		case KEY_F7:        strcpy(tmp, "F7");     break;
		case KEY_F8:        strcpy(tmp, "F8");     break;
		case KEY_F9:        strcpy(tmp, "F9");     break;
		case KEY_F10:       strcpy(tmp, "F10");    break;
		case KEY_F11:       strcpy(tmp, "F11");    break;
		case KEY_F12:       strcpy(tmp, "F12");    break;
		case KEY_0_PAD:     strcpy(tmp, "0 PAD");  break;
		case KEY_1_PAD:     strcpy(tmp, "1 PAD");  break;
		case KEY_2_PAD:     strcpy(tmp, "2 PAD");  break;
		case KEY_3_PAD:     strcpy(tmp, "3 PAD");  break;
		case KEY_4_PAD:     strcpy(tmp, "4 PAD");  break;
		case KEY_5_PAD:     strcpy(tmp, "5 PAD");  break;
		case KEY_6_PAD:     strcpy(tmp, "6 PAD");  break;
		case KEY_7_PAD:     strcpy(tmp, "7 PAD");  break;
		case KEY_8_PAD:     strcpy(tmp, "8 PAD");  break;
		case KEY_9_PAD:     strcpy(tmp, "9 PAD");  break;
		default:            sprintf(tmp, "%c", toupper(get_ascii(c))); break; 
	}
}

void mi_msg_inp_kb_down(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].cdown, "%s", tmp);

	input[0].down = get_scancode(c);
}
void mi_msg_inp_kb_left(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].cleft, "%s", tmp);

	input[0].left = get_scancode(c);
}
void mi_msg_inp_kb_right(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].cright, "%s", tmp);

	input[0].right = get_scancode(c);
}
void mi_msg_inp_kb_fleft(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].cflipl, "%s", tmp);

	input[0].flipl = get_scancode(c);
}
void mi_msg_inp_kb_fright(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].cflipr, "%s", tmp);

	input[0].flipr = get_scancode(c);
}
void mi_msg_inp_kb_sel(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].csel, "%s", tmp);

	input[0].sel = get_scancode(c);
}
void mi_msg_inp_kb_esc(int m, int c)
{
	char tmp[8];

	_mi_msg_inp_kb_item(tmp, c);
	
	sprintf(input[0].cesc, "%s", tmp);

	input[0].esc = get_scancode(c);
}

menu_t main_menu[] = {
	{"Main Menu", mi_draw_menu,   mi_msg_menu},
	{"Play 1p",   mi_draw_string, mi_play_1p},
//	{"Play 2p",   mi_draw_string, mi_play_2p},
	{"Configure", mi_draw_string, mi_conf_menu},
	{"Exit",      mi_draw_string, mi_exit_menu},
	{NULL, NULL},
};

menu_t conf_menu[] = {
	{"Congig",       mi_draw_menu,     mi_msg_menu},
	{"Input Config", mi_draw_string,   mi_inp_conf},
	{"Theme:",        mi_draw_theme,    mi_set_theme},
	{"Game Speed:",  mi_draw_speed,    mi_set_speed},
	{"P1 level:",    mi_draw_p1_level, mi_set_p1_level},
//	{"P2 level:",    mi_draw_p2_level, mi_set_p2_level},
	{"Global Vol:",  mi_draw_snd,      mi_set_snd},
	{"Music Vol:",   mi_draw_music,    mi_set_music},
	{"SndFx Vol:",   mi_draw_fx,       mi_set_fx},
	{"Back",         mi_draw_string,   mi_exit_menu},
	{NULL, NULL},
};

menu_t inp_conf_menu[] = {
	{"Input Config",    mi_draw_menu,     mi_msg_menu},
	{"P1 input type:",  mi_draw_p1_inp,   mi_set_p1_inp},
	{"Config P1 input", mi_draw_string,   mi_cnf_p1_inp},
//	{"P2 input type:",  mi_draw_ply2_inp, mi_set_ply2_inp},
//	{"Config P2 input", mi_draw_string,   mi_cnf_ply2_inp},
	{"Back",            mi_draw_string,   mi_exit_menu},
	{NULL, NULL},
};

menu_t inp_p1_kb_conf_menu[] = {
	{"P1 Input Config", mi_draw_menu,          mi_msg_menu},
	{"Dir down:",       mi_draw_inp_kb_down,   mi_msg_inp_kb_down},
	{"Dir left:",       mi_draw_inp_kb_left,   mi_msg_inp_kb_left},
	{"Dir right:",      mi_draw_inp_kb_right,  mi_msg_inp_kb_right},
	{"Flip left:",      mi_draw_inp_kb_fleft,  mi_msg_inp_kb_fleft},
	{"Flip right:",     mi_draw_inp_kb_fright, mi_msg_inp_kb_fright},
	{"Select:",         mi_draw_inp_kb_sel,    mi_msg_inp_kb_sel},
	{"Escape:",         mi_draw_inp_kb_esc,    mi_msg_inp_kb_esc},
	{"Back",            mi_draw_string,        mi_exit_menu},
	{NULL, NULL},
};

/*menu_t inp_p1_joy_conf_menu[] = {
	{"P1 Input Config",  mi_draw_menu,   mi_msg_menu},
	{"Dir down: DOWN",   mi_draw_string, mi_msg_menu},
	{"Dir left: LEFT",   mi_draw_string, mi_msg_menu},
	{"Dir right: RIGHT", mi_draw_string, mi_msg_menu},
	{"Flip left:",       mi_draw_inp_joy_fleft,  mi_msg_inp_joy_fleft},
	{"Flip right:",      mi_draw_inp_joy_fright, mi_msg_inp_joy_fright},
	{"Select:",          mi_draw_inp_joy_sel,    mi_msg_inp_joy_sel},
	{"Escape:",          mi_draw_inp_joy_esc,    mi_msg_inp_joy_esc},
	{"Back",             mi_draw_string,        mi_exit_menu},
	{NULL, NULL},
};*/

// main-menu: [Play 1p, Play 2p, Configure, Exit]
// Conf-menu: [Input, Speed, P1 level, P2 level]
// inp-conf: [ply1-inp-typ, conf-pl1-inp, ply2-inp-typ, conf-ply2-inp]

FONT *large = NULL, *med = NULL, *small = NULL;

void _draw_scr(void)
{
	_do_bg(screen);
	textout(screen, small, "Act Of Donkey", 3, text_height(small)-1, makecol(0,0,0));
	textout(screen, small, "Act Of Donkey", 4, text_height(small), makecol(255,255,255));
	
	textout(screen, small, "Its Your Turn To Donky Donkey Donkey", 3, SCREEN_H-text_height(small)*2-1, makecol(0,0,0));
	textout(screen, small, "Its Your Turn To Donky Donkey Donkey", 4, SCREEN_H-text_height(small)*2, makecol(255,255,255));

	draw_hiscores(20, 40);

}

int _do_menu(menu_t *menu)
{
	int i=0,kp,scan;

	text_mode(-1);
	
	exit_menu = 0;

	while(!exit_menu) {

		if(menu != cur_menu) {
			set_menu(menu);
			//clear(screen);
			_draw_scr();
			for(i=0; cur_menu[i].text; i++) {
				_do_draw(i);
			}

			if(title_song && ptheme) {
				play_midi(title_song, 1);
				ptheme = 0;
			}
		}

		if(!keypressed()) continue;

		kp = readkey();
		scan = get_scancode(kp);

		if(scan == KEY_UP) {
			if(key_shifts & KB_CTRL_FLAG) {
				cur_menu[sel_item].msg(MENU_KEY, kp);
				_draw_scr();
				for(i=0; cur_menu[i].text; i++) {
					_do_draw(i);
				}
			} else {
				i = sel_item--;
				if(!sel_item) while(cur_menu[sel_item+1].text) sel_item++;
				_do_draw(i);
				_do_draw(sel_item);
			}
		} else
		if(scan == KEY_DOWN) {
			if(key_shifts & KB_CTRL_FLAG) {
				cur_menu[sel_item].msg(MENU_KEY, kp);
				_draw_scr();
				for(i=0; cur_menu[i].text; i++) {
					_do_draw(i);
				}
			} else {
				i = sel_item++;
				if(!cur_menu[sel_item].text) sel_item = 1;
				_do_draw(i);
				_do_draw(sel_item);
			}

		} else
		if(scan == KEY_LEFT) {
			cur_menu[sel_item].msg(MENU_LEFT, kp);

			_draw_scr();
			for(i=0; cur_menu[i].text; i++) {
				_do_draw(i);
			}
			//_do_draw(sel_item);
		} else
		if(scan == KEY_RIGHT) {
			cur_menu[sel_item].msg(MENU_RIGHT, kp);
			_draw_scr();
			for(i=0; cur_menu[i].text; i++) {
				_do_draw(i);
			}
			//_do_draw(sel_item);
		} else
		if(scan == KEY_ENTER || scan == KEY_SPACE) {
			cur_menu[sel_item].msg(MENU_SELECT, kp);
		} else
		if(scan == KEY_ESC) {
			if(key_shifts & KB_CTRL_FLAG) {
				cur_menu[sel_item].msg(MENU_KEY, kp);
				_draw_scr();
				for(i=0; cur_menu[i].text; i++) {
					_do_draw(i);
				}
			} else {
				break;
			}
		} else {
			cur_menu[sel_item].msg(MENU_KEY, kp);
			_draw_scr();
			for(i=0; cur_menu[i].text; i++) {
				_do_draw(i);
			}
			//_do_draw(sel_item);
		}
		if(!_tone_playing) {
			int tone = 500;
			if(cur_menu == main_menu) tone += (sizeof(main_menu)/sizeof(menu_t)-sel_item) * 100;
			else
			if(cur_menu == conf_menu) tone += (sizeof(conf_menu)/sizeof(menu_t)-sel_item) * 100;
			else
			if(cur_menu == inp_conf_menu) tone += (sizeof(inp_conf_menu)/sizeof(menu_t)-sel_item) * 100;
			else
			if(cur_menu == inp_p1_kb_conf_menu) tone += (sizeof(inp_p1_kb_conf_menu)/sizeof(menu_t)-sel_item) * 100;

			set_tone_pan(128);
			play_tone(tone, 5);
		}
		clear_keybuf();
	}

	exit_menu = 0;

	return 1;
}

#include "fonts.h"

void read_themes(void)
{
	int themes=0,i=0;
	char tmp[255], **t=NULL;
	
	theme_cnt = themes = get_config_int("themes", "themecnt", 0);

	if(theme_cnt < 1) return;

	theme_names = calloc(themes+1, sizeof(char *));
	if(!theme_names) return;

	theme_files = calloc(themes+1, sizeof(char *));
	if(!theme_files) { free(theme_names); theme_names=NULL; return; }

	for(; themes>0; themes--) {
		sprintf(tmp, "theme%i", themes);
		t = get_config_argv("themes", tmp, &i);
		if(!t) { printf("failed to get var: %s\n", tmp); return; }
		theme_names[themes] = calloc(1, strlen(t[0])+1);
		if(!theme_names[themes]) return;
		strcpy(theme_names[themes], t[0]);

		theme_files[themes] = calloc(1, strlen(t[1])+1);
		if(!theme_files[themes]) return;
		strcpy(theme_files[themes], t[1]);
	}

	theme = get_config_int("themes", "theme", 0)-1;
	if(theme < 0) theme = 0;

	if(theme > 0) song = load_midi(theme_files[theme]);
	
}

void free_themes(void)
{
	if(!theme_names) return;

	for(; theme_cnt<0; theme_cnt--) {
		free(theme_names[theme_cnt]);
		free(theme_files[theme_cnt]);
	}

	set_config_int("themes", "theme", theme);
}

/* int menu_main() */
int main(int argc, char **argv)
{
	BITMAP *dk = NULL;
	SAMPLE *sound = NULL;
	DATAFILE *data = NULL;
	
	allegro_init();
	install_keyboard();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	set_color_depth(16);

	init_tone();

	data = load_datafile("fonts.dat");
	if(!data) return 0;

	large = data[largefnt].dat;
	med   = data[medfnt].dat;
	small = data[smallfnt].dat;


	if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 640, 480)<0) {
		fprintf(stderr, "Error: %s\n", allegro_error);
		return 0;
	}

	init();
	read_themes();

	title_song = load_midi("title.mid");

	sound = load_sample("donky.wav");
	if(sound) play_sample(sound, 255, 128, 1000, 0);

	dk = load_bitmap("donkey.tga", NULL);
	if(!dk) printf("Error: %s\n", allegro_error);
	draw_sprite(screen, dk, SCREEN_W/2-dk->w/2-10, SCREEN_H/2-dk->h/2);

	text_mode(-1);
	textout(screen, large, "Act",    55, 100, makecol(255,255,255));
	textout(screen, med,   "Of",     55, 150, makecol(255,255,255));
	textout(screen, large, "Donkey", 55, 200, makecol(255,255,255));
	textout(screen, large, "Software", 55, 250, makecol(255,255,255));


	textout(screen, small, "Bringing games", 405, 300, makecol(255,255,255));
	textout(screen, small, "Like This",      405, 350, makecol(255,255,255));
	textout(screen, small, "To you Since",   405, 400, makecol(255,255,255));
	textout(screen, small, "Donkey Donkey Donkey", 370, 450, makecol(255,255,255));


	readkey();

	title_song = load_midi("title.mid");
	if(title_song) play_midi(title_song, 1);

	_do_menu(main_menu);

	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);

	write_kbinput();
	write_scores();

	free_themes();
	free_tone();
	return 0;

}
END_OF_MAIN();








 