#ifndef __DR_H__
#define __DR_H__

#include <stdio.h>
#include <time.h>
#include <allegro.h>
#include <allegro/aintern.h>

#define BOARD_W 8
#define BOARD_H 16

#define TILE_W 22
#define TILE_H 22

#define TILE_BLANK 1
#define TILE_RED 2
#define TILE_BLUE 4
#define TILE_YELLOW 8
#define TILE_DIRTY 16
#define TILE_JOIN_UP 32
#define TILE_JOIN_DOWN 64
#define TILE_JOIN_LEFT 128
#define TILE_JOIN_RIGHT 512
#define TILE_VIRUS 1024

#define SWAP(a, b) ({ a ^= b ^= a ^= b; })

#define num_viri(lev) (((lev) + 1) * 4)
#define min_y(lev) ((BOARD_H - 10) + (((level[lev] - 9) > 0) ? (level[lev] - 9) / 2 : 0))
// 9 is used because the level is zero based. and 'level[lev] - 9'
// looks cleaner than 'level[lev]+1 - 10' :) (but like it matters)

#define DIR_LEFT 1
#define DIR_RIGHT 2
#define DIR_DOWN 3

#define PLAYER_ONE 0
#define PLAYER_TWO 1

#define rand_color() (colors[(rand() % 3)+1])

#define rand_pill(pill) ({\
	int i, j; \
	for(i=0; i<2; i++)for(j=0; j<2; j++) pill[i][j] = 0; \
	pill[1][1] = rand() % 3 + 1; \
	pill[1][0] = rand() % 3 + 1; \
})

#define copy_pill(to, from) ({ \
	int i,j; \
	for(i=0; i<2; i++)for(j=0; j<2; j++) to[i][j] = from[i][j]; \
})

#define next_pill(ply) ({ \
	copy_pill(pill[ply], npill[ply]); \
	rand_pill(npill[ply]); \
})

#define set_board_pos(ply, x, y) (void)((board_x[ply]=x) && (board_y[ply]=y))

#define PLY_INPUT_JOY 0
#define PLY_INPUT_KEY 1

#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3

typedef struct joy_state {
	int init;
	int dir[4];
	int num_buttons;
	int *buttons;
} joy_state;

typedef struct ply_input {
	int typ; // joy, or keyboard [1,2]
	int joy; // if joy which joy.
	joy_state jstate;
	int sel, esc, flipl, flipr; // and these are for KEY_* or joy button numbers.
	int up,down,left,right; // these are for KEY_*

	char csel[8], cesc[8], cflipl[8], cflipr[8];
	char cup[8],cdown[8],cleft[8],cright[8];
} ply_input;

#define GKEY(opt,ret)\
	if((opt)==key) return ret;\
	else 

#define PLY_MSG_UP 1
#define PLY_MSG_DOWN 2
#define PLY_MSG_LEFT 3
#define PLY_MSG_RIGHT 4
#define PLY_MSG_SEL 5
#define PLY_MSG_ESC 6
#define PLY_MSG_FLIPR 7
#define PLY_MSG_FLIPL 8

extern ply_input input[2];
extern int speed;
extern int level[2];
extern int score[2];
extern int players;
extern int key_read;

void set_def_keys(void);
int _init_joy_info(int);
int play();
int init(void);
void init_input(int);
void write_kbinput();
void _do_bg(BITMAP *);
void draw_hiscores(int, int);
int write_scores(void);

#endif /* __DR_H__ */