#include "dr.h"
#include "hiscore.h"
#include "tone.h"

#define FLIP_TONE 400
#define DROP_TONE 100

#define TONE_LEN 10

extern FONT *large;
extern FONT *med;
extern FONT *small;

int qsort_helper(const void *, const void *);

int colors[4] = { TILE_BLANK, TILE_RED, TILE_BLUE, TILE_YELLOW };
int npill[2][2][2];
int pill[2][2][2];
int pill_x[2], pill_y[2];
int level[2];
int dirty[2];
int viri[2];
int done[2];
int dropping[2];
int **board[2];
int board_x[2];
int board_y[2];
int kill_cnt[2];
int players = 0;
int player = -1;
int score[2]={0,0};

int speed = 1;

ply_input input[2];

BITMAP *boards[2];

void write_kbinput()
{
	set_config_string("input", "down_str",  input[0].cdown);
	set_config_int("input",    "down_scan", input[0].down);

	set_config_string("input", "left_str", input[0].cleft);
	set_config_int("input",    "left_scan", input[0].left);

	set_config_string("input", "right_str", input[0].cright);
	set_config_int("input",    "right_scan", input[0].right);

	set_config_string("input", "flipl_str", input[0].cflipl);
	set_config_int("input",    "flipl_scan", input[0].flipl);

	set_config_string("input", "flipr_str", input[0].cflipr);
	set_config_int("input",    "flipr_scan", input[0].flipr);

	set_config_string("input", "sel_str", input[0].csel);
	set_config_int("input",    "sel_scan", input[0].sel);

	set_config_string("input", "esc_str", input[0].cesc);
	set_config_int("input",    "esc_scan", input[0].esc);
}

void read_kbinput()
{
	const char *tmp = NULL;
	int t=0;

	tmp = get_config_string("input", "down_str", "DOWN");
	t   = get_config_int("input", "down_scan", KEY_DOWN);
	strcpy(input[0].cdown, tmp);
	input[0].down = t;

	tmp = get_config_string("input", "left_str", "LEFT");
	t   = get_config_int("input", "left_scan", KEY_LEFT);
	strcpy(input[0].cleft , tmp);
	input[0].left = t;

	tmp = get_config_string("input", "right_str", "RIGHT");
	t   = get_config_int("input", "left_str", KEY_RIGHT);
	strcpy(input[0].cright , tmp);
	input[0].right = t;

	tmp = get_config_string("input", "flipl_str", "Z");
	t   = get_config_int("input", "flipl_scan", KEY_Z);
	strcpy(input[0].cflipl , tmp);
	input[0].flipl = t;

	tmp = get_config_string("input", "flipr_str", "X");
	t   = get_config_int("input", "flipr_scan", KEY_X);
	strcpy(input[0].cflipr , tmp);
	input[0].flipr = t;

	tmp = get_config_string("input", "esc_str", "ESC");
	t   = get_config_int("input", "esc_scan", KEY_ESC);
	strcpy(input[0].cesc , tmp);
	input[0].esc = t;

	tmp = get_config_string("input", "sel_str", "ENTER");
	t   = get_config_int("input", "sel_scan", KEY_ENTER);
	strcpy(input[0].csel , tmp);
	input[0].sel = t;
}

void add_score(char *name, int score)
{
	if(!name) return;

	if(hiscores[10].name) free(hiscores[10].name);

	hiscores[10].name = calloc(sizeof(char),strlen(name)+1);

	if(!hiscores[10].name) return;

	strcpy(hiscores[10].name,name);

	hiscores[10].score = score;

   qsort(hiscores, 11, sizeof(HISCORE), qsort_helper);
}

int is_hiscore(int sc)
{
   return (sc>=hiscores[9].score) ? 1 : 0;
}

void roundrect(BITMAP *b, int r, int x1, int y1, int x2, int y2, int c)
{
   int t;
   if(x1>x2) { t = x1; x1 = x2; x2 = t; }
   if(y1>y2) { t = y1; y1 = y2; y2 = t; }

   if(r>255) r = 1;

   hline(b,x1+r,y1,x2-r,c); // top of rect
   hline(b,x1+r,y2,x2-r,c); // bottom of rect

   vline(b,x1,y1+r,y2-r,c); // left side of rect
   vline(b,x2,y1+r,y2-r,c); // right side of rect

   arc(b,x1+r,y1+r,itofix(64),itofix(128),r,c);  // top left
   arc(b,x1+r,y2-r,itofix(128),itofix(192),r,c); // bottom left
   arc(b,x2-r,y1+r,itofix(0),itofix(64),r,c);    // top right
   arc(b,x2-r,y2-r,itofix(192),itofix(0),r,c);   // bottom right
}

void draw_hiscores(int x, int y)
{
	int i;

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	rectfill(screen, x, y, x+200, y+240, makecol(150,150,150));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

	textout(screen, med, "HIGH SCORES", x+20, y+3, makecol(255,255,255));
	textout(screen, med, "HIGH SCORES", x+21, y+4, makecol(0,0,0));

	rect(screen, x, y, x+200, y+240, makecol(255,255,255));
	rect(screen, x-1, y-1, x+201, y+241, makecol(0,0,0));

	x += 4;
	y += 4;

	for(i=0; i<10; i++) {
		textprintf(screen, font, x, y+(text_height(font)+12)*(i)+40, makecol(255,255,255), "%i: %s %i", i+1, hiscores[i].name, hiscores[i].score);
	}
}

/* start of reused code */
volatile int dr_game_timer = 0;
volatile int paused = 0;
void dr_game_timer_func(void)
{
	if(!paused) dr_game_timer++;
} END_OF_FUNCTION(dr_game_timer_func);

volatile int dr_drop_timer = 0;
void dr_drop_timer_func(void)
{
	if(!paused) dr_drop_timer++;
} END_OF_FUNCTION(dr_drop_timer_func);

int set_board(int ply)
{
	int i = 0, miny = 0, j = 0, x, y, c=0;
	if(!players || ply >= players || ply < 0) return 0;
	
	if(!board[ply]) { // create ply's board if it hasn't been
		boards[ply] = create_bitmap(BOARD_W*TILE_W, BOARD_H*TILE_H);
		if(!boards[ply]) return 0;
		board[ply] = calloc(BOARD_H, sizeof(int *));
		if(!board[ply]) return 0;
		for(i=0; i<BOARD_H; i++) {
			board[ply][i] = calloc(BOARD_W, sizeof(int));
			if(!board[ply][i]) return 0;
		}
	}

	dirty[ply] = 1;
	for(i=0; i<BOARD_H; i++)
		for(j=0; j<BOARD_W; j++) {
			board[ply][i][j] = 0;
			board[ply][i][j] |= (TILE_DIRTY|TILE_BLANK);
		}

	miny = min_y(ply);
	// get the minimum hight for placing viri (in this case the top is 0)
	
	viri[ply] = num_viri(level[ply]);
	// get the number of viri to place

	for(i = viri[ply]; i; i--) {
BEGIN:
		x = rand() % BOARD_W;
		y = (rand() % (BOARD_H-miny));

		if(!(board[ply][y+miny][x] & TILE_BLANK)) { goto BEGIN; }
		// if this spot already has a virus in it then try again.

		c = rand_color();
		// get a random color.

		board[ply][y+miny][x] &=~ TILE_BLANK;
		board[ply][y+miny][x] |= (c | TILE_VIRUS);
		// place the virus on the board.
	}
	
	return 1;
} /* set_board */

void draw_board(int ply)
{
	int i, j, c = 0;
	if(!players || ply+1 > players || ply < 0) return;

	if(dirty[ply]) { // if ply's board has changed draw it.
		dirty[ply] = 0;
		//blit(buf, boards[ply], board_x[ply]+(40*5), board_y[ply]+40, 0, 0, BOARD_W*TILE_W, BOARD_H*TILE_H);

		_do_bg(boards[ply]);

		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		rectfill(boards[ply], 0, 0, boards[ply]->w, boards[ply]->h, makecol(150, 150, 150));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

		for(i=0; i<BOARD_H; i++) {
			
			for(j=0; j<BOARD_W; j++) {
				//if(!(board[ply][i][j] & TILE_DIRTY)) continue;
				// if the tile hasn't changed try the next.


				if(board[ply][i][j] & TILE_BLANK) c = 0;
				else if(board[ply][i][j] & TILE_RED) c = makecol(255, 0, 0);
				else if(board[ply][i][j] & TILE_BLUE) c = makecol(0, 0, 255);
				else if(board[ply][i][j] & TILE_YELLOW) c = makecol(255, 255, 0);

				if(board[ply][i][j] & TILE_VIRUS) {
					//rectfill(boards[ply], TILE_W*j+5, TILE_H*i+5, TILE_W*j+TILE_W-5, TILE_H*i+TILE_H-5, makecol(255,0,255));
					circlefill(boards[ply], TILE_W*j+TILE_W/2, TILE_H*i+TILE_H/2, 12, c);
					
				} else
				if(c) rectfill(boards[ply], TILE_W*j, TILE_H*i, TILE_W*j+TILE_W, TILE_H*i+TILE_H, c);
				//else rectfill(boards[ply], TILE_W*j, TILE_H*i, TILE_W*j+TILE_W, TILE_H*i+TILE_H, makecol(0,0,0));

				
				if(board[ply][i][j] & TILE_JOIN_UP) putpixel(boards[ply], TILE_W*j+TILE_W/2-5, TILE_H*i+5, makecol(0,0,0));
				else if(board[ply][i][j] & TILE_JOIN_DOWN) putpixel(boards[ply], TILE_W*j+TILE_W/2-5, TILE_H*i+TILE_H-5, makecol(0,0,0));
				else if(board[ply][i][j] & TILE_JOIN_LEFT) putpixel(boards[ply], TILE_W*j+5, TILE_H*i+TILE_H/2-5, makecol(0,0,0));
				else if(board[ply][i][j] & TILE_JOIN_RIGHT) putpixel(boards[ply], TILE_W*j+TILE_W-5, TILE_H*i+TILE_H/2-5, makecol(0,0,0));
			}
		}
	}
} /* draw_board */

void draw_pill(int ply)
{
	int i = 0, j = 0;
	int c = 0;
	dirty[ply] = 1;
	for(i=1; i<3; i++) {
		for(j=1; j<3; j++) {
			if(pill[ply][i-1][j-1]) {
				if(pill[ply][i-1][j-1] == 1) c = makecol(255,0,0);
				else if(pill[ply][i-1][j-1] == 2) c = makecol(0,0,255);
				else if(pill[ply][i-1][j-1] == 3) c = makecol(255,255,0);
				rectfill(boards[ply], TILE_W*(j+pill_x[ply]-1),
							TILE_H*(i+pill_y[ply]-2),
							TILE_W*(j+pill_x[ply]-1)+TILE_W,
							TILE_H*(i+pill_y[ply]-2)+TILE_H, c);
			}
		}
	}
} /* draw_pill */

void draw_npill(int ply)
{
	static BITMAP *np = NULL;
	int i = 0, j = 0;
	int c = 0;

	if(!np) np = create_bitmap(TILE_W*3, TILE_H*2);
	if(!np) return;

	_do_bg(np);

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	rectfill(np, 0, 0, np->w, np->h, makecol(150, 150, 150));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

	for(i=0; i<2; i++) {
		for(j=0; j<2; j++) {
			if(npill[ply][i][j]) {
				if(npill[ply][i][j] == 1) c = makecol(255,0,0);
				else if(npill[ply][i][j] == 2) c = makecol(0,0,255);
				else if(npill[ply][i][j] == 3) c = makecol(255,255,0);
				else c = makecol(255,255,255);
				rectfill(np, TILE_W/2+TILE_W*(j), TILE_H*(i)-TILE_H/2, TILE_W/2+TILE_W*(j)+TILE_W, TILE_H*(i)+TILE_H-TILE_H/2, c);
			}
		}
	}

	blit(np, screen, 0, 0, 447, 100, np->w, np->h);
	rect(screen, 446, 99, 447+np->w, 100+np->h, makecol(255,255,255));
	rect(screen, 445, 98, 447+np->w+1, 100+np->h+1, makecol(0,0,0));
} /* draw_npill */

void flip_pill(int ply, int dir)
{
	if(ply+1 > players) return;
	
	if(dir == DIR_LEFT) {
		if(pill[ply][0][0] && pill[ply][1][0]) {
			if(pill_x[ply] < 0 || pill_x[ply] > BOARD_W-2) return;
			if(!(board[ply][ pill_y[ply] ][ pill_x[ply]+1 ] & TILE_BLANK)) return;

			SWAP(pill[ply][1][0], pill[ply][1][1]);
			SWAP(pill[ply][0][0], pill[ply][1][0]);

		} else
		if(pill[ply][1][0] && pill[ply][1][1]) {
			if(pill_y[ply] < 1 || pill_y[ply] > BOARD_H-1) return;
			if(!(board[ply][ pill_y[ply]-1 ][ pill_x[ply] ] & TILE_BLANK)) return;
			SWAP(pill[ply][0][0], pill[ply][1][1]);
		}
	} else
	if(dir == DIR_RIGHT) {
		if(pill[ply][0][0] && pill[ply][1][0]) {
			if(pill_x[ply] < 0 || pill_x[ply] > BOARD_W-2) return;
			if(!(board[ply][ pill_y[ply] ][ pill_x[ply]+1 ] & TILE_BLANK)) return;
			SWAP(pill[ply][0][0], pill[ply][1][1]);

		} else
		if(pill[ply][1][0] && pill[ply][1][1]) {
			if(pill_y[ply] < 1 || pill_y[ply] > BOARD_H-1) return;
			if(!(board[ply][ pill_y[ply]-1 ][ pill_x[ply] ] & TILE_BLANK)) return;
			SWAP(pill[ply][0][0], pill[ply][1][1]);
			SWAP(pill[ply][0][0], pill[ply][1][0]);
		}
	}
} /* flip_pill */

void put_pill(int ply)
{
	int p1 = 0;
	int p2 = 0;
	dirty[ply] = 1;
	if(pill[ply][0][0] && pill[ply][1][0]) {
		p1 = colors[pill[ply][0][0]];
		p2 = colors[pill[ply][1][0]];
		
		board[ply][ pill_y[ply]-1 ][ pill_x[ply] ] = 0;
		board[ply][ pill_y[ply]-1 ][ pill_x[ply] ] |= (p1 | TILE_DIRTY | TILE_JOIN_DOWN);

		board[ply][ pill_y[ply] ][ pill_x[ply] ] = 0;
		board[ply][ pill_y[ply] ][ pill_x[ply] ] |= (p2 | TILE_DIRTY | TILE_JOIN_UP);
	} else
	if(pill[ply][1][0] && pill[ply][1][1]) {
		p1 = colors[pill[ply][1][0]];
		p2 = colors[pill[ply][1][1]];
		
		board[ply][ pill_y[ply] ][ pill_x[ply] ] = (0 | TILE_DIRTY | TILE_JOIN_RIGHT);
		board[ply][ pill_y[ply] ][ pill_x[ply] ] |= p1;

		board[ply][ pill_y[ply] ][ pill_x[ply]+1 ] = (0 | TILE_DIRTY | TILE_JOIN_LEFT);
		board[ply][ pill_y[ply] ][ pill_x[ply]+1 ] |= p2;
	}
} /* put_pill */

int _do_col(int ply, int check, int x)
{
	int i,bl=0;

	for(i=BOARD_H-1; i>-1; i--) {
		if(board[ply][i][x] & TILE_BLANK) { bl = 1; continue; }

		if(bl) {
			if(board[ply][i][x] & TILE_JOIN_UP) {
				if(i<BOARD_H-1) {
					if(check) return 1;
					SWAP(board[ply][i][x], board[ply][i+1][x]);
					SWAP(board[ply][i-1][x], board[ply][i][x]);
					
					if(!(board[ply][i-1][x] & TILE_VIRUS)) SWAP(board[ply][i-1][x], board[ply][i][x]);
					if(!(board[ply][i-2][x] & TILE_VIRUS)) SWAP(board[ply][i-1][x], board[ply][i][x]);
				}
			} else
			if(board[ply][i][x] & TILE_JOIN_RIGHT) {
				if(!(board[ply][i+1][x+1] & TILE_BLANK)) { bl=0; continue; }
				if(i<BOARD_H-1) {
					if(check) return 1;
					SWAP(board[ply][i][x], board[ply][i+1][x]);
					SWAP(board[ply][i][x+1], board[ply][i+1][x+1]);
					
					if(!(board[ply][i-1][x] & TILE_VIRUS)) SWAP(board[ply][i-1][x], board[ply][i][x]);
					if(!(board[ply][i-1][x+1] & TILE_VIRUS)) SWAP(board[ply][i-1][x+1], board[ply][i][x+1]);
				}
			} else
			if(!((board[ply][i][x] & TILE_JOIN_LEFT) && (board[ply][i][x-1] & TILE_JOIN_RIGHT)) &&
			   !((board[ply][i][x] & TILE_JOIN_DOWN) && (board[ply][i+1][x] & TILE_JOIN_UP)) &&
				!(board[ply][i][x] & TILE_VIRUS)) {
				if(i<BOARD_H-1) {
					if(check) return 1;
					SWAP(board[ply][i][x], board[ply][i+1][x]);
					if(!(board[ply][i-1][x] & TILE_VIRUS)) SWAP(board[ply][i-1][x], board[ply][i][x]);
				}
			}
			bl = 0;
			if(i<BOARD_H-2 && board[ply][i+1][x] & TILE_BLANK && !(board[ply][i+2][x] & TILE_BLANK)) i++;

		}
	}
	return 0;
} /* _do_col */

int check_drop(int ply)
{
	int j,check=0,t=0;
	if(paused) return 0;

	for(j=0; j<BOARD_W; j++) {
		t = check;
		check = _do_col(ply, 1, j);
		if(t || check) check = 1;
	}

	return check;
} /* drop_pills */


void drop_pills(int ply)
{
	int j;
	if(paused) return;
	dirty[ply] = 1;
	for(j=0; j<BOARD_W; j++) {
		_do_col(ply, 0, j);
	}
} /* drop_pills */

/* end of reused code */

#define GET_TYPE(i) (((i)&TILE_BLANK)?0:(((i)&TILE_RED)?1:(((i)&TILE_BLUE)?2:(((i)&TILE_YELLOW)?3:0))))

void _kill_line(int ply, int sx, int sy, int cnt, int dir)
{
	int i,typ=0,j;

	typ = GET_TYPE(board[ply][sy][sx]);
	if(!typ) return;

	if(dir)
		for(i=sy; i<BOARD_H && cnt>-1; i++,cnt--) {
			if(GET_TYPE(board[ply][i][sx]) != typ) break;
			
			if(sx>0 && board[ply][i][sx] & TILE_JOIN_LEFT) board[ply][i][sx-1] &=~ TILE_JOIN_RIGHT;
			if(sx<BOARD_W-1 && board[ply][i][sx] & TILE_JOIN_RIGHT) board[ply][i][sx+1] &=~ TILE_JOIN_LEFT;
			if(i<BOARD_H-1 && board[ply][i][sx] & TILE_JOIN_DOWN) board[ply][i+1][sx] &=~ TILE_JOIN_UP;
			if(i>0 && board[ply][i][sx] & TILE_JOIN_UP) board[ply][i-1][sx] &=~ TILE_JOIN_DOWN;

			if(board[ply][i][sx] & TILE_VIRUS) {
				viri[ply]--;
				kill_cnt[ply]++;
				if(dropping[ply]) {
					score[ply] += (100 * kill_cnt[ply]) + ((kill_cnt[ply] - 2) * 100);
				}
				else {
					score[ply] += (100 * kill_cnt[ply]) + ((kill_cnt[ply] - 1) * 100);
				}
			}
			
			board[ply][i][sx] = 0;
			board[ply][i][sx] |= (TILE_BLANK | TILE_DIRTY);
		}
	else
		for(j=sx; j<BOARD_W && cnt>-1; j++,cnt--) {
			if(GET_TYPE(board[ply][sy][j]) != typ) break;

			if(j>0 && board[ply][sy][j] & TILE_JOIN_LEFT) board[ply][sy][j-1] &=~ TILE_JOIN_RIGHT;
			if(j<BOARD_W-1 && board[ply][sy][j] & TILE_JOIN_RIGHT) board[ply][sy][j+1] &=~ TILE_JOIN_LEFT;
			if(sy<BOARD_H-1 && board[ply][sy][j] & TILE_JOIN_DOWN) board[ply][sy+1][j] &=~ TILE_JOIN_UP;
			if(sy>0 && board[ply][sy][j] & TILE_JOIN_UP) board[ply][sy-1][j] &=~ TILE_JOIN_DOWN;

			if(board[ply][sy][j] & TILE_VIRUS) {
				viri[ply]--;
				kill_cnt[ply]++;
				if(dropping[ply]) {
					score[ply] += (100 * kill_cnt[ply]) + ((kill_cnt[ply] - 2) * 100);
				}
				else {
					score[ply] += (100 * kill_cnt[ply]) + ((kill_cnt[ply] - 1) * 100);
				}
			}

			board[ply][sy][j] = 0;
			board[ply][sy][j] |= (TILE_BLANK | TILE_DIRTY);
		}
}

int kill_combo(int ply, int check)
{
	int i,j,cnt=0,tt=0,typ=0,x,y;
	if(paused) return 0;

	for(j=0; j<BOARD_W; j++) {
		y = BOARD_H-1;
		x = j;
		for(i=y; i>-1; i--) {
			tt = typ;
			typ = GET_TYPE(board[ply][i][j]);

			if(tt || typ) {
				if(tt != typ) {
					if(cnt >= 4) {
						if(check) return 1;
						_kill_line(ply, x, y, cnt, 1);
						cnt = 0;
						continue;
					}

					if(typ) {
						cnt = 1;
						x = j;
						y = i;
					} else {
						cnt = 0;
					}
				}
				else {
					cnt++;
					y=i;
					if(i==0) {
						if(cnt >= 4) {
							if(check) return 1;
							_kill_line(ply, x, y, cnt, 1);
							cnt = 0;
							continue;
						}
					}
				}
			}
		}
	}

	for(i=0; i<BOARD_H; i++) {
		y = i;
		x = BOARD_W-1;
		cnt = 0;
		for(j=x; j>-1; j--) {
			tt = typ;
			typ = GET_TYPE(board[ply][i][j]);

			if(tt || typ) {
				if(tt != typ) {
					if(cnt >= 4) {
						if(check) return 1;
						_kill_line(ply, x, y, cnt, 0);
						cnt = 0;
						continue;
					}

					if(typ) {
						cnt = 1;
						x = j;
						y = i;
					} else {
						cnt = 0;
					}
				}
				else {
					cnt++;
					x=j;
					if(j==0) {
						if(cnt >= 4) {
							if(check) return 1;
							_kill_line(ply, x, y, cnt, 0);
							cnt = 0;
							continue;
						}
					}
				}
			}
		}
	}
	
	if(check) return 0;
	else return 1;
} /* kill_combo */

int can_move(int ply, int dir)
{
	if(ply+1 > players) return 0;
	
	if(dir == DIR_DOWN) {
		if(pill_y[ply] < 0 || pill_y[ply] > BOARD_H-2) return 0;
		if(board[ply][ pill_y[ply]+1 ][ pill_x[ply] ] & TILE_BLANK) {
			if(pill[ply][1][1] && board[ply][ pill_y[ply]+1 ][ pill_x[ply]+1 ] & TILE_BLANK) {
				return 1;
			} else if(pill[ply][1][1]) return 0;
			return 1;
		}
	} else
	if(dir == DIR_LEFT) {
		if(pill_x[ply] < 1 || pill_x[ply] > BOARD_W-1) return 0;
		if(pill_x[ply] == BOARD_W - 1 && pill[ply][1][1]) return 0;

		if(!(board[ply][ pill_y[ply] ][ pill_x[ply]-1 ] & TILE_BLANK)) return 0;
		if(pill[ply][0][0] && !(board[ply][ pill_y[ply]-1 ][ pill_x[ply]-1 ] & TILE_BLANK)) return 0;
		
		return 1;
	} else
	if(dir == DIR_RIGHT) {
		if(pill_x[ply] < 0 || pill_x[ply] > BOARD_W - 2) return 0;
		if(pill_x[ply] == BOARD_W - 2 && pill[ply][1][1]) return 0;

		if(!(board[ply][ pill_y[ply] ][ pill_x[ply]+1 ] & TILE_BLANK)) return 0;
		if(pill[ply][1][1] && !(board[ply][ pill_y[ply] ][ pill_x[ply]+2 ] & TILE_BLANK)) return 0;
		if(pill[ply][0][0] && !(board[ply][ pill_y[ply]-1 ][ pill_x[ply]+1 ] & TILE_BLANK)) return 0;
		return 1;
	}
	
	return 0;
} /* can_move */

void _do_bg(BITMAP *bmp)
{
	int w = 40;
	int h = 40;
	int i = bmp->h/h+1;
	int j = bmp->w/w+1;
	int x, y;
	int flip = makecol(0,0,0);

	if(i % 2) i++;
	if(j % 2) j++;

	x = bmp->w/2-((j+1)*w)/2;
	y = bmp->h/2-((i+1)*h)/2;

	for(; i>0; i--) {
		if(flip == makecol(0,0,0)) flip = makecol(255,255,255);
		else flip = makecol(0,0,0);

		for(j = bmp->w/w+2; j>0; j--) {
			rectfill(bmp, j*w+x, i*h+y, (w*j-w)+x, (h*i-h)+y, flip);
			if(flip == makecol(0,0,0)) flip = makecol(255,255,255);
			else flip = makecol(0,0,0);
		}
	}
}

void init_input(int ply)
{
	if(input[ply].typ == PLY_INPUT_KEY) {
		set_def_keys();
	} else
	if(input[ply].typ == PLY_INPUT_JOY) {
		_init_joy_info(ply);
	}
}

void set_def_keys(void) // just enough to get things to work if it no config is set.
{
	input[PLAYER_ONE].sel = KEY_ENTER;
	input[PLAYER_ONE].esc = KEY_ESC;
	input[PLAYER_ONE].flipl = KEY_Z;
	input[PLAYER_ONE].flipr = KEY_X;
	input[PLAYER_ONE].up = KEY_UP;
	input[PLAYER_ONE].down = KEY_DOWN;
	input[PLAYER_ONE].left = KEY_LEFT;
	input[PLAYER_ONE].right = KEY_RIGHT;

	sprintf(input[PLAYER_ONE].csel,   "ENTER");
	sprintf(input[PLAYER_ONE].cesc,   "ESC");
	sprintf(input[PLAYER_ONE].cflipl, "Z");
	sprintf(input[PLAYER_ONE].cflipr, "X");
	sprintf(input[PLAYER_ONE].cup,    "UP");
	sprintf(input[PLAYER_ONE].cdown,  "DOWN");
	sprintf(input[PLAYER_ONE].cleft,  "LEFT");
	sprintf(input[PLAYER_ONE].cright, "RIGHT");
}

int _init_joy_info(int ply)
{
	int i;
	if(ply > 1 || ply < 0 || input[ply].jstate.init) return 0;

	// initialize directional buttons
	input[ply].jstate.dir[0] = 0;
	input[ply].jstate.dir[1] = 0;
	input[ply].jstate.dir[2] = 0;
	input[ply].jstate.dir[3] = 0;

	input[ply].jstate.num_buttons = joy[input[ply].joy].num_buttons;
	if(!input[ply].jstate.num_buttons) return 0;
	input[ply].jstate.buttons = realloc(input[ply].jstate.buttons, input[ply].jstate.num_buttons*sizeof(int));
	if(!input[ply].jstate.buttons) return 0;

	for(i=0; i<input[ply].jstate.num_buttons; i++)
		input[ply].jstate.buttons[i] = 0;

	input[ply].jstate.init = 1;

	return 1;
}


int _get_joy_info(int ply)
{
	if(ply > 1 || ply < 0 || !input[ply].jstate.init) return 0;

	if(joy[input[ply].joy].button[input[ply].sel].b) {
		if(!input[ply].jstate.buttons[input[ply].sel]) {
			input[ply].jstate.buttons[input[ply].sel] = 1;
			return PLY_MSG_SEL;
		}
	} else
		input[ply].jstate.buttons[input[ply].sel] = 0;

	if(joy[input[ply].joy].button[input[ply].esc].b) {
		if(!input[ply].jstate.buttons[input[ply].esc]) {
			input[ply].jstate.buttons[input[ply].esc] = 1;
			return PLY_MSG_ESC;
		}
	} else
		input[ply].jstate.buttons[input[ply].esc] = 0;

	if(joy[input[ply].joy].button[input[ply].flipl].b) {
		if(!input[ply].jstate.buttons[input[ply].flipl]) {
			input[ply].jstate.buttons[input[ply].flipl] = 1;
			return PLY_MSG_FLIPL;
		}
	} else
		input[ply].jstate.buttons[input[ply].flipl] = 0;

	if(joy[input[ply].joy].button[input[ply].flipr].b) {
		if(!input[ply].jstate.buttons[input[ply].flipr]) {
			input[ply].jstate.buttons[input[ply].flipr] = 1;
			return PLY_MSG_FLIPR;
		}
	} else
		input[ply].jstate.buttons[input[ply].flipr] = 0;

		

	// up
	if(joy[input[ply].joy].stick[0].axis[1].d1) {
		if(!input[ply].jstate.dir[UP]) {
			input[ply].jstate.dir[UP] = 1;
			return PLY_MSG_UP;
		}
	} else
		input[ply].jstate.dir[UP] = 0;

	// down
	if(joy[input[ply].joy].stick[0].axis[1].d2) {
		if(!input[ply].jstate.dir[DOWN]) {
			input[ply].jstate.dir[DOWN] = 1;
			return PLY_MSG_DOWN;
		}
	} else
		input[ply].jstate.dir[DOWN] = 0;


	// left
	if(joy[input[ply].joy].stick[0].axis[0].d1) {
		if(!input[ply].jstate.dir[LEFT]) {
			input[ply].jstate.dir[LEFT] = 1;
			return PLY_MSG_LEFT;
		}
	} else
		input[ply].jstate.dir[LEFT] = 0;

	// right
	if(joy[input[ply].joy].stick[0].axis[0].d2) {
		if(!input[ply].jstate.dir[RIGHT]) {
			input[ply].jstate.dir[RIGHT] = 1;
			return PLY_MSG_RIGHT;
		}
	} else
		input[ply].jstate.dir[RIGHT] = 0;

	return 0;
}

int key_read=0;

int _get_input(int ply)
{
	int key = 0;
	if(ply>players-1) return 0;

	if(input[ply].typ == PLY_INPUT_KEY) {
		if(!keypressed()) return 0;
		key_read = readkey();
		key = key_read >> 8;
		clear_keybuf();

		GKEY(input[ply].sel, PLY_MSG_SEL)
		GKEY(input[ply].esc, PLY_MSG_ESC)
		GKEY(input[ply].up, PLY_MSG_UP)
		GKEY(input[ply].down, PLY_MSG_DOWN)
		GKEY(input[ply].left, PLY_MSG_LEFT)
		GKEY(input[ply].right, PLY_MSG_RIGHT)
		GKEY(input[ply].flipr, PLY_MSG_FLIPR)
		GKEY(input[ply].flipl, PLY_MSG_FLIPL);

		return 0;
	} else if(input[ply].typ == PLY_INPUT_JOY) {
		poll_joystick();
		return _get_joy_info(ply);
	}

	return 0;
}



void restart(int ply)
{
	pill_x[ply] = 3;
	pill_y[ply] = 0;

	rand_pill(npill[ply]);
	next_pill(ply);
}

char name_str[15];
int cursor_ptr=0, cur_sel=0;
/*
A B C D E F G H I J K L M N O
P Q R S T U V W X Y Z a b c d
e f g h i j k l m n o p q r s
t u v w x y z _ space del ok   

 */

void put_key(char *s, int x, int y)
{
	int w,h;

	w = text_length(font, s)+10;
	h = text_height(font)+10;

	if(cur_sel) {
		roundrect(screen, 6, x, y, x+w, y+h, makecol(255,0,0));
		textout(screen, font, s, x+6, y+6, makecol(255,0,0));
	 } else {
	 	roundrect(screen, 6, x, y, x+w, y+h, makecol(255,255,255));
		textout(screen, font, s, x+6, y+6, makecol(255,255,255));
	}
}

void get_name(void)
{
	int old_x=0, old_y=0,x,y,done=0,rkey,w=0,h=0,cur_x=0, cur_y=0;
	char alph[4][15][6] = {
		{ "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", },
		{ "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", },
		{ "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", },
		{ "t", "u", "v", "w", "x", "y", "z", "_", "del", "OK", { 0 }, },
	};

	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	rectfill(screen, 80, 170, 540, 360, makecol(150,150,150));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

	textout(screen, large, "NEW HIGH SCORE", 80+(540-80)/2-text_length(large, "NEW HIGH SCORE")/2, 174, makecol(0,0,0));
	textout(screen, large, "NEW HIGH SCORE", 81+(540-80)/2-text_length(large, "NEW HIGH SCORE")/2, 175, makecol(255,255,255));

	rectfill(screen, 200, 220, 204+(14*text_length(font, " ")), 224+text_height(font), makecol(255,255,255));
	textout(screen, font, name_str, 202, 222, makecol(0,0,0));

	rect(screen, 80, 170, 540, 360, makecol(255,255,255));
	rect(screen, 79, 169, 541, 361, makecol(0,0,0));

	for(y=0; y<4; y++) {
		for(x=0; x<15; x++) {
			if(y==3 && x >=10) break;

			if(x==cur_x && y==cur_y) cur_sel = 1;
			
			put_key(alph[y][x], 100+(x+1)+w, 240+(y+1)+h);
			w += text_length(font, alph[y][x])+20;

			cur_sel = 0;
		}
		w = 0;
		h += text_height(font)+20;
	}

	while(!done) {
		//if(!keypressed()) continue;

		rkey = _get_input(0);

		old_x = cur_x;
		old_y = cur_y;

		switch(rkey) {
			case PLY_MSG_ESC:
				//done=1;
				break;

			case PLY_MSG_SEL:
				if(cur_x == 8 && cur_y == 3) {
					if(cursor_ptr) name_str[--cursor_ptr] = 0;
					else name_str[0] = 0;
				} else
				if(cur_x == 9 && cur_y == 3) {
					if(cursor_ptr) done = 1;
					break;
				} else if(cursor_ptr < 14)
					name_str[cursor_ptr++] = alph[cur_y][cur_x][0];

				//text_mode(-1);
				rectfill(screen, 200, 220, 204+(14*text_length(font, " ")), 224+text_height(font), makecol(255,255,255));
				textout(screen, font, name_str, 202, 222, makecol(0,0,0));

				break;
				
			case PLY_MSG_UP:
				if(cur_y <= 0) {
					if(cur_x >= 9) cur_y = 2;
					else
						cur_y = 3;
				}
				else cur_y--;
				break;
				
			case PLY_MSG_DOWN:
				if(cur_y >= 3) cur_y = 0;
				else {
					if(cur_x > 9 && cur_y == 2) cur_y = 0;
					else
						cur_y++;
				}
				break;
				
			case PLY_MSG_LEFT:
				if(cur_x <= 0) {
					if(cur_y == 3)
						cur_x = 9;
					else
						cur_x = 14;
				}
				else cur_x--;
				break;
				
			case PLY_MSG_RIGHT:
				if(cur_x >= 14) cur_x = 0;
				else {
					if(cur_y == 3 && cur_x == 9)
						cur_x = 0;
					else
						cur_x++;
				}
				break;
		}

		if(old_x != cur_x || old_y != cur_y) {
			w = 0; h = 0;
			for(y=0; y<4; y++) {
				for(x=0; x<15; x++) {
					if(y==3 && x >=11) break;

					if(y == old_y && x == old_x) break;
					w += text_length(font, alph[y][x])+20;

				}
				if(y == old_y && x == old_x) break;
				
				w = 0;
				h += text_height(font)+20;
			}
			put_key(alph[old_y][old_x], 100+(old_x+1)+w, 240+(old_y)+h+1);

			w = 0; h = 0;
			for(y=0; y<4; y++) {
				for(x=0; x<15; x++) {
					if(y==3 && x >=11) break;

					if(y == cur_y && x == cur_x) break;
					w += text_length(font, alph[y][x])+20;
				}
				if(y == cur_y && x == cur_x) break;
				
				w = 0;
				h += text_height(font)+20;
			}
			cur_sel = 1;
			put_key(alph[cur_y][cur_x], 100+(cur_x+1)+w, 240+(cur_y)+h+1);
			cur_sel = 0;
		}
		
	}
}


int init(void)
{
	LOCK_VARIABLE(paused);
	LOCK_VARIABLE(dr_game_timer);
	LOCK_VARIABLE(dr_drop_timer);
	LOCK_FUNCTION(dr_game_timer_func);
	LOCK_FUNCTION(dr_drop_timer_func);

	read_scores();

	srand(time(0));

	//if(install_joystick(JOY_TYPE_AUTODETECT) < 0) {
	//	printf("error: %s\n", allegro_error);
	//	exit(EXIT_FAILURE);
	//}

	set_trans_blender(200,200,200,200);

	read_kbinput();

	input[PLAYER_ONE].typ = PLY_INPUT_KEY;

	init_input(PLAYER_ONE);

	level[PLAYER_ONE] = 0;
	return 1;
}

int play()
{
	int ok=0, inp=0, put = 0;

	RESTART:
	restart(PLAYER_ONE);
	if(players) {
		char tmp[255];
		if(is_hiscore(score[0])) {
			get_name();
			add_score(name_str, score[0]);
		}
		sprintf(tmp, "next level: %i", level[0]);
		ok = alert("would you like to play again?", tmp, NULL, "Yes", "No", 0, 0);
		if(ok==2) {
			return 0;
		}
		clear_keybuf();
	}

	players = 1;

	pill_x[0] = 3;
	pill_y[0] = 0;

	set_board_pos(PLAYER_ONE, SCREEN_W/2-(BOARD_W*TILE_W)/2, SCREEN_H/2-(BOARD_H*TILE_H)/2);
	set_board(PLAYER_ONE);

	dr_game_timer = 0;
	dr_drop_timer = 0;

	_do_bg(screen);
	
	draw_board(PLAYER_ONE);
	draw_pill(PLAYER_ONE);

	clear_keybuf();

	install_int_ex(dr_drop_timer_func, BPS_TO_TIMER(2+speed));
	install_int_ex(dr_game_timer_func, BPS_TO_TIMER(40));

	draw_hiscores(20,20);

	while(!key[KEY_ESC]) {
		if(paused && key[KEY_P]) { clear_keybuf(); paused = 0; }

		blit(boards[0], screen, 0, 0, board_x[0], board_y[0], boards[0]->w, boards[0]->h);

		draw_npill(PLAYER_ONE);

		roundrect(screen, 6, board_x[0]-2, board_y[0]-2, BOARD_W*TILE_W+board_x[0]+1, BOARD_H*TILE_H+board_y[0]+1, makecol(0,0,0));
		roundrect(screen, 6, board_x[0]-1, board_y[0]-1, BOARD_W*TILE_W+board_x[0], BOARD_H*TILE_H+board_y[0], makecol(255,255,255));
		//roundrect(buf, 5, board_x[0]-1, board_y[0]-1, BOARD_W*TILE_W+board_x[0], BOARD_H*TILE_H+board_y[0], makecol(255,255,255));

		text_mode(0);
		textprintf(screen, font, 20, 420, makecol(255,255,255), "Score: %0i", score[0]);
		text_mode(-1);

		while(!dropping[0] && dr_game_timer>0) {
			/*if(!paused)*/ dr_game_timer--;

			if(!paused && key[KEY_P]) { paused = 1; continue; }
			else if(paused && key[KEY_P]) { paused = 0;  continue; }

			inp = _get_input(PLAYER_ONE);
			// turn all this into a 'switch/case'.
			if(inp==PLY_MSG_FLIPL) {
				flip_pill(PLAYER_ONE, DIR_LEFT);
				set_tone_pan(0);
				play_tone(FLIP_TONE, TONE_LEN);
			}
			
			if(inp==PLY_MSG_FLIPR) {
				flip_pill(PLAYER_ONE, DIR_RIGHT);
				set_tone_pan(256);
				play_tone(FLIP_TONE, TONE_LEN);
			}
			
			if(inp==PLY_MSG_UP && pill_y[0] > 0 && (pill_y[0] == 1 ? !pill[0][0][0] : 1)) pill_y[0]--;

			if(dr_drop_timer && can_move(0, DIR_DOWN)) { pill_y[0]++; dr_drop_timer--; }
			if(inp==PLY_MSG_DOWN && can_move(0, DIR_DOWN)) pill_y[0]++;
			if(inp==PLY_MSG_LEFT && can_move(0, DIR_LEFT)) pill_x[0]--;
			if(inp==PLY_MSG_RIGHT && can_move(0, DIR_RIGHT)) pill_x[0]++;

			if(inp==PLY_MSG_ESC)  break;

			if(!can_move(0, DIR_DOWN) && put>20) {
				if(!(board[0][0][3] & TILE_BLANK) ||
				   !(board[0][0][4] & TILE_BLANK)) goto RESTART;
				kill_cnt[PLAYER_ONE] = 0;
				put_pill(PLAYER_ONE);

				pill_x[0] = 3;
				pill_y[0] = 0;

				next_pill(PLAYER_ONE);
				clear_keybuf();
				put = 0;
				break;
			} else
			if(!can_move(0, DIR_DOWN) && put<=20) {
				put++;
				dr_drop_timer=0;
			}
			clear_keybuf();
		}
		
		if(check_drop(PLAYER_ONE)) {
			dropping[0] = 1;

			//if(!viri[0] && done[0]) { level[0]++; goto RESTART; }
			if(!viri[0] && !done[0]) done[0] = 1;
			if(dr_drop_timer) {
				drop_pills(PLAYER_ONE);
				draw_board(PLAYER_ONE);
				draw_pill(PLAYER_ONE);
				set_tone_pan(128);
				play_tone(DROP_TONE, TONE_LEN);
				dr_drop_timer--;
				clear_keybuf();
			}
		} else {
			if(!viri[0] && done[0] && kill_combo(PLAYER_ONE, 1)) kill_combo(PLAYER_ONE, 0);
			draw_board(PLAYER_ONE);
			if(dropping[0]) { dr_game_timer=0; dr_drop_timer=0; }
			else draw_pill(PLAYER_ONE);

			dropping[0] = 0;

			if(!viri[0] && done[0]) { level[0]++; goto RESTART; }
			else if(!viri[0] && !done[0]) done[0] = 1;
		}
		
		kill_combo(PLAYER_ONE, 0);

		if(kill_cnt[PLAYER_ONE] && !dropping[PLAYER_ONE]) {
			//kill_cnt[PLAYER_ONE] = 0;
		}
	}

	clear_keybuf();

	return 0;
}


