#include <allegro.h>
#include "obstacle.h"
#include "collide.h"

obstacle::obstacle(int x,int y,int roughness):
  position(x,y),
  roughness(roughness)
{
}

round_obstacle::round_obstacle(int x,int y,int radius,int roughness):
  obstacle(x,y,roughness),
  radius(radius),
  squared_radius(radius*radius)
{
}

int round_obstacle::is_in(int x,int y) const
{
  return ((x-get_x())*(x-get_x())+(y-get_y())*(y-get_y()))<=squared_radius;
}

bool round_obstacle::collide_with(const obstacle *o) const
{
  return o->collide_with_round(this);
}

bool round_obstacle::collide_with_round(const round_obstacle *o) const
{
  return collide(o, this);
}

bool round_obstacle::collide_with_rect(const rect_obstacle *o) const
{
  return collide(o, this);
}

void round_obstacle::draw(BITMAP *dest,int color) const
{
  circle(dest,get_x(),get_y(),radius,color);
}

rect_obstacle::rect_obstacle(int x,int y,int w,int h,int roughness):
  obstacle(x,y,roughness),
  width(w),
  height(h)
{
}

int rect_obstacle::is_in(int x,int y) const
{
  return x>=get_x()-width/2 && x<get_x()+width/2 &&
    y>=get_y()-height/2 && y<get_y()+height/2;
}

bool rect_obstacle::collide_with(const obstacle *o) const
{
  return o->collide_with_rect(this);
}

bool rect_obstacle::collide_with_round(const round_obstacle *o) const
{
  return collide(this, o);
}

bool rect_obstacle::collide_with_rect(const rect_obstacle *o) const
{
  return collide(this, o);
}

void rect_obstacle::draw(BITMAP *dest,int color) const
{
  rect(
    dest,get_x()-width/2,get_y()-height/2,get_x()+width/2,get_y()+height/2,color
  );
}

