#include <stdio.h>
#include <stdarg.h>
#include <allegro.h>
#include "error.h"

void exit_error(const char *msg,...)
{
  static char message[2048];
  va_list ap;
  va_start(ap,msg);
#ifdef ALLEGRO_LINUX
  vsnprintf(message,sizeof(message),msg,ap);
#else
  vsprintf(message,msg,ap);
#endif
  va_end(ap);

  set_gfx_mode(GFX_TEXT,80,25,0,0);
  allegro_message("%s\n",message);
  exit(1);
}

