#include <stdio.h>
#include <string.h>
#include <allegro.h>

static struct {
  char *name;
  int r,g,b;
} colnames[]={
  {"Magenta",255,0,255},
  {"DarkOrange",255,140,0},
};

BITMAP *load_xpm(char *xpm[])
{
  int width,height,ncolors,chars;
  BITMAP *bitmap=NULL;
  int *colors=NULL;
  int n;
  int i,j;

  sscanf(xpm[0],"%d %d %d %d",&width,&height,&ncolors,&chars);
  bitmap=create_bitmap(width,height);
  colors=(int*)malloc(ncolors*sizeof(int));
  for (n=0;n<ncolors;++n) {
    char *colname=xpm[1+n]+3+chars;
    colors[n]=-1;
    if (colname[0]=='#') {
      int c=strtol(colname+1,NULL,16);
      colors[n]=makecol((c>>16)&255,(c>>8)&255,c&255);
    }
    else if (!strncmp(colname,"Gray",4)) {
      int gray = (atoi(colname+4) * 255) / 100;
      colors[n]=makecol(gray,gray,gray);
    }
    else {
      unsigned int c;
      for (c=0;c<sizeof(colnames)/sizeof(colnames[0]);++c) {
        if (!strncmp(colnames[c].name,colname,strlen(colnames[c].name))) {
          colors[n]=makecol(colnames[c].r,colnames[c].g,colnames[c].b);
          break;
        }
      }
    }
    if (colors[n]==-1) {
      fprintf(stderr,"Color %s invalid",colname);
      goto error;
    }
  }

  for (j=0;j<height;++j) {
    char *ptr=xpm[j+ncolors+1];
    for (i=0;i<width;++i) {
      int c=-1;
      for (n=0;n<ncolors;++n) {
        if (!strncmp(ptr,xpm[1+n],chars)) {
          c=colors[n];
          break;
        }
      }
      if (c==-1) {
        fprintf(stderr,"Color not found: %*.*s",chars,chars,ptr);
        goto error;
      }
      putpixel(bitmap,i,j,c);
      ptr+=chars;
    }
  }

  free(colors);

  return bitmap;

error:
  free(colors);
  destroy_bitmap(bitmap);
  return NULL;
}
