#ifndef _OBSTACLE_H_
#define _OBSTACLE_H_

#include "position.h"

struct BITMAP;

class round_obstacle;
class rect_obstacle;

class obstacle: public position {
private:
  int roughness;

public:
  obstacle(int x,int y,int roughness);

  virtual int is_in(int x,int y) const=0;
  /* I *love* double-dispatching -a */
  virtual bool collide_with(const obstacle *o) const=0;
  virtual bool collide_with_round(const round_obstacle *o) const=0;
  virtual bool collide_with_rect(const rect_obstacle *o) const=0;
  virtual void draw(BITMAP *dest,int color) const=0;
  inline int get_roughness() const {return roughness;}
};

class round_obstacle: public obstacle {
private:
  int radius;
  int squared_radius;

public:
  round_obstacle(int x,int y,int radius,int roughness);

  inline int get_radius() const {return radius;}
  void set_radius(int radius);

  virtual int is_in(int x,int y) const;
  virtual bool collide_with(const obstacle *o) const;
  virtual bool collide_with_round(const round_obstacle *o) const;
  virtual bool collide_with_rect(const rect_obstacle *o) const;
  virtual void draw(BITMAP *dest,int color) const;
};

class rect_obstacle: public obstacle {
private:
  int width;
  int height;

public:
  rect_obstacle(int x,int y,int w,int h,int roughness);

  inline int get_width() const {return width;}
  inline int get_height() const {return height;}
  void set_width(int w) {width=w;}
  void set_height(int h) {height=h;}

  virtual int is_in(int x,int y) const;
  virtual bool collide_with(const obstacle *o) const;
  virtual bool collide_with_round(const round_obstacle *o) const;
  virtual bool collide_with_rect(const rect_obstacle *o) const;
  virtual void draw(BITMAP *dest,int color) const;
};

#endif
