#ifndef _ITEMS_H_
#define _ITEMS_H_

#include <allegro/fixed.h>
#include "item.h"

class area;

class tree: public item {
public:
  tree(int x,int y,int radius=14);

  virtual void draw(BITMAP *dest) const;
};

class crater: public item {
public:
  crater(int x,int y,int radius=16);

  virtual void draw(BITMAP *dest) const;
};

class h_wall: public item {
public:
  enum type {
    wall,
    barbedwire,
    type_count
  };

private:
  type which;

public:
  h_wall(int x, int y, type which=wall, int width=16, int height=6);

  virtual void draw(BITMAP *dest) const;
};

class v_wall: public item {
public:
  enum type {
    wall,
    barbedwire,
    type_count
  };

private:
  type which;

public:
  v_wall(int x, int y, type which=wall, int width=6, int height=16);

  virtual void draw(BITMAP *dest) const;
};

class wounded: public item {
public:
  enum type {
    civilian,
    army0,
    army1,
  };

private:
  type which;

public:
  wounded(int x,int y,type which);

  virtual void draw(BITMAP *dest) const;
};

class ambulance: public item {
public:
  enum type {
    anar_symbol,
    ankh_symbol,
    circle_symbol,
    crescent_symbol,
    cross_symbol,
    peace_symbol,
    star5_symbol,
    star6_symbol,
    num_types
  };
  static BITMAP *get_bitmap(type t)
    { init(); return xpms[t]; }

private:
  static BITMAP *xpms[num_types];
  static void init();

  type which;
  fixed angle;
  fixed speed;
  int pickup_radius;
  int motion_radius;
  fixed frac_dx;
  fixed frac_dy;
  int engine;

  fixed get_angle(int x,int y) const;

public:
  ambulance(int x,int y,type which);
  virtual ~ambulance();

  inline fixed get_angle() const {return angle;}
  inline fixed get_speed() const {return speed;}
  void set_angle(fixed a) {angle=a;}
  void set_speed(fixed s) {speed=s;}
  void set_pickup_radius(int r) {pickup_radius=r;}
  void set_motion_radius(int r) {motion_radius=r;}

  int tick(area *a,int dx,int dy);

  virtual void draw(BITMAP *dest) const;
};

#endif
