#include <limits.h>
#include <stdio.h>
#include <allegro.h>
#include "xpm.h"
#include "gfx/tree.xpm"
#include "gfx/grounds/crater2.xpm"
#include "gfx/wounded/civilian.xpm"
#include "gfx/wounded/ally.xpm"
#include "gfx/wounded/enemy.xpm"
#include "gfx/walls/h_wall.xpm"
#include "gfx/walls/h_bwire.xpm"
#include "gfx/walls/v_wall.xpm"
#include "gfx/walls/v_bwire.xpm"
#include "gfx/amb/anar.xpm"
#include "gfx/amb/ankh.xpm"
#include "gfx/amb/circle.xpm"
#include "gfx/amb/crescent.xpm"
#include "gfx/amb/cross.xpm"
#include "gfx/amb/peace.xpm"
#include "gfx/amb/star5.xpm"
#include "gfx/amb/star6.xpm"
#include "sfx/collide.inc"
#include "sfx/engine.inc"
#include "obstacle.h"
#include "area.h"
#include "items.h"

tree::tree(int x,int y,int radius):
  item(x,y)
{
  set_obstacle(new round_obstacle(x,y,radius,INT_MAX));
}

void tree::draw(BITMAP *dest) const
{
  static BITMAP *xpm=load_xpm(tree_magick);

  draw_sprite(dest,xpm,get_x()-xpm->w/2,get_y()-xpm->h/2);

  item::draw(dest);
}

crater::crater(int x,int y,int radius):
  item(x,y)
{
  set_obstacle(new round_obstacle(x,y,radius,4));
  set_blastable(false);
}

void crater::draw(BITMAP *dest) const
{
  static BITMAP *xpm=load_xpm(crater_magick);

  draw_sprite(dest,xpm,get_x()-xpm->w/2,get_y()-xpm->h/2);

  item::draw(dest);
}

h_wall::h_wall(int x,int y,type which,int width, int height):
  item(x,y), which(which)
{
  set_obstacle(new rect_obstacle(x,y,width,height,INT_MAX));
}

void h_wall::draw(BITMAP *dest) const
{
  static BITMAP *xpms[]={
    load_xpm(h_wall_magick),
    load_xpm(h_bwire_magick),
  };
  BITMAP *xpm=xpms[which];

  draw_sprite(dest,xpm,get_x()-xpm->w/2,get_y()-xpm->h/2);

  item::draw(dest);
}

v_wall::v_wall(int x,int y,type which,int width, int height):
  item(x,y), which(which)
{
  set_obstacle(new rect_obstacle(x,y,width,height,INT_MAX));
}

void v_wall::draw(BITMAP *dest) const
{
  static BITMAP *xpms[]={
    load_xpm(v_wall_magick),
    load_xpm(v_bwire_magick),
  };
  BITMAP *xpm=xpms[which];

  draw_sprite(dest,xpm,get_x()-xpm->w/2,get_y()-xpm->h/2);

  item::draw(dest);
}

wounded::wounded(int x,int y,type which):
  item(x,y),
  which(which)
{
  set_pickable(true);
  set_obstacle(new round_obstacle(x,y,8,0));
}

void wounded::draw(BITMAP *dest) const
{
  static BITMAP *xpms[]={
    load_xpm(civilian_magick),
    load_xpm(ally_magick),
    load_xpm(enemy_magick),
  };
  BITMAP *xpm=xpms[which];
  draw_sprite(dest,xpm,get_x()-xpm->w/2,get_y()-xpm->h/2);
  item::draw(dest);
}

BITMAP *ambulance::xpms[];

void ambulance::init()
{
  static bool done = false;
  if (!done) {
    xpms[0] = load_xpm(anar_magick);
    xpms[1] = load_xpm(ankh_magick);
    xpms[2] = load_xpm(circle_magick);
    xpms[3] = load_xpm(crescent_magick);
    xpms[4] = load_xpm(cross_magick);
    xpms[5] = load_xpm(peace_magick);
    xpms[6] = load_xpm(star5_magick);
    xpms[7] = load_xpm(star6_magick);
    done=true;
  }
}

ambulance::ambulance(int x,int y,type which):
  item(x,y),
  which(which),
  angle(0),
  speed(0),
  pickup_radius(0),
  motion_radius(0),
  frac_dx(itofix(1)/2),
  frac_dy(itofix(1)/2)
{
  init();
  set_obstacle(new round_obstacle(x,y,12,INT_MAX));
  engine=play_sample(&sfx_engine,24,128,1000,1);
}

ambulance::~ambulance()
{
  voice_stop(engine);
}

void ambulance::draw(BITMAP *dest) const
{
  BITMAP *xpm=xpms[which];

  // beams
  static const int yellow=makecol(255,255,0);
  const int beam_angle=32;
  drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
  set_trans_blender(0,0,0,16);
  for (int d=128;d>=16;d-=16) {
    int x1=get_x()+fixtoi(d*fcos(angle+itofix(beam_angle/2)));
    int y1=get_y()+fixtoi(d*fsin(angle+itofix(beam_angle/2)));
    int x2=get_x()+fixtoi(d*fcos(angle-itofix(beam_angle/2)));
    int y2=get_y()+fixtoi(d*fsin(angle-itofix(beam_angle/2)));
    triangle(dest,get_x(),get_y(),x1,y1,x2,y2,yellow);
  }
  solid_mode();

  // the ambulance itself
  rotate_sprite(dest,xpm,get_x()-xpm->w/2,get_y()-xpm->h/2,angle+itofix(64));

  // the helper radii
  circle(dest,get_x(),get_y(),motion_radius,makecol(255,255,255));
  circle(dest,get_x(),get_y(),pickup_radius,makecol(0,0,255));

  item::draw(dest);
}

fixed ambulance::get_angle(int x,int y) const
{
  int dx=x-get_x();
  int dy=y-get_y();
  fixed angle=(itofix(256)+fatan2(itofix(dy),itofix(dx)))&(itofix(256)-1);
  return angle;
}

int ambulance::tick(area *a,int dx,int dy)
{
  int pickup_count=0;

  int squared_distance=dx*dx+dy*dy-motion_radius*motion_radius;
  if (squared_distance<0) squared_distance=0;

  // out of the motion radius, move
  fixed requested_angle=get_angle(get_x()+dx,get_y()+dy);
  fixed delta=requested_angle-angle;
  while (delta>itofix(128)) delta-=itofix(256);
  while (delta<-itofix(128)) delta+=itofix(256);
  //fprintf(stderr,"delta: %2.1f\n",fixtof(delta));
  fixed turn=MID(-itofix(8),delta,itofix(8));
  if (squared_distance>0) {
    angle+=turn;
  }

  const int max_req_speed=itofix(12);
  fixed requested_speed=0;
  if (speed==0 && squared_distance==0) {
    // not moving, attempt pickup
    pickup_count=a->pickup(*this,pickup_radius);
  }
  else {
    int roughness=a->get_roughness_at(get_x(),get_y());
    fixed mag=squared_distance*32/(1+roughness);
    requested_speed=MID(0,mag,max_req_speed);
    if (squared_distance==0) requested_speed=0;
    if (requested_speed>speed) {
      speed+=256*32;
      if (requested_speed<speed) speed=requested_speed;
    }
    else if (requested_speed<speed) {
      speed-=256*32;
      if (requested_speed>speed) speed=requested_speed;
    }
    fixed realx=itofix(get_x())+frac_dx;
    fixed realy=itofix(get_y())+frac_dy;
    fixed new_realx=realx+fmul(speed,fcos(angle));
    fixed new_realy=realy+fmul(speed,fsin(angle));
    frac_dx=new_realx&0xffff;
    frac_dy=new_realy&0xffff;
    int new_x=new_realx>>16;
    int new_y=new_realy>>16;
    if (!a->advance(this,new_x,new_y)) {
      play_sample(&sfx_collide,255*speed/max_req_speed,128,1000,0);
      speed=0;
    }
    else {
      set_position(new_x,new_y);
    }
  }

  static const int coeff = 1400;
  int freq=sfx_engine.freq+fixtoi(((speed+speed+requested_speed)/3)*coeff);
  voice_set_frequency(engine,freq);

  return pickup_count;
}

