#ifndef _ITEM_H_
#define _ITEM_H_

#include "position.h"

struct BITMAP;
class obstacle;

class item: public position {
private:
  obstacle *o;
  bool is_blastable_;
  bool is_pickable_;

protected:
  inline void set_blastable(bool yesno) { is_blastable_=yesno; }
  inline void set_pickable(bool yesno) { is_pickable_=yesno; }

public:
  item(int x,int y);
  virtual ~item();

  virtual void set_position(int x,int y);
  void set_obstacle(obstacle *o);
  const obstacle *get_obstacle() const {return o;}
  int is_in(int x,int y) const;
  bool collide_with(const item *i) const;
  inline bool is_blastable() const { return is_blastable_; }
  inline bool is_pickable() const { return is_pickable_; }

  virtual void draw(BITMAP *dest) const;
};

#endif
