#include "collide.h"

#include "obstacle.h"

static inline bool is_between(int x, int x1, int x2)
{
  return x>=x1 && x<x2;
}

static inline bool is_in(int x, int y, int x1, int y1, int r1)
{
  return (x-x1)*(x-x1)+(y-y1)*(y-y1) < r1*r1;
}

static inline bool is_in(int x, int y, int x1, int y1, int x2, int y2)
{
  return is_between(x, x1, x2) && is_between(y, y1, y2);
}

bool collide_circle_circle(int xa, int ya, int ra, int xb, int yb, int rb)
{
  return is_in(xa, ya, xb, yb, ra+rb);
}

bool collide_rect_rect(
  int xa1, int ya1, int xa2, int ya2, int xb1, int yb1, int xb2, int yb2
)
{
  int xa = (xa1+xa2)/2;
  int ya = (ya1+ya2)/2;
  int ra = (int)(sqrt((xa2-xa1)*(xa2-xa1)+(ya2-ya1)*(ya2-ya1))/2);
  int xb = (xb1+xb2)/2;
  int yb = (yb1+yb2)/2;
  int rb = (int)(sqrt((xb2-xb1)*(xb2-xb1)+(yb2-yb1)*(yb2-yb1))/2);
  if (!collide_circle_circle(xa, ya, ra, xb, yb, rb)) {
    return false;
  }
  for (int x=xa1; x<=xa2; ++x) {
    if (
      is_in(x, ya1, xb1, yb1, xb2, yb2) || is_in(x, ya2, xb1, yb1, xb2, yb2)
    ) {
      return true;
    }
  }
  for (int y=ya1; y<=ya2; ++y) {
    if (
      is_in(xa1, y, xb1, yb1, xb2, yb2) || is_in(xa2, y, xb1, yb1, xb2, yb2)
    ) {
      return true;
    }
  }
  return false;
}

bool collide_rect_circle(
  int xa1, int ya1, int xa2, int ya2, int xb, int yb, int rb
)
{
  int xa = (xa1+xa2)/2;
  int ya = (ya1+ya2)/2;
  int ra = (int)(sqrt((xa2-xa1)*(xa2-xa1)+(ya2-ya1)*(ya2-ya1))/2);
  if (!collide_circle_circle(xa, ya, ra, xb, yb, rb)) {
    return false;
  }
  for (int x=xa1; x<=xa2; ++x) {
    if (is_in(x, ya1, xb, yb, rb) || is_in(x, ya2, xb, yb, rb)) {
      return true;
    }
  }
  for (int y=ya1; y<=ya2; ++y) {
    if (is_in(xa1, y, xb, yb, rb) || is_in(xa2, y, xb, yb, rb)) {
      return true;
    }
  }
  return false;
}

bool collide(const rect_obstacle *o1, const rect_obstacle *o2)
{
  return collide_rect_rect(
    o1->get_x()-o1->get_width()/2, o1->get_y()-o1->get_height()/2,
    o1->get_x()+o1->get_width()/2, o1->get_y()+o1->get_height()/2,
    o2->get_x()-o2->get_width()/2, o2->get_y()-o2->get_height()/2,
    o2->get_x()+o2->get_width()/2, o2->get_y()+o2->get_height()/2
  );
}


bool collide(const round_obstacle *o1, const round_obstacle *o2)
{
  return collide_circle_circle(
    o1->get_x(), o1->get_y(), o1->get_radius(),
    o2->get_x(), o2->get_y(), o2->get_radius()
  );
}


bool collide(const rect_obstacle *o1, const round_obstacle *o2)
{
  return collide_rect_circle(
    o1->get_x()-o1->get_width()/2, o1->get_y()-o1->get_height()/2,
    o1->get_x()+o1->get_width()/2, o1->get_y()+o1->get_height()/2,
    o2->get_x(), o2->get_y(), o2->get_radius()
  );
}

