#include <allegro.h>
#include "area.h"
#include "items.h"
#include "bomb.h"

bomb::bomb(int x,int y,int radius,int lifetime):
  position(x,y),
  radius(radius),
  lifetime(lifetime),
  total_lifetime(lifetime)
{
}

bomb::~bomb()
{
}

int bomb::tick()
{
  lifetime--;
  return lifetime>0;
}

void bomb::draw(BITMAP *dest) const
{
  int gray=256*(total_lifetime-lifetime)/total_lifetime;
  set_trans_blender(0,0,0,gray);
  drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
  int delta_rad=radius*gray/256;
  //circlefill(dest,get_x(),get_y(),get_radius()-delta_rad,makecol(128,128,128));
  circlefill(dest,get_x(),get_y(),get_radius()-delta_rad,makecol(0,0,0));
  solid_mode();
}
