#ifndef _AREA_H_
#define _AREA_H_

//#include <string>
#include <list>
#include "defines.h"

struct BITMAP;
class position;
class item;
class ambulance;
class bomb;
class anim;
class animator;
class message;

class area {
private:
  int width;
  int height;

  int bomb_freq;
  int bomb_lifetime;
  int pickable_count;

  ambulance *amb;
  std::list<item*> items;
  std::list<bomb*> bombs;
  std::list<animator*> anims;
  std::list<message*> msgs;

  anim *explo;

  int get_random_cry_delay() const;
  int compute_volume(int x,int y) const;
  int compute_pan(int x,int y) const;

  int time;
  int next_cry_time;

public:
  area(int width,int height,int bomb_freq,int bomb_lifetime);
  virtual ~area();

  inline int get_width() const {return width;}
  inline int get_height() const {return height;}

  void add(item*);
  void remove(item*);
  void destroy(item*);
  void destroy(list<item*> &);
  void add_bomb(int radius,int lifetime);
  void set_ambulance(ambulance*);
  inline ambulance *get_ambulance() const {return amb;}
  void add_anim(animator*);
  void add_message(const char *text,int color,int lifetime);

  inline int get_bomb_freq() const
    { return bomb_freq; }
  inline int get_bomb_lifetime() const
    { return bomb_lifetime; }
  inline int get_pickable_count() const
    { return pickable_count; }

  int get_roughness_at(int, int) const;
  bool is_blocked_at(int, int) const;
  bool collide_with_any(const item *i) const;
  bool collide_with_blocked(const item *i) const;

  int advance(item *i,int x,int y) const;

  void blast(item *crater,bool in_game=0);
  int pickup(position &position,int radius);

  void draw(BITMAP *dest);
  int tick(int dx,int dy);
};

#endif
