#ifndef _ANIM_H_
#define _ANIM_H_

#include "position.h"

struct BITMAP;

class anim {
private:
  int nframes;
  BITMAP **frames;

public:
  anim(const char *script,int width,int height,int nframes);
  virtual ~anim();

  inline int get_num_frames() const {return nframes;}
  inline BITMAP *get_frame(int index) const {return frames[index];}
};

class animator: public position {
private:
  const anim *master;
  int frame;
  int loop;
  int max_frames;

public:
  animator(int x,int y,const anim *a,int loop=0,int max_frames=-1);

  inline BITMAP *get_frame() const {return master->get_frame(frame);}

  int tick();
  void draw(BITMAP *dest) const;
  void rewind() {frame=0;}
};

#endif
