#include <limits.h>
#include <float.h>
#include <allegro.h>
#include "error.h"
#include "anim.h"

extern "C" {
#include "egg.h"
}

anim::anim(const char *script,int width,int height,int nframes):
  nframes(nframes),
  frames(NULL)
{
  static char error[80];
  strcpy(error,"");
  static double planes[]={-DBL_MAX,DBL_MAX};
#if 0
  EGG *egg=load_egg((char*)script,error);
#else
  EGG *egg=use_egg((void*)script,strlen(script)+1,error);
#endif
  if (!egg) exit_error("Error in EGG %s: %s\n",script,error);
  egg->alpha=1;
  frames=new BITMAP*[nframes];
  for (int n=0;n<nframes;++n) {
    if (update_egg(egg,error)) {
      exit_error("Error in EGG %s: %s\n",script,error);
    }
    frames[n]=create_bitmap_ex(32,width,height);
    lay_egg(egg,&frames[n],2,planes);
  }
  destroy_egg(egg);
}

anim::~anim()
{
  for (int n=0;n<nframes;++n) destroy_bitmap(frames[n]);
  delete[] frames;
}

animator::animator(int x,int y,const anim *a,int loop,int max_frames):
  position(x,y),
  master(a),
  frame(0),
  loop(loop),
  max_frames(max_frames)
{
}

int animator::tick()
{
  if (max_frames>=0) {
    --max_frames;
    if (max_frames<0) return 0;
  }
  ++frame;
  if (frame>=master->get_num_frames()) {
    if (!loop) return 0;
    rewind();
  }
  return 1;
}

void animator::draw(BITMAP *dest) const
{
  set_alpha_blender();
  BITMAP *frame=get_frame();
  draw_trans_sprite(dest,frame,get_x()-frame->w/2,get_y()-frame->h/2);
  solid_mode();
}
