#include <stdio.h>
#include <allegro.h>

int main(int argc,char **argv)
{
  if (argc!=4) {
    fprintf(stderr,"sample2c <from> <to> <c-name>\n");
    exit(1);
  }

  allegro_init();

  char *from_name=argv[1];
  char *to_name=argv[2];
  char *c_name=argv[3];

  SAMPLE *sample=load_sample(from_name);
  if (!sample) {
    fprintf(stderr,"cound not load sample %s\n",from_name);
    exit(1);
  }

  FILE *f=fopen(to_name,"wt");
  fprintf(f,"#include <allegro/digi.h>\n");

  fprintf(f,"\n");

  fprintf(f,"const unsigned char %s_sample_data[]={\n",c_name);
  for (unsigned int n=0;n<sample->len*sample->bits/8;++n) {
    if (n && (n%8==0)) fprintf(f,"\n");
    unsigned char byte=((unsigned char*)sample->data)[n];
    fprintf(f,"0x%02x, ",byte);
  }
  fprintf(f,"\n");
  fprintf(f,"  };\n");

  fprintf(f,"\n");

  fprintf(f,"const SAMPLE %s={\n",c_name);
  fprintf(f,"  %d,\n",sample->bits);
  fprintf(f,"  %d,\n",sample->stereo);
  fprintf(f,"  %d,\n",sample->freq);
  fprintf(f,"  %d,\n",sample->priority);
  fprintf(f,"  %lu,\n",sample->len);
  fprintf(f,"  %lu,\n",sample->loop_start);
  fprintf(f,"  %lu,\n",sample->loop_end);
  fprintf(f,"  %lu,\n",sample->param);
  fprintf(f,"  (void*)%s_sample_data\n",c_name);
  fprintf(f,"};\n");
  fclose(f);

  return 0;
}
END_OF_MAIN();
