#include <allegro.h>
#include <string.h>
#include "message.h"

message::message(const char *text,int color,int lifetime):
  text(strdup(text)),
  color(color),
  lifetime(lifetime)
{
}

message::~message()
{
  free(text);
}

int message::tick()
{
  if (lifetime>=0) {
    if (--lifetime<=0) return 0;
  }
  return 1;
}

void message::draw(BITMAP *dest,int x,int y) const
{
  textprintf_centre(dest,font,x,y,color,"%s",text);
}
