#include <allegro.h>
#include "obstacle.h"
#include "item.h"

item::item(int x,int y):
  position(x,y),
  o(NULL),
  is_blastable_(true),
  is_pickable_(false)
{
}

item::~item()
{
}

void item::set_position(int x,int y)
{
  position::set_position(x,y);
  if (o) o->set_position(x,y);
}

void item::set_obstacle(obstacle *o)
{
  if (this->o) delete this->o;
  this->o=o;
}

int item::is_in(int x, int y) const
{
  if (o) {
    return o->is_in(x, y);
  }
  else {
    return x==get_x() && y==get_y();
  }
}

bool item::collide_with(const item *i) const
{
  if (i->o) {
    if (o) {
      return i->o->collide_with(o);
    }
    else {
      return i->o->is_in(get_x(), get_y());
    }
  }
  else {
    return is_in(i->get_x(), i->get_y());
  }
}

void item::draw(BITMAP *dest) const
{
#ifdef DEBUG
  //if (o) o->draw(dest,makecol(255,0,0));
#endif
}
